class GSToyHelper extends GSController
{
firsttime_start = true
system = 0
x = 0
y = 0

town = 0
towns_served = 0
pass_amt = 0
gf_amt = 0
pb_amt = 0
//mail_mult = 0

industry = 0
industry_count = 0
industries_served = 0
ind_density = 0
industry_pts = 0
min_industry_pts = 0
cargo = 0

min_ind_served = 0
min_ind_transport = 0

//MC addon:
economy_mood = 0
economy_points = 0
global_town_count = 0
gamestart_year = 0
game_duration = 0
industry_goal_reached = 0
}

function GSToyHelper::CheckDeliveredCargo(Town, lab1, lab2) {
	local cargo_transported = 0
	foreach(cargo,_ in GSCargoList())
		{
			if ((GSCargo.GetCargoLabel(cargo) == lab1) || (GSCargo.GetCargoLabel(cargo) == lab2)) {
				for(local company_id = GSCompany.COMPANY_FIRST; company_id < GSCompany.COMPANY_LAST; company_id++)
				{
					cargo_transported +=  GSCargoMonitor.GetTownDeliveryAmount(company_id, cargo, town, true);
				} 
// GSLog.Info(cargo_transported);
			}
		}
	return cargo_transported;
}

function GSToyHelper::CheckTownPASS(Town) {
//	mail_mult = GetSetting("dummy2")
	local town_growth_allowed = 0;
	local pass_transport = GSTown.GetLastMonthTransportedPercentage(town,0)+GSTown.GetLastMonthTransportedPercentage(town,2);
	local gf_transport = CheckDeliveredCargo(town, "GOOD", "FOOD");
	local pb_transport = CheckDeliveredCargo(town, "PETR", "BDMT");
	pass_amt = GetSetting("passmail")
	gf_amt = GetSetting("goodfood")
	pb_amt = GetSetting("petrbdmt")
	if (GSTown.GetPopulation(Town) <= 10) {
  		town_growth_allowed = 1;
	}
	else if (pass_transport >= pass_amt) {
//GSLog.Info("pass ok");
		if (GSTown.GetPopulation(Town)<max(4500, 5000 + 10 * economy_mood)) {
			GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_MET, pass_transport, pass_amt))
			town_growth_allowed = 1;
//GSLog.Info("pass ok and small town");

		}
		else if (gf_transport >= gf_amt) {
			if (GSTown.GetPopulation(Town)<max(9500, 10000 + 100 * economy_mood)) {
			//	GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_MET, pass_transport, pass_amt))
//GSLog.Info("gf ok");
				GSTown.SetText(Town, GSText(GSText.STR_TOWN_GOODFOOD_MET, gf_transport, gf_amt, GSText(GSText.STR_TOWN_PASS_MET, pass_transport, pass_amt)))
				town_growth_allowed = 1;
			} else if (pb_transport >= pb_amt) {
					town_growth_allowed = 1;
			//		GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_MET, pass_transport, pass_amt))
			//		GSTown.SetText(Town, GSText(GSText.STR_TOWN_GOODFOOD_MET, gf_transport, gf_amt))
					GSTown.SetText(Town, GSText(GSText.STR_TOWN_PETRBDMT_MET, pb_transport, pb_amt, GSText(GSText.STR_TOWN_GOODFOOD_MET, gf_transport, gf_amt, GSText(GSText.STR_TOWN_PASS_MET, pass_transport, pass_amt))))
				}
		}
	}
	if (town_growth_allowed > 0) {
		if (economy_mood > -GetSetting("economypoints")) {
			GSTown.SetGrowthRate(town,GSTown.TOWN_GROWTH_NORMAL)
		} else {
			GSTown.SetGrowthRate(town, 400)
		}
		towns_served ++
	} else {
		GSTown.SetGrowthRate(town,GSTown.TOWN_GROWTH_NONE)
		if (pass_transport < pass_amt) {
			GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_NMET, pass_transport, pass_amt))
		} else if ((GSTown.GetPopulation(Town)<max(9500, 10000 + 100 * economy_mood)) && (gf_transport < gf_amt)) {
			GSTown.SetText(Town, GSText(GSText.STR_TOWN_GOODFOOD_NMET, gf_transport, gf_amt))
		} else if (pb_transport < pb_amt) {
			GSTown.SetText(Town, GSText(GSText.STR_TOWN_PETRBDMT_NMET, pb_transport, pb_amt))
		}
	}
}

function GSToyHelper::CheckIndustries() {
	// A is the first system
	min_ind_served = GetSetting("minprct")
	min_ind_transport = GetSetting("mintrans")
	industry_count = 0;
	local cargo_transported = 0;
	local c = 0;
	y = 0
	local list = GSIndustryList()
	industries_served = 0;
	for (local v = list.Begin (); !list.IsEnd (); v = 	list.Next ()) {
		y++
		industry_count ++;
		local ind_type = GSIndustry.GetIndustryType(v)
		local produced_cargoes = GSIndustryType.GetProducedCargo(ind_type)
		local num_cargoes = produced_cargoes.Count()
		local transport_percent = 0
		foreach (c, _ in produced_cargoes) {
			transport_percent += GSIndustry.GetLastMonthTransportedPercentage(v,c)
		}
		if (GSIndustryType.GetProducedCargo(ind_type).Count() == 0) {
			if (GSIndustry.GetAmountOfStationsAround(v)>0) {
				industries_served ++
			}
		} else if (num_cargoes == 0) {
			industry_count --
		} else if (transport_percent/num_cargoes>min_ind_transport){
			industries_served ++
		} 
	}

	industries_served *= 1;
	if ((industries_served*100/industry_count >= min_ind_served) || (economy_mood>GetSetting("goodeconomy"))) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_MET, industries_served, industry_count))
		industry_goal_reached = 1
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_NMET, industries_served, industry_count))
		industry_goal_reached = 0
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, industries_served*100/industry_count))
}

function GSToyHelper::CheckIndustriesB() {
	// B is the second system
	industry_count = GSIndustry.GetIndustryCount()
	industry_pts = 0
//	min_industry_pts = GetSetting("dummy6")
	local c = 0
	
	local list = GSIndustryList()

	for (local v = list.Begin (); !list.IsEnd (); v = 	list.Next ()) {
		industry = v;
		industry_count ++;
		GSLog.Info(industry_count)
		local ind_type = GSIndustry.GetIndustryType(v)
		local produced_cargoes = GSIndustryType.GetProducedCargo(ind_type)
		local num_cargoes = produced_cargoes.Count()
		if (num_cargoes == 0) {
			industry_count --
		} else {
			foreach (c, _ in produced_cargoes) {
				industry_pts += GSIndustry.GetLastMonthTransportedPercentage(v,c)/num_cargoes
			}
		}
	}
	if (industry_pts/industry_count >= min_industry_pts) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_MET, industry_pts, industry_count*min_industry_pts))
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_NMET, industry_pts, industry_count*min_industry_pts))
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, industry_pts/industry_count))

}

function GSToyHelper::CheckIndustryClose() {
	local event = null
	local eventtype = null
	local event2 = null
	if (economy_mood>0) {
		while (GSEventController.IsEventWaiting()) {
			event = GSEventController.GetNextEvent()
			eventtype = event.GetEventType()
			switch (eventtype) {
				case GSEvent.ET_INDUSTRY_CLOSE: 
					event = GSEventIndustryClose.Convert(event)
					local industry = event.GetIndustryID()
					if (!GSIndustry.IsValidIndustry(industry)) break;			
				
					local indtype = GSIndustry.GetIndustryType(industry)
					GSIndustryType.ProspectIndustry(indtype)
			}
		}
	}
}

function GSToyHelper::Start() {
	GSLog.Info("Listing cargoes...")
	for (local x = 0; x < 32; x++) {
		GSLog.Info(x+": "+GSCargo.GetCargoLabel(x))
	}
	GSLog.Info("Initializing goals...")
	if (true) {
		for (local i = 0; i < 10; i++) {GSGoal.Remove(i)}
		GSGoal.New(-1, "System ? - Initializing",0,0)
		GSGoal.New(-1, "Towns served: ? / ?",0,0)
		GSGoal.New(-1, "Time elapsed: ? Economy mood: ? ",0,0)
	}
	GSLog.Info("Initializing game start year...")
	gamestart_year = GSDate.GetYear(GSDate.GetCurrentDate());

	GSLog.Info("Initializing...")
	ind_density = GSGameSettings.GetValue("difficulty.industry_density")
	industry_count = GSIndustry.GetIndustryCount()
	while (true) {
		x++
		towns_served = 0
		global_town_count = GSTown.GetTownCount();
		for (town = 0; town < global_town_count; town += 1) {
			GSToyHelper.CheckTownPASS(town)
		}
		GSGoal.SetText(1, GSText(GSText.STR_TOWN_GOAL, towns_served, global_town_count))
			GSGoal.SetProgress(1, GSText(GSText.STR_PROGRESS2, towns_served*100/global_town_count))

		if (industry_count) {
			GSToyHelper.CheckIndustries()
		} else {
			GSGoal.SetText(0, "No industry control is taking place")
		}
		economy_points = GetSetting("economypoints");
		game_duration = max(0, GSDate.GetYear(GSDate.GetCurrentDate()) - gamestart_year);
		economy_mood = 1 + (50 * towns_served / global_town_count) + (50 * industries_served / (1 + GSIndustry.GetIndustryCount())) - economy_points * (20 - 20/(1+game_duration/10))/(industry_goal_reached + 20);
		if (economy_mood>GetSetting("goodeconomy")) {
              GSGoal.SetText(2, GSText(GSText.STR_GOOD_ECONOMY_GOAL_REACHED, game_duration, economy_mood))
		} else if (economy_mood>=0) {		
              		GSGoal.SetText(2, GSText(GSText.STR_AVERAGE_ECONOMY_GOAL_REACHED, game_duration, economy_mood))	
            } else {
            	   GSGoal.SetText(2, GSText(GSText.STR_ECONOMY_WEAK, game_duration, economy_mood))
		}
		if (GetSetting("keepind")) {
		GSToyHelper.CheckIndustryClose()
		}
		this.Sleep(74 * 7) // sleep for a week at a time
	}
}

function GSToyHelper::Load(version, data)
{
	firsttime_start = false
}

function GSToyHelper::Save() {
return {
	x = 0 // this bypasses the "Script took too long to save" error message.
};
}
