class GSToyHelper extends GSController
{
firsttime_start = true
system = 0
x = 0
y = 0

town = 0
towns_served = 0
pass_amt = 0
cg_amt = 0
ig_amt = 0
//mail_mult = 0

industry = 0
industry_count = 0
industries_served = 0
ind_density = 0
industry_pts = 0
min_industry_pts = 0
cargo = 0

min_ind_served = 0
min_ind_transport = 0

//MC addon:
economy_mood = 0
economy_points = 0
global_town_count = 0
gamestart_year = 0
game_duration = 0
industry_goal_reached = 0
weight_average = 0
week_count = 0;
average_pop = 0;
}

function GSToyHelper::CheckDeliveredCargo(Town, lab1) {
	local cargo_transported = 0
	foreach(cargo,_ in GSCargoList())
		{
			if (GSCargo.GetCargoLabel(cargo) == lab1) {
				for(local company_id = GSCompany.COMPANY_FIRST; company_id < GSCompany.COMPANY_LAST; company_id++)
				{
					cargo_transported +=  GSCargoMonitor.GetTownDeliveryAmount(company_id, cargo, town, true);
				} 
			}
		}
	return cargo_transported;
}

function GSToyHelper::CountConsumerGoods(town) {
	local total_cargo = 0;
	total_cargo = 	 	 CheckDeliveredCargo(town, "FOOD") 
				+CheckDeliveredCargo(town, "GOOD")
				+CheckDeliveredCargo(town, "BEER")
				+CheckDeliveredCargo(town, "WATR")
				+CheckDeliveredCargo(town, "PETR")
				+CheckDeliveredCargo(town, "BDMT")
				+CheckDeliveredCargo(town, "GOLD")
				+CheckDeliveredCargo(town, "VALU")
				+CheckDeliveredCargo(town, "DIAM");
	return total_cargo;
}

function GSToyHelper::CountIndustryGoods(town) {
	local total_cargo = 0;
	total_cargo = 	 	 CheckDeliveredCargo(town, "COAL") 
				+CheckDeliveredCargo(town, "_OIL")
				+CheckDeliveredCargo(town, "ENSP")
				+CheckDeliveredCargo(town, "MNSP")
				+CheckDeliveredCargo(town, "FMSP")
				+CheckDeliveredCargo(town, "VEHI")
				+CheckDeliveredCargo(town, "PAPR")
				+CheckDeliveredCargo(town, "STEL")
				+CheckDeliveredCargo(town, "COPR")
				+CheckDeliveredCargo(town, "GRAI")
				+CheckDeliveredCargo(town, "CERE")
				+CheckDeliveredCargo(town, "WHEA")
				+CheckDeliveredCargo(town, "MAIZ")
				+CheckDeliveredCargo(town, "LVST")
				+CheckDeliveredCargo(town, "FISH")
				+CheckDeliveredCargo(town, "FRUT")
				+CheckDeliveredCargo(town, "YETI");
	return total_cargo;
}

function GSToyHelper::CheckTownPASS(Town) {
	local growth_speed = max(20, 50 + 2 * economy_mood);
	local town_population = GSTown.GetPopulation(Town);
	local town_growth_mode = 0;
	local town_growth_speed = GSTown.TOWN_GROWTH_NORMAL;
	local town_expansion = 0;
	local previous_growth = GSTown.GetGrowthRate(town);		 
	local pass_transport = GSTown.GetLastMonthTransportedPercentage(Town, 0)+GSTown.GetLastMonthTransportedPercentage(Town, 2);
	pass_transport += 100 * CheckDeliveredCargo(Town, "TOUR")/(5000+town_population);
	local cg_transport = 0;
	local ig_transport = 0;
	local cg_percent = 0;
	local ig_percent = 0;
	pass_amt = GetSetting("passmail");
	cg_amt = GetSetting("consumer");
	ig_amt = GetSetting("industrial");
	weight_average = GetSetting("smoothgrowth");

	if (pass_transport>=pass_amt) {
		towns_served ++
		if (!(GetSetting("nosubsidies")) && (week_count == 1) && (GSBase.RandRange(365) < GetSetting("refreshrate")*(-1+economy_mood))) {
			local Town2 = GSBase.RandRange(global_town_count);
			local dist2 = GSTown.GetDistanceManhattanToTile(Town, GSTown.GetLocation(Town2));
			if ((Town2 != Town) && (dist2>25) && (GSBase.RandRange(GSMap.GetMapSizeX()+GSMap.GetMapSizeY())> 2*dist2) && (GSTown.GetPopulation(Town) > average_pop / 2)) {
				GSSubsidy.Create(0, GSSubsidy.SPT_TOWN, Town, GSSubsidy.SPT_TOWN, Town2);
			}
		}
	}

	if (town_population <= 25) {
 //regrowth
  		town_growth_mode = -2;
 	        town_growth_speed = 50+town_population;
	} else if (town_population <= 250)  {
 //normal growth
  		town_growth_mode = -1;
		town_growth_speed = GSTown.TOWN_GROWTH_NORMAL;
	} else if (town_population <= 2500)  {
 //growth depend on pass+mail
  		town_growth_mode = 1;
		town_expansion = 5 * growth_speed * (pass_transport - pass_amt);
	} else {
 //growth depend on pass+mail, 2 * pass and mail goal + food if arctic or tropic regardless of location
  		town_growth_mode = 1;
		if (week_count == 0) {
			GSTown.SetCargoGoal(Town, GSCargo.TE_PASSENGERS, 
						1 + pass_amt * town_population/1000);
			GSTown.SetCargoGoal(Town, GSCargo.TE_MAIL, 1 + pass_amt * town_population/3000); 
			if ((GSGame.GetLandscape() == GSGame.LT_ARCTIC) ||
		 	(GSGame.GetLandscape() == GSGame.LT_TROPIC)) {
				GSTown.SetCargoGoal(Town, GSCargo.TE_FOOD, 1 + cg_amt * town_population/5000); 				
			}
		}
		if (town_population <= 5000)  {
			town_expansion = 3 * growth_speed * (pass_transport - pass_amt);
		} else if (town_population <= 10000)  {
 //growth depend on pass+mail and consumer goods transport
  			town_growth_mode = 2;
			cg_transport = GSToyHelper.CountConsumerGoods(Town);
			cg_percent = 10000 * cg_transport/(10000+town_population);
			town_expansion = growth_speed * (2 * (pass_transport - pass_amt) 
							+ 8 * cg_transport);
			if (cg_percent<cg_amt) {
				town_expansion /= 2;
			}
		} else {
 //growth depend on pass+mail, consumer and industry resources
  			town_growth_mode = 3;
			cg_transport = GSToyHelper.CountConsumerGoods(Town);
			cg_percent = 10000 * cg_transport/(10000+town_population);
			ig_transport = GSToyHelper.CountIndustryGoods(Town);
			ig_percent = 20000 * ig_transport/(20000+town_population);
			town_expansion = growth_speed * 
					(pass_transport - pass_amt + 2 * cg_transport 
					+ 7 * ig_transport);
			if (cg_percent<cg_amt) {
				town_expansion /= 4;
			}
			if (ig_percent<ig_amt) {
				town_expansion /= 2;
			}
		}
	}
	if (town_growth_mode > 0) {
			if (previous_growth==GSTown.TOWN_GROWTH_NONE) {
				town_expansion /= (1 + weight_average);
			} else {
				town_expansion = (1000000/(weight_average*previous_growth) 
				+ town_expansion) / (1 + weight_average);
			}
			if ( (town_expansion<1) || 
		( (GSTile.GetTerrainType(GSTown.GetLocation(Town)) == GSTile.TERRAIN_SNOW) && 
		(GSTown.GetLastMonthReceived(town, GSCargo.TE_FOOD)==0) ) ) {        
				town_growth_speed = GSTown.TOWN_GROWTH_NONE;
			} else {
				town_growth_speed = 1 + 1000000 / (1 + town_expansion);
				if (town_growth_speed > 740) {
					town_growth_speed = GSTown.TOWN_GROWTH_NONE;
				}
			}
			if (pass_transport<pass_amt) {
  				town_growth_mode = 0;
				town_growth_speed = GSTown.TOWN_GROWTH_NONE;
			}
	}	
	GSTown.SetGrowthRate(Town, town_growth_speed);
	if (town_growth_mode == 0) {
		GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_NMET, pass_transport, pass_amt))
	}
	if (town_growth_mode == 1) {
		GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_MET, pass_transport, pass_amt))
	}
	if (town_growth_mode == 2) {
		GSTown.SetText(Town, GSText(GSText.STR_TOWN_STAGE2, cg_transport, cg_amt*(10000+town_population)/10000))
	}
	if (town_growth_mode == 3) {
		GSTown.SetText(Town, GSText(GSText.STR_TOWN_STAGE3, ig_transport, ig_amt*(20000+town_population)/20000))
	}
	if (town_growth_mode < 0) {
		GSTown.SetText(Town, GSText(GSText.STR_TOWN_EMPTY));
	}
}

function GSToyHelper::CheckIndustries() {
	// A is the first system
	min_ind_served = GetSetting("minprct")
	min_ind_transport = GetSetting("mintrans")
	industry_count = 0;
	local cargo_transported = 0;
	local c = 0;
	y = 0
	local list = GSIndustryList()
	industries_served = 0;
	for (local v = list.Begin (); !list.IsEnd (); v = 	list.Next ()) {
		y++
		industry_count ++;
		local ind_type = GSIndustry.GetIndustryType(v)
		local produced_cargoes = GSIndustryType.GetProducedCargo(ind_type)
		local num_cargoes = produced_cargoes.Count()
		local transport_percent = 0
		foreach (c, _ in produced_cargoes) {
			transport_percent += GSIndustry.GetLastMonthTransportedPercentage(v,c)
		}
		if (GSIndustryType.GetProducedCargo(ind_type).Count() == 0) {
			if (GSIndustry.GetAmountOfStationsAround(v)>0) {
				industries_served ++
			}
		} else if (num_cargoes == 0) {
			industry_count --
		} else if (transport_percent/num_cargoes>min_ind_transport){
			industries_served ++
		} 
	}

	industries_served *= 1;
	if ((industries_served*100/industry_count >= min_ind_served) || (economy_mood>GetSetting("goodeconomy"))) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_MET, industries_served, industry_count))
		industry_goal_reached = 1
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_NMET, industries_served, industry_count))
		industry_goal_reached = 0
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, industries_served*100/industry_count))
}

function GSToyHelper::CheckIndustriesB() {
	// B is the second system
	industry_count = GSIndustry.GetIndustryCount()
	industry_pts = 0

	local c = 0
	
	local list = GSIndustryList()

	for (local v = list.Begin (); !list.IsEnd (); v = 	list.Next ()) {
		industry = v;
		industry_count ++;
		GSLog.Info(industry_count)
		local ind_type = GSIndustry.GetIndustryType(v)
		local produced_cargoes = GSIndustryType.GetProducedCargo(ind_type)
		local num_cargoes = produced_cargoes.Count()
		if (num_cargoes == 0) {
			industry_count --
		} else {
			foreach (c, _ in produced_cargoes) {
				industry_pts += GSIndustry.GetLastMonthTransportedPercentage(v,c)/num_cargoes
			}
		}
	}
	if (industry_pts/industry_count >= min_industry_pts) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_MET, industry_pts, industry_count*min_industry_pts))
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_NMET, industry_pts, industry_count*min_industry_pts))
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, industry_pts/industry_count))

}

function GSToyHelper::CheckIndustryClose() {
	local event = null
	local eventtype = null
	local event2 = null
	if (economy_mood>0) {
		while (GSEventController.IsEventWaiting()) {
			event = GSEventController.GetNextEvent()
			eventtype = event.GetEventType()
			switch (eventtype) {
				case GSEvent.ET_INDUSTRY_CLOSE: 
					event = GSEventIndustryClose.Convert(event)
					local industry = event.GetIndustryID()
					if (!GSIndustry.IsValidIndustry(industry)) break;			
				
					local indtype = GSIndustry.GetIndustryType(industry)
					GSIndustryType.ProspectIndustry(indtype)
			}
		}
	}
}

function GSToyHelper::Start() {
	GSLog.Info("Listing cargoes...")
	for (local x = 0; x < 32; x++) {
		GSLog.Info(x+": "+GSCargo.GetCargoLabel(x))
	}
	GSLog.Info("Initializing goals...")
	if (true) {
		for (local i = 0; i < 10; i++) {GSGoal.Remove(i)}
		GSGoal.New(-1, "System ? - Initializing",0,0)
		GSGoal.New(-1, "Towns served: ? / ?",0,0)
		GSGoal.New(-1, "Time elapsed: ? Economy mood: ? ",0,0)
	}
	GSLog.Info("Initializing game start year...")
	gamestart_year = GSDate.GetYear(GSDate.GetCurrentDate());

	GSLog.Info("Initializing...")
	ind_density = GSGameSettings.GetValue("difficulty.industry_density")
	industry_count = GSIndustry.GetIndustryCount()
	while (true) {
		if (!GSGame.IsPaused()) {
			x++
			towns_served = 0
			global_town_count = GSTown.GetTownCount();
			if (week_count == 0) {
				average_pop = 0;
				for (town = 0; town < global_town_count; town += 1) {
					average_pop += GSTown.GetPopulation(town);
				}	
				average_pop /= global_town_count;		
			}
			for (town = 0; town < global_town_count; town += 1) {
				GSToyHelper.CheckTownPASS(town);
			}
			GSGoal.SetText(1, GSText(GSText.STR_TOWN_GOAL, towns_served, global_town_count))
			GSGoal.SetProgress(1, GSText(GSText.STR_PROGRESS2, towns_served*100/global_town_count))

			if (industry_count) {
				GSToyHelper.CheckIndustries()
			} else {
				GSGoal.SetText(0, "No industry control is taking place")
			}
			economy_points = GetSetting("economypoints");
			game_duration = max(0, GSDate.GetYear(GSDate.GetCurrentDate()) - gamestart_year);
			economy_mood = (1 + economy_mood + (50 * towns_served / global_town_count) + (50 * industries_served / (1 + GSIndustry.GetIndustryCount())) - economy_points * (20 - 20/(1+game_duration/10))/(industry_goal_reached + 20)) / 2;
			if (economy_mood>GetSetting("goodeconomy")) {
              GSGoal.SetText(2, GSText(GSText.STR_GOOD_ECONOMY_GOAL_REACHED, game_duration, economy_mood))
			} else if (economy_mood>=0) {		
              		GSGoal.SetText(2, GSText(GSText.STR_AVERAGE_ECONOMY_GOAL_REACHED, game_duration, economy_mood))	
	            } else {
	            	   GSGoal.SetText(2, GSText(GSText.STR_ECONOMY_WEAK, game_duration, economy_mood))
			}
			if (GetSetting("keepind")) {
			GSToyHelper.CheckIndustryClose()
			}
			week_count ++
			if (week_count>4) {
				week_count = 0;
		 	}
		}
		this.Sleep(74 * GetSetting("refreshrate")) // sleep for a week (default) at a time
	}
	GSLog.Info("Ready")
}

function GSToyHelper::Load(version, data)
{
	firsttime_start = false
}

function GSToyHelper::Save() {
return {
	x = 0 // this bypasses the "Script took too long to save" error message.
};
}
