class GSToyHelper extends GSController
{
firsttime_start = true
system = 0
x = 0

town = 0
towns_served = 0
pass_amt = 0
mail_mult = 0

industry = 0
industry_count = 0
industries_served = 0
ind_density = 0
industry_pts = 0
min_industry_pts = 0
cargo = 0

min_ind_served = 0
min_ind_transport = 0
}

function GSToyHelper::CheckTownPASS(Town) {
	mail_mult = GetSetting("dummy2")
	local pass_transport = GSTown.GetLastMonthTransportedPercentage(town,0)+(mail_mult *GSTown.GetLastMonthTransportedPercentage(town,2))/100;
	pass_amt = GetSetting("dummy")
	if (pass_transport >= pass_amt) {
		GSTown.SetGrowthRate(town,GSTown.TOWN_GROWTH_NORMAL)
		GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_MET, pass_transport, pass_amt))
		towns_served ++
	} else {
		GSTown.SetGrowthRate(town,GSTown.TOWN_GROWTH_NONE)
		GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_NMET, pass_transport, pass_amt))
	}
}

function GSToyHelper::CheckIndustriesA() {
	// A is the first system
	min_ind_served = GetSetting("dummy4")
	min_ind_transport = GetSetting("dummy5")
	industry_count = GSIndustry.GetIndustryCount()
	for (industry = 0; industry<industry_count; industry++) {
		if (GSIndustry.GetLastMonthTransported(industry,0) > min_ind_transport) {
			industries_served ++
		}
	}

	industries_served * 100
	if (industries_served/industry_count >= min_ind_served) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_MET, industries_served/100, industry_count))
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_NMET, industries_served/100, industry_count))
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, industries_served/industry_count))
}

function GSToyHelper::CheckIndustriesB() {
	// B is the second system
	industry_count = GSIndustry.GetIndustryCount()
	industry_pts = 0
	min_industry_pts = GetSetting("dummy6")
	for (industry = 0; industry<industry_count; industry++) {
		if (GSIndustry.IsValidIndustry(industry)) {
			foreach(cargo, _ in GSIndustryType.GetProducedCargo(GSIndustry.GetIndustryType(industry))) {
				industry_pts += GSIndustry.GetLastMonthTransported(industry, cargo)
			}
		}
	}

	if (industry_pts/industry_count >= min_industry_pts) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_MET, industry_pts, industry_count*min_industry_pts))
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_NMET, industry_pts, industry_count*min_industry_pts))
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, industry_pts/industry_count))

}

function GSToyHelper::Start() {
	GSLog.Info("Listing cargoes...")
	for (local x = 0; x < 32; x++) {
		GSLog.Info(x+": "+GSCargo.GetCargoLabel(x))
	}
	GSLog.Info("Initializing goals...")
	if (true) {
		for (local i = 0; i < 10; i++) {GSGoal.Remove(i)}
		GSGoal.New(-1, "System ? - Initializing",0,0)
		GSGoal.New(-1, "Towns served: ? / ?",0,0)
	}
	

	GSLog.Info("Initializing...")
	ind_density = GSGameSettings.GetValue("difficulty.industry_density")
	industry_count = GSIndustry.GetIndustryCount()
	while (true) {
		x++
		towns_served = 0
		for (town = 0; town < GSTown.GetTownCount(); town += 1) {
			GSToyHelper.CheckTownPASS(town)
			GSGoal.SetText(1, GSText(GSText.STR_TOWN_GOAL, towns_served, GSTown.GetTownCount()))
			GSGoal.SetProgress(1, GSText(GSText.STR_PROGRESS2, towns_served*100/GSTown.GetTownCount()))
		}
		if (GetSetting("dummy3") == 1 && industry_count) {
			GSToyHelper.CheckIndustriesA()
		} else if (GetSetting("dummy3")==2 && industry_count) {
			GSToyHelper.CheckIndustriesB()
		}
		this.Sleep(74 * 30) // process approx. once a month
	}
}

function GSToyHelper::Load(version, data)
{
	firsttime_start = false
}

function GSToyHelper::Save() {
return {
	x = 0 // this bypasses the "Script took too long to save" error message.
};
}
