class GSToyHelper extends GSInfo
{
	function GetAuthor()		{ return "James"; }
	function GetName()			{ return "Town & Industry Control"; }
	function GetDescription() 	{ return "This controls both town and industry growth by requiring passengers and mail to be transported and industries to be served. See readme.txt for more info."; }
	function GetVersion()		{ return 4; }
	function GetDate()			{ return "2017-08-14"; }
	function CreateInstance()	{ return "GSToyHelper"; }
	function GetShortName()		{ return "TNIG"; }
	function GetAPIVersion()	{ return "1.4"; }
	function MinVersionToLoad()	{ return 1; }

	function GetSettings()
	{
		AddSetting({name = "dummy",
		description = "Passengers+mail transport percentange required",
		min_value = 0
		max_value = 100
		easy_value = 10,
		medium_value = 15,
		hard_value = 20,
		custom_value = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "dummy2",
		description = "100 mail counts as X passengers",
		min_value = 0
		max_value = 1000
		easy_value = 150,
		medium_value = 100,
		hard_value = 50,
		custom_value = 100,
		step_size = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "dummy3",
		description = "System to control industry growth",
		min_value = 0
		max_value = 2
		easy_value = 1,
		medium_value = 1,
		hard_value = 1,
		custom_value = 1
		flags = CONFIG_INGAME
		});

		AddLabels("dummy3",{_0 = "None", _1 = "Individual serving of industries", _2 = "Global serving of industries"});
		
		AddSetting({name = "dummy4",
		description = "System 1: Percent of industries required to be served",
		min_value = 0
		max_value = 99
		easy_value = 35,
		medium_value = 55,
		hard_value = 75,
		custom_value = 50,
		step_size = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "dummy5",
		description = "System 1: Percent of cargo to transport from an industry",
		min_value = 0
		max_value = 99
		easy_value = 25,
		medium_value = 50,
		hard_value = 75,
		custom_value = 50,
		step_size = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "dummy6",
		description = "System 2: Percent of total max points you must score",
		min_value = 0
		max_value = 99
		easy_value = 25,
		medium_value = 50,
		hard_value = 75,
		custom_value = 50,
		step_size = 10,
		flags = CONFIG_INGAME
		});

		AddSetting({name = "dummy7",
		description = "Industry: Try to keep the number of industries on map",
		easy_value = 0,
		medium_value = 0,
		hard_value = 0,
		custom_value = 0,
		flags = CONFIG_INGAME|CONFIG_BOOLEAN
		});
	}

}

RegisterGS(GSToyHelper());
