class GSToyHelper extends GSController
{
firsttime_start = true
system = 0
x = 0
y = 0

town = 0
towns_served = 0
pass_amt = 0
mail_mult = 0

industry = 0
industry_count = 0
industries_served = 0
ind_density = 0
industry_pts = 0
min_industry_pts = 0
cargo = 0

min_ind_served = 0
min_ind_transport = 0
}

function GSToyHelper::CheckTownPASS(Town) {
	mail_mult = GetSetting("dummy2")
	local pass_transport = GSTown.GetLastMonthTransportedPercentage(town,0)+(mail_mult *GSTown.GetLastMonthTransportedPercentage(town,2))/100;
	pass_amt = GetSetting("dummy")
	if (pass_transport >= pass_amt) {
		GSTown.SetGrowthRate(town,GSTown.TOWN_GROWTH_NORMAL)
		GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_MET, pass_transport, pass_amt))
		towns_served ++
	} else {
		GSTown.SetGrowthRate(town,GSTown.TOWN_GROWTH_NONE)
		GSTown.SetText(Town, GSText(GSText.STR_TOWN_PASS_NMET, pass_transport, pass_amt))
	}
}

function GSToyHelper::CheckIndustriesA() {
	// A is the first system
	min_ind_served = GetSetting("dummy4")
	min_ind_transport = GetSetting("dummy5")
	industry_count = 0;
	local cargo_transported = 0;
	local c = 0;
	y = 0
	local list = GSIndustryList()
	industries_served = 0;
	for (local v = list.Begin (); !list.IsEnd (); v = 	list.Next ()) {
		y++
		industry_count ++;
		local ind_type = GSIndustry.GetIndustryType(v)
		local produced_cargoes = GSIndustryType.GetProducedCargo(ind_type)
		local num_cargoes = produced_cargoes.Count()
		local transport_percent = 0
		foreach (c, _ in produced_cargoes) {
			transport_percent += GSIndustry.GetLastMonthTransportedPercentage(v,c)
		}
		if (GSIndustryType.GetProducedCargo(ind_type).Count() == 0) {
			if (GSIndustry.GetAmountOfStationsAround(v)>0) {
				industries_served ++
			}
		} else if (num_cargoes == 0) {
			industry_count --
		} else if (transport_percent/num_cargoes>min_ind_transport){
			industries_served ++
		} 
	}

	industries_served *= 1;
	if (industries_served/industry_count >= min_ind_served) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_MET, industries_served, industry_count))
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_A_NMET, industries_served, industry_count))
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, industries_served/industry_count))
}

function GSToyHelper::CheckIndustriesB() {
	// B is the second system
	industry_count = GSIndustry.GetIndustryCount()
	industry_pts = 0
	min_industry_pts = GetSetting("dummy6")
	local c = 0
	
	local list = GSIndustryList()

	for (local v = list.Begin (); !list.IsEnd (); v = 	list.Next ()) {
		industry = v;
		industry_count ++;
		GSLog.Info(industry_count)
		local ind_type = GSIndustry.GetIndustryType(v)
		local produced_cargoes = GSIndustryType.GetProducedCargo(ind_type)
		local num_cargoes = produced_cargoes.Count()
		if (num_cargoes == 0) {
			industry_count --
		} else {
			foreach (c, _ in produced_cargoes) {
				industry_pts += GSIndustry.GetLastMonthTransportedPercentage(v,c)/num_cargoes
			}
		}
	}
	if (industry_pts/industry_count >= min_industry_pts) {
		GSGameSettings.SetValue("difficulty.industry_density", ind_density)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_MET, industry_pts, industry_count*min_industry_pts))
	} else {
		GSGameSettings.SetValue("difficulty.industry_density", 0)
		GSGoal.SetText(0, GSText(GSText.STR_IND_GOAL_B_NMET, industry_pts, industry_count*min_industry_pts))
	}
	GSGoal.SetProgress(0, GSText(GSText.STR_PROGRESS, industry_pts/industry_count))

}

function GSToyHelper::CheckIndustryClose() {
	local event = null
	local eventtype = null
	local event2 = null
	while (GSEventController.IsEventWaiting()) {
		event = GSEventController.GetNextEvent()
		eventtype = event.GetEventType()
		switch (eventtype) {
			case GSEvent.ET_INDUSTRY_CLOSE: 
				event = GSEventIndustryClose.Convert(event)
				local industry = event.GetIndustryID()
				if (!GSIndustry.IsValidIndustry(industry)) break;
				
				
				local indtype = GSIndustry.GetIndustryType(industry)
				GSIndustryType.ProspectIndustry(indtype)
		}
	}
}

function GSToyHelper::Start() {
	GSLog.Info("Listing cargoes...")
	for (local x = 0; x < 32; x++) {
		GSLog.Info(x+": "+GSCargo.GetCargoLabel(x))
	}
	GSLog.Info("Initializing goals...")
	if (true) {
		for (local i = 0; i < 10; i++) {GSGoal.Remove(i)}
		GSGoal.New(-1, "System ? - Initializing",0,0)
		GSGoal.New(-1, "Towns served: ? / ?",0,0)
	}
	
	GSLog.Info("Initializing...")
	ind_density = GSGameSettings.GetValue("difficulty.industry_density")
	industry_count = GSIndustry.GetIndustryCount()
	while (true) {
		x++
		towns_served = 0
		for (town = 0; town < GSTown.GetTownCount(); town += 1) {
			GSToyHelper.CheckTownPASS(town)
		}
		GSGoal.SetText(1, GSText(GSText.STR_TOWN_GOAL, towns_served, GSTown.GetTownCount()))
			GSGoal.SetProgress(1, GSText(GSText.STR_PROGRESS2, towns_served*100/GSTown.GetTownCount()))

		if (GetSetting("dummy3") == 1 && industry_count) {
			GSToyHelper.CheckIndustriesA()
		} else if (GetSetting("dummy3")==2 && industry_count) {
			GSToyHelper.CheckIndustriesB()
		} else if (GetSetting("dummy3")==0) {
			GSGoal.SetText(0, "No industry control is taking place")
		}
		if (GetSetting("dummy7")) {
		GSToyHelper.CheckIndustryClose()
		}
		this.Sleep(74 * 7) // sleep for a week at a time
	}
}

function GSToyHelper::Load(version, data)
{
	firsttime_start = false
}

function GSToyHelper::Save() {
return {
	x = 0 // this bypasses the "Script took too long to save" error message.
};
}
