/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.xml.XmlEnclosingTagUnwrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RemoveTagAndPromoteChildrenIntentionAction
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = XmlAnalysisBundle.message((String)"xml.quickfix.remove.tag.family", (Object[])new Object[0]);
        if (string == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        XmlTag tag;
        if (project == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(2);
        }
        if ((tag = RemoveTagAndPromoteChildrenIntentionAction.getTag(editor, psiFile)) == null) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        ASTNode startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode());
        if (startEnd == null || offset <= startEnd.getStartOffset()) {
            return true;
        }
        ASTNode endStart = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(tag.getNode());
        return endStart == null || offset >= startEnd.getStartOffset();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            RemoveTagAndPromoteChildrenIntentionAction.$$$reportNull$$$0(3);
        }
        new XmlEnclosingTagUnwrapper().unwrap(editor, (PsiElement)RemoveTagAndPromoteChildrenIntentionAction.getTag(editor, psiFile));
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static XmlTag getTag(Editor editor, PsiFile psiFile) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = psiFile.findElementAt(offset);
        PsiElement psiElement = parent = element != null ? element.getParent() : null;
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        if (parent instanceof XmlAttribute) {
            return null;
        }
        element = psiFile.findElementAt(offset - 1);
        PsiElement psiElement2 = parent = element != null ? element.getParent() : null;
        if (parent instanceof XmlTag) {
            return (XmlTag)parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveTagAndPromoteChildrenIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveTagAndPromoteChildrenIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

