/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commit.signing;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.project.Project;
import git4idea.commit.signing.GpgAgentCommandExecutor;
import git4idea.config.GitExecutable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\r\"\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lgit4idea/commit/signing/GpgAgentCommandExecutorImpl;", "Lgit4idea/commit/signing/GpgAgentCommandExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "executable", "Lgit4idea/config/GitExecutable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/config/GitExecutable;)V", "execute", "", "", "command", "params", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/util/List;", "intellij.vcs.git"})
final class GpgAgentCommandExecutorImpl
implements GpgAgentCommandExecutor {
    @NotNull
    private final Project project;
    @NotNull
    private final GitExecutable executable;

    public GpgAgentCommandExecutorImpl(@NotNull Project project, @NotNull GitExecutable executable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        this.project = project;
        this.executable = executable;
    }

    @Override
    @NotNull
    public List<String> execute(@NotNull String command, String ... params) {
        GeneralCommandLine generalCommandLine;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (this.executable.isLocal()) {
            var4_3 = new String[]{command};
            GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(var4_3);
            generalCommandLine = generalCommandLine2;
        } else {
            var4_3 = new String[]{command};
            generalCommandLine = this.executable.createBundledCommandLine(this.project, var4_3);
        }
        GeneralCommandLine commandLine = generalCommandLine;
        ProcessOutput processOutput = new CapturingProcessHandler.Silent(commandLine.withParameters(Arrays.copyOf(params, params.length))).runProcess(10000, true);
        List list = processOutput.getStdoutLines();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
        Collection collection = list;
        List list2 = processOutput.getStderrLines();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStderrLines(...)");
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }
}

