/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.execService.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.python.community.execService.impl.ExecLoggerService;
import com.intellij.python.community.execService.impl.LoggedProcess;
import com.intellij.python.community.execService.impl.LoggedProcessExe;
import com.intellij.python.community.execService.impl.LoggedProcessExitInfo;
import com.intellij.python.community.execService.impl.LoggedProcessLine;
import com.intellij.python.community.execService.impl.LoggingInputStream;
import com.intellij.python.community.execService.impl.LoggingKt;
import com.intellij.util.io.ProcessKt;
import com.jetbrains.python.TraceContext;
import com.jetbrains.python.errorProcessing.Exe;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Clock;
import kotlin.time.Instant;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000e\u0012\u0006\u0010\u000f\u001a\u00020\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010\u001e\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u001fH\u0016J\b\u0010&\u001a\u00020'H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u0001H\u0016J\n\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/python/community/execService/impl/LoggingProcess;", "Ljava/lang/Process;", "backingProcess", "traceContext", "Lcom/jetbrains/python/TraceContext;", "startedAt", "Lkotlin/time/Instant;", "cwd", "", "exe", "Lcom/jetbrains/python/errorProcessing/Exe;", "args", "", "env", "", "target", "<init>", "(Ljava/lang/Process;Lcom/jetbrains/python/TraceContext;Lkotlin/time/Instant;Ljava/lang/String;Lcom/jetbrains/python/errorProcessing/Exe;Ljava/util/List;Ljava/util/Map;Ljava/lang/String;)V", "loggedProcess", "Lcom/intellij/python/community/execService/impl/LoggedProcess;", "getLoggedProcess", "()Lcom/intellij/python/community/execService/impl/LoggedProcess;", "stdoutStream", "Lcom/intellij/python/community/execService/impl/LoggingInputStream;", "stderrStream", "getOutputStream", "Ljava/io/OutputStream;", "getInputStream", "Ljava/io/InputStream;", "getErrorStream", "waitFor", "", "", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "exitValue", "destroy", "", "destroyForcibly", "toHandle", "Ljava/lang/ProcessHandle;", "supportsNormalTermination", "intellij.python.community.execService"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nlogging.kt\nKotlin\n*S Kotlin\n*F\n+ 1 logging.kt\ncom/intellij/python/community/execService/impl/LoggingProcess\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,271:1\n30#2,2:272\n*S KotlinDebug\n*F\n+ 1 logging.kt\ncom/intellij/python/community/execService/impl/LoggingProcess\n*L\n121#1:272,2\n*E\n"})
public final class LoggingProcess
extends Process {
    @NotNull
    private final Process backingProcess;
    @NotNull
    private final LoggedProcess loggedProcess;
    @NotNull
    private final LoggingInputStream stdoutStream;
    @NotNull
    private final LoggingInputStream stderrStream;

    public LoggingProcess(@NotNull Process backingProcess, @Nullable TraceContext traceContext, @NotNull Instant startedAt, @Nullable String cwd, @NotNull Exe exe, @NotNull List<String> args2, @NotNull Map<String, String> env, @NotNull String target) {
        Long l;
        TraceContext traceContext2;
        LoggingProcess loggingProcess;
        Intrinsics.checkNotNullParameter((Object)backingProcess, (String)"backingProcess");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        Intrinsics.checkNotNullParameter((Object)exe, (String)"exe");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        Intrinsics.checkNotNullParameter(env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.backingProcess = backingProcess;
        InputStream inputStream = this.backingProcess.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        this.stdoutStream = new LoggingInputStream(inputStream);
        InputStream inputStream2 = this.backingProcess.getErrorStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
        this.stderrStream = new LoggingInputStream(inputStream2);
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        ComponentManager $this$service$iv = (ComponentManager)application;
        boolean $i$f$service = false;
        Class<ExecLoggerService> serviceClass$iv = ExecLoggerService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ExecLoggerService service = (ExecLoggerService)object;
        MutableSharedFlow linesFlow = SharedFlowKt.MutableSharedFlow$default((int)1024, (int)0, null, (int)6, null);
        MutableStateFlow exitInfoFlow = StateFlowKt.MutableStateFlow(null);
        TraceContext traceContext3 = traceContext;
        LoggingProcess loggingProcess2 = this;
        try {
            loggingProcess = loggingProcess2;
            traceContext2 = traceContext3;
            l = this.backingProcess.pid();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            loggingProcess = loggingProcess2;
            traceContext2 = traceContext3;
            l = null;
        }
        MutableStateFlow mutableStateFlow = exitInfoFlow;
        SharedFlow sharedFlow = (SharedFlow)linesFlow;
        String string = target;
        Map<String, String> map = env;
        List<String> list = args2;
        LoggedProcessExe loggedProcessExe = new LoggedProcessExe(exe.toString(), exe.pathParts());
        String string2 = cwd;
        Instant instant = startedAt;
        Long l2 = l;
        TraceContext traceContext4 = traceContext2;
        loggingProcess.loggedProcess = new LoggedProcess(traceContext4, l2, instant, string2, loggedProcessExe, list, map, string, (SharedFlow<LoggedProcessLine>)sharedFlow, (MutableStateFlow<LoggedProcessExitInfo>)mutableStateFlow);
        BuildersKt.launch$default((CoroutineScope)service.getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(service, this, (MutableSharedFlow<LoggedProcessLine>)linesFlow, (MutableStateFlow<LoggedProcessExitInfo>)exitInfoFlow, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ ExecLoggerService $service;
            final /* synthetic */ LoggingProcess this$0;
            final /* synthetic */ MutableSharedFlow<LoggedProcessLine> $linesFlow;
            final /* synthetic */ MutableStateFlow<LoggedProcessExitInfo> $exitInfoFlow;
            {
                this.$service = $service;
                this.this$0 = $receiver;
                this.$linesFlow = $linesFlow;
                this.$exitInfoFlow = $exitInfoFlow;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$service.getProcessesInternal$intellij_python_community_execService().emit((Object)this.this$0.getLoggedProcess(), (Continuation)this);
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ProcessKt.awaitExit((Process)this.this$0, (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        stdoutReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(LoggingProcess.access$getStdoutStream$p(this.this$0).getByteArray())));
                        stderrReader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(LoggingProcess.access$getStderrStream$p(this.this$0).getByteArray())));
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)stdoutReader);
                        this.L$1 = stderrReader;
                        this.label = 3;
                        v2 = LoggingKt.access$collectOutputLines(stdoutReader, this.$linesFlow, LoggedProcessLine.Kind.OUT, (Continuation)this);
                        if (v2 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl35
                    }
                    case 3: {
                        stderrReader = (BufferedReader)this.L$1;
                        stdoutReader = (BufferedReader)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl35:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)stdoutReader);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)stderrReader);
                        this.label = 4;
                        v3 = LoggingKt.access$collectOutputLines(stderrReader, this.$linesFlow, LoggedProcessLine.Kind.ERR, (Continuation)this);
                        if (v3 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl47
                    }
                    case 4: {
                        stderrReader = (BufferedReader)this.L$1;
                        stdoutReader = (BufferedReader)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl47:
                        // 2 sources

                        this.$exitInfoFlow.setValue((Object)new LoggedProcessExitInfo(Clock.System.INSTANCE.now(), this.this$0.exitValue(), null, 4, null));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final LoggedProcess getLoggedProcess() {
        return this.loggedProcess;
    }

    @Override
    @NotNull
    public OutputStream getOutputStream() {
        OutputStream outputStream = this.backingProcess.getOutputStream();
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getOutputStream(...)");
        return outputStream;
    }

    @Override
    @NotNull
    public InputStream getInputStream() {
        return this.stdoutStream;
    }

    @Override
    @NotNull
    public InputStream getErrorStream() {
        return this.stderrStream;
    }

    @Override
    public int waitFor() {
        return this.backingProcess.waitFor();
    }

    @Override
    public boolean waitFor(long timeout, @NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        return this.backingProcess.waitFor(timeout, unit);
    }

    @Override
    public int exitValue() {
        return this.backingProcess.exitValue();
    }

    @Override
    public void destroy() {
        this.backingProcess.destroy();
    }

    @Override
    @Nullable
    public Process destroyForcibly() {
        return this.backingProcess.destroyForcibly();
    }

    @Override
    @Nullable
    public ProcessHandle toHandle() {
        return this.backingProcess.toHandle();
    }

    @Override
    public boolean supportsNormalTermination() {
        return this.backingProcess.supportsNormalTermination();
    }

    public static final /* synthetic */ LoggingInputStream access$getStdoutStream$p(LoggingProcess $this) {
        return $this.stdoutStream;
    }

    public static final /* synthetic */ LoggingInputStream access$getStderrStream$p(LoggingProcess $this) {
        return $this.stderrStream;
    }
}

