/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;

public class RegExpMatch {
    private final IntList groups = new IntArrayList();

    public RegExpMatch() {
    }

    public RegExpMatch(int start, int end) {
        this.add(start, end);
    }

    public void add(int start, int end) {
        this.groups.add(start);
        this.groups.add(end);
    }

    public int count() {
        return this.groups.size() / 2;
    }

    public int start(int i) {
        if (i < 0 || i > this.count() - 1) {
            throw new IllegalArgumentException();
        }
        return this.groups.getInt(i * 2);
    }

    public int end(int i) {
        if (i < 0 || i > this.count() - 1) {
            throw new IllegalArgumentException();
        }
        return this.groups.getInt(i * 2 + 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.groups.equals((Object)((RegExpMatch)o).groups);
    }

    public int hashCode() {
        return this.groups.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RegExpMatch{");
        int max = this.groups.size();
        for (int i = 0; i < max; i += 2) {
            builder.append('[').append(this.groups.getInt(i)).append(", ").append(this.groups.getInt(i + 1)).append(']');
        }
        builder.append('}');
        return builder.toString();
    }
}

