/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.compact.parser;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import java.util.IdentityHashMap;
import java.util.Map;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.compact.RncElementTypes;
import org.intellij.plugins.relaxNG.compact.RncTokenTypes;
import org.intellij.plugins.relaxNG.compact.parser.DeclarationParsing;
import org.intellij.plugins.relaxNG.compact.parser.NameClassParsing;

public final class PatternParsing
extends DeclarationParsing {
    private static final Map<IElementType, IElementType> TOKEN_MAP = new IdentityHashMap<IElementType, IElementType>();
    private final NameClassParsing myNameClassParsing;

    public PatternParsing(PsiBuilder builder) {
        super(builder);
        this.myNameClassParsing = new NameClassParsing(builder);
    }

    public void parse() {
        this.parseTopLevel();
    }

    @Override
    protected boolean parsePattern() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseQuantifiedPattern()) {
            marker.drop();
            return false;
        }
        while (RncTokenTypes.BINARY_OPS.contains(this.currentToken())) {
            IElementType t = this.currentToken();
            if (!RncTokenTypes.BINARY_OPS.contains(t)) continue;
            do {
                this.advance();
                if (this.parseQuantifiedPattern()) continue;
                this.error(RelaxngBundle.message("relaxng.parse.error.pattern-expected", new Object[0]));
            } while (this.currentToken() == t);
            marker.done(TOKEN_MAP.get(t));
            marker = marker.precede();
        }
        marker.drop();
        return true;
    }

    private boolean parseQuantifiedPattern() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (!this.parseSinglePattern()) {
            marker.drop();
            return false;
        }
        IElementType t = this.currentToken();
        if (this.matches(RncTokenTypes.QUANTIFIER_OPS)) {
            marker.done(TOKEN_MAP.get(t));
        } else {
            marker.drop();
        }
        return true;
    }

    private boolean parseSinglePattern() {
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (this.matches(ATTR_OR_ELEMENT)) {
            if (!this.myNameClassParsing.parseNameClass()) {
                this.error(RelaxngBundle.message("relaxng.parse.error.name-class-expected", new Object[0]));
                marker.drop();
                return false;
            }
            this.parseBracedPattern();
            marker.done(RncElementTypes.PATTERN);
        } else if (this.matches(RncTokenTypes.KEYWORD_LIST)) {
            this.parseBracedPattern();
            marker.done(RncElementTypes.LIST_PATTERN);
        } else if (this.matches(RncTokenTypes.KEYWORD_MIXED)) {
            this.parseBracedPattern();
            marker.done(RncElementTypes.MIXED_PATTERN);
        } else if (this.matches(RncTokenTypes.KEYWORD_EXTERNAL)) {
            this.parseAnyUriLiteral();
            this.parseInherit();
            marker.done(RncElementTypes.EXTERNAL_REF);
        } else if (this.matches(RncTokenTypes.KEYWORD_NOT_ALLOWED)) {
            marker.done(RncElementTypes.NOT_ALLOWED_PATTERN);
        } else if (this.matches(RncTokenTypes.KEYWORD_TEXT)) {
            marker.done(RncElementTypes.TEXT_PATTERN);
        } else if (this.matches(RncTokenTypes.KEYWORD_EMPTY)) {
            marker.done(RncElementTypes.EMPTY_PATTERN);
        } else if (this.matches(RncTokenTypes.KEYWORD_PARENT)) {
            this.match(RncTokenTypes.IDENTIFIERS, RelaxngBundle.message("relaxng.parse.error.identifier-expected", new Object[0]));
            marker.done(RncElementTypes.PARENT_REF);
        } else if (this.matches(RncTokenTypes.KEYWORD_GRAMMAR)) {
            this.parseBracedGrammarContents();
            marker.done(RncElementTypes.GRAMMAR_PATTERN);
        } else if (this.matches(RncTokenTypes.LPAREN)) {
            if (!this.parsePattern()) {
                this.error(RelaxngBundle.message("relaxng.parse.error.pattern-expected", new Object[0]));
            }
            this.match(RncTokenTypes.RPAREN, RelaxngBundle.message("relaxng.parse.error.rparen-expected", new Object[0]));
            marker.done(RncElementTypes.GROUP_PATTERN);
        } else if (this.matches(RncTokenTypes.IDENTIFIERS)) {
            marker.done(RncElementTypes.REF_PATTERN);
        } else if (this.matches(LA_DATATYPE)) {
            this.parseDatatype();
            marker.done(RncElementTypes.DATATYPE_PATTERN);
        } else if (this.currentToken() == RncTokenTypes.PREFIXED_NAME) {
            this.makeName();
            this.parseDatatype();
            marker.done(RncElementTypes.DATATYPE_PATTERN);
        } else if (this.matches(RncTokenTypes.LITERAL)) {
            marker.done(RncElementTypes.DATATYPE_PATTERN);
        } else {
            marker.drop();
            return false;
        }
        return true;
    }

    private void parseDatatype() {
        if (this.currentToken() == RncTokenTypes.LITERAL) {
            this.advance();
        } else if (this.matches(RncTokenTypes.LBRACE)) {
            this.parseParams();
            if (this.matches(RncTokenTypes.MINUS) && !this.parsePattern()) {
                this.error(RelaxngBundle.message("relaxng.parse.error.pattern-expected", new Object[0]));
            }
            this.match(RncTokenTypes.RBRACE, RelaxngBundle.message("relaxng.parse.error.rbrace-expected", new Object[0]));
        }
    }

    private void parseBracedPattern() {
        this.match(RncTokenTypes.LBRACE, RelaxngBundle.message("relaxng.parse.error.lbrace-expected", new Object[0]));
        if (!this.parsePattern()) {
            this.error(RelaxngBundle.message("relaxng.parse.error.pattern-expected", new Object[0]));
        }
        this.match(RncTokenTypes.RBRACE, RelaxngBundle.message("relaxng.parse.error.rbrace-expected", new Object[0]));
    }

    private void parseParams() {
        IElementType t = this.currentToken();
        if (t != RncTokenTypes.RBRACE) {
            do {
                PsiBuilder.Marker marker = this.myBuilder.mark();
                this.match(RncTokenTypes.IDENTIFIER_OR_KEYWORD, RelaxngBundle.message("relaxng.parse.error.identifier-expected", new Object[0]));
                this.match(RncTokenTypes.EQ, RelaxngBundle.message("relaxng.parse.error.equals-expected", new Object[0]));
                this.match(RncTokenTypes.LITERAL, RelaxngBundle.message("relaxng.parse.error.literal-expected", new Object[0]));
                marker.done(RncElementTypes.PARAM);
            } while (RncTokenTypes.IDENTIFIER_OR_KEYWORD.contains(this.currentToken()));
        }
    }

    static {
        TOKEN_MAP.put(RncTokenTypes.COMMA, RncElementTypes.SEQUENCE);
        TOKEN_MAP.put(RncTokenTypes.PIPE, RncElementTypes.CHOICE);
        TOKEN_MAP.put(RncTokenTypes.AND, RncElementTypes.INTERLEAVE);
        TOKEN_MAP.put(RncTokenTypes.STAR, RncElementTypes.ZERO_OR_MORE);
        TOKEN_MAP.put(RncTokenTypes.PLUS, RncElementTypes.ONE_OR_MORE);
        TOKEN_MAP.put(RncTokenTypes.QUEST, RncElementTypes.OPTIONAL);
    }
}

