/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.duplicates;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import mediathek.config.Daten;
import mediathek.daten.DatenFilm;
import mediathek.gui.duplicates.FilmStatistics;

public class CommonStatsEvaluationTask
implements Runnable {
    @Override
    public void run() {
        List<DatenFilm> films = Daten.getInstance().getListeFilme().parallelStream().filter(f -> !f.isLivestream()).toList();
        EventList<FilmStatistics> statisticsList = Daten.getInstance().getCommonStatistics();
        Map<String, Long> statisticsMap = films.parallelStream().collect(Collectors.groupingBy(DatenFilm::getSender, Collectors.counting()));
        TransactionList tList = new TransactionList(statisticsList);
        statisticsList.getReadWriteLock().writeLock().lock();
        tList.beginEvent(true);
        tList.clear();
        for (String sender : statisticsMap.keySet()) {
            tList.add((Object)new FilmStatistics(sender, statisticsMap.get(sender)));
        }
        tList.commitEvent();
        statisticsList.getReadWriteLock().writeLock().unlock();
    }
}

