/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.resources;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.Icon;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceBundles;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.ActionAcceleratorManager;
import org.freeplane.core.ui.TimePeriodUnits;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.icon.factory.IconFactory;
import org.freeplane.features.mode.AController;
import org.freeplane.features.mode.Controller;

public abstract class ResourceController {
    public static final String USE_ACCENT_COLOR = "useAccentColor=true";
    public static final String USE_ACCENT_COLOR_QUERY = "?useAccentColor=true";
    public static final String FREEPLANE_PROPERTIES = "/freeplane.properties";
    public static final String LOCAL_PROPERTIES = "LocalProperties.";
    public static final String RESOURCE_DRAW_RECTANGLE_FOR_SELECTION = "standarddrawrectangleforselection";
    public static final String RESOURCE_HIGHLIGHT_ASCENDANT_EDGES = "highlightascendantedges";
    private final List<IFreeplanePropertyListener> propertyChangeListeners = new Vector<IFreeplanePropertyListener>();
    private static ActionAcceleratorManager acceleratorManager;
    private ResourceBundles resources;
    public static final String FREEPLANE_RESOURCE_URL_PROTOCOL = "freeplaneresource";
    public static final String OBJECT_TYPE = "ObjectType";
    private final Locale systemLocale;
    private Map<String, Icon> iconCache = new HashMap<String, Icon>();

    public static ResourceController getResourceController() {
        return Controller.getCurrentController().getResourceController();
    }

    public ResourceController() {
        this.systemLocale = Locale.getDefault();
    }

    public void addLanguageResources(String language, URL url) {
        this.resources.addResources(language, url);
    }

    public void addLanguageResources(String language, Map<String, String> resources) {
        this.resources.addResources(language, resources);
    }

    public void putUserResourceString(String key, String value) {
        this.resources.putUserResourceString(key, value);
    }

    public void putResourceString(String key, String value) {
        this.resources.putResourceString(key, value);
    }

    public void addPropertyChangeListener(IFreeplanePropertyListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void addPropertyChangeListenerAndPropagate(IFreeplanePropertyListener listener) {
        this.addPropertyChangeListener(listener);
        for (Map.Entry<Object, Object> entry : this.getProperties().entrySet()) {
            String key = (String)entry.getKey();
            listener.propertyChanged(key, (String)entry.getValue(), null);
        }
    }

    protected void loadAnotherLanguage() {
        this.resources.loadAnotherLanguage(this.getProperty("language"));
    }

    public void firePropertyChanged(String property, String value, String oldValue) {
        if (oldValue == null || !oldValue.equals(value)) {
            for (IFreeplanePropertyListener listener : this.getPropertyChangeListeners()) {
                listener.propertyChanged(property, value, oldValue);
            }
        }
    }

    public boolean getBooleanProperty(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String value = this.getProperty(key, null);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public <T extends Enum<T>> T getEnumProperty(String propertyName, Enum<T> defaultValue) {
        try {
            String propertyValue = this.getProperty(propertyName);
            if (propertyValue != null) {
                defaultValue = Enum.valueOf(defaultValue.getClass(), propertyValue.toUpperCase(Locale.ENGLISH));
            }
        }
        catch (Exception e) {
            LogUtils.severe(e);
        }
        return (T)defaultValue;
    }

    public String getDefaultProperty(String key) {
        return null;
    }

    public double getDoubleProperty(String key, double defaultValue) {
        try {
            return Double.parseDouble(ResourceController.getResourceController().getProperty(key));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public abstract String getFreeplaneUserDirectory();

    public int getIntProperty(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public int getLengthProperty(String name) {
        Quantity<LengthUnit> quantity = this.getLengthQuantityProperty(name);
        return quantity.toBaseUnitsRounded();
    }

    public Quantity<LengthUnit> getLengthQuantityProperty(String name) {
        String property = this.getProperty(name);
        Quantity quantity = Quantity.fromString((String)property, (Enum)LengthUnit.px);
        return quantity;
    }

    public int getTimeProperty(String name) {
        Quantity<TimePeriodUnits> quantity = this.getTimeQuantityProperty(name);
        return quantity.toBaseUnitsRounded();
    }

    public Quantity<TimePeriodUnits> getTimeQuantityProperty(String name) {
        String property = this.getProperty(name);
        Quantity quantity = Quantity.fromString((String)property, (Enum)TimePeriodUnits.ms);
        return quantity;
    }

    public int getIntProperty(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public double getDoubleProperty(String key) {
        return Double.parseDouble(this.getProperty(key));
    }

    public long getLongProperty(String key, long defaultValue) {
        try {
            return Long.parseLong(this.getProperty(key));
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public Color getColorProperty(String name) {
        String string = this.getProperty(name);
        return ColorUtils.stringToColor(string);
    }

    public File getFile(String key) {
        String value = this.getProperty(key);
        String freeplaneUserDirectory = ResourceController.getResourceController().getFreeplaneUserDirectory();
        value = TextUtils.replaceAtBegin(value, "{freeplaneuserdir}", freeplaneUserDirectory);
        File file = new File(value);
        return file;
    }

    public abstract Properties getProperties();

    public abstract String getProperty(String var1);

    public String getProperty(String key, String value) {
        return this.getProperties().getProperty(key, value);
    }

    public boolean containsProperty(String key) {
        return this.getProperties().containsKey(key);
    }

    public Collection<IFreeplanePropertyListener> getPropertyChangeListeners() {
        return Collections.unmodifiableCollection(this.propertyChangeListeners);
    }

    public URL getResource(String resourcePath) {
        return this.getClass().getResource(resourcePath);
    }

    public InputStream getResourceStream(String resFileName) throws IOException {
        URL resUrl = this.getResource(resFileName);
        if (resUrl == null) {
            LogUtils.severe("Can't find " + resFileName + " as resource.");
            throw new IllegalArgumentException("Can't find " + resFileName + " as resource.");
        }
        return new BufferedInputStream(resUrl.openStream());
    }

    public String getResourceBaseDir() {
        return "";
    }

    public String getInstallationBaseDir() {
        return "";
    }

    public ResourceBundle getResources() {
        if (this.resources == null) {
            this.resources = new ResourceBundles(this.getProperty("language"));
        }
        return this.resources;
    }

    public String getLanguageCode() {
        return this.resources.getLanguageCode();
    }

    public String getDefaultLanguageCode() {
        return this.resources.getDefaultLanguageCode();
    }

    public String getText(String key, String resource) {
        return ((ResourceBundles)this.getResources()).getResourceString(key, resource);
    }

    protected void init() {
    }

    public void removePropertyChangeListener(IFreeplanePropertyListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public abstract void saveProperties();

    public abstract void setDefaultProperty(String var1, String var2);

    public void setProperty(String property, boolean value) {
        this.setProperty(property, Boolean.toString(value));
    }

    public void setProperty(String name, int value) {
        this.setProperty(name, Integer.toString(value));
    }

    public void setProperty(String name, long value) {
        this.setProperty(name, Long.toString(value));
    }

    public void setProperty(String name, double value) {
        this.setProperty(name, Double.toString(value));
    }

    public abstract void setProperty(String var1, String var2);

    public static boolean loadProperties(Properties resultProps, URL url) {
        boolean bl;
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        try {
            resultProps.load(in);
            LogUtils.info("Loaded properties from " + url);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                System.err.println("Could not load properties from " + url);
                return false;
            }
        }
        ((InputStream)in).close();
        return bl;
    }

    public void addDefaults(URL propertiesUrl) {
        Properties props = new Properties();
        ResourceController.loadProperties(props, propertiesUrl);
        this.addDefaults(props);
    }

    public <KT, VT> void addDefaults(Map<KT, VT> defaultProperties) {
        for (Map.Entry<KT, VT> entry : defaultProperties.entrySet()) {
            this.setDefaultProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public boolean isApplet() {
        return false;
    }

    public void removePropertyChangeListener(Class<? extends AController.IActionOnChange> clazz, AFreeplaneAction action) {
        Iterator<IFreeplanePropertyListener> iterator = this.propertyChangeListeners.iterator();
        while (iterator.hasNext()) {
            IFreeplanePropertyListener next = iterator.next();
            if (!(next instanceof AController.IActionOnChange) || ((AController.IActionOnChange)((Object)next)).getAction() != action) continue;
            iterator.remove();
            return;
        }
    }

    public ActionAcceleratorManager getAcceleratorManager() {
        if (acceleratorManager == null) {
            acceleratorManager = new ActionAcceleratorManager();
        }
        return acceleratorManager;
    }

    public Icon getIcon(String iconKey) {
        return this.getIcon(iconKey, false);
    }

    public Icon getOptionalIcon(String iconKey) {
        return this.getIcon(iconKey, true);
    }

    private Icon getIcon(String iconKey, boolean isOptional) {
        String iconResource;
        Icon icon = this.iconCache.get(iconKey);
        if (icon == null && (icon = this.loadIcon(iconResource = iconKey.startsWith("/") ? iconKey : this.getProperty(iconKey, null), isOptional)) != null) {
            this.iconCache.put(iconKey, icon);
        }
        return icon;
    }

    public URL getIconResource(String resourcePath) {
        boolean usesAccentColor;
        String urlPath;
        URL url;
        if (resourcePath != null && (url = this.getResource(urlPath = (usesAccentColor = resourcePath.endsWith(USE_ACCENT_COLOR_QUERY)) ? resourcePath.substring(0, resourcePath.length() - USE_ACCENT_COLOR_QUERY.length()) : resourcePath)) != null) {
            return usesAccentColor ? this.withAccentColorQuery(url) : url;
        }
        return null;
    }

    private Icon loadIcon(String resourcePath, boolean isOptional) {
        if (resourcePath == null) {
            return null;
        }
        URL url = this.getIconResource(resourcePath);
        if (url != null) {
            return IconFactory.getInstance().getIcon(url, IconFactory.DEFAULT_UI_ICON_HEIGHT);
        }
        if (!isOptional) {
            LogUtils.severe("can not load icon '" + resourcePath + "'");
        }
        return null;
    }

    private URL withAccentColorQuery(URL url) {
        try {
            return new URL(url.toString() + USE_ACCENT_COLOR_QUERY);
        }
        catch (MalformedURLException e) {
            LogUtils.severe(e);
            return url;
        }
    }

    public Icon getImageIcon(String iconKey) {
        return FreeplaneIconFactory.toImageIcon(this.getIcon(iconKey));
    }

    public Locale getSystemLocale() {
        return this.systemLocale;
    }

    public String[] getArrayProperty(String key, String separator) {
        String joinedValues = this.getProperty(key);
        String[] groupNames = joinedValues != null ? joinedValues.split(separator) : new String[]{};
        return groupNames;
    }

    public abstract Properties getSecuredProperties();

    public abstract void secureProperty(String var1);

    public boolean isPropertySetByUser(String key) {
        return false;
    }

    public String loadString(String path) {
        Scanner s = new Scanner(this.getResourceStream(path));
        try {
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            s.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LogUtils.severe(e);
                return "";
            }
        }
    }
}

