/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.message.StreamsGroupHeartbeatRequestData;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTopologyValue;
import org.apache.kafka.coordinator.group.streams.StreamsCoordinatorRecordHelpers;

public record StreamsTopology(int topologyEpoch, Map<String, StreamsGroupTopologyValue.Subtopology> subtopologies) {
    public StreamsTopology {
        if (topologyEpoch < 0) {
            throw new IllegalArgumentException("Topology epoch must be non-negative.");
        }
        subtopologies = Collections.unmodifiableMap(Objects.requireNonNull(subtopologies, "Subtopologies cannot be null."));
    }

    public Set<String> requiredTopics() {
        return this.subtopologies.values().stream().flatMap(x -> Stream.concat(Stream.concat(x.sourceTopics().stream(), x.repartitionSourceTopics().stream().map(StreamsGroupTopologyValue.TopicInfo::name)), x.stateChangelogTopics().stream().map(StreamsGroupTopologyValue.TopicInfo::name))).collect(Collectors.toSet());
    }

    public static StreamsTopology fromRecord(StreamsGroupTopologyValue record) {
        return new StreamsTopology(record.epoch(), record.subtopologies().stream().collect(Collectors.toMap(StreamsGroupTopologyValue.Subtopology::subtopologyId, x -> x)));
    }

    public static StreamsTopology fromHeartbeatRequest(StreamsGroupHeartbeatRequestData.Topology topology) {
        StreamsGroupTopologyValue recordValue = StreamsCoordinatorRecordHelpers.convertToStreamsGroupTopologyRecord(topology);
        Map<String, StreamsGroupTopologyValue.Subtopology> subtopologyMap = recordValue.subtopologies().stream().collect(Collectors.toMap(StreamsGroupTopologyValue.Subtopology::subtopologyId, x -> x));
        return new StreamsTopology(topology.epoch(), subtopologyMap);
    }
}

