/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.trogdor.common.JsonUtil;
import org.apache.kafka.trogdor.workload.Histogram;
import org.apache.kafka.trogdor.workload.RecordProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimestampRecordProcessor
implements RecordProcessor {
    private final int histogramMaxMs;
    private final int histogramMinMs;
    private final int histogramStepMs;
    private final ByteBuffer buffer;
    private final Histogram histogram;
    private static final Logger log = LoggerFactory.getLogger(TimestampRecordProcessor.class);
    static final float[] PERCENTILES = new float[]{0.5f, 0.95f, 0.99f};

    @JsonCreator
    public TimestampRecordProcessor(@JsonProperty(value="histogramMaxMs") int histogramMaxMs, @JsonProperty(value="histogramMinMs") int histogramMinMs, @JsonProperty(value="histogramStepMs") int histogramStepMs) {
        this.histogramMaxMs = histogramMaxMs;
        this.histogramMinMs = histogramMinMs;
        this.histogramStepMs = histogramStepMs;
        this.histogram = new Histogram((histogramMaxMs - histogramMinMs) / histogramStepMs);
        this.buffer = ByteBuffer.allocate(8);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @JsonProperty
    public int histogramMaxMs() {
        return this.histogramMaxMs;
    }

    @JsonProperty
    public int histogramMinMs() {
        return this.histogramMinMs;
    }

    @JsonProperty
    public int histogramStepMs() {
        return this.histogramStepMs;
    }

    private void putHistogram(long latency) {
        this.histogram.add(Long.max(0L, (latency - (long)this.histogramMinMs) / (long)this.histogramStepMs));
    }

    @Override
    public synchronized void processRecords(ConsumerRecords<byte[], byte[]> consumerRecords) {
        long curTime = Time.SYSTEM.milliseconds();
        for (ConsumerRecord record : consumerRecords) {
            try {
                this.buffer.clear();
                this.buffer.put((byte[])record.value(), 0, 8);
                this.buffer.rewind();
                this.putHistogram(curTime - this.buffer.getLong());
            }
            catch (RuntimeException e) {
                log.error("Error in processRecords:", (Throwable)e);
            }
        }
    }

    @Override
    public JsonNode processorStatus() {
        Histogram.Summary summary = this.histogram.summarize(PERCENTILES);
        StatusData statusData = new StatusData(summary.average() * (float)this.histogramStepMs + (float)this.histogramMinMs, summary.percentiles().get(0).value() * this.histogramStepMs + this.histogramMinMs, summary.percentiles().get(1).value() * this.histogramStepMs + this.histogramMinMs, summary.percentiles().get(2).value() * this.histogramStepMs + this.histogramMinMs);
        return JsonUtil.JSON_SERDE.valueToTree((Object)statusData);
    }

    private static class StatusData {
        private final float averageLatencyMs;
        private final int p50LatencyMs;
        private final int p95LatencyMs;
        private final int p99LatencyMs;
        static final float[] PERCENTILES = new float[]{0.5f, 0.95f, 0.99f};

        @JsonCreator
        StatusData(@JsonProperty(value="averageLatencyMs") float averageLatencyMs, @JsonProperty(value="p50LatencyMs") int p50latencyMs, @JsonProperty(value="p95LatencyMs") int p95latencyMs, @JsonProperty(value="p99LatencyMs") int p99latencyMs) {
            this.averageLatencyMs = averageLatencyMs;
            this.p50LatencyMs = p50latencyMs;
            this.p95LatencyMs = p95latencyMs;
            this.p99LatencyMs = p99latencyMs;
        }

        @JsonProperty
        public float averageLatencyMs() {
            return this.averageLatencyMs;
        }

        @JsonProperty
        public int p50LatencyMs() {
            return this.p50LatencyMs;
        }

        @JsonProperty
        public int p95LatencyMs() {
            return this.p95LatencyMs;
        }

        @JsonProperty
        public int p99LatencyMs() {
            return this.p99LatencyMs;
        }
    }
}

