/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.util.function.BiConsumer;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.SelectablePath;

@FunctionalInterface
public interface SelectableConsumer {
    public void accept(int var1, SelectableMapping var2);

    default public void accept(String tableName, JdbcMappingContainer base, String[] columnNames) {
        if (!1.$assertionsDisabled && base.getJdbcTypeCount() != columnNames.length) {
            throw new AssertionError();
        }
        MutableSelectableMapping mutableSelectableMapping = new MutableSelectableMapping(tableName, base, columnNames);
        mutableSelectableMapping.forEach(this::accept);
    }

    default public void accept(SelectableMappings base, String tableName, String[] columnNames) {
        class SelectableMappingIterator
        implements SelectableMapping {
            private final String tableName;
            private final SelectableMappings delegate;
            private final String[] columnNames;
            private int index;

            public SelectableMappingIterator(String tableName, SelectableMappings delegate, String[] columnNames) {
                this.tableName = tableName;
                this.delegate = delegate;
                this.columnNames = columnNames;
                assert (delegate.getJdbcTypeCount() == columnNames.length);
            }

            private void forEach(BiConsumer<Integer, SelectableMapping> consumer) {
                this.index = 0;
                while (this.index < this.columnNames.length) {
                    consumer.accept(this.index, this);
                    ++this.index;
                }
            }

            @Override
            public String getContainingTableExpression() {
                return this.tableName;
            }

            @Override
            public String getSelectionExpression() {
                return this.columnNames[this.index];
            }

            @Override
            public @Nullable String getCustomReadExpression() {
                return null;
            }

            @Override
            public @Nullable String getCustomWriteExpression() {
                return null;
            }

            private SelectableMapping getDelegate() {
                return this.delegate.getSelectable(this.index);
            }

            @Override
            public String getSelectableName() {
                return this.getDelegate().getSelectableName();
            }

            @Override
            public SelectablePath getSelectablePath() {
                return this.getDelegate().getSelectablePath();
            }

            @Override
            public boolean isFormula() {
                return this.getDelegate().isFormula();
            }

            @Override
            public boolean isNullable() {
                return this.getDelegate().isNullable();
            }

            @Override
            public boolean isInsertable() {
                return this.getDelegate().isInsertable();
            }

            @Override
            public boolean isUpdateable() {
                return this.getDelegate().isUpdateable();
            }

            @Override
            public boolean isPartitioned() {
                return this.getDelegate().isPartitioned();
            }

            @Override
            public @Nullable String getColumnDefinition() {
                return this.getDelegate().getColumnDefinition();
            }

            @Override
            public @Nullable Long getLength() {
                return this.getDelegate().getLength();
            }

            @Override
            public @Nullable Integer getPrecision() {
                return this.getDelegate().getPrecision();
            }

            @Override
            public @Nullable Integer getScale() {
                return this.getDelegate().getScale();
            }

            @Override
            public @Nullable Integer getTemporalPrecision() {
                return this.getDelegate().getTemporalPrecision();
            }

            @Override
            public boolean isLob() {
                return this.getDelegate().isLob();
            }

            @Override
            public JdbcMapping getJdbcMapping() {
                return this.getDelegate().getJdbcMapping();
            }

            @Override
            public Size toSize() {
                return this.getDelegate().toSize();
            }
        }
        SelectableMappingIterator mutableSelectableMapping = new SelectableMappingIterator(tableName, base, columnNames);
        mutableSelectableMapping.forEach(this::accept);
    }

    default public void accept(final String tableName, final String[] columnNames, final IntFunction<JdbcMapping> jdbcMappings) {
        class SelectableMappingIterator
        implements SelectableMapping {
            private int index;

            SelectableMappingIterator() {
            }

            @Override
            public String getContainingTableExpression() {
                return tableName;
            }

            @Override
            public String getSelectionExpression() {
                return columnNames[this.index];
            }

            @Override
            public String getCustomReadExpression() {
                return null;
            }

            @Override
            public String getCustomWriteExpression() {
                return null;
            }

            @Override
            public String getColumnDefinition() {
                return null;
            }

            @Override
            public Long getLength() {
                return null;
            }

            @Override
            public Integer getPrecision() {
                return null;
            }

            @Override
            public Integer getScale() {
                return null;
            }

            @Override
            public Integer getTemporalPrecision() {
                return null;
            }

            @Override
            public boolean isFormula() {
                return false;
            }

            @Override
            public boolean isNullable() {
                return true;
            }

            @Override
            public boolean isInsertable() {
                return true;
            }

            @Override
            public boolean isUpdateable() {
                return true;
            }

            @Override
            public boolean isPartitioned() {
                return false;
            }

            @Override
            public JdbcMapping getJdbcMapping() {
                return (JdbcMapping)jdbcMappings.apply(this.index);
            }
        }
        SelectableMappingIterator iterator = new SelectableMappingIterator();
        while (iterator.index < columnNames.length) {
            this.accept(iterator.index, iterator);
            ++iterator.index;
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class MutableSelectableMapping
    implements SelectableMapping {
        private final String tableName;
        private final JdbcMappingContainer base;
        private final String[] columnNames;
        private int index;

        public MutableSelectableMapping(String tableName, JdbcMappingContainer base, String[] columnNames) {
            this.tableName = tableName;
            this.base = base;
            this.columnNames = columnNames;
            assert (base.getJdbcTypeCount() == columnNames.length);
        }

        private void forEach(BiConsumer<Integer, SelectableMapping> consumer) {
            this.index = 0;
            while (this.index < this.columnNames.length) {
                consumer.accept(this.index, this);
                ++this.index;
            }
        }

        @Override
        public String getContainingTableExpression() {
            return this.tableName;
        }

        @Override
        public String getSelectionExpression() {
            return this.columnNames[this.index];
        }

        @Override
        public JdbcMapping getJdbcMapping() {
            return this.base.getJdbcMapping(this.index);
        }

        @Override
        public boolean isFormula() {
            return false;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public boolean isInsertable() {
            return true;
        }

        @Override
        public boolean isUpdateable() {
            return false;
        }

        @Override
        public boolean isPartitioned() {
            return false;
        }

        @Override
        public String getColumnDefinition() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getPrecision() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public Integer getTemporalPrecision() {
            return null;
        }

        @Override
        public String getCustomReadExpression() {
            return null;
        }

        @Override
        public String getCustomWriteExpression() {
            return null;
        }
    }
}

