interface StyleState {
    color: string | null;
    bcolor: string | null;
    history: string[];
}
export declare function escapeHtmlChars(text: string): string;
/**
 * Given the state of the message, open or close an HTML tag with the
 * appropriate attributes.
 *
 * Tags are stored in an array, which is used as a stack.
 * Opening a tag is always pushed to the end. This can happen multiple times
 * for nested tags of the same type.
 * Closing a tag closes all tags up to the most recent corresponding tag in
 * the history, and re-opens the ones opened after. Nothing happens if the tag
 * doesn't exist.
 *
 * @param {Object} state Current state of a message
 * @param {string} name Name of the HTML tag.
 * @param {boolean} open Open or close the tag (optional) .
 *                       Detected automatically when omitted.
 * @returns {string} Text containing the relevant open/closing tags.
 */
export declare function htmlTag(state: StyleState, name: string, open?: boolean): string;
export declare function stripIrcFormatting(text: string): string;
export declare function htmlToIrc(html?: string): string | null;
export declare function ircToHtml(text: string): string;
/**
 * Returns a trimmed string if the input text is a Markdown-style code block.
 * This is used to allow small code snippets to look nice in IRC and not be
 * transformed into an upload.
 */
export declare function markdownCodeToIrc(text: string): string | null;
export declare function toIrcLowerCase(str: string, caseMapping?: "strict-rfc1459" | "rfc1459"): string;
export {};
