"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const ansi_to_react_1 = __importDefault(require("ansi-to-react"));
const React = __importStar(require("react"));
const styled_components_1 = __importDefault(require("styled-components"));
const PlainKernelOutputError = (props) => {
    const { output } = props;
    if (!output) {
        return null;
    }
    const { ename, evalue, traceback = [] } = output;
    // Allow traceback to be Immutable.List or Array
    const joinedTraceback = typeof traceback.join === "function" ? traceback.join("\n") : traceback;
    const kernelOutputError = [];
    if (joinedTraceback) {
        kernelOutputError.push(joinedTraceback);
    }
    else {
        if (ename && evalue) {
            kernelOutputError.push(`${ename}: ${evalue}`);
        }
    }
    return (React.createElement(ansi_to_react_1.default, { className: props.className, linkify: false }, kernelOutputError.join("\n")));
};
exports.KernelOutputError = styled_components_1.default(PlainKernelOutputError) `
  white-space: pre-wrap;
`;
exports.KernelOutputError.defaultProps = {
    output_type: "error"
};
exports.KernelOutputError.displayName = "KernelOutputError";
exports.default = exports.KernelOutputError;
