/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TableClass {
    STANDARD("STANDARD"),
    STANDARD_INFREQUENT_ACCESS("STANDARD_INFREQUENT_ACCESS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TableClass> VALUE_MAP;
    private final String value;

    private TableClass(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TableClass fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TableClass> knownValues() {
        EnumSet<TableClass> knownValues = EnumSet.allOf(TableClass.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TableClass.class, TableClass::toString);
    }
}

