/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.adt.Barcode;
import ca.odell.glazedlists.impl.adt.IndexedTree;
import ca.odell.glazedlists.impl.adt.IndexedTreeNode;
import java.util.Collections;
import java.util.List;

public class CollectionList
extends TransformedList
implements ListEventListener {
    private final ChildElement EMPTY_CHILD_ELEMENT = new SimpleChildElement(Collections.EMPTY_LIST, null);
    private final Model model;
    private final Barcode barcode = new Barcode();
    private final IndexedTree childElements = new IndexedTree();
    static final /* synthetic */ boolean $assertionsDisabled;

    public CollectionList(EventList source, Model model) {
        super(source);
        if (model == null) {
            throw new IllegalArgumentException("Collection map cannot be null");
        }
        this.model = model;
        for (int i = 0; i < source.size(); ++i) {
            List children = model.getChildren(source.get(i));
            IndexedTreeNode node = this.childElements.addByNode(i, this.EMPTY_CHILD_ELEMENT);
            node.setValue(this.createChildElementForList(children, node));
            this.barcode.addBlack(this.barcode.size(), 1);
            if (children.isEmpty()) continue;
            this.barcode.addWhite(this.barcode.size(), children.size());
        }
        source.addListEventListener(this);
    }

    public int size() {
        return this.barcode.whiteSize();
    }

    public Object get(int index) {
        ChildElement childElement = this.getChildElement(index);
        int childIndexInParent = this.barcode.getWhiteSequenceIndex(index);
        return childElement.get(childIndexInParent);
    }

    public Object set(int index, Object value) {
        ChildElement childElement = this.getChildElement(index);
        int childIndexInParent = this.barcode.getWhiteSequenceIndex(index);
        return childElement.set(childIndexInParent, value);
    }

    public Object remove(int index) {
        ChildElement childElement = this.getChildElement(index);
        int childIndexInParent = this.barcode.getWhiteSequenceIndex(index);
        return childElement.remove(childIndexInParent);
    }

    public int childStartingIndex(int parentIndex) {
        if (parentIndex < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + parentIndex);
        }
        if (parentIndex >= this.source.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + parentIndex);
        }
        int parentFullIndex = this.barcode.getIndex(parentIndex, Barcode.BLACK);
        int childFullIndex = parentFullIndex + 1;
        if (childFullIndex >= this.barcode.size()) {
            return -1;
        }
        if (this.barcode.get(childFullIndex) != Barcode.WHITE) {
            return -1;
        }
        int childIndex = childFullIndex - (parentIndex + 1);
        if (!$assertionsDisabled && this.barcode.getWhiteIndex(childFullIndex) != childIndex) {
            throw new AssertionError();
        }
        return childIndex;
    }

    public int childEndingIndex(int parentIndex) {
        if (parentIndex < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + parentIndex);
        }
        if (parentIndex >= this.source.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + parentIndex);
        }
        int nextParentFullIndex = parentIndex == this.barcode.blackSize() - 1 ? this.barcode.size() : this.barcode.getIndex(parentIndex + 1, Barcode.BLACK);
        int lastWhiteBeforeNextParent = nextParentFullIndex - 1;
        if (this.barcode.get(lastWhiteBeforeNextParent) == Barcode.BLACK) {
            return -1;
        }
        int childIndex = lastWhiteBeforeNextParent - (parentIndex + 1);
        if (!$assertionsDisabled && this.barcode.getWhiteIndex(lastWhiteBeforeNextParent) != childIndex) {
            throw new AssertionError();
        }
        return childIndex;
    }

    public void listChanged(ListEvent listChanges) {
        this.updates.beginEvent();
        while (listChanges.next()) {
            int index = listChanges.getIndex();
            int type = listChanges.getType();
            if (type == 2) {
                this.handleInsert(index);
                continue;
            }
            if (type == 0) {
                this.handleDelete(index);
                continue;
            }
            if (type != 1) continue;
            this.handleDelete(index);
            this.handleInsert(index);
        }
        this.updates.commitEvent();
    }

    private void handleInsert(int parentIndex) {
        int absoluteIndex = this.getAbsoluteIndex(parentIndex);
        Object parent = this.source.get(parentIndex);
        List children = this.model.getChildren(parent);
        IndexedTreeNode node = this.childElements.addByNode(parentIndex, this.EMPTY_CHILD_ELEMENT);
        node.setValue(this.createChildElementForList(children, node));
        this.barcode.addBlack(absoluteIndex, 1);
        if (!children.isEmpty()) {
            this.barcode.addWhite(absoluteIndex + 1, children.size());
        }
        if (!children.isEmpty()) {
            int childIndex = absoluteIndex - parentIndex;
            this.updates.addInsert(childIndex, childIndex + children.size() - 1);
        }
    }

    private void handleDelete(int sourceIndex) {
        int parentIndex = this.getAbsoluteIndex(sourceIndex);
        int nextParentIndex = this.getAbsoluteIndex(sourceIndex + 1);
        ChildElement removedChildElement = (ChildElement)this.childElements.removeByIndex(sourceIndex).getValue();
        removedChildElement.dispose();
        int childCount = nextParentIndex - parentIndex - 1;
        this.barcode.remove(parentIndex, 1 + childCount);
        if (childCount > 0) {
            int firstDeletedChildIndex = parentIndex - sourceIndex;
            int firstNotDeletedChildIndex = firstDeletedChildIndex + childCount;
            this.updates.addDelete(firstDeletedChildIndex, firstNotDeletedChildIndex - 1);
        }
    }

    private ChildElement getChildElement(int childIndex) {
        if (childIndex < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + childIndex);
        }
        if (childIndex >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + childIndex + ", Size: " + this.size());
        }
        int parentIndex = this.barcode.getBlackBeforeWhite(childIndex);
        return (ChildElement)this.childElements.getNode(parentIndex).getValue();
    }

    private ChildElement createChildElementForList(List children, IndexedTreeNode node) {
        if (children instanceof EventList) {
            return new EventChildElement((EventList)children, node);
        }
        return new SimpleChildElement(children, node);
    }

    private int getAbsoluteIndex(int parentIndex) {
        if (parentIndex < this.barcode.blackSize()) {
            return this.barcode.getIndex(parentIndex, Barcode.BLACK);
        }
        if (parentIndex == this.barcode.blackSize()) {
            return this.barcode.size();
        }
        throw new IndexOutOfBoundsException();
    }

    static {
        $assertionsDisabled = !CollectionList.class.desiredAssertionStatus();
    }

    private class EventChildElement
    implements ChildElement,
    ListEventListener {
        private EventList children;
        private IndexedTreeNode node;

        public EventChildElement(EventList children, IndexedTreeNode node) {
            this.children = children;
            this.node = node;
            children.addListEventListener(this);
        }

        public Object get(int index) {
            return this.children.get(index);
        }

        public Object remove(int index) {
            return this.children.remove(index);
        }

        public Object set(int index, Object element) {
            return this.children.set(index, element);
        }

        public void listChanged(ListEvent listChanges) {
            int firstChildIndex;
            int parentIndex = this.node.getIndex();
            int absoluteIndex = CollectionList.this.getAbsoluteIndex(parentIndex);
            int nextNodeIndex = CollectionList.this.getAbsoluteIndex(parentIndex + 1);
            int previousChildrenCount = nextNodeIndex - (firstChildIndex = absoluteIndex + 1);
            if (previousChildrenCount > 0) {
                CollectionList.this.barcode.remove(firstChildIndex, previousChildrenCount);
            }
            if (!this.children.isEmpty()) {
                CollectionList.this.barcode.addWhite(firstChildIndex, this.children.size());
            }
            int childOffset = absoluteIndex - parentIndex;
            CollectionList.this.updates.beginEvent();
            while (listChanges.next()) {
                int index = listChanges.getIndex();
                int type = listChanges.getType();
                CollectionList.this.updates.addChange(type, index + childOffset);
            }
            CollectionList.this.updates.commitEvent();
        }

        public void dispose() {
            this.children.removeListEventListener(this);
        }
    }

    private class SimpleChildElement
    implements ChildElement {
        private List children;
        private IndexedTreeNode node;

        public SimpleChildElement(List children, IndexedTreeNode node) {
            this.children = children;
            this.node = node;
        }

        public Object get(int index) {
            return this.children.get(index);
        }

        public Object remove(int index) {
            Object removed = this.children.remove(index);
            int parentIndex = this.node.getIndex();
            int absoluteIndex = CollectionList.this.getAbsoluteIndex(parentIndex);
            int firstChildIndex = absoluteIndex + 1;
            CollectionList.this.barcode.remove(firstChildIndex + index, 1);
            int childOffset = absoluteIndex - parentIndex;
            CollectionList.this.updates.beginEvent();
            CollectionList.this.updates.addDelete(index + childOffset);
            CollectionList.this.updates.commitEvent();
            return removed;
        }

        public Object set(int index, Object element) {
            Object replaced = this.children.set(index, element);
            int parentIndex = this.node.getIndex();
            int absoluteIndex = CollectionList.this.getAbsoluteIndex(parentIndex);
            int childOffset = absoluteIndex - parentIndex;
            CollectionList.this.updates.beginEvent();
            CollectionList.this.updates.addUpdate(index + childOffset);
            CollectionList.this.updates.commitEvent();
            return replaced;
        }

        public void dispose() {
        }
    }

    public static interface Model {
        public List getChildren(Object var1);
    }

    private static interface ChildElement {
        public Object get(int var1);

        public Object remove(int var1);

        public Object set(int var1, Object var2);

        public void dispose();
    }
}

