<?php
/*******************************************************************************
** Basic Analysis and Security Engine (BASE)
** Copyright (C) 2004 BASE Project Team
** Copyright (C) 2000 Carnegie Mellon University
**
** (see the file 'base_main.php' for license details)
**
** Project Leads: Kevin Johnson <kjohnson@secureideas.net>
** Built upon work by Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
**
** Purpose: FAQ page
********************************************************************************
** Authors:
********************************************************************************
** Kevin Johnson <kjohnson@secureideas.net
**
********************************************************************************
*/
include("../base_conf.php");

?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Basic Analysis and Security Engine (BASE) <?php echo $BASE_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Kevin Johnson">
    <TITLE>BASE: </TITLE>
  <LINK rel="stylesheet" type="text/css" HREF="../styles/base_style.css">

</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("../base_hdr1.php");
     ?>
  </TD>
  <TD class="mainheadertitle">Local FAQ</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("../base_hdr2.php");
     ?>
  </TD>

</TR>
</TABLE>
<P><P>

<CENTER>
<H3>Always check the BASE <A HREF="http://base.sourceforge.net">website</A> for the latest FAQ.</H3>
</CENTER>

<P>
<B>Why do certain alerts seem to have 'unknown' IPs?</B>
<P>
The Snort database plug-in only logs packet information into the database when an alert is 
triggered by a rule (signature).  Therefore, since alerts generated by pre-preprocessors 
such as portscan and mini-fragment have no corresponding rules, no packet information is 
logged beyond an entry  indicating their occurrence.  As a consequence, BASE cannot display 
any packet-level (e.g. IP address) information for these alerts.
<P>
For these particular alerts, certain statistics may show zero unique IP addresses, list 
the IP address as 'unknown', and will not list any packet information when decoding the alert. 

<P>
<B>BASE appears to be broken in Lynx</B>
<P>
This is a known issue.  Lynx mangles some of the form arguments appended to the URL.  It's resolution is being investigated, but use Netscape, Opera, or IE in the mean time.

<P>
<B>Can priorities be assigned to Alerts?</B> 
<P>
The quick answer to this question is no.  BASE is at the mercy of the underlying database, since Snort doesn't assign priorities, BASE does not have priorities.  Nevertheless, there are several work-arounds:
<UL>
  <LI>It is possible to enforce priorities of sort at the database level by writing alerts of different severity to separate databases.  For example, critical alerts such as buffer overflows can be written to one database, while scan alerts can be written to another.  Then load two different versions of BASE, each pointing to a different instance of the database.
  <P>
  <LI>With manual intervention Alert Groups (AG) can be used to assign priority.  Essentially, this strategy entails creating an AG for each severity level and manually moving the alerts as they arrive into the appropriate group. 
</UL>

<P>
<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("../base_footer.php");
     ?>
  </TD>
</TR>
</TABLE>

</BODY>

</HTML>
