// vs_label.cc

#include "vs_label.h"
#include "vscreen.h"

#include <config/colors.h>

#include <algorithm>

using namespace std;

vs_label::vs_label(string _txt, int _attr)
  :txt(_txt), attr(_attr)
{
  set_bg(attr);
}

vs_label::vs_label(string _txt)
  :txt(_txt), attr(get_color("DefaultWidgetBackground"))
{
}

bool vs_label::get_cursorvisible()
{
  return false;
}

point vs_label::get_cursorloc()
{
  return point(0,0);
}

void vs_label::set_text(string _txt)
{
  txt=_txt;
  // Our size might have changed, so re-layout the screen.
  vscreen_queuelayout();
}

void vs_label::paint()
{
  erase();

  int x=0, y=0;

  for(string::size_type i=0; i<txt.size(); i++)
    {
      switch(txt[i])
	{
	case '\n':
	  y++;
	  x=0;
	  break;
	case '\t':
	  x+=8-(x%8);
	  break;
	default:
	  mvaddch(y, x, (unsigned char) txt[i]);
	  x++;
	  break;
	}
    }
}

size vs_label::size_request()
{
  int maxx=0, maxy=1, curx=0, cury=1;

  for(string::size_type i=0; i<txt.size(); i++)
    {
      switch(txt[i])
	{
	case '\n':
	  cury++;
	  curx=0;
	  break;
	case '\t':
	  curx+=8-(curx%8);
	  break;
	default:
	  curx++;
	  break;
	}

      maxx=max<int>(curx, maxx);
      maxy=max<int>(cury, maxy);
    }

  return size(maxx, maxy);
}


bool vs_transientlabel::handle_char(chtype ch)
{
  destroy();
  return true;
}
