// distribution boxbackup-0.11rc2 (svn version: 2072)
//  
// Copyright (c) 2003 - 2008
//      Ben Summers and contributors.  All rights reserved.
//  
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. All use of this software and associated advertising materials must 
//    display the following acknowledgment:
//        This product includes software developed by Ben Summers.
// 4. The names of the Authors may not be used to endorse or promote
//    products derived from this software without specific prior written
//    permission.
// 
// [Where legally impermissible the Authors do not disclaim liability for 
// direct physical injury or death caused solely by defects in the software 
// unless it is modified by a third party.]
// 
// THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY DIRECT,
// INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
// ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//  
//  
//  
// --------------------------------------------------------------------------
//
// File
//		Name:    Timer.h
//		Purpose: Generic timers which execute arbitrary code when
//			 they expire.
//		Created: 5/11/2006
//
// --------------------------------------------------------------------------

#ifndef TIMER__H
#define TIMER__H

#ifdef HAVE_SYS_TIME_H
	#include <sys/time.h>
#endif

#include <vector>

#include "BoxTime.h"

#include "MemLeakFindOn.h"

class Timer;

// --------------------------------------------------------------------------
//
// Class
//		Name:    Timers
//		Purpose: Static class to manage all timers and arrange 
//			 efficient delivery of wakeup signals
//		Created: 19/3/04
//
// --------------------------------------------------------------------------
class Timers
{
	private:
	static std::vector<Timer*>* spTimers;
	static void Reschedule();

	static bool sRescheduleNeeded;
	static void SignalHandler(int iUnused);
	
	public:
	static void Init();
	static void Cleanup();
	static void Add   (Timer& rTimer);
	static void Remove(Timer& rTimer);
	static void RequestReschedule()
	{
		sRescheduleNeeded = true;
	}

	static void RescheduleIfNeeded()
	{
		if (sRescheduleNeeded) 
		{
			Reschedule();
		}
	}
};

class Timer
{
public:
	Timer(size_t timeoutSecs);
	virtual ~Timer();
	Timer(const Timer &);
	Timer &operator=(const Timer &);

public:
	box_time_t   GetExpiryTime() { return mExpires; }
	virtual void OnExpire();
	bool         HasExpired()
	{
		Timers::RescheduleIfNeeded();
		return mExpired; 
	}
	
private:
	box_time_t mExpires;
	bool       mExpired;
};

#include "MemLeakFindOff.h"

#endif // TIMER__H
