<?php
/**
 * eGroupWare - Notifications
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package notifications
 * @link http://www.egroupware.org
 * @author Cornelius Weiss <nelius@cwtech.de>
 * @version $Id: class.iface_notification.inc.php 24126 2007-06-18 08:49:59Z nelius_weiss $
 */

/**
 * Instant user notification
 */
interface iface_notification {

	/**
	 * constructor 
	 *
	 * @param object $_account
	 * @param object $_preferences
	 */
	public function __construct( $_account=false, $_preferences=false );
	
	/**
	 * sends notification
	 *
	 * @abstract NOTE, $_message contains some html-tags (<p><a><b><br>)
	 * implementing class needs to handle them somehow.
	 * @param string $_message
	 */
	public function send( $_message );
}
