/*
                             Recycle Bin Index
 */

#ifndef EDV_RECBIN_INDEX_H
#define EDV_RECBIN_INDEX_H

#include <stdio.h>
#include <glib.h>
#include "edv_types.h"
#include "edv_recycled_obj.h"


typedef struct _edv_recbin_index_struct	edv_recbin_index_struct;
#define EDV_RECBIN_INDEX(p)	((edv_recbin_index_struct *)(p))


/*
 *	Recycle bin index file IO handle (reading only):
 */
struct _edv_recbin_index_struct {

	FILE		*fp;	/* Handle to opened recycle bin index file */

	guint		index;	/* This recycled object's index */

	edv_recycled_object_struct *obj;

};


extern const gchar *EDVRecBinIndexGetError(void);

/* Get Index List & Total */
extern gint EDVRecBinIndexGetTotal(const gchar *index_path);
extern GList *EDVRecBinIndexGetList(const gchar *index_path);

/* Index File Open, Next, and Close */
extern edv_recbin_index_struct *EDVRecBinIndexOpen(
	const gchar *index_path
);
extern gint EDVRecBinIndexNext(edv_recbin_index_struct *rbi_ptr);
extern void EDVRecBinIndexClose(edv_recbin_index_struct *rbi_ptr);

/* Index Adding & Removing */
extern guint EDVRecBinIndexAdd(
	const gchar *index_path,
	const edv_recycled_object_struct *obj
);
extern gint EDVRecBinIndexRemove(
	const gchar *index_path,
	const guint index		/* Index of the recycled object */
);

/* Get Recycled Object From Index */
extern gint EDVRecBinObjectGetFromIndexFile(
        const gchar *index_path,
	const guint index,		/* Index of the recycled object */
        edv_recycled_object_struct *obj	/* Storage */
);

/* Deleting, Recovering, and Purging */
extern gint EDVRecBinDiskObjectDelete(
	const gchar *index_path,
	const guint index,		/* Add to the recycled index file
					 * under this index */
	const gchar *path,		/* Object to delete */
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer data
);
extern gint EDVRecBinDiskObjectRecover(
	const gchar *index_path,
	const guint index,		/* Index of the recycled object */
	const gchar *path,		/* Alternate recovery location (can
					 * be NULL) */
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer data
);
extern gint EDVRecBinDiskObjectPurge(
	const gchar *index_path,
	const guint index,		/* Index of the recycled object */
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer data
);
extern gint EDVRecBinDiskObjectPurgeAll(
	const gchar *index_path,    /* Recycle bin index file */
	gint (*progress_cb)(gpointer, const gulong, const gulong),
	gpointer data
);


#endif	/* EDV_RECBIN_INDEX_H */
