/* -------------------------------------------
     This file was created with csUtility.java 

    Unicode mapping table generated from java mapping and UnicodeData.txt

#
#    Name:     Cp1257 to Unicode table
#    Unicode version: Java 1.3
#
#    Format: Three tab-separated columns
#        Column #1 is the Cp1257 code (in hex)
#        Column #2 is the Unicode (in hex as 0xXXXX)
#        Column #3 is the Unicode name (follows a comment sign, '#')
#
#    The entries are in Cp1257 order
#
0x00	0x0000	#NULL
0x01	0x0001	#START OF HEADING
0x02	0x0002	#START OF TEXT
0x03	0x0003	#END OF TEXT
0x04	0x0004	#END OF TRANSMISSION
0x05	0x0005	#ENQUIRY
0x06	0x0006	#ACKNOWLEDGE
0x07	0x0007	#BELL
0x08	0x0008	#BACKSPACE
0x09	0x0009	#CHARACTER TABULATION
0x0a	0x000a	#LINE FEED (LF)
0x0b	0x000b	#LINE TABULATION
0x0c	0x000c	#FORM FEED (FF)
0x0d	0x000d	#CARRIAGE RETURN (CR)
0x0e	0x000e	#SHIFT OUT
0x0f	0x000f	#SHIFT IN
0x10	0x0010	#DATA LINK ESCAPE
0x11	0x0011	#DEVICE CONTROL ONE
0x12	0x0012	#DEVICE CONTROL TWO
0x13	0x0013	#DEVICE CONTROL THREE
0x14	0x0014	#DEVICE CONTROL FOUR
0x15	0x0015	#NEGATIVE ACKNOWLEDGE
0x16	0x0016	#SYNCHRONOUS IDLE
0x17	0x0017	#END OF TRANSMISSION BLOCK
0x18	0x0018	#CANCEL
0x19	0x0019	#END OF MEDIUM
0x1a	0x001a	#SUBSTITUTE
0x1b	0x001b	#ESCAPE
0x1c	0x001c	#INFORMATION SEPARATOR FOUR
0x1d	0x001d	#INFORMATION SEPARATOR THREE
0x1e	0x001e	#INFORMATION SEPARATOR TWO
0x1f	0x001f	#INFORMATION SEPARATOR ONE
0x20	0x0020	#SPACE
0x21	0x0021	#EXCLAMATION MARK
0x22	0x0022	#QUOTATION MARK
0x23	0x0023	#NUMBER SIGN
0x24	0x0024	#DOLLAR SIGN
0x25	0x0025	#PERCENT SIGN
0x26	0x0026	#AMPERSAND
0x27	0x0027	#APOSTROPHE
0x28	0x0028	#LEFT PARENTHESIS
0x29	0x0029	#RIGHT PARENTHESIS
0x2a	0x002a	#ASTERISK
0x2b	0x002b	#PLUS SIGN
0x2c	0x002c	#COMMA
0x2d	0x002d	#HYPHEN-MINUS
0x2e	0x002e	#FULL STOP
0x2f	0x002f	#SOLIDUS
0x30	0x0030	#DIGIT ZERO
0x31	0x0031	#DIGIT ONE
0x32	0x0032	#DIGIT TWO
0x33	0x0033	#DIGIT THREE
0x34	0x0034	#DIGIT FOUR
0x35	0x0035	#DIGIT FIVE
0x36	0x0036	#DIGIT SIX
0x37	0x0037	#DIGIT SEVEN
0x38	0x0038	#DIGIT EIGHT
0x39	0x0039	#DIGIT NINE
0x3a	0x003a	#COLON
0x3b	0x003b	#SEMICOLON
0x3c	0x003c	#LESS-THAN SIGN
0x3d	0x003d	#EQUALS SIGN
0x3e	0x003e	#GREATER-THAN SIGN
0x3f	0x003f	#QUESTION MARK
0x40	0x0040	#COMMERCIAL AT
0x41	0x0041	#LATIN CAPITAL LETTER A
0x42	0x0042	#LATIN CAPITAL LETTER B
0x43	0x0043	#LATIN CAPITAL LETTER C
0x44	0x0044	#LATIN CAPITAL LETTER D
0x45	0x0045	#LATIN CAPITAL LETTER E
0x46	0x0046	#LATIN CAPITAL LETTER F
0x47	0x0047	#LATIN CAPITAL LETTER G
0x48	0x0048	#LATIN CAPITAL LETTER H
0x49	0x0049	#LATIN CAPITAL LETTER I
0x4a	0x004a	#LATIN CAPITAL LETTER J
0x4b	0x004b	#LATIN CAPITAL LETTER K
0x4c	0x004c	#LATIN CAPITAL LETTER L
0x4d	0x004d	#LATIN CAPITAL LETTER M
0x4e	0x004e	#LATIN CAPITAL LETTER N
0x4f	0x004f	#LATIN CAPITAL LETTER O
0x50	0x0050	#LATIN CAPITAL LETTER P
0x51	0x0051	#LATIN CAPITAL LETTER Q
0x52	0x0052	#LATIN CAPITAL LETTER R
0x53	0x0053	#LATIN CAPITAL LETTER S
0x54	0x0054	#LATIN CAPITAL LETTER T
0x55	0x0055	#LATIN CAPITAL LETTER U
0x56	0x0056	#LATIN CAPITAL LETTER V
0x57	0x0057	#LATIN CAPITAL LETTER W
0x58	0x0058	#LATIN CAPITAL LETTER X
0x59	0x0059	#LATIN CAPITAL LETTER Y
0x5a	0x005a	#LATIN CAPITAL LETTER Z
0x5b	0x005b	#LEFT SQUARE BRACKET
0x5c	0x005c	#REVERSE SOLIDUS
0x5d	0x005d	#RIGHT SQUARE BRACKET
0x5e	0x005e	#CIRCUMFLEX ACCENT
0x5f	0x005f	#LOW LINE
0x60	0x0060	#GRAVE ACCENT
0x61	0x0061	#LATIN SMALL LETTER A
0x62	0x0062	#LATIN SMALL LETTER B
0x63	0x0063	#LATIN SMALL LETTER C
0x64	0x0064	#LATIN SMALL LETTER D
0x65	0x0065	#LATIN SMALL LETTER E
0x66	0x0066	#LATIN SMALL LETTER F
0x67	0x0067	#LATIN SMALL LETTER G
0x68	0x0068	#LATIN SMALL LETTER H
0x69	0x0069	#LATIN SMALL LETTER I
0x6a	0x006a	#LATIN SMALL LETTER J
0x6b	0x006b	#LATIN SMALL LETTER K
0x6c	0x006c	#LATIN SMALL LETTER L
0x6d	0x006d	#LATIN SMALL LETTER M
0x6e	0x006e	#LATIN SMALL LETTER N
0x6f	0x006f	#LATIN SMALL LETTER O
0x70	0x0070	#LATIN SMALL LETTER P
0x71	0x0071	#LATIN SMALL LETTER Q
0x72	0x0072	#LATIN SMALL LETTER R
0x73	0x0073	#LATIN SMALL LETTER S
0x74	0x0074	#LATIN SMALL LETTER T
0x75	0x0075	#LATIN SMALL LETTER U
0x76	0x0076	#LATIN SMALL LETTER V
0x77	0x0077	#LATIN SMALL LETTER W
0x78	0x0078	#LATIN SMALL LETTER X
0x79	0x0079	#LATIN SMALL LETTER Y
0x7a	0x007a	#LATIN SMALL LETTER Z
0x7b	0x007b	#LEFT CURLY BRACKET
0x7c	0x007c	#VERTICAL LINE
0x7d	0x007d	#RIGHT CURLY BRACKET
0x7e	0x007e	#TILDE
0x7f	0x007f	#DELETE
0x80	0x20ac	#EURO SIGN
0x81	     	#UNDEFINED
0x82	0x201a	#SINGLE LOW-9 QUOTATION MARK
0x83	     	#UNDEFINED
0x84	0x201e	#DOUBLE LOW-9 QUOTATION MARK
0x85	0x2026	#HORIZONTAL ELLIPSIS
0x86	0x2020	#DAGGER
0x87	0x2021	#DOUBLE DAGGER
0x88	     	#UNDEFINED
0x89	0x2030	#PER MILLE SIGN
0x8a	     	#UNDEFINED
0x8b	0x2039	#SINGLE LEFT-POINTING ANGLE QUOTATION MARK
0x8c	     	#UNDEFINED
0x8d	0x00a8	#DIAERESIS
0x8e	0x02c7	#CARON
0x8f	0x00b8	#CEDILLA
0x90	     	#UNDEFINED
0x91	0x2018	#LEFT SINGLE QUOTATION MARK
0x92	0x2019	#RIGHT SINGLE QUOTATION MARK
0x93	0x201c	#LEFT DOUBLE QUOTATION MARK
0x94	0x201d	#RIGHT DOUBLE QUOTATION MARK
0x95	0x2022	#BULLET
0x96	0x2013	#EN DASH
0x97	0x2014	#EM DASH
0x98	     	#UNDEFINED
0x99	0x2122	#TRADE MARK SIGN
0x9a	     	#UNDEFINED
0x9b	0x203a	#SINGLE RIGHT-POINTING ANGLE QUOTATION MARK
0x9c	     	#UNDEFINED
0x9d	0x00af	#MACRON
0x9e	0x02db	#OGONEK
0x9f	     	#UNDEFINED
0xa0	0x00a0	#NO-BREAK SPACE
0xa1	     	#UNDEFINED
0xa2	0x00a2	#CENT SIGN
0xa3	0x00a3	#POUND SIGN
0xa4	0x00a4	#CURRENCY SIGN
0xa5	     	#UNDEFINED
0xa6	0x00a6	#BROKEN BAR
0xa7	0x00a7	#SECTION SIGN
0xa8	0x00d8	#LATIN CAPITAL LETTER O WITH STROKE
0xa9	0x00a9	#COPYRIGHT SIGN
0xaa	0x0156	#LATIN CAPITAL LETTER R WITH CEDILLA
0xab	0x00ab	#LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
0xac	0x00ac	#NOT SIGN
0xad	0x00ad	#SOFT HYPHEN
0xae	0x00ae	#REGISTERED SIGN
0xaf	0x00c6	#LATIN CAPITAL LETTER AE
0xb0	0x00b0	#DEGREE SIGN
0xb1	0x00b1	#PLUS-MINUS SIGN
0xb2	0x00b2	#SUPERSCRIPT TWO
0xb3	0x00b3	#SUPERSCRIPT THREE
0xb4	0x00b4	#ACUTE ACCENT
0xb5	0x00b5	#MICRO SIGN
0xb6	0x00b6	#PILCROW SIGN
0xb7	0x00b7	#MIDDLE DOT
0xb8	0x00f8	#LATIN SMALL LETTER O WITH STROKE
0xb9	0x00b9	#SUPERSCRIPT ONE
0xba	0x0157	#LATIN SMALL LETTER R WITH CEDILLA
0xbb	0x00bb	#RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
0xbc	0x00bc	#VULGAR FRACTION ONE QUARTER
0xbd	0x00bd	#VULGAR FRACTION ONE HALF
0xbe	0x00be	#VULGAR FRACTION THREE QUARTERS
0xbf	0x00e6	#LATIN SMALL LETTER AE
0xc0	0x0104	#LATIN CAPITAL LETTER A WITH OGONEK
0xc1	0x012e	#LATIN CAPITAL LETTER I WITH OGONEK
0xc2	0x0100	#LATIN CAPITAL LETTER A WITH MACRON
0xc3	0x0106	#LATIN CAPITAL LETTER C WITH ACUTE
0xc4	0x00c4	#LATIN CAPITAL LETTER A WITH DIAERESIS
0xc5	0x00c5	#LATIN CAPITAL LETTER A WITH RING ABOVE
0xc6	0x0118	#LATIN CAPITAL LETTER E WITH OGONEK
0xc7	0x0112	#LATIN CAPITAL LETTER E WITH MACRON
0xc8	0x010c	#LATIN CAPITAL LETTER C WITH CARON
0xc9	0x00c9	#LATIN CAPITAL LETTER E WITH ACUTE
0xca	0x0179	#LATIN CAPITAL LETTER Z WITH ACUTE
0xcb	0x0116	#LATIN CAPITAL LETTER E WITH DOT ABOVE
0xcc	0x0122	#LATIN CAPITAL LETTER G WITH CEDILLA
0xcd	0x0136	#LATIN CAPITAL LETTER K WITH CEDILLA
0xce	0x012a	#LATIN CAPITAL LETTER I WITH MACRON
0xcf	0x013b	#LATIN CAPITAL LETTER L WITH CEDILLA
0xd0	0x0160	#LATIN CAPITAL LETTER S WITH CARON
0xd1	0x0143	#LATIN CAPITAL LETTER N WITH ACUTE
0xd2	0x0145	#LATIN CAPITAL LETTER N WITH CEDILLA
0xd3	0x00d3	#LATIN CAPITAL LETTER O WITH ACUTE
0xd4	0x014c	#LATIN CAPITAL LETTER O WITH MACRON
0xd5	0x00d5	#LATIN CAPITAL LETTER O WITH TILDE
0xd6	0x00d6	#LATIN CAPITAL LETTER O WITH DIAERESIS
0xd7	0x00d7	#MULTIPLICATION SIGN
0xd8	0x0172	#LATIN CAPITAL LETTER U WITH OGONEK
0xd9	0x0141	#LATIN CAPITAL LETTER L WITH STROKE
0xda	0x015a	#LATIN CAPITAL LETTER S WITH ACUTE
0xdb	0x016a	#LATIN CAPITAL LETTER U WITH MACRON
0xdc	0x00dc	#LATIN CAPITAL LETTER U WITH DIAERESIS
0xdd	0x017b	#LATIN CAPITAL LETTER Z WITH DOT ABOVE
0xde	0x017d	#LATIN CAPITAL LETTER Z WITH CARON
0xdf	0x00df	#LATIN SMALL LETTER SHARP S
0xe0	0x0105	#LATIN SMALL LETTER A WITH OGONEK
0xe1	0x012f	#LATIN SMALL LETTER I WITH OGONEK
0xe2	0x0101	#LATIN SMALL LETTER A WITH MACRON
0xe3	0x0107	#LATIN SMALL LETTER C WITH ACUTE
0xe4	0x00e4	#LATIN SMALL LETTER A WITH DIAERESIS
0xe5	0x00e5	#LATIN SMALL LETTER A WITH RING ABOVE
0xe6	0x0119	#LATIN SMALL LETTER E WITH OGONEK
0xe7	0x0113	#LATIN SMALL LETTER E WITH MACRON
0xe8	0x010d	#LATIN SMALL LETTER C WITH CARON
0xe9	0x00e9	#LATIN SMALL LETTER E WITH ACUTE
0xea	0x017a	#LATIN SMALL LETTER Z WITH ACUTE
0xeb	0x0117	#LATIN SMALL LETTER E WITH DOT ABOVE
0xec	0x0123	#LATIN SMALL LETTER G WITH CEDILLA
0xed	0x0137	#LATIN SMALL LETTER K WITH CEDILLA
0xee	0x012b	#LATIN SMALL LETTER I WITH MACRON
0xef	0x013c	#LATIN SMALL LETTER L WITH CEDILLA
0xf0	0x0161	#LATIN SMALL LETTER S WITH CARON
0xf1	0x0144	#LATIN SMALL LETTER N WITH ACUTE
0xf2	0x0146	#LATIN SMALL LETTER N WITH CEDILLA
0xf3	0x00f3	#LATIN SMALL LETTER O WITH ACUTE
0xf4	0x014d	#LATIN SMALL LETTER O WITH MACRON
0xf5	0x00f5	#LATIN SMALL LETTER O WITH TILDE
0xf6	0x00f6	#LATIN SMALL LETTER O WITH DIAERESIS
0xf7	0x00f7	#DIVISION SIGN
0xf8	0x0173	#LATIN SMALL LETTER U WITH OGONEK
0xf9	0x0142	#LATIN SMALL LETTER L WITH STROKE
0xfa	0x015b	#LATIN SMALL LETTER S WITH ACUTE
0xfb	0x016b	#LATIN SMALL LETTER U WITH MACRON
0xfc	0x00fc	#LATIN SMALL LETTER U WITH DIAERESIS
0xfd	0x017c	#LATIN SMALL LETTER Z WITH DOT ABOVE
0xfe	0x017e	#LATIN SMALL LETTER Z WITH CARON
0xff	0x02d9	#DOT ABOVE


 * The contents of this file are subject to the Interbase Public
 * License Version 1.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy
 * of the License at http://www.Inprise.com/IPL.html
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code was created by Inprise Corporation
 * and its predecessors. Portions created by Inprise Corporation are
 * Copyright (C) Inprise Corporation.
 *
 * All Rights Reserved.
 * Contributor(s): Blas Rodriguez Somoza.
   -------------------------------------------- */
static const int CANT_MAP_CHARACTER = 0;

static const USHORT to_unicode_map[256] = {
/* 00 */  0x0000 /*                                          NULL */,
/* 01 */  0x0001 /*                              START OF HEADING */,
/* 02 */  0x0002 /*                                 START OF TEXT */,
/* 03 */  0x0003 /*                                   END OF TEXT */,
/* 04 */  0x0004 /*                           END OF TRANSMISSION */,
/* 05 */  0x0005 /*                                       ENQUIRY */,
/* 06 */  0x0006 /*                                   ACKNOWLEDGE */,
/* 07 */  0x0007 /*                                          BELL */,
/* 08 */  0x0008 /*                                     BACKSPACE */,
/* 09 */  0x0009 /*                          CHARACTER TABULATION */,
/* 0A */  0x000A /*                                LINE FEED (LF) */,
/* 0B */  0x000B /*                               LINE TABULATION */,
/* 0C */  0x000C /*                                FORM FEED (FF) */,
/* 0D */  0x000D /*                          CARRIAGE RETURN (CR) */,
/* 0E */  0x000E /*                                     SHIFT OUT */,
/* 0F */  0x000F /*                                      SHIFT IN */,
/* 10 */  0x0010 /*                              DATA LINK ESCAPE */,
/* 11 */  0x0011 /*                            DEVICE CONTROL ONE */,
/* 12 */  0x0012 /*                            DEVICE CONTROL TWO */,
/* 13 */  0x0013 /*                          DEVICE CONTROL THREE */,
/* 14 */  0x0014 /*                           DEVICE CONTROL FOUR */,
/* 15 */  0x0015 /*                          NEGATIVE ACKNOWLEDGE */,
/* 16 */  0x0016 /*                              SYNCHRONOUS IDLE */,
/* 17 */  0x0017 /*                     END OF TRANSMISSION BLOCK */,
/* 18 */  0x0018 /*                                        CANCEL */,
/* 19 */  0x0019 /*                                 END OF MEDIUM */,
/* 1A */  0x001A /*                                    SUBSTITUTE */,
/* 1B */  0x001B /*                                        ESCAPE */,
/* 1C */  0x001C /*                    INFORMATION SEPARATOR FOUR */,
/* 1D */  0x001D /*                   INFORMATION SEPARATOR THREE */,
/* 1E */  0x001E /*                     INFORMATION SEPARATOR TWO */,
/* 1F */  0x001F /*                     INFORMATION SEPARATOR ONE */,
/* 20 */  0x0020 /*                                         SPACE */,
/* 21 */  0x0021 /*                              EXCLAMATION MARK */,
/* 22 */  0x0022 /*                                QUOTATION MARK */,
/* 23 */  0x0023 /*                                   NUMBER SIGN */,
/* 24 */  0x0024 /*                                   DOLLAR SIGN */,
/* 25 */  0x0025 /*                                  PERCENT SIGN */,
/* 26 */  0x0026 /*                                     AMPERSAND */,
/* 27 */  0x0027 /*                                    APOSTROPHE */,
/* 28 */  0x0028 /*                              LEFT PARENTHESIS */,
/* 29 */  0x0029 /*                             RIGHT PARENTHESIS */,
/* 2A */  0x002A /*                                      ASTERISK */,
/* 2B */  0x002B /*                                     PLUS SIGN */,
/* 2C */  0x002C /*                                         COMMA */,
/* 2D */  0x002D /*                                  HYPHEN-MINUS */,
/* 2E */  0x002E /*                                     FULL STOP */,
/* 2F */  0x002F /*                                       SOLIDUS */,
/* 30 */  0x0030 /*                                    DIGIT ZERO */,
/* 31 */  0x0031 /*                                     DIGIT ONE */,
/* 32 */  0x0032 /*                                     DIGIT TWO */,
/* 33 */  0x0033 /*                                   DIGIT THREE */,
/* 34 */  0x0034 /*                                    DIGIT FOUR */,
/* 35 */  0x0035 /*                                    DIGIT FIVE */,
/* 36 */  0x0036 /*                                     DIGIT SIX */,
/* 37 */  0x0037 /*                                   DIGIT SEVEN */,
/* 38 */  0x0038 /*                                   DIGIT EIGHT */,
/* 39 */  0x0039 /*                                    DIGIT NINE */,
/* 3A */  0x003A /*                                         COLON */,
/* 3B */  0x003B /*                                     SEMICOLON */,
/* 3C */  0x003C /*                                LESS-THAN SIGN */,
/* 3D */  0x003D /*                                   EQUALS SIGN */,
/* 3E */  0x003E /*                             GREATER-THAN SIGN */,
/* 3F */  0x003F /*                                 QUESTION MARK */,
/* 40 */  0x0040 /*                                 COMMERCIAL AT */,
/* 41 */  0x0041 /*                        LATIN CAPITAL LETTER A */,
/* 42 */  0x0042 /*                        LATIN CAPITAL LETTER B */,
/* 43 */  0x0043 /*                        LATIN CAPITAL LETTER C */,
/* 44 */  0x0044 /*                        LATIN CAPITAL LETTER D */,
/* 45 */  0x0045 /*                        LATIN CAPITAL LETTER E */,
/* 46 */  0x0046 /*                        LATIN CAPITAL LETTER F */,
/* 47 */  0x0047 /*                        LATIN CAPITAL LETTER G */,
/* 48 */  0x0048 /*                        LATIN CAPITAL LETTER H */,
/* 49 */  0x0049 /*                        LATIN CAPITAL LETTER I */,
/* 4A */  0x004A /*                        LATIN CAPITAL LETTER J */,
/* 4B */  0x004B /*                        LATIN CAPITAL LETTER K */,
/* 4C */  0x004C /*                        LATIN CAPITAL LETTER L */,
/* 4D */  0x004D /*                        LATIN CAPITAL LETTER M */,
/* 4E */  0x004E /*                        LATIN CAPITAL LETTER N */,
/* 4F */  0x004F /*                        LATIN CAPITAL LETTER O */,
/* 50 */  0x0050 /*                        LATIN CAPITAL LETTER P */,
/* 51 */  0x0051 /*                        LATIN CAPITAL LETTER Q */,
/* 52 */  0x0052 /*                        LATIN CAPITAL LETTER R */,
/* 53 */  0x0053 /*                        LATIN CAPITAL LETTER S */,
/* 54 */  0x0054 /*                        LATIN CAPITAL LETTER T */,
/* 55 */  0x0055 /*                        LATIN CAPITAL LETTER U */,
/* 56 */  0x0056 /*                        LATIN CAPITAL LETTER V */,
/* 57 */  0x0057 /*                        LATIN CAPITAL LETTER W */,
/* 58 */  0x0058 /*                        LATIN CAPITAL LETTER X */,
/* 59 */  0x0059 /*                        LATIN CAPITAL LETTER Y */,
/* 5A */  0x005A /*                        LATIN CAPITAL LETTER Z */,
/* 5B */  0x005B /*                           LEFT SQUARE BRACKET */,
/* 5C */  0x005C /*                               REVERSE SOLIDUS */,
/* 5D */  0x005D /*                          RIGHT SQUARE BRACKET */,
/* 5E */  0x005E /*                             CIRCUMFLEX ACCENT */,
/* 5F */  0x005F /*                                      LOW LINE */,
/* 60 */  0x0060 /*                                  GRAVE ACCENT */,
/* 61 */  0x0061 /*                          LATIN SMALL LETTER A */,
/* 62 */  0x0062 /*                          LATIN SMALL LETTER B */,
/* 63 */  0x0063 /*                          LATIN SMALL LETTER C */,
/* 64 */  0x0064 /*                          LATIN SMALL LETTER D */,
/* 65 */  0x0065 /*                          LATIN SMALL LETTER E */,
/* 66 */  0x0066 /*                          LATIN SMALL LETTER F */,
/* 67 */  0x0067 /*                          LATIN SMALL LETTER G */,
/* 68 */  0x0068 /*                          LATIN SMALL LETTER H */,
/* 69 */  0x0069 /*                          LATIN SMALL LETTER I */,
/* 6A */  0x006A /*                          LATIN SMALL LETTER J */,
/* 6B */  0x006B /*                          LATIN SMALL LETTER K */,
/* 6C */  0x006C /*                          LATIN SMALL LETTER L */,
/* 6D */  0x006D /*                          LATIN SMALL LETTER M */,
/* 6E */  0x006E /*                          LATIN SMALL LETTER N */,
/* 6F */  0x006F /*                          LATIN SMALL LETTER O */,
/* 70 */  0x0070 /*                          LATIN SMALL LETTER P */,
/* 71 */  0x0071 /*                          LATIN SMALL LETTER Q */,
/* 72 */  0x0072 /*                          LATIN SMALL LETTER R */,
/* 73 */  0x0073 /*                          LATIN SMALL LETTER S */,
/* 74 */  0x0074 /*                          LATIN SMALL LETTER T */,
/* 75 */  0x0075 /*                          LATIN SMALL LETTER U */,
/* 76 */  0x0076 /*                          LATIN SMALL LETTER V */,
/* 77 */  0x0077 /*                          LATIN SMALL LETTER W */,
/* 78 */  0x0078 /*                          LATIN SMALL LETTER X */,
/* 79 */  0x0079 /*                          LATIN SMALL LETTER Y */,
/* 7A */  0x007A /*                          LATIN SMALL LETTER Z */,
/* 7B */  0x007B /*                            LEFT CURLY BRACKET */,
/* 7C */  0x007C /*                                 VERTICAL LINE */,
/* 7D */  0x007D /*                           RIGHT CURLY BRACKET */,
/* 7E */  0x007E /*                                         TILDE */,
/* 7F */  0x007F /*                                        DELETE */,
/* 80 */  0x20AC /*                                     EURO SIGN */,
/* 81 */     CANT_MAP_CHARACTER   ,
/* 82 */  0x201A /*                   SINGLE LOW-9 QUOTATION MARK */,
/* 83 */     CANT_MAP_CHARACTER   ,
/* 84 */  0x201E /*                   DOUBLE LOW-9 QUOTATION MARK */,
/* 85 */  0x2026 /*                           HORIZONTAL ELLIPSIS */,
/* 86 */  0x2020 /*                                        DAGGER */,
/* 87 */  0x2021 /*                                 DOUBLE DAGGER */,
/* 88 */     CANT_MAP_CHARACTER   ,
/* 89 */  0x2030 /*                                PER MILLE SIGN */,
/* 8A */     CANT_MAP_CHARACTER   ,
/* 8B */  0x2039 /*     SINGLE LEFT-POINTING ANGLE QUOTATION MARK */,
/* 8C */     CANT_MAP_CHARACTER   ,
/* 8D */  0x00A8 /*                                     DIAERESIS */,
/* 8E */  0x02C7 /*                                         CARON */,
/* 8F */  0x00B8 /*                                       CEDILLA */,
/* 90 */     CANT_MAP_CHARACTER   ,
/* 91 */  0x2018 /*                    LEFT SINGLE QUOTATION MARK */,
/* 92 */  0x2019 /*                   RIGHT SINGLE QUOTATION MARK */,
/* 93 */  0x201C /*                    LEFT DOUBLE QUOTATION MARK */,
/* 94 */  0x201D /*                   RIGHT DOUBLE QUOTATION MARK */,
/* 95 */  0x2022 /*                                        BULLET */,
/* 96 */  0x2013 /*                                       EN DASH */,
/* 97 */  0x2014 /*                                       EM DASH */,
/* 98 */     CANT_MAP_CHARACTER   ,
/* 99 */  0x2122 /*                               TRADE MARK SIGN */,
/* 9A */     CANT_MAP_CHARACTER   ,
/* 9B */  0x203A /*    SINGLE RIGHT-POINTING ANGLE QUOTATION MARK */,
/* 9C */     CANT_MAP_CHARACTER   ,
/* 9D */  0x00AF /*                                        MACRON */,
/* 9E */  0x02DB /*                                        OGONEK */,
/* 9F */     CANT_MAP_CHARACTER   ,
/* A0 */  0x00A0 /*                                NO-BREAK SPACE */,
/* A1 */     CANT_MAP_CHARACTER   ,
/* A2 */  0x00A2 /*                                     CENT SIGN */,
/* A3 */  0x00A3 /*                                    POUND SIGN */,
/* A4 */  0x00A4 /*                                 CURRENCY SIGN */,
/* A5 */     CANT_MAP_CHARACTER   ,
/* A6 */  0x00A6 /*                                    BROKEN BAR */,
/* A7 */  0x00A7 /*                                  SECTION SIGN */,
/* A8 */  0x00D8 /*            LATIN CAPITAL LETTER O WITH STROKE */,
/* A9 */  0x00A9 /*                                COPYRIGHT SIGN */,
/* AA */  0x0156 /*           LATIN CAPITAL LETTER R WITH CEDILLA */,
/* AB */  0x00AB /*     LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */,
/* AC */  0x00AC /*                                      NOT SIGN */,
/* AD */  0x00AD /*                                   SOFT HYPHEN */,
/* AE */  0x00AE /*                               REGISTERED SIGN */,
/* AF */  0x00C6 /*                       LATIN CAPITAL LETTER AE */,
/* B0 */  0x00B0 /*                                   DEGREE SIGN */,
/* B1 */  0x00B1 /*                               PLUS-MINUS SIGN */,
/* B2 */  0x00B2 /*                               SUPERSCRIPT TWO */,
/* B3 */  0x00B3 /*                             SUPERSCRIPT THREE */,
/* B4 */  0x00B4 /*                                  ACUTE ACCENT */,
/* B5 */  0x00B5 /*                                    MICRO SIGN */,
/* B6 */  0x00B6 /*                                  PILCROW SIGN */,
/* B7 */  0x00B7 /*                                    MIDDLE DOT */,
/* B8 */  0x00F8 /*              LATIN SMALL LETTER O WITH STROKE */,
/* B9 */  0x00B9 /*                               SUPERSCRIPT ONE */,
/* BA */  0x0157 /*             LATIN SMALL LETTER R WITH CEDILLA */,
/* BB */  0x00BB /*    RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */,
/* BC */  0x00BC /*                   VULGAR FRACTION ONE QUARTER */,
/* BD */  0x00BD /*                      VULGAR FRACTION ONE HALF */,
/* BE */  0x00BE /*                VULGAR FRACTION THREE QUARTERS */,
/* BF */  0x00E6 /*                         LATIN SMALL LETTER AE */,
/* C0 */  0x0104 /*            LATIN CAPITAL LETTER A WITH OGONEK */,
/* C1 */  0x012E /*            LATIN CAPITAL LETTER I WITH OGONEK */,
/* C2 */  0x0100 /*            LATIN CAPITAL LETTER A WITH MACRON */,
/* C3 */  0x0106 /*             LATIN CAPITAL LETTER C WITH ACUTE */,
/* C4 */  0x00C4 /*         LATIN CAPITAL LETTER A WITH DIAERESIS */,
/* C5 */  0x00C5 /*        LATIN CAPITAL LETTER A WITH RING ABOVE */,
/* C6 */  0x0118 /*            LATIN CAPITAL LETTER E WITH OGONEK */,
/* C7 */  0x0112 /*            LATIN CAPITAL LETTER E WITH MACRON */,
/* C8 */  0x010C /*             LATIN CAPITAL LETTER C WITH CARON */,
/* C9 */  0x00C9 /*             LATIN CAPITAL LETTER E WITH ACUTE */,
/* CA */  0x0179 /*             LATIN CAPITAL LETTER Z WITH ACUTE */,
/* CB */  0x0116 /*         LATIN CAPITAL LETTER E WITH DOT ABOVE */,
/* CC */  0x0122 /*           LATIN CAPITAL LETTER G WITH CEDILLA */,
/* CD */  0x0136 /*           LATIN CAPITAL LETTER K WITH CEDILLA */,
/* CE */  0x012A /*            LATIN CAPITAL LETTER I WITH MACRON */,
/* CF */  0x013B /*           LATIN CAPITAL LETTER L WITH CEDILLA */,
/* D0 */  0x0160 /*             LATIN CAPITAL LETTER S WITH CARON */,
/* D1 */  0x0143 /*             LATIN CAPITAL LETTER N WITH ACUTE */,
/* D2 */  0x0145 /*           LATIN CAPITAL LETTER N WITH CEDILLA */,
/* D3 */  0x00D3 /*             LATIN CAPITAL LETTER O WITH ACUTE */,
/* D4 */  0x014C /*            LATIN CAPITAL LETTER O WITH MACRON */,
/* D5 */  0x00D5 /*             LATIN CAPITAL LETTER O WITH TILDE */,
/* D6 */  0x00D6 /*         LATIN CAPITAL LETTER O WITH DIAERESIS */,
/* D7 */  0x00D7 /*                           MULTIPLICATION SIGN */,
/* D8 */  0x0172 /*            LATIN CAPITAL LETTER U WITH OGONEK */,
/* D9 */  0x0141 /*            LATIN CAPITAL LETTER L WITH STROKE */,
/* DA */  0x015A /*             LATIN CAPITAL LETTER S WITH ACUTE */,
/* DB */  0x016A /*            LATIN CAPITAL LETTER U WITH MACRON */,
/* DC */  0x00DC /*         LATIN CAPITAL LETTER U WITH DIAERESIS */,
/* DD */  0x017B /*         LATIN CAPITAL LETTER Z WITH DOT ABOVE */,
/* DE */  0x017D /*             LATIN CAPITAL LETTER Z WITH CARON */,
/* DF */  0x00DF /*                    LATIN SMALL LETTER SHARP S */,
/* E0 */  0x0105 /*              LATIN SMALL LETTER A WITH OGONEK */,
/* E1 */  0x012F /*              LATIN SMALL LETTER I WITH OGONEK */,
/* E2 */  0x0101 /*              LATIN SMALL LETTER A WITH MACRON */,
/* E3 */  0x0107 /*               LATIN SMALL LETTER C WITH ACUTE */,
/* E4 */  0x00E4 /*           LATIN SMALL LETTER A WITH DIAERESIS */,
/* E5 */  0x00E5 /*          LATIN SMALL LETTER A WITH RING ABOVE */,
/* E6 */  0x0119 /*              LATIN SMALL LETTER E WITH OGONEK */,
/* E7 */  0x0113 /*              LATIN SMALL LETTER E WITH MACRON */,
/* E8 */  0x010D /*               LATIN SMALL LETTER C WITH CARON */,
/* E9 */  0x00E9 /*               LATIN SMALL LETTER E WITH ACUTE */,
/* EA */  0x017A /*               LATIN SMALL LETTER Z WITH ACUTE */,
/* EB */  0x0117 /*           LATIN SMALL LETTER E WITH DOT ABOVE */,
/* EC */  0x0123 /*             LATIN SMALL LETTER G WITH CEDILLA */,
/* ED */  0x0137 /*             LATIN SMALL LETTER K WITH CEDILLA */,
/* EE */  0x012B /*              LATIN SMALL LETTER I WITH MACRON */,
/* EF */  0x013C /*             LATIN SMALL LETTER L WITH CEDILLA */,
/* F0 */  0x0161 /*               LATIN SMALL LETTER S WITH CARON */,
/* F1 */  0x0144 /*               LATIN SMALL LETTER N WITH ACUTE */,
/* F2 */  0x0146 /*             LATIN SMALL LETTER N WITH CEDILLA */,
/* F3 */  0x00F3 /*               LATIN SMALL LETTER O WITH ACUTE */,
/* F4 */  0x014D /*              LATIN SMALL LETTER O WITH MACRON */,
/* F5 */  0x00F5 /*               LATIN SMALL LETTER O WITH TILDE */,
/* F6 */  0x00F6 /*           LATIN SMALL LETTER O WITH DIAERESIS */,
/* F7 */  0x00F7 /*                                 DIVISION SIGN */,
/* F8 */  0x0173 /*              LATIN SMALL LETTER U WITH OGONEK */,
/* F9 */  0x0142 /*              LATIN SMALL LETTER L WITH STROKE */,
/* FA */  0x015B /*               LATIN SMALL LETTER S WITH ACUTE */,
/* FB */  0x016B /*              LATIN SMALL LETTER U WITH MACRON */,
/* FC */  0x00FC /*           LATIN SMALL LETTER U WITH DIAERESIS */,
/* FD */  0x017C /*           LATIN SMALL LETTER Z WITH DOT ABOVE */,
/* FE */  0x017E /*               LATIN SMALL LETTER Z WITH CARON */,
/* FF */  0x02D9 /*                                     DOT ABOVE */,
};


static const UCHAR from_unicode_mapping_array[] = {
/* U+XX00 */	CANT_MAP_CHARACTER,	/* 0 */
/* U+XX01 */	CANT_MAP_CHARACTER,	/* 1 */
/* U+XX02 */	CANT_MAP_CHARACTER,	/* 2 */
/* U+XX03 */	CANT_MAP_CHARACTER,	/* 3 */
/* U+XX04 */	CANT_MAP_CHARACTER,	/* 4 */
/* U+XX05 */	CANT_MAP_CHARACTER,	/* 5 */
/* U+XX06 */	CANT_MAP_CHARACTER,	/* 6 */
/* U+XX07 */	CANT_MAP_CHARACTER,	/* 7 */
/* U+XX08 */	CANT_MAP_CHARACTER,	/* 8 */
/* U+XX09 */	CANT_MAP_CHARACTER,	/* 9 */
/* U+XX0A */	CANT_MAP_CHARACTER,	/* 10 */
/* U+XX0B */	CANT_MAP_CHARACTER,	/* 11 */
/* U+XX0C */	CANT_MAP_CHARACTER,	/* 12 */
/* U+XX0D */	CANT_MAP_CHARACTER,	/* 13 */
/* U+XX0E */	CANT_MAP_CHARACTER,	/* 14 */
/* U+XX0F */	CANT_MAP_CHARACTER,	/* 15 */
/* U+XX10 */	CANT_MAP_CHARACTER,	/* 16 */
/* U+XX11 */	CANT_MAP_CHARACTER,	/* 17 */
/* U+XX12 */	CANT_MAP_CHARACTER,	/* 18 */
/* U+XX13 */	CANT_MAP_CHARACTER,	/* 19 */
/* U+XX14 */	CANT_MAP_CHARACTER,	/* 20 */
/* U+XX15 */	CANT_MAP_CHARACTER,	/* 21 */
/* U+XX16 */	CANT_MAP_CHARACTER,	/* 22 */
/* U+XX17 */	CANT_MAP_CHARACTER,	/* 23 */
/* U+XX18 */	CANT_MAP_CHARACTER,	/* 24 */
/* U+XX19 */	CANT_MAP_CHARACTER,	/* 25 */
/* U+XX1A */	CANT_MAP_CHARACTER,	/* 26 */
/* U+XX1B */	CANT_MAP_CHARACTER,	/* 27 */
/* U+XX1C */	CANT_MAP_CHARACTER,	/* 28 */
/* U+XX1D */	CANT_MAP_CHARACTER,	/* 29 */
/* U+XX1E */	CANT_MAP_CHARACTER,	/* 30 */
/* U+XX1F */	CANT_MAP_CHARACTER,	/* 31 */
/* U+XX20 */	CANT_MAP_CHARACTER,	/* 32 */
/* U+XX21 */	CANT_MAP_CHARACTER,	/* 33 */
/* U+XX22 */	CANT_MAP_CHARACTER,	/* 34 */
/* U+XX23 */	CANT_MAP_CHARACTER,	/* 35 */
/* U+XX24 */	CANT_MAP_CHARACTER,	/* 36 */
/* U+XX25 */	CANT_MAP_CHARACTER,	/* 37 */
/* U+XX26 */	CANT_MAP_CHARACTER,	/* 38 */
/* U+XX27 */	CANT_MAP_CHARACTER,	/* 39 */
/* U+XX28 */	CANT_MAP_CHARACTER,	/* 40 */
/* U+XX29 */	CANT_MAP_CHARACTER,	/* 41 */
/* U+XX2A */	CANT_MAP_CHARACTER,	/* 42 */
/* U+XX2B */	CANT_MAP_CHARACTER,	/* 43 */
/* U+XX2C */	CANT_MAP_CHARACTER,	/* 44 */
/* U+XX2D */	CANT_MAP_CHARACTER,	/* 45 */
/* U+XX2E */	CANT_MAP_CHARACTER,	/* 46 */
/* U+XX2F */	CANT_MAP_CHARACTER,	/* 47 */
/* U+XX30 */	CANT_MAP_CHARACTER,	/* 48 */
/* U+XX31 */	CANT_MAP_CHARACTER,	/* 49 */
/* U+XX32 */	CANT_MAP_CHARACTER,	/* 50 */
/* U+XX33 */	CANT_MAP_CHARACTER,	/* 51 */
/* U+XX34 */	CANT_MAP_CHARACTER,	/* 52 */
/* U+XX35 */	CANT_MAP_CHARACTER,	/* 53 */
/* U+XX36 */	CANT_MAP_CHARACTER,	/* 54 */
/* U+XX37 */	CANT_MAP_CHARACTER,	/* 55 */
/* U+XX38 */	CANT_MAP_CHARACTER,	/* 56 */
/* U+XX39 */	CANT_MAP_CHARACTER,	/* 57 */
/* U+XX3A */	CANT_MAP_CHARACTER,	/* 58 */
/* U+XX3B */	CANT_MAP_CHARACTER,	/* 59 */
/* U+XX3C */	CANT_MAP_CHARACTER,	/* 60 */
/* U+XX3D */	CANT_MAP_CHARACTER,	/* 61 */
/* U+XX3E */	CANT_MAP_CHARACTER,	/* 62 */
/* U+XX3F */	CANT_MAP_CHARACTER,	/* 63 */
/* U+XX40 */	CANT_MAP_CHARACTER,	/* 64 */
/* U+XX41 */	CANT_MAP_CHARACTER,	/* 65 */
/* U+XX42 */	CANT_MAP_CHARACTER,	/* 66 */
/* U+XX43 */	CANT_MAP_CHARACTER,	/* 67 */
/* U+XX44 */	CANT_MAP_CHARACTER,	/* 68 */
/* U+XX45 */	CANT_MAP_CHARACTER,	/* 69 */
/* U+XX46 */	CANT_MAP_CHARACTER,	/* 70 */
/* U+XX47 */	CANT_MAP_CHARACTER,	/* 71 */
/* U+XX48 */	CANT_MAP_CHARACTER,	/* 72 */
/* U+XX49 */	CANT_MAP_CHARACTER,	/* 73 */
/* U+XX4A */	CANT_MAP_CHARACTER,	/* 74 */
/* U+XX4B */	CANT_MAP_CHARACTER,	/* 75 */
/* U+XX4C */	CANT_MAP_CHARACTER,	/* 76 */
/* U+XX4D */	CANT_MAP_CHARACTER,	/* 77 */
/* U+XX4E */	CANT_MAP_CHARACTER,	/* 78 */
/* U+XX4F */	CANT_MAP_CHARACTER,	/* 79 */
/* U+XX50 */	CANT_MAP_CHARACTER,	/* 80 */
/* U+XX51 */	CANT_MAP_CHARACTER,	/* 81 */
/* U+XX52 */	CANT_MAP_CHARACTER,	/* 82 */
/* U+XX53 */	CANT_MAP_CHARACTER,	/* 83 */
/* U+XX54 */	CANT_MAP_CHARACTER,	/* 84 */
/* U+XX55 */	CANT_MAP_CHARACTER,	/* 85 */
/* U+XX56 */	CANT_MAP_CHARACTER,	/* 86 */
/* U+XX57 */	CANT_MAP_CHARACTER,	/* 87 */
/* U+XX58 */	CANT_MAP_CHARACTER,	/* 88 */
/* U+XX59 */	CANT_MAP_CHARACTER,	/* 89 */
/* U+XX5A */	CANT_MAP_CHARACTER,	/* 90 */
/* U+XX5B */	CANT_MAP_CHARACTER,	/* 91 */
/* U+XX5C */	CANT_MAP_CHARACTER,	/* 92 */
/* U+XX5D */	CANT_MAP_CHARACTER,	/* 93 */
/* U+XX5E */	CANT_MAP_CHARACTER,	/* 94 */
/* U+XX5F */	CANT_MAP_CHARACTER,	/* 95 */
/* U+XX60 */	CANT_MAP_CHARACTER,	/* 96 */
/* U+XX61 */	CANT_MAP_CHARACTER,	/* 97 */
/* U+XX62 */	CANT_MAP_CHARACTER,	/* 98 */
/* U+XX63 */	CANT_MAP_CHARACTER,	/* 99 */
/* U+XX64 */	CANT_MAP_CHARACTER,	/* 100 */
/* U+XX65 */	CANT_MAP_CHARACTER,	/* 101 */
/* U+XX66 */	CANT_MAP_CHARACTER,	/* 102 */
/* U+XX67 */	CANT_MAP_CHARACTER,	/* 103 */
/* U+XX68 */	CANT_MAP_CHARACTER,	/* 104 */
/* U+XX69 */	CANT_MAP_CHARACTER,	/* 105 */
/* U+XX6A */	CANT_MAP_CHARACTER,	/* 106 */
/* U+XX6B */	CANT_MAP_CHARACTER,	/* 107 */
/* U+XX6C */	CANT_MAP_CHARACTER,	/* 108 */
/* U+XX6D */	CANT_MAP_CHARACTER,	/* 109 */
/* U+XX6E */	CANT_MAP_CHARACTER,	/* 110 */
/* U+XX6F */	CANT_MAP_CHARACTER,	/* 111 */
/* U+XX70 */	CANT_MAP_CHARACTER,	/* 112 */
/* U+XX71 */	CANT_MAP_CHARACTER,	/* 113 */
/* U+XX72 */	CANT_MAP_CHARACTER,	/* 114 */
/* U+XX73 */	CANT_MAP_CHARACTER,	/* 115 */
/* U+XX74 */	CANT_MAP_CHARACTER,	/* 116 */
/* U+XX75 */	CANT_MAP_CHARACTER,	/* 117 */
/* U+XX76 */	CANT_MAP_CHARACTER,	/* 118 */
/* U+XX77 */	CANT_MAP_CHARACTER,	/* 119 */
/* U+XX78 */	CANT_MAP_CHARACTER,	/* 120 */
/* U+XX79 */	CANT_MAP_CHARACTER,	/* 121 */
/* U+XX7A */	CANT_MAP_CHARACTER,	/* 122 */
/* U+XX7B */	CANT_MAP_CHARACTER,	/* 123 */
/* U+XX7C */	CANT_MAP_CHARACTER,	/* 124 */
/* U+XX7D */	CANT_MAP_CHARACTER,	/* 125 */
/* U+XX7E */	CANT_MAP_CHARACTER,	/* 126 */
/* U+XX7F */	CANT_MAP_CHARACTER,	/* 127 */
/* U+XX80 */	CANT_MAP_CHARACTER,	/* 128 */
/* U+XX81 */	CANT_MAP_CHARACTER,	/* 129 */
/* U+XX82 */	CANT_MAP_CHARACTER,	/* 130 */
/* U+XX83 */	CANT_MAP_CHARACTER,	/* 131 */
/* U+XX84 */	CANT_MAP_CHARACTER,	/* 132 */
/* U+XX85 */	CANT_MAP_CHARACTER,	/* 133 */
/* U+XX86 */	CANT_MAP_CHARACTER,	/* 134 */
/* U+XX87 */	CANT_MAP_CHARACTER,	/* 135 */
/* U+XX88 */	CANT_MAP_CHARACTER,	/* 136 */
/* U+XX89 */	CANT_MAP_CHARACTER,	/* 137 */
/* U+XX8A */	CANT_MAP_CHARACTER,	/* 138 */
/* U+XX8B */	CANT_MAP_CHARACTER,	/* 139 */
/* U+XX8C */	CANT_MAP_CHARACTER,	/* 140 */
/* U+XX8D */	CANT_MAP_CHARACTER,	/* 141 */
/* U+XX8E */	CANT_MAP_CHARACTER,	/* 142 */
/* U+XX8F */	CANT_MAP_CHARACTER,	/* 143 */
/* U+XX90 */	CANT_MAP_CHARACTER,	/* 144 */
/* U+XX91 */	CANT_MAP_CHARACTER,	/* 145 */
/* U+XX92 */	CANT_MAP_CHARACTER,	/* 146 */
/* U+XX93 */	CANT_MAP_CHARACTER,	/* 147 */
/* U+XX94 */	CANT_MAP_CHARACTER,	/* 148 */
/* U+XX95 */	CANT_MAP_CHARACTER,	/* 149 */
/* U+XX96 */	CANT_MAP_CHARACTER,	/* 150 */
/* U+XX97 */	CANT_MAP_CHARACTER,	/* 151 */
/* U+XX98 */	CANT_MAP_CHARACTER,	/* 152 */
/* U+XX99 */	CANT_MAP_CHARACTER,	/* 153 */
/* U+XX9A */	CANT_MAP_CHARACTER,	/* 154 */
/* U+XX9B */	CANT_MAP_CHARACTER,	/* 155 */
/* U+XX9C */	CANT_MAP_CHARACTER,	/* 156 */
/* U+XX9D */	CANT_MAP_CHARACTER,	/* 157 */
/* U+XX9E */	CANT_MAP_CHARACTER,	/* 158 */
/* U+XX9F */	CANT_MAP_CHARACTER,	/* 159 */
/* U+XXA0 */	CANT_MAP_CHARACTER,	/* 160 */
/* U+XXA1 */	CANT_MAP_CHARACTER,	/* 161 */
/* U+XXA2 */	CANT_MAP_CHARACTER,	/* 162 */
/* U+XXA3 */	CANT_MAP_CHARACTER,	/* 163 */
/* U+XXA4 */	CANT_MAP_CHARACTER,	/* 164 */
/* U+XXA5 */	CANT_MAP_CHARACTER,	/* 165 */
/* U+XXA6 */	CANT_MAP_CHARACTER,	/* 166 */
/* U+XXA7 */	CANT_MAP_CHARACTER,	/* 167 */
/* U+XXA8 */	CANT_MAP_CHARACTER,	/* 168 */
/* U+XXA9 */	CANT_MAP_CHARACTER,	/* 169 */
/* U+XXAA */	CANT_MAP_CHARACTER,	/* 170 */
/* U+XXAB */	CANT_MAP_CHARACTER,	/* 171 */
/* U+XXAC */	CANT_MAP_CHARACTER,	/* 172 */
/* U+XXAD */	CANT_MAP_CHARACTER,	/* 173 */
/* U+XXAE */	CANT_MAP_CHARACTER,	/* 174 */
/* U+XXAF */	CANT_MAP_CHARACTER,	/* 175 */
/* U+XXB0 */	CANT_MAP_CHARACTER,	/* 176 */
/* U+XXB1 */	CANT_MAP_CHARACTER,	/* 177 */
/* U+XXB2 */	CANT_MAP_CHARACTER,	/* 178 */
/* U+XXB3 */	CANT_MAP_CHARACTER,	/* 179 */
/* U+XXB4 */	CANT_MAP_CHARACTER,	/* 180 */
/* U+XXB5 */	CANT_MAP_CHARACTER,	/* 181 */
/* U+XXB6 */	CANT_MAP_CHARACTER,	/* 182 */
/* U+XXB7 */	CANT_MAP_CHARACTER,	/* 183 */
/* U+XXB8 */	CANT_MAP_CHARACTER,	/* 184 */
/* U+XXB9 */	CANT_MAP_CHARACTER,	/* 185 */
/* U+XXBA */	CANT_MAP_CHARACTER,	/* 186 */
/* U+XXBB */	CANT_MAP_CHARACTER,	/* 187 */
/* U+XXBC */	CANT_MAP_CHARACTER,	/* 188 */
/* U+XXBD */	CANT_MAP_CHARACTER,	/* 189 */
/* U+XXBE */	CANT_MAP_CHARACTER,	/* 190 */
/* U+XXBF */	CANT_MAP_CHARACTER,	/* 191 */
/* U+XXC0 */	CANT_MAP_CHARACTER,	/* 192 */
/* U+XXC1 */	CANT_MAP_CHARACTER,	/* 193 */
/* U+XXC2 */	CANT_MAP_CHARACTER,	/* 194 */
/* U+XXC3 */	CANT_MAP_CHARACTER,	/* 195 */
/* U+XXC4 */	CANT_MAP_CHARACTER,	/* 196 */
/* U+XXC5 */	CANT_MAP_CHARACTER,	/* 197 */
/* U+XXC6 */	CANT_MAP_CHARACTER,	/* 198 */
/* U+XXC7 */	CANT_MAP_CHARACTER,	/* 199 */
/* U+XXC8 */	CANT_MAP_CHARACTER,	/* 200 */
/* U+XXC9 */	CANT_MAP_CHARACTER,	/* 201 */
/* U+XXCA */	CANT_MAP_CHARACTER,	/* 202 */
/* U+XXCB */	CANT_MAP_CHARACTER,	/* 203 */
/* U+XXCC */	CANT_MAP_CHARACTER,	/* 204 */
/* U+XXCD */	CANT_MAP_CHARACTER,	/* 205 */
/* U+XXCE */	CANT_MAP_CHARACTER,	/* 206 */
/* U+XXCF */	CANT_MAP_CHARACTER,	/* 207 */
/* U+XXD0 */	CANT_MAP_CHARACTER,	/* 208 */
/* U+XXD1 */	CANT_MAP_CHARACTER,	/* 209 */
/* U+XXD2 */	CANT_MAP_CHARACTER,	/* 210 */
/* U+XXD3 */	CANT_MAP_CHARACTER,	/* 211 */
/* U+XXD4 */	CANT_MAP_CHARACTER,	/* 212 */
/* U+XXD5 */	CANT_MAP_CHARACTER,	/* 213 */
/* U+XXD6 */	CANT_MAP_CHARACTER,	/* 214 */
/* U+XXD7 */	CANT_MAP_CHARACTER,	/* 215 */
/* U+XXD8 */	CANT_MAP_CHARACTER,	/* 216 */
/* U+XXD9 */	CANT_MAP_CHARACTER,	/* 217 */
/* U+XXDA */	CANT_MAP_CHARACTER,	/* 218 */
/* U+XXDB */	CANT_MAP_CHARACTER,	/* 219 */
/* U+XXDC */	CANT_MAP_CHARACTER,	/* 220 */
/* U+XXDD */	CANT_MAP_CHARACTER,	/* 221 */
/* U+XXDE */	CANT_MAP_CHARACTER,	/* 222 */
/* U+XXDF */	CANT_MAP_CHARACTER,	/* 223 */
/* U+XXE0 */	CANT_MAP_CHARACTER,	/* 224 */
/* U+XXE1 */	CANT_MAP_CHARACTER,	/* 225 */
/* U+XXE2 */	CANT_MAP_CHARACTER,	/* 226 */
/* U+XXE3 */	CANT_MAP_CHARACTER,	/* 227 */
/* U+XXE4 */	CANT_MAP_CHARACTER,	/* 228 */
/* U+XXE5 */	CANT_MAP_CHARACTER,	/* 229 */
/* U+XXE6 */	CANT_MAP_CHARACTER,	/* 230 */
/* U+XXE7 */	CANT_MAP_CHARACTER,	/* 231 */
/* U+XXE8 */	CANT_MAP_CHARACTER,	/* 232 */
/* U+XXE9 */	CANT_MAP_CHARACTER,	/* 233 */
/* U+XXEA */	CANT_MAP_CHARACTER,	/* 234 */
/* U+XXEB */	CANT_MAP_CHARACTER,	/* 235 */
/* U+XXEC */	CANT_MAP_CHARACTER,	/* 236 */
/* U+XXED */	CANT_MAP_CHARACTER,	/* 237 */
/* U+XXEE */	CANT_MAP_CHARACTER,	/* 238 */
/* U+XXEF */	CANT_MAP_CHARACTER,	/* 239 */
/* U+XXF0 */	CANT_MAP_CHARACTER,	/* 240 */
/* U+XXF1 */	CANT_MAP_CHARACTER,	/* 241 */
/* U+XXF2 */	CANT_MAP_CHARACTER,	/* 242 */
/* U+XXF3 */	CANT_MAP_CHARACTER,	/* 243 */
/* U+XXF4 */	CANT_MAP_CHARACTER,	/* 244 */
/* U+XXF5 */	CANT_MAP_CHARACTER,	/* 245 */
/* U+XXF6 */	CANT_MAP_CHARACTER,	/* 246 */
/* U+XXF7 */	CANT_MAP_CHARACTER,	/* 247 */
/* U+XXF8 */	CANT_MAP_CHARACTER,	/* 248 */
/* U+XXF9 */	CANT_MAP_CHARACTER,	/* 249 */
/* U+XXFA */	CANT_MAP_CHARACTER,	/* 250 */
/* U+XXFB */	CANT_MAP_CHARACTER,	/* 251 */
/* U+XXFC */	CANT_MAP_CHARACTER,	/* 252 */
/* U+XXFD */	CANT_MAP_CHARACTER,	/* 253 */
/* U+XXFE */	CANT_MAP_CHARACTER,	/* 254 */
/* U+XXFF */	CANT_MAP_CHARACTER,	/* 255 */
/* U+0000 */	0x00	/*                                          NULL */,/* 256 */
/* U+0001 */	0x01	/*                              START OF HEADING */,/* 257 */
/* U+0002 */	0x02	/*                                 START OF TEXT */,/* 258 */
/* U+0003 */	0x03	/*                                   END OF TEXT */,/* 259 */
/* U+0004 */	0x04	/*                           END OF TRANSMISSION */,/* 260 */
/* U+0005 */	0x05	/*                                       ENQUIRY */,/* 261 */
/* U+0006 */	0x06	/*                                   ACKNOWLEDGE */,/* 262 */
/* U+0007 */	0x07	/*                                          BELL */,/* 263 */
/* U+0008 */	0x08	/*                                     BACKSPACE */,/* 264 */
/* U+0009 */	0x09	/*                          CHARACTER TABULATION */,/* 265 */
/* U+000A */	0x0A	/*                                LINE FEED (LF) */,/* 266 */
/* U+000B */	0x0B	/*                               LINE TABULATION */,/* 267 */
/* U+000C */	0x0C	/*                                FORM FEED (FF) */,/* 268 */
/* U+000D */	0x0D	/*                          CARRIAGE RETURN (CR) */,/* 269 */
/* U+000E */	0x0E	/*                                     SHIFT OUT */,/* 270 */
/* U+000F */	0x0F	/*                                      SHIFT IN */,/* 271 */
/* U+0010 */	0x10	/*                              DATA LINK ESCAPE */,/* 272 */
/* U+0011 */	0x11	/*                            DEVICE CONTROL ONE */,/* 273 */
/* U+0012 */	0x12	/*                            DEVICE CONTROL TWO */,/* 274 */
/* U+0013 */	0x13	/*                          DEVICE CONTROL THREE */,/* 275 */
/* U+0014 */	0x14	/*                           DEVICE CONTROL FOUR */,/* 276 */
/* U+0015 */	0x15	/*                          NEGATIVE ACKNOWLEDGE */,/* 277 */
/* U+0016 */	0x16	/*                              SYNCHRONOUS IDLE */,/* 278 */
/* U+0017 */	0x17	/*                     END OF TRANSMISSION BLOCK */,/* 279 */
/* U+0018 */	0x18	/*                                        CANCEL */,/* 280 */
/* U+0019 */	0x19	/*                                 END OF MEDIUM */,/* 281 */
/* U+001A */	0x1A	/*                                    SUBSTITUTE */,/* 282 */
/* U+001B */	0x1B	/*                                        ESCAPE */,/* 283 */
/* U+001C */	0x1C	/*                    INFORMATION SEPARATOR FOUR */,/* 284 */
/* U+001D */	0x1D	/*                   INFORMATION SEPARATOR THREE */,/* 285 */
/* U+001E */	0x1E	/*                     INFORMATION SEPARATOR TWO */,/* 286 */
/* U+001F */	0x1F	/*                     INFORMATION SEPARATOR ONE */,/* 287 */
/* U+0020 */	0x20	/*                                         SPACE */,/* 288 */
/* U+0021 */	0x21	/*                              EXCLAMATION MARK */,/* 289 */
/* U+0022 */	0x22	/*                                QUOTATION MARK */,/* 290 */
/* U+0023 */	0x23	/*                                   NUMBER SIGN */,/* 291 */
/* U+0024 */	0x24	/*                                   DOLLAR SIGN */,/* 292 */
/* U+0025 */	0x25	/*                                  PERCENT SIGN */,/* 293 */
/* U+0026 */	0x26	/*                                     AMPERSAND */,/* 294 */
/* U+0027 */	0x27	/*                                    APOSTROPHE */,/* 295 */
/* U+0028 */	0x28	/*                              LEFT PARENTHESIS */,/* 296 */
/* U+0029 */	0x29	/*                             RIGHT PARENTHESIS */,/* 297 */
/* U+002A */	0x2A	/*                                      ASTERISK */,/* 298 */
/* U+002B */	0x2B	/*                                     PLUS SIGN */,/* 299 */
/* U+002C */	0x2C	/*                                         COMMA */,/* 300 */
/* U+002D */	0x2D	/*                                  HYPHEN-MINUS */,/* 301 */
/* U+002E */	0x2E	/*                                     FULL STOP */,/* 302 */
/* U+002F */	0x2F	/*                                       SOLIDUS */,/* 303 */
/* U+0030 */	0x30	/*                                    DIGIT ZERO */,/* 304 */
/* U+0031 */	0x31	/*                                     DIGIT ONE */,/* 305 */
/* U+0032 */	0x32	/*                                     DIGIT TWO */,/* 306 */
/* U+0033 */	0x33	/*                                   DIGIT THREE */,/* 307 */
/* U+0034 */	0x34	/*                                    DIGIT FOUR */,/* 308 */
/* U+0035 */	0x35	/*                                    DIGIT FIVE */,/* 309 */
/* U+0036 */	0x36	/*                                     DIGIT SIX */,/* 310 */
/* U+0037 */	0x37	/*                                   DIGIT SEVEN */,/* 311 */
/* U+0038 */	0x38	/*                                   DIGIT EIGHT */,/* 312 */
/* U+0039 */	0x39	/*                                    DIGIT NINE */,/* 313 */
/* U+003A */	0x3A	/*                                         COLON */,/* 314 */
/* U+003B */	0x3B	/*                                     SEMICOLON */,/* 315 */
/* U+003C */	0x3C	/*                                LESS-THAN SIGN */,/* 316 */
/* U+003D */	0x3D	/*                                   EQUALS SIGN */,/* 317 */
/* U+003E */	0x3E	/*                             GREATER-THAN SIGN */,/* 318 */
/* U+003F */	0x3F	/*                                 QUESTION MARK */,/* 319 */
/* U+0040 */	0x40	/*                                 COMMERCIAL AT */,/* 320 */
/* U+0041 */	0x41	/*                        LATIN CAPITAL LETTER A */,/* 321 */
/* U+0042 */	0x42	/*                        LATIN CAPITAL LETTER B */,/* 322 */
/* U+0043 */	0x43	/*                        LATIN CAPITAL LETTER C */,/* 323 */
/* U+0044 */	0x44	/*                        LATIN CAPITAL LETTER D */,/* 324 */
/* U+0045 */	0x45	/*                        LATIN CAPITAL LETTER E */,/* 325 */
/* U+0046 */	0x46	/*                        LATIN CAPITAL LETTER F */,/* 326 */
/* U+0047 */	0x47	/*                        LATIN CAPITAL LETTER G */,/* 327 */
/* U+0048 */	0x48	/*                        LATIN CAPITAL LETTER H */,/* 328 */
/* U+0049 */	0x49	/*                        LATIN CAPITAL LETTER I */,/* 329 */
/* U+004A */	0x4A	/*                        LATIN CAPITAL LETTER J */,/* 330 */
/* U+004B */	0x4B	/*                        LATIN CAPITAL LETTER K */,/* 331 */
/* U+004C */	0x4C	/*                        LATIN CAPITAL LETTER L */,/* 332 */
/* U+004D */	0x4D	/*                        LATIN CAPITAL LETTER M */,/* 333 */
/* U+004E */	0x4E	/*                        LATIN CAPITAL LETTER N */,/* 334 */
/* U+004F */	0x4F	/*                        LATIN CAPITAL LETTER O */,/* 335 */
/* U+0050 */	0x50	/*                        LATIN CAPITAL LETTER P */,/* 336 */
/* U+0051 */	0x51	/*                        LATIN CAPITAL LETTER Q */,/* 337 */
/* U+0052 */	0x52	/*                        LATIN CAPITAL LETTER R */,/* 338 */
/* U+0053 */	0x53	/*                        LATIN CAPITAL LETTER S */,/* 339 */
/* U+0054 */	0x54	/*                        LATIN CAPITAL LETTER T */,/* 340 */
/* U+0055 */	0x55	/*                        LATIN CAPITAL LETTER U */,/* 341 */
/* U+0056 */	0x56	/*                        LATIN CAPITAL LETTER V */,/* 342 */
/* U+0057 */	0x57	/*                        LATIN CAPITAL LETTER W */,/* 343 */
/* U+0058 */	0x58	/*                        LATIN CAPITAL LETTER X */,/* 344 */
/* U+0059 */	0x59	/*                        LATIN CAPITAL LETTER Y */,/* 345 */
/* U+005A */	0x5A	/*                        LATIN CAPITAL LETTER Z */,/* 346 */
/* U+005B */	0x5B	/*                           LEFT SQUARE BRACKET */,/* 347 */
/* U+005C */	0x5C	/*                               REVERSE SOLIDUS */,/* 348 */
/* U+005D */	0x5D	/*                          RIGHT SQUARE BRACKET */,/* 349 */
/* U+005E */	0x5E	/*                             CIRCUMFLEX ACCENT */,/* 350 */
/* U+005F */	0x5F	/*                                      LOW LINE */,/* 351 */
/* U+0060 */	0x60	/*                                  GRAVE ACCENT */,/* 352 */
/* U+0061 */	0x61	/*                          LATIN SMALL LETTER A */,/* 353 */
/* U+0062 */	0x62	/*                          LATIN SMALL LETTER B */,/* 354 */
/* U+0063 */	0x63	/*                          LATIN SMALL LETTER C */,/* 355 */
/* U+0064 */	0x64	/*                          LATIN SMALL LETTER D */,/* 356 */
/* U+0065 */	0x65	/*                          LATIN SMALL LETTER E */,/* 357 */
/* U+0066 */	0x66	/*                          LATIN SMALL LETTER F */,/* 358 */
/* U+0067 */	0x67	/*                          LATIN SMALL LETTER G */,/* 359 */
/* U+0068 */	0x68	/*                          LATIN SMALL LETTER H */,/* 360 */
/* U+0069 */	0x69	/*                          LATIN SMALL LETTER I */,/* 361 */
/* U+006A */	0x6A	/*                          LATIN SMALL LETTER J */,/* 362 */
/* U+006B */	0x6B	/*                          LATIN SMALL LETTER K */,/* 363 */
/* U+006C */	0x6C	/*                          LATIN SMALL LETTER L */,/* 364 */
/* U+006D */	0x6D	/*                          LATIN SMALL LETTER M */,/* 365 */
/* U+006E */	0x6E	/*                          LATIN SMALL LETTER N */,/* 366 */
/* U+006F */	0x6F	/*                          LATIN SMALL LETTER O */,/* 367 */
/* U+0070 */	0x70	/*                          LATIN SMALL LETTER P */,/* 368 */
/* U+0071 */	0x71	/*                          LATIN SMALL LETTER Q */,/* 369 */
/* U+0072 */	0x72	/*                          LATIN SMALL LETTER R */,/* 370 */
/* U+0073 */	0x73	/*                          LATIN SMALL LETTER S */,/* 371 */
/* U+0074 */	0x74	/*                          LATIN SMALL LETTER T */,/* 372 */
/* U+0075 */	0x75	/*                          LATIN SMALL LETTER U */,/* 373 */
/* U+0076 */	0x76	/*                          LATIN SMALL LETTER V */,/* 374 */
/* U+0077 */	0x77	/*                          LATIN SMALL LETTER W */,/* 375 */
/* U+0078 */	0x78	/*                          LATIN SMALL LETTER X */,/* 376 */
/* U+0079 */	0x79	/*                          LATIN SMALL LETTER Y */,/* 377 */
/* U+007A */	0x7A	/*                          LATIN SMALL LETTER Z */,/* 378 */
/* U+007B */	0x7B	/*                            LEFT CURLY BRACKET */,/* 379 */
/* U+007C */	0x7C	/*                                 VERTICAL LINE */,/* 380 */
/* U+007D */	0x7D	/*                           RIGHT CURLY BRACKET */,/* 381 */
/* U+007E */	0x7E	/*                                         TILDE */,/* 382 */
/* U+007F */	0x7F	/*                                        DELETE */,/* 383 */
/* U+0080 */	CANT_MAP_CHARACTER,	/* 384 */
/* U+0081 */	CANT_MAP_CHARACTER,	/* 385 */
/* U+0082 */	CANT_MAP_CHARACTER,	/* 386 */
/* U+0083 */	CANT_MAP_CHARACTER,	/* 387 */
/* U+0084 */	CANT_MAP_CHARACTER,	/* 388 */
/* U+0085 */	CANT_MAP_CHARACTER,	/* 389 */
/* U+0086 */	CANT_MAP_CHARACTER,	/* 390 */
/* U+0087 */	CANT_MAP_CHARACTER,	/* 391 */
/* U+0088 */	CANT_MAP_CHARACTER,	/* 392 */
/* U+0089 */	CANT_MAP_CHARACTER,	/* 393 */
/* U+008A */	CANT_MAP_CHARACTER,	/* 394 */
/* U+008B */	CANT_MAP_CHARACTER,	/* 395 */
/* U+008C */	CANT_MAP_CHARACTER,	/* 396 */
/* U+008D */	CANT_MAP_CHARACTER,	/* 397 */
/* U+008E */	CANT_MAP_CHARACTER,	/* 398 */
/* U+008F */	CANT_MAP_CHARACTER,	/* 399 */
/* U+0090 */	CANT_MAP_CHARACTER,	/* 400 */
/* U+0091 */	CANT_MAP_CHARACTER,	/* 401 */
/* U+0092 */	CANT_MAP_CHARACTER,	/* 402 */
/* U+0093 */	CANT_MAP_CHARACTER,	/* 403 */
/* U+0094 */	CANT_MAP_CHARACTER,	/* 404 */
/* U+0095 */	CANT_MAP_CHARACTER,	/* 405 */
/* U+0096 */	CANT_MAP_CHARACTER,	/* 406 */
/* U+0097 */	CANT_MAP_CHARACTER,	/* 407 */
/* U+0098 */	CANT_MAP_CHARACTER,	/* 408 */
/* U+0099 */	CANT_MAP_CHARACTER,	/* 409 */
/* U+009A */	CANT_MAP_CHARACTER,	/* 410 */
/* U+009B */	CANT_MAP_CHARACTER,	/* 411 */
/* U+009C */	CANT_MAP_CHARACTER,	/* 412 */
/* U+009D */	CANT_MAP_CHARACTER,	/* 413 */
/* U+009E */	CANT_MAP_CHARACTER,	/* 414 */
/* U+009F */	CANT_MAP_CHARACTER,	/* 415 */
/* U+00A0 */	0xA0	/*                                NO-BREAK SPACE */,/* 416 */
/* U+00A1 */	CANT_MAP_CHARACTER,	/* 417 */
/* U+00A2 */	0xA2	/*                                     CENT SIGN */,/* 418 */
/* U+00A3 */	0xA3	/*                                    POUND SIGN */,/* 419 */
/* U+00A4 */	0xA4	/*                                 CURRENCY SIGN */,/* 420 */
/* U+00A5 */	CANT_MAP_CHARACTER,	/* 421 */
/* U+00A6 */	0xA6	/*                                    BROKEN BAR */,/* 422 */
/* U+00A7 */	0xA7	/*                                  SECTION SIGN */,/* 423 */
/* U+00A8 */	0x8D	/*                                     DIAERESIS */,/* 424 */
/* U+00A9 */	0xA9	/*                                COPYRIGHT SIGN */,/* 425 */
/* U+00AA */	CANT_MAP_CHARACTER,	/* 426 */
/* U+00AB */	0xAB	/*     LEFT-POINTING DOUBLE ANGLE QUOTATION MARK */,/* 427 */
/* U+00AC */	0xAC	/*                                      NOT SIGN */,/* 428 */
/* U+00AD */	0xAD	/*                                   SOFT HYPHEN */,/* 429 */
/* U+00AE */	0xAE	/*                               REGISTERED SIGN */,/* 430 */
/* U+00AF */	0x9D	/*                                        MACRON */,/* 431 */
/* U+00B0 */	0xB0	/*                                   DEGREE SIGN */,/* 432 */
/* U+00B1 */	0xB1	/*                               PLUS-MINUS SIGN */,/* 433 */
/* U+00B2 */	0xB2	/*                               SUPERSCRIPT TWO */,/* 434 */
/* U+00B3 */	0xB3	/*                             SUPERSCRIPT THREE */,/* 435 */
/* U+00B4 */	0xB4	/*                                  ACUTE ACCENT */,/* 436 */
/* U+00B5 */	0xB5	/*                                    MICRO SIGN */,/* 437 */
/* U+00B6 */	0xB6	/*                                  PILCROW SIGN */,/* 438 */
/* U+00B7 */	0xB7	/*                                    MIDDLE DOT */,/* 439 */
/* U+00B8 */	0x8F	/*                                       CEDILLA */,/* 440 */
/* U+00B9 */	0xB9	/*                               SUPERSCRIPT ONE */,/* 441 */
/* U+00BA */	CANT_MAP_CHARACTER,	/* 442 */
/* U+00BB */	0xBB	/*    RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK */,/* 443 */
/* U+00BC */	0xBC	/*                   VULGAR FRACTION ONE QUARTER */,/* 444 */
/* U+00BD */	0xBD	/*                      VULGAR FRACTION ONE HALF */,/* 445 */
/* U+00BE */	0xBE	/*                VULGAR FRACTION THREE QUARTERS */,/* 446 */
/* U+00BF */	CANT_MAP_CHARACTER,	/* 447 */
/* U+00C0 */	CANT_MAP_CHARACTER,	/* 448 */
/* U+00C1 */	CANT_MAP_CHARACTER,	/* 449 */
/* U+00C2 */	CANT_MAP_CHARACTER,	/* 450 */
/* U+00C3 */	CANT_MAP_CHARACTER,	/* 451 */
/* U+00C4 */	0xC4	/*         LATIN CAPITAL LETTER A WITH DIAERESIS */,/* 452 */
/* U+00C5 */	0xC5	/*        LATIN CAPITAL LETTER A WITH RING ABOVE */,/* 453 */
/* U+00C6 */	0xAF	/*                       LATIN CAPITAL LETTER AE */,/* 454 */
/* U+00C7 */	CANT_MAP_CHARACTER,	/* 455 */
/* U+00C8 */	CANT_MAP_CHARACTER,	/* 456 */
/* U+00C9 */	0xC9	/*             LATIN CAPITAL LETTER E WITH ACUTE */,/* 457 */
/* U+00CA */	CANT_MAP_CHARACTER,	/* 458 */
/* U+00CB */	CANT_MAP_CHARACTER,	/* 459 */
/* U+00CC */	CANT_MAP_CHARACTER,	/* 460 */
/* U+00CD */	CANT_MAP_CHARACTER,	/* 461 */
/* U+00CE */	CANT_MAP_CHARACTER,	/* 462 */
/* U+00CF */	CANT_MAP_CHARACTER,	/* 463 */
/* U+00D0 */	CANT_MAP_CHARACTER,	/* 464 */
/* U+00D1 */	CANT_MAP_CHARACTER,	/* 465 */
/* U+00D2 */	CANT_MAP_CHARACTER,	/* 466 */
/* U+00D3 */	0xD3	/*             LATIN CAPITAL LETTER O WITH ACUTE */,/* 467 */
/* U+00D4 */	CANT_MAP_CHARACTER,	/* 468 */
/* U+00D5 */	0xD5	/*             LATIN CAPITAL LETTER O WITH TILDE */,/* 469 */
/* U+00D6 */	0xD6	/*         LATIN CAPITAL LETTER O WITH DIAERESIS */,/* 470 */
/* U+00D7 */	0xD7	/*                           MULTIPLICATION SIGN */,/* 471 */
/* U+00D8 */	0xA8	/*            LATIN CAPITAL LETTER O WITH STROKE */,/* 472 */
/* U+00D9 */	CANT_MAP_CHARACTER,	/* 473 */
/* U+00DA */	CANT_MAP_CHARACTER,	/* 474 */
/* U+00DB */	CANT_MAP_CHARACTER,	/* 475 */
/* U+00DC */	0xDC	/*         LATIN CAPITAL LETTER U WITH DIAERESIS */,/* 476 */
/* U+00DD */	CANT_MAP_CHARACTER,	/* 477 */
/* U+00DE */	CANT_MAP_CHARACTER,	/* 478 */
/* U+00DF */	0xDF	/*                    LATIN SMALL LETTER SHARP S */,/* 479 */
/* U+00E0 */	CANT_MAP_CHARACTER,	/* 480 */
/* U+00E1 */	CANT_MAP_CHARACTER,	/* 481 */
/* U+00E2 */	CANT_MAP_CHARACTER,	/* 482 */
/* U+00E3 */	CANT_MAP_CHARACTER,	/* 483 */
/* U+00E4 */	0xE4	/*           LATIN SMALL LETTER A WITH DIAERESIS */,/* 484 */
/* U+00E5 */	0xE5	/*          LATIN SMALL LETTER A WITH RING ABOVE */,/* 485 */
/* U+00E6 */	0xBF	/*                         LATIN SMALL LETTER AE */,/* 486 */
/* U+00E7 */	CANT_MAP_CHARACTER,	/* 487 */
/* U+00E8 */	CANT_MAP_CHARACTER,	/* 488 */
/* U+00E9 */	0xE9	/*               LATIN SMALL LETTER E WITH ACUTE */,/* 489 */
/* U+00EA */	CANT_MAP_CHARACTER,	/* 490 */
/* U+00EB */	CANT_MAP_CHARACTER,	/* 491 */
/* U+00EC */	CANT_MAP_CHARACTER,	/* 492 */
/* U+00ED */	CANT_MAP_CHARACTER,	/* 493 */
/* U+00EE */	CANT_MAP_CHARACTER,	/* 494 */
/* U+00EF */	CANT_MAP_CHARACTER,	/* 495 */
/* U+00F0 */	CANT_MAP_CHARACTER,	/* 496 */
/* U+00F1 */	CANT_MAP_CHARACTER,	/* 497 */
/* U+00F2 */	CANT_MAP_CHARACTER,	/* 498 */
/* U+00F3 */	0xF3	/*               LATIN SMALL LETTER O WITH ACUTE */,/* 499 */
/* U+00F4 */	CANT_MAP_CHARACTER,	/* 500 */
/* U+00F5 */	0xF5	/*               LATIN SMALL LETTER O WITH TILDE */,/* 501 */
/* U+00F6 */	0xF6	/*           LATIN SMALL LETTER O WITH DIAERESIS */,/* 502 */
/* U+00F7 */	0xF7	/*                                 DIVISION SIGN */,/* 503 */
/* U+00F8 */	0xB8	/*              LATIN SMALL LETTER O WITH STROKE */,/* 504 */
/* U+00F9 */	CANT_MAP_CHARACTER,	/* 505 */
/* U+00FA */	CANT_MAP_CHARACTER,	/* 506 */
/* U+00FB */	CANT_MAP_CHARACTER,	/* 507 */
/* U+00FC */	0xFC	/*           LATIN SMALL LETTER U WITH DIAERESIS */,/* 508 */
/* U+00FD */	CANT_MAP_CHARACTER,	/* 509 */
/* U+00FE */	CANT_MAP_CHARACTER,	/* 510 */
/* U+00FF */	CANT_MAP_CHARACTER,	/* 511 */
/* U+0100 */	0xC2	/*            LATIN CAPITAL LETTER A WITH MACRON */,/* 512 */
/* U+0101 */	0xE2	/*              LATIN SMALL LETTER A WITH MACRON */,/* 513 */
/* U+0102 */	CANT_MAP_CHARACTER,	/* 514 */
/* U+0103 */	CANT_MAP_CHARACTER,	/* 515 */
/* U+0104 */	0xC0	/*            LATIN CAPITAL LETTER A WITH OGONEK */,/* 516 */
/* U+0105 */	0xE0	/*              LATIN SMALL LETTER A WITH OGONEK */,/* 517 */
/* U+0106 */	0xC3	/*             LATIN CAPITAL LETTER C WITH ACUTE */,/* 518 */
/* U+0107 */	0xE3	/*               LATIN SMALL LETTER C WITH ACUTE */,/* 519 */
/* U+0108 */	CANT_MAP_CHARACTER,	/* 520 */
/* U+0109 */	CANT_MAP_CHARACTER,	/* 521 */
/* U+010A */	CANT_MAP_CHARACTER,	/* 522 */
/* U+010B */	CANT_MAP_CHARACTER,	/* 523 */
/* U+010C */	0xC8	/*             LATIN CAPITAL LETTER C WITH CARON */,/* 524 */
/* U+010D */	0xE8	/*               LATIN SMALL LETTER C WITH CARON */,/* 525 */
/* U+010E */	CANT_MAP_CHARACTER,	/* 526 */
/* U+010F */	CANT_MAP_CHARACTER,	/* 527 */
/* U+0110 */	CANT_MAP_CHARACTER,	/* 528 */
/* U+0111 */	CANT_MAP_CHARACTER,	/* 529 */
/* U+0112 */	0xC7	/*            LATIN CAPITAL LETTER E WITH MACRON */,/* 530 */
/* U+0113 */	0xE7	/*              LATIN SMALL LETTER E WITH MACRON */,/* 531 */
/* U+0114 */	CANT_MAP_CHARACTER,	/* 532 */
/* U+0115 */	CANT_MAP_CHARACTER,	/* 533 */
/* U+0116 */	0xCB	/*         LATIN CAPITAL LETTER E WITH DOT ABOVE */,/* 534 */
/* U+0117 */	0xEB	/*           LATIN SMALL LETTER E WITH DOT ABOVE */,/* 535 */
/* U+0118 */	0xC6	/*            LATIN CAPITAL LETTER E WITH OGONEK */,/* 536 */
/* U+0119 */	0xE6	/*              LATIN SMALL LETTER E WITH OGONEK */,/* 537 */
/* U+011A */	CANT_MAP_CHARACTER,	/* 538 */
/* U+011B */	CANT_MAP_CHARACTER,	/* 539 */
/* U+011C */	CANT_MAP_CHARACTER,	/* 540 */
/* U+011D */	CANT_MAP_CHARACTER,	/* 541 */
/* U+011E */	CANT_MAP_CHARACTER,	/* 542 */
/* U+011F */	CANT_MAP_CHARACTER,	/* 543 */
/* U+0120 */	CANT_MAP_CHARACTER,	/* 544 */
/* U+0121 */	CANT_MAP_CHARACTER,	/* 545 */
/* U+0122 */	0xCC	/*           LATIN CAPITAL LETTER G WITH CEDILLA */,/* 546 */
/* U+0123 */	0xEC	/*             LATIN SMALL LETTER G WITH CEDILLA */,/* 547 */
/* U+0124 */	CANT_MAP_CHARACTER,	/* 548 */
/* U+0125 */	CANT_MAP_CHARACTER,	/* 549 */
/* U+0126 */	CANT_MAP_CHARACTER,	/* 550 */
/* U+0127 */	CANT_MAP_CHARACTER,	/* 551 */
/* U+0128 */	CANT_MAP_CHARACTER,	/* 552 */
/* U+0129 */	CANT_MAP_CHARACTER,	/* 553 */
/* U+012A */	0xCE	/*            LATIN CAPITAL LETTER I WITH MACRON */,/* 554 */
/* U+012B */	0xEE	/*              LATIN SMALL LETTER I WITH MACRON */,/* 555 */
/* U+012C */	CANT_MAP_CHARACTER,	/* 556 */
/* U+012D */	CANT_MAP_CHARACTER,	/* 557 */
/* U+012E */	0xC1	/*            LATIN CAPITAL LETTER I WITH OGONEK */,/* 558 */
/* U+012F */	0xE1	/*              LATIN SMALL LETTER I WITH OGONEK */,/* 559 */
/* U+0130 */	CANT_MAP_CHARACTER,	/* 560 */
/* U+0131 */	CANT_MAP_CHARACTER,	/* 561 */
/* U+0132 */	CANT_MAP_CHARACTER,	/* 562 */
/* U+0133 */	CANT_MAP_CHARACTER,	/* 563 */
/* U+0134 */	CANT_MAP_CHARACTER,	/* 564 */
/* U+0135 */	CANT_MAP_CHARACTER,	/* 565 */
/* U+0136 */	0xCD	/*           LATIN CAPITAL LETTER K WITH CEDILLA */,/* 566 */
/* U+0137 */	0xED	/*             LATIN SMALL LETTER K WITH CEDILLA */,/* 567 */
/* U+0138 */	CANT_MAP_CHARACTER,	/* 568 */
/* U+0139 */	CANT_MAP_CHARACTER,	/* 569 */
/* U+013A */	CANT_MAP_CHARACTER,	/* 570 */
/* U+013B */	0xCF	/*           LATIN CAPITAL LETTER L WITH CEDILLA */,/* 571 */
/* U+013C */	0xEF	/*             LATIN SMALL LETTER L WITH CEDILLA */,/* 572 */
/* U+013D */	CANT_MAP_CHARACTER,	/* 573 */
/* U+013E */	CANT_MAP_CHARACTER,	/* 574 */
/* U+013F */	CANT_MAP_CHARACTER,	/* 575 */
/* U+0140 */	CANT_MAP_CHARACTER,	/* 576 */
/* U+0141 */	0xD9	/*            LATIN CAPITAL LETTER L WITH STROKE */,/* 577 */
/* U+0142 */	0xF9	/*              LATIN SMALL LETTER L WITH STROKE */,/* 578 */
/* U+0143 */	0xD1	/*             LATIN CAPITAL LETTER N WITH ACUTE */,/* 579 */
/* U+0144 */	0xF1	/*               LATIN SMALL LETTER N WITH ACUTE */,/* 580 */
/* U+0145 */	0xD2	/*           LATIN CAPITAL LETTER N WITH CEDILLA */,/* 581 */
/* U+0146 */	0xF2	/*             LATIN SMALL LETTER N WITH CEDILLA */,/* 582 */
/* U+0147 */	CANT_MAP_CHARACTER,	/* 583 */
/* U+0148 */	CANT_MAP_CHARACTER,	/* 584 */
/* U+0149 */	CANT_MAP_CHARACTER,	/* 585 */
/* U+014A */	CANT_MAP_CHARACTER,	/* 586 */
/* U+014B */	CANT_MAP_CHARACTER,	/* 587 */
/* U+014C */	0xD4	/*            LATIN CAPITAL LETTER O WITH MACRON */,/* 588 */
/* U+014D */	0xF4	/*              LATIN SMALL LETTER O WITH MACRON */,/* 589 */
/* U+014E */	CANT_MAP_CHARACTER,	/* 590 */
/* U+014F */	CANT_MAP_CHARACTER,	/* 591 */
/* U+0150 */	CANT_MAP_CHARACTER,	/* 592 */
/* U+0151 */	CANT_MAP_CHARACTER,	/* 593 */
/* U+0152 */	CANT_MAP_CHARACTER,	/* 594 */
/* U+0153 */	CANT_MAP_CHARACTER,	/* 595 */
/* U+0154 */	CANT_MAP_CHARACTER,	/* 596 */
/* U+0155 */	CANT_MAP_CHARACTER,	/* 597 */
/* U+0156 */	0xAA	/*           LATIN CAPITAL LETTER R WITH CEDILLA */,/* 598 */
/* U+0157 */	0xBA	/*             LATIN SMALL LETTER R WITH CEDILLA */,/* 599 */
/* U+0158 */	CANT_MAP_CHARACTER,	/* 600 */
/* U+0159 */	CANT_MAP_CHARACTER,	/* 601 */
/* U+015A */	0xDA	/*             LATIN CAPITAL LETTER S WITH ACUTE */,/* 602 */
/* U+015B */	0xFA	/*               LATIN SMALL LETTER S WITH ACUTE */,/* 603 */
/* U+015C */	CANT_MAP_CHARACTER,	/* 604 */
/* U+015D */	CANT_MAP_CHARACTER,	/* 605 */
/* U+015E */	CANT_MAP_CHARACTER,	/* 606 */
/* U+015F */	CANT_MAP_CHARACTER,	/* 607 */
/* U+0160 */	0xD0	/*             LATIN CAPITAL LETTER S WITH CARON */,/* 608 */
/* U+0161 */	0xF0	/*               LATIN SMALL LETTER S WITH CARON */,/* 609 */
/* U+0162 */	CANT_MAP_CHARACTER,	/* 610 */
/* U+0163 */	CANT_MAP_CHARACTER,	/* 611 */
/* U+0164 */	CANT_MAP_CHARACTER,	/* 612 */
/* U+0165 */	CANT_MAP_CHARACTER,	/* 613 */
/* U+0166 */	CANT_MAP_CHARACTER,	/* 614 */
/* U+0167 */	CANT_MAP_CHARACTER,	/* 615 */
/* U+0168 */	CANT_MAP_CHARACTER,	/* 616 */
/* U+0169 */	CANT_MAP_CHARACTER,	/* 617 */
/* U+016A */	0xDB	/*            LATIN CAPITAL LETTER U WITH MACRON */,/* 618 */
/* U+016B */	0xFB	/*              LATIN SMALL LETTER U WITH MACRON */,/* 619 */
/* U+016C */	CANT_MAP_CHARACTER,	/* 620 */
/* U+016D */	CANT_MAP_CHARACTER,	/* 621 */
/* U+016E */	CANT_MAP_CHARACTER,	/* 622 */
/* U+016F */	CANT_MAP_CHARACTER,	/* 623 */
/* U+0170 */	CANT_MAP_CHARACTER,	/* 624 */
/* U+0171 */	CANT_MAP_CHARACTER,	/* 625 */
/* U+0172 */	0xD8	/*            LATIN CAPITAL LETTER U WITH OGONEK */,/* 626 */
/* U+0173 */	0xF8	/*              LATIN SMALL LETTER U WITH OGONEK */,/* 627 */
/* U+0174 */	CANT_MAP_CHARACTER,	/* 628 */
/* U+0175 */	CANT_MAP_CHARACTER,	/* 629 */
/* U+0176 */	CANT_MAP_CHARACTER,	/* 630 */
/* U+0177 */	CANT_MAP_CHARACTER,	/* 631 */
/* U+0178 */	CANT_MAP_CHARACTER,	/* 632 */
/* U+0179 */	0xCA	/*             LATIN CAPITAL LETTER Z WITH ACUTE */,/* 633 */
/* U+017A */	0xEA	/*               LATIN SMALL LETTER Z WITH ACUTE */,/* 634 */
/* U+017B */	0xDD	/*         LATIN CAPITAL LETTER Z WITH DOT ABOVE */,/* 635 */
/* U+017C */	0xFD	/*           LATIN SMALL LETTER Z WITH DOT ABOVE */,/* 636 */
/* U+017D */	0xDE	/*             LATIN CAPITAL LETTER Z WITH CARON */,/* 637 */
/* U+017E */	0xFE	/*               LATIN SMALL LETTER Z WITH CARON */,/* 638 */
/* U+017F */	CANT_MAP_CHARACTER,	/* 639 */
/* U+0180 */	CANT_MAP_CHARACTER,	/* 640 */
/* U+0181 */	CANT_MAP_CHARACTER,	/* 641 */
/* U+0182 */	CANT_MAP_CHARACTER,	/* 642 */
/* U+0183 */	CANT_MAP_CHARACTER,	/* 643 */
/* U+0184 */	CANT_MAP_CHARACTER,	/* 644 */
/* U+0185 */	CANT_MAP_CHARACTER,	/* 645 */
/* U+0186 */	CANT_MAP_CHARACTER,	/* 646 */
/* U+0187 */	CANT_MAP_CHARACTER,	/* 647 */
/* U+0188 */	CANT_MAP_CHARACTER,	/* 648 */
/* U+0189 */	CANT_MAP_CHARACTER,	/* 649 */
/* U+018A */	CANT_MAP_CHARACTER,	/* 650 */
/* U+018B */	CANT_MAP_CHARACTER,	/* 651 */
/* U+018C */	CANT_MAP_CHARACTER,	/* 652 */
/* U+018D */	CANT_MAP_CHARACTER,	/* 653 */
/* U+018E */	CANT_MAP_CHARACTER,	/* 654 */
/* U+018F */	CANT_MAP_CHARACTER,	/* 655 */
/* U+0190 */	CANT_MAP_CHARACTER,	/* 656 */
/* U+0191 */	CANT_MAP_CHARACTER,	/* 657 */
/* U+0192 */	CANT_MAP_CHARACTER,	/* 658 */
/* U+0193 */	CANT_MAP_CHARACTER,	/* 659 */
/* U+0194 */	CANT_MAP_CHARACTER,	/* 660 */
/* U+0195 */	CANT_MAP_CHARACTER,	/* 661 */
/* U+0196 */	CANT_MAP_CHARACTER,	/* 662 */
/* U+0197 */	CANT_MAP_CHARACTER,	/* 663 */
/* U+0198 */	CANT_MAP_CHARACTER,	/* 664 */
/* U+0199 */	CANT_MAP_CHARACTER,	/* 665 */
/* U+019A */	CANT_MAP_CHARACTER,	/* 666 */
/* U+019B */	CANT_MAP_CHARACTER,	/* 667 */
/* U+019C */	CANT_MAP_CHARACTER,	/* 668 */
/* U+019D */	CANT_MAP_CHARACTER,	/* 669 */
/* U+019E */	CANT_MAP_CHARACTER,	/* 670 */
/* U+019F */	CANT_MAP_CHARACTER,	/* 671 */
/* U+01A0 */	CANT_MAP_CHARACTER,	/* 672 */
/* U+01A1 */	CANT_MAP_CHARACTER,	/* 673 */
/* U+01A2 */	CANT_MAP_CHARACTER,	/* 674 */
/* U+01A3 */	CANT_MAP_CHARACTER,	/* 675 */
/* U+01A4 */	CANT_MAP_CHARACTER,	/* 676 */
/* U+01A5 */	CANT_MAP_CHARACTER,	/* 677 */
/* U+01A6 */	CANT_MAP_CHARACTER,	/* 678 */
/* U+01A7 */	CANT_MAP_CHARACTER,	/* 679 */
/* U+01A8 */	CANT_MAP_CHARACTER,	/* 680 */
/* U+01A9 */	CANT_MAP_CHARACTER,	/* 681 */
/* U+01AA */	CANT_MAP_CHARACTER,	/* 682 */
/* U+01AB */	CANT_MAP_CHARACTER,	/* 683 */
/* U+01AC */	CANT_MAP_CHARACTER,	/* 684 */
/* U+01AD */	CANT_MAP_CHARACTER,	/* 685 */
/* U+01AE */	CANT_MAP_CHARACTER,	/* 686 */
/* U+01AF */	CANT_MAP_CHARACTER,	/* 687 */
/* U+01B0 */	CANT_MAP_CHARACTER,	/* 688 */
/* U+01B1 */	CANT_MAP_CHARACTER,	/* 689 */
/* U+01B2 */	CANT_MAP_CHARACTER,	/* 690 */
/* U+01B3 */	CANT_MAP_CHARACTER,	/* 691 */
/* U+01B4 */	CANT_MAP_CHARACTER,	/* 692 */
/* U+01B5 */	CANT_MAP_CHARACTER,	/* 693 */
/* U+01B6 */	CANT_MAP_CHARACTER,	/* 694 */
/* U+01B7 */	CANT_MAP_CHARACTER,	/* 695 */
/* U+01B8 */	CANT_MAP_CHARACTER,	/* 696 */
/* U+01B9 */	CANT_MAP_CHARACTER,	/* 697 */
/* U+01BA */	CANT_MAP_CHARACTER,	/* 698 */
/* U+01BB */	CANT_MAP_CHARACTER,	/* 699 */
/* U+01BC */	CANT_MAP_CHARACTER,	/* 700 */
/* U+01BD */	CANT_MAP_CHARACTER,	/* 701 */
/* U+01BE */	CANT_MAP_CHARACTER,	/* 702 */
/* U+01BF */	CANT_MAP_CHARACTER,	/* 703 */
/* U+01C0 */	CANT_MAP_CHARACTER,	/* 704 */
/* U+01C1 */	CANT_MAP_CHARACTER,	/* 705 */
/* U+01C2 */	CANT_MAP_CHARACTER,	/* 706 */
/* U+01C3 */	CANT_MAP_CHARACTER,	/* 707 */
/* U+01C4 */	CANT_MAP_CHARACTER,	/* 708 */
/* U+01C5 */	CANT_MAP_CHARACTER,	/* 709 */
/* U+01C6 */	CANT_MAP_CHARACTER,	/* 710 */
/* U+01C7 */	CANT_MAP_CHARACTER,	/* 711 */
/* U+01C8 */	CANT_MAP_CHARACTER,	/* 712 */
/* U+01C9 */	CANT_MAP_CHARACTER,	/* 713 */
/* U+01CA */	CANT_MAP_CHARACTER,	/* 714 */
/* U+01CB */	CANT_MAP_CHARACTER,	/* 715 */
/* U+01CC */	CANT_MAP_CHARACTER,	/* 716 */
/* U+01CD */	CANT_MAP_CHARACTER,	/* 717 */
/* U+01CE */	CANT_MAP_CHARACTER,	/* 718 */
/* U+01CF */	CANT_MAP_CHARACTER,	/* 719 */
/* U+01D0 */	CANT_MAP_CHARACTER,	/* 720 */
/* U+01D1 */	CANT_MAP_CHARACTER,	/* 721 */
/* U+01D2 */	CANT_MAP_CHARACTER,	/* 722 */
/* U+01D3 */	CANT_MAP_CHARACTER,	/* 723 */
/* U+01D4 */	CANT_MAP_CHARACTER,	/* 724 */
/* U+01D5 */	CANT_MAP_CHARACTER,	/* 725 */
/* U+01D6 */	CANT_MAP_CHARACTER,	/* 726 */
/* U+01D7 */	CANT_MAP_CHARACTER,	/* 727 */
/* U+01D8 */	CANT_MAP_CHARACTER,	/* 728 */
/* U+01D9 */	CANT_MAP_CHARACTER,	/* 729 */
/* U+01DA */	CANT_MAP_CHARACTER,	/* 730 */
/* U+01DB */	CANT_MAP_CHARACTER,	/* 731 */
/* U+01DC */	CANT_MAP_CHARACTER,	/* 732 */
/* U+01DD */	CANT_MAP_CHARACTER,	/* 733 */
/* U+01DE */	CANT_MAP_CHARACTER,	/* 734 */
/* U+01DF */	CANT_MAP_CHARACTER,	/* 735 */
/* U+01E0 */	CANT_MAP_CHARACTER,	/* 736 */
/* U+01E1 */	CANT_MAP_CHARACTER,	/* 737 */
/* U+01E2 */	CANT_MAP_CHARACTER,	/* 738 */
/* U+01E3 */	CANT_MAP_CHARACTER,	/* 739 */
/* U+01E4 */	CANT_MAP_CHARACTER,	/* 740 */
/* U+01E5 */	CANT_MAP_CHARACTER,	/* 741 */
/* U+01E6 */	CANT_MAP_CHARACTER,	/* 742 */
/* U+01E7 */	CANT_MAP_CHARACTER,	/* 743 */
/* U+01E8 */	CANT_MAP_CHARACTER,	/* 744 */
/* U+01E9 */	CANT_MAP_CHARACTER,	/* 745 */
/* U+01EA */	CANT_MAP_CHARACTER,	/* 746 */
/* U+01EB */	CANT_MAP_CHARACTER,	/* 747 */
/* U+01EC */	CANT_MAP_CHARACTER,	/* 748 */
/* U+01ED */	CANT_MAP_CHARACTER,	/* 749 */
/* U+01EE */	CANT_MAP_CHARACTER,	/* 750 */
/* U+01EF */	CANT_MAP_CHARACTER,	/* 751 */
/* U+01F0 */	CANT_MAP_CHARACTER,	/* 752 */
/* U+01F1 */	CANT_MAP_CHARACTER,	/* 753 */
/* U+01F2 */	CANT_MAP_CHARACTER,	/* 754 */
/* U+01F3 */	CANT_MAP_CHARACTER,	/* 755 */
/* U+01F4 */	CANT_MAP_CHARACTER,	/* 756 */
/* U+01F5 */	CANT_MAP_CHARACTER,	/* 757 */
/* U+01F6 */	CANT_MAP_CHARACTER,	/* 758 */
/* U+01F7 */	CANT_MAP_CHARACTER,	/* 759 */
/* U+01F8 */	CANT_MAP_CHARACTER,	/* 760 */
/* U+01F9 */	CANT_MAP_CHARACTER,	/* 761 */
/* U+01FA */	CANT_MAP_CHARACTER,	/* 762 */
/* U+01FB */	CANT_MAP_CHARACTER,	/* 763 */
/* U+01FC */	CANT_MAP_CHARACTER,	/* 764 */
/* U+01FD */	CANT_MAP_CHARACTER,	/* 765 */
/* U+01FE */	CANT_MAP_CHARACTER,	/* 766 */
/* U+01FF */	CANT_MAP_CHARACTER,	/* 767 */
/* U+0200 */	CANT_MAP_CHARACTER,	/* 768 */
/* U+0201 */	CANT_MAP_CHARACTER,	/* 769 */
/* U+0202 */	CANT_MAP_CHARACTER,	/* 770 */
/* U+0203 */	CANT_MAP_CHARACTER,	/* 771 */
/* U+0204 */	CANT_MAP_CHARACTER,	/* 772 */
/* U+0205 */	CANT_MAP_CHARACTER,	/* 773 */
/* U+0206 */	CANT_MAP_CHARACTER,	/* 774 */
/* U+0207 */	CANT_MAP_CHARACTER,	/* 775 */
/* U+0208 */	CANT_MAP_CHARACTER,	/* 776 */
/* U+0209 */	CANT_MAP_CHARACTER,	/* 777 */
/* U+020A */	CANT_MAP_CHARACTER,	/* 778 */
/* U+020B */	CANT_MAP_CHARACTER,	/* 779 */
/* U+020C */	CANT_MAP_CHARACTER,	/* 780 */
/* U+020D */	CANT_MAP_CHARACTER,	/* 781 */
/* U+020E */	CANT_MAP_CHARACTER,	/* 782 */
/* U+020F */	CANT_MAP_CHARACTER,	/* 783 */
/* U+0210 */	CANT_MAP_CHARACTER,	/* 784 */
/* U+0211 */	CANT_MAP_CHARACTER,	/* 785 */
/* U+0212 */	CANT_MAP_CHARACTER,	/* 786 */
/* U+0213 */	CANT_MAP_CHARACTER,	/* 787 */
/* U+0214 */	CANT_MAP_CHARACTER,	/* 788 */
/* U+0215 */	CANT_MAP_CHARACTER,	/* 789 */
/* U+0216 */	CANT_MAP_CHARACTER,	/* 790 */
/* U+0217 */	CANT_MAP_CHARACTER,	/* 791 */
/* U+0218 */	CANT_MAP_CHARACTER,	/* 792 */
/* U+0219 */	CANT_MAP_CHARACTER,	/* 793 */
/* U+021A */	CANT_MAP_CHARACTER,	/* 794 */
/* U+021B */	CANT_MAP_CHARACTER,	/* 795 */
/* U+021C */	CANT_MAP_CHARACTER,	/* 796 */
/* U+021D */	CANT_MAP_CHARACTER,	/* 797 */
/* U+021E */	CANT_MAP_CHARACTER,	/* 798 */
/* U+021F */	CANT_MAP_CHARACTER,	/* 799 */
/* U+0220 */	CANT_MAP_CHARACTER,	/* 800 */
/* U+0221 */	CANT_MAP_CHARACTER,	/* 801 */
/* U+0222 */	CANT_MAP_CHARACTER,	/* 802 */
/* U+0223 */	CANT_MAP_CHARACTER,	/* 803 */
/* U+0224 */	CANT_MAP_CHARACTER,	/* 804 */
/* U+0225 */	CANT_MAP_CHARACTER,	/* 805 */
/* U+0226 */	CANT_MAP_CHARACTER,	/* 806 */
/* U+0227 */	CANT_MAP_CHARACTER,	/* 807 */
/* U+0228 */	CANT_MAP_CHARACTER,	/* 808 */
/* U+0229 */	CANT_MAP_CHARACTER,	/* 809 */
/* U+022A */	CANT_MAP_CHARACTER,	/* 810 */
/* U+022B */	CANT_MAP_CHARACTER,	/* 811 */
/* U+022C */	CANT_MAP_CHARACTER,	/* 812 */
/* U+022D */	CANT_MAP_CHARACTER,	/* 813 */
/* U+022E */	CANT_MAP_CHARACTER,	/* 814 */
/* U+022F */	CANT_MAP_CHARACTER,	/* 815 */
/* U+0230 */	CANT_MAP_CHARACTER,	/* 816 */
/* U+0231 */	CANT_MAP_CHARACTER,	/* 817 */
/* U+0232 */	CANT_MAP_CHARACTER,	/* 818 */
/* U+0233 */	CANT_MAP_CHARACTER,	/* 819 */
/* U+0234 */	CANT_MAP_CHARACTER,	/* 820 */
/* U+0235 */	CANT_MAP_CHARACTER,	/* 821 */
/* U+0236 */	CANT_MAP_CHARACTER,	/* 822 */
/* U+0237 */	CANT_MAP_CHARACTER,	/* 823 */
/* U+0238 */	CANT_MAP_CHARACTER,	/* 824 */
/* U+0239 */	CANT_MAP_CHARACTER,	/* 825 */
/* U+023A */	CANT_MAP_CHARACTER,	/* 826 */
/* U+023B */	CANT_MAP_CHARACTER,	/* 827 */
/* U+023C */	CANT_MAP_CHARACTER,	/* 828 */
/* U+023D */	CANT_MAP_CHARACTER,	/* 829 */
/* U+023E */	CANT_MAP_CHARACTER,	/* 830 */
/* U+023F */	CANT_MAP_CHARACTER,	/* 831 */
/* U+0240 */	CANT_MAP_CHARACTER,	/* 832 */
/* U+0241 */	CANT_MAP_CHARACTER,	/* 833 */
/* U+0242 */	CANT_MAP_CHARACTER,	/* 834 */
/* U+0243 */	CANT_MAP_CHARACTER,	/* 835 */
/* U+0244 */	CANT_MAP_CHARACTER,	/* 836 */
/* U+0245 */	CANT_MAP_CHARACTER,	/* 837 */
/* U+0246 */	CANT_MAP_CHARACTER,	/* 838 */
/* U+0247 */	CANT_MAP_CHARACTER,	/* 839 */
/* U+0248 */	CANT_MAP_CHARACTER,	/* 840 */
/* U+0249 */	CANT_MAP_CHARACTER,	/* 841 */
/* U+024A */	CANT_MAP_CHARACTER,	/* 842 */
/* U+024B */	CANT_MAP_CHARACTER,	/* 843 */
/* U+024C */	CANT_MAP_CHARACTER,	/* 844 */
/* U+024D */	CANT_MAP_CHARACTER,	/* 845 */
/* U+024E */	CANT_MAP_CHARACTER,	/* 846 */
/* U+024F */	CANT_MAP_CHARACTER,	/* 847 */
/* U+0250 */	CANT_MAP_CHARACTER,	/* 848 */
/* U+0251 */	CANT_MAP_CHARACTER,	/* 849 */
/* U+0252 */	CANT_MAP_CHARACTER,	/* 850 */
/* U+0253 */	CANT_MAP_CHARACTER,	/* 851 */
/* U+0254 */	CANT_MAP_CHARACTER,	/* 852 */
/* U+0255 */	CANT_MAP_CHARACTER,	/* 853 */
/* U+0256 */	CANT_MAP_CHARACTER,	/* 854 */
/* U+0257 */	CANT_MAP_CHARACTER,	/* 855 */
/* U+0258 */	CANT_MAP_CHARACTER,	/* 856 */
/* U+0259 */	CANT_MAP_CHARACTER,	/* 857 */
/* U+025A */	CANT_MAP_CHARACTER,	/* 858 */
/* U+025B */	CANT_MAP_CHARACTER,	/* 859 */
/* U+025C */	CANT_MAP_CHARACTER,	/* 860 */
/* U+025D */	CANT_MAP_CHARACTER,	/* 861 */
/* U+025E */	CANT_MAP_CHARACTER,	/* 862 */
/* U+025F */	CANT_MAP_CHARACTER,	/* 863 */
/* U+0260 */	CANT_MAP_CHARACTER,	/* 864 */
/* U+0261 */	CANT_MAP_CHARACTER,	/* 865 */
/* U+0262 */	CANT_MAP_CHARACTER,	/* 866 */
/* U+0263 */	CANT_MAP_CHARACTER,	/* 867 */
/* U+0264 */	CANT_MAP_CHARACTER,	/* 868 */
/* U+0265 */	CANT_MAP_CHARACTER,	/* 869 */
/* U+0266 */	CANT_MAP_CHARACTER,	/* 870 */
/* U+0267 */	CANT_MAP_CHARACTER,	/* 871 */
/* U+0268 */	CANT_MAP_CHARACTER,	/* 872 */
/* U+0269 */	CANT_MAP_CHARACTER,	/* 873 */
/* U+026A */	CANT_MAP_CHARACTER,	/* 874 */
/* U+026B */	CANT_MAP_CHARACTER,	/* 875 */
/* U+026C */	CANT_MAP_CHARACTER,	/* 876 */
/* U+026D */	CANT_MAP_CHARACTER,	/* 877 */
/* U+026E */	CANT_MAP_CHARACTER,	/* 878 */
/* U+026F */	CANT_MAP_CHARACTER,	/* 879 */
/* U+0270 */	CANT_MAP_CHARACTER,	/* 880 */
/* U+0271 */	CANT_MAP_CHARACTER,	/* 881 */
/* U+0272 */	CANT_MAP_CHARACTER,	/* 882 */
/* U+0273 */	CANT_MAP_CHARACTER,	/* 883 */
/* U+0274 */	CANT_MAP_CHARACTER,	/* 884 */
/* U+0275 */	CANT_MAP_CHARACTER,	/* 885 */
/* U+0276 */	CANT_MAP_CHARACTER,	/* 886 */
/* U+0277 */	CANT_MAP_CHARACTER,	/* 887 */
/* U+0278 */	CANT_MAP_CHARACTER,	/* 888 */
/* U+0279 */	CANT_MAP_CHARACTER,	/* 889 */
/* U+027A */	CANT_MAP_CHARACTER,	/* 890 */
/* U+027B */	CANT_MAP_CHARACTER,	/* 891 */
/* U+027C */	CANT_MAP_CHARACTER,	/* 892 */
/* U+027D */	CANT_MAP_CHARACTER,	/* 893 */
/* U+027E */	CANT_MAP_CHARACTER,	/* 894 */
/* U+027F */	CANT_MAP_CHARACTER,	/* 895 */
/* U+0280 */	CANT_MAP_CHARACTER,	/* 896 */
/* U+0281 */	CANT_MAP_CHARACTER,	/* 897 */
/* U+0282 */	CANT_MAP_CHARACTER,	/* 898 */
/* U+0283 */	CANT_MAP_CHARACTER,	/* 899 */
/* U+0284 */	CANT_MAP_CHARACTER,	/* 900 */
/* U+0285 */	CANT_MAP_CHARACTER,	/* 901 */
/* U+0286 */	CANT_MAP_CHARACTER,	/* 902 */
/* U+0287 */	CANT_MAP_CHARACTER,	/* 903 */
/* U+0288 */	CANT_MAP_CHARACTER,	/* 904 */
/* U+0289 */	CANT_MAP_CHARACTER,	/* 905 */
/* U+028A */	CANT_MAP_CHARACTER,	/* 906 */
/* U+028B */	CANT_MAP_CHARACTER,	/* 907 */
/* U+028C */	CANT_MAP_CHARACTER,	/* 908 */
/* U+028D */	CANT_MAP_CHARACTER,	/* 909 */
/* U+028E */	CANT_MAP_CHARACTER,	/* 910 */
/* U+028F */	CANT_MAP_CHARACTER,	/* 911 */
/* U+0290 */	CANT_MAP_CHARACTER,	/* 912 */
/* U+0291 */	CANT_MAP_CHARACTER,	/* 913 */
/* U+0292 */	CANT_MAP_CHARACTER,	/* 914 */
/* U+0293 */	CANT_MAP_CHARACTER,	/* 915 */
/* U+0294 */	CANT_MAP_CHARACTER,	/* 916 */
/* U+0295 */	CANT_MAP_CHARACTER,	/* 917 */
/* U+0296 */	CANT_MAP_CHARACTER,	/* 918 */
/* U+0297 */	CANT_MAP_CHARACTER,	/* 919 */
/* U+0298 */	CANT_MAP_CHARACTER,	/* 920 */
/* U+0299 */	CANT_MAP_CHARACTER,	/* 921 */
/* U+029A */	CANT_MAP_CHARACTER,	/* 922 */
/* U+029B */	CANT_MAP_CHARACTER,	/* 923 */
/* U+029C */	CANT_MAP_CHARACTER,	/* 924 */
/* U+029D */	CANT_MAP_CHARACTER,	/* 925 */
/* U+029E */	CANT_MAP_CHARACTER,	/* 926 */
/* U+029F */	CANT_MAP_CHARACTER,	/* 927 */
/* U+02A0 */	CANT_MAP_CHARACTER,	/* 928 */
/* U+02A1 */	CANT_MAP_CHARACTER,	/* 929 */
/* U+02A2 */	CANT_MAP_CHARACTER,	/* 930 */
/* U+02A3 */	CANT_MAP_CHARACTER,	/* 931 */
/* U+02A4 */	CANT_MAP_CHARACTER,	/* 932 */
/* U+02A5 */	CANT_MAP_CHARACTER,	/* 933 */
/* U+02A6 */	CANT_MAP_CHARACTER,	/* 934 */
/* U+02A7 */	CANT_MAP_CHARACTER,	/* 935 */
/* U+02A8 */	CANT_MAP_CHARACTER,	/* 936 */
/* U+02A9 */	CANT_MAP_CHARACTER,	/* 937 */
/* U+02AA */	CANT_MAP_CHARACTER,	/* 938 */
/* U+02AB */	CANT_MAP_CHARACTER,	/* 939 */
/* U+02AC */	CANT_MAP_CHARACTER,	/* 940 */
/* U+02AD */	CANT_MAP_CHARACTER,	/* 941 */
/* U+02AE */	CANT_MAP_CHARACTER,	/* 942 */
/* U+02AF */	CANT_MAP_CHARACTER,	/* 943 */
/* U+02B0 */	CANT_MAP_CHARACTER,	/* 944 */
/* U+02B1 */	CANT_MAP_CHARACTER,	/* 945 */
/* U+02B2 */	CANT_MAP_CHARACTER,	/* 946 */
/* U+02B3 */	CANT_MAP_CHARACTER,	/* 947 */
/* U+02B4 */	CANT_MAP_CHARACTER,	/* 948 */
/* U+02B5 */	CANT_MAP_CHARACTER,	/* 949 */
/* U+02B6 */	CANT_MAP_CHARACTER,	/* 950 */
/* U+02B7 */	CANT_MAP_CHARACTER,	/* 951 */
/* U+02B8 */	CANT_MAP_CHARACTER,	/* 952 */
/* U+02B9 */	CANT_MAP_CHARACTER,	/* 953 */
/* U+02BA */	CANT_MAP_CHARACTER,	/* 954 */
/* U+02BB */	CANT_MAP_CHARACTER,	/* 955 */
/* U+02BC */	CANT_MAP_CHARACTER,	/* 956 */
/* U+02BD */	CANT_MAP_CHARACTER,	/* 957 */
/* U+02BE */	CANT_MAP_CHARACTER,	/* 958 */
/* U+02BF */	CANT_MAP_CHARACTER,	/* 959 */
/* U+02C0 */	CANT_MAP_CHARACTER,	/* 960 */
/* U+02C1 */	CANT_MAP_CHARACTER,	/* 961 */
/* U+02C2 */	CANT_MAP_CHARACTER,	/* 962 */
/* U+02C3 */	CANT_MAP_CHARACTER,	/* 963 */
/* U+02C4 */	CANT_MAP_CHARACTER,	/* 964 */
/* U+02C5 */	CANT_MAP_CHARACTER,	/* 965 */
/* U+02C6 */	CANT_MAP_CHARACTER,	/* 966 */
/* U+02C7 */	0x8E	/*                                         CARON */,/* 967 */
/* U+02C8 */	CANT_MAP_CHARACTER,	/* 968 */
/* U+02C9 */	CANT_MAP_CHARACTER,	/* 969 */
/* U+02CA */	CANT_MAP_CHARACTER,	/* 970 */
/* U+02CB */	CANT_MAP_CHARACTER,	/* 971 */
/* U+02CC */	CANT_MAP_CHARACTER,	/* 972 */
/* U+02CD */	CANT_MAP_CHARACTER,	/* 973 */
/* U+02CE */	CANT_MAP_CHARACTER,	/* 974 */
/* U+02CF */	CANT_MAP_CHARACTER,	/* 975 */
/* U+02D0 */	CANT_MAP_CHARACTER,	/* 976 */
/* U+02D1 */	CANT_MAP_CHARACTER,	/* 977 */
/* U+02D2 */	CANT_MAP_CHARACTER,	/* 978 */
/* U+02D3 */	CANT_MAP_CHARACTER,	/* 979 */
/* U+02D4 */	CANT_MAP_CHARACTER,	/* 980 */
/* U+02D5 */	CANT_MAP_CHARACTER,	/* 981 */
/* U+02D6 */	CANT_MAP_CHARACTER,	/* 982 */
/* U+02D7 */	CANT_MAP_CHARACTER,	/* 983 */
/* U+02D8 */	CANT_MAP_CHARACTER,	/* 984 */
/* U+02D9 */	0xFF	/*                                     DOT ABOVE */,/* 985 */
/* U+02DA */	CANT_MAP_CHARACTER,	/* 986 */
/* U+02DB */	0x9E	/*                                        OGONEK */,/* 987 */
/* U+02DC */	CANT_MAP_CHARACTER,	/* 988 */
/* U+02DD */	CANT_MAP_CHARACTER,	/* 989 */
/* U+02DE */	CANT_MAP_CHARACTER,	/* 990 */
/* U+02DF */	CANT_MAP_CHARACTER,	/* 991 */
/* U+02E0 */	CANT_MAP_CHARACTER,	/* 992 */
/* U+02E1 */	CANT_MAP_CHARACTER,	/* 993 */
/* U+02E2 */	CANT_MAP_CHARACTER,	/* 994 */
/* U+02E3 */	CANT_MAP_CHARACTER,	/* 995 */
/* U+02E4 */	CANT_MAP_CHARACTER,	/* 996 */
/* U+02E5 */	CANT_MAP_CHARACTER,	/* 997 */
/* U+02E6 */	CANT_MAP_CHARACTER,	/* 998 */
/* U+02E7 */	CANT_MAP_CHARACTER,	/* 999 */
/* U+02E8 */	CANT_MAP_CHARACTER,	/* 1000 */
/* U+02E9 */	CANT_MAP_CHARACTER,	/* 1001 */
/* U+02EA */	CANT_MAP_CHARACTER,	/* 1002 */
/* U+02EB */	CANT_MAP_CHARACTER,	/* 1003 */
/* U+02EC */	CANT_MAP_CHARACTER,	/* 1004 */
/* U+02ED */	CANT_MAP_CHARACTER,	/* 1005 */
/* U+02EE */	CANT_MAP_CHARACTER,	/* 1006 */
/* U+02EF */	CANT_MAP_CHARACTER,	/* 1007 */
/* U+02F0 */	CANT_MAP_CHARACTER,	/* 1008 */
/* U+02F1 */	CANT_MAP_CHARACTER,	/* 1009 */
/* U+02F2 */	CANT_MAP_CHARACTER,	/* 1010 */
/* U+02F3 */	CANT_MAP_CHARACTER,	/* 1011 */
/* U+02F4 */	CANT_MAP_CHARACTER,	/* 1012 */
/* U+02F5 */	CANT_MAP_CHARACTER,	/* 1013 */
/* U+02F6 */	CANT_MAP_CHARACTER,	/* 1014 */
/* U+02F7 */	CANT_MAP_CHARACTER,	/* 1015 */
/* U+02F8 */	CANT_MAP_CHARACTER,	/* 1016 */
/* U+02F9 */	CANT_MAP_CHARACTER,	/* 1017 */
/* U+02FA */	CANT_MAP_CHARACTER,	/* 1018 */
/* U+02FB */	CANT_MAP_CHARACTER,	/* 1019 */
/* U+02FC */	CANT_MAP_CHARACTER,	/* 1020 */
/* U+02FD */	CANT_MAP_CHARACTER,	/* 1021 */
/* U+02FE */	CANT_MAP_CHARACTER,	/* 1022 */
/* U+02FF */	CANT_MAP_CHARACTER,	/* 1023 */
/* U+2000 */	CANT_MAP_CHARACTER,	/* 1024 */
/* U+2001 */	CANT_MAP_CHARACTER,	/* 1025 */
/* U+2002 */	CANT_MAP_CHARACTER,	/* 1026 */
/* U+2003 */	CANT_MAP_CHARACTER,	/* 1027 */
/* U+2004 */	CANT_MAP_CHARACTER,	/* 1028 */
/* U+2005 */	CANT_MAP_CHARACTER,	/* 1029 */
/* U+2006 */	CANT_MAP_CHARACTER,	/* 1030 */
/* U+2007 */	CANT_MAP_CHARACTER,	/* 1031 */
/* U+2008 */	CANT_MAP_CHARACTER,	/* 1032 */
/* U+2009 */	CANT_MAP_CHARACTER,	/* 1033 */
/* U+200A */	CANT_MAP_CHARACTER,	/* 1034 */
/* U+200B */	CANT_MAP_CHARACTER,	/* 1035 */
/* U+200C */	CANT_MAP_CHARACTER,	/* 1036 */
/* U+200D */	CANT_MAP_CHARACTER,	/* 1037 */
/* U+200E */	CANT_MAP_CHARACTER,	/* 1038 */
/* U+200F */	CANT_MAP_CHARACTER,	/* 1039 */
/* U+2010 */	CANT_MAP_CHARACTER,	/* 1040 */
/* U+2011 */	CANT_MAP_CHARACTER,	/* 1041 */
/* U+2012 */	CANT_MAP_CHARACTER,	/* 1042 */
/* U+2013 */	0x96	/*                                       EN DASH */,/* 1043 */
/* U+2014 */	0x97	/*                                       EM DASH */,/* 1044 */
/* U+2015 */	CANT_MAP_CHARACTER,	/* 1045 */
/* U+2016 */	CANT_MAP_CHARACTER,	/* 1046 */
/* U+2017 */	CANT_MAP_CHARACTER,	/* 1047 */
/* U+2018 */	0x91	/*                    LEFT SINGLE QUOTATION MARK */,/* 1048 */
/* U+2019 */	0x92	/*                   RIGHT SINGLE QUOTATION MARK */,/* 1049 */
/* U+201A */	0x82	/*                   SINGLE LOW-9 QUOTATION MARK */,/* 1050 */
/* U+201B */	CANT_MAP_CHARACTER,	/* 1051 */
/* U+201C */	0x93	/*                    LEFT DOUBLE QUOTATION MARK */,/* 1052 */
/* U+201D */	0x94	/*                   RIGHT DOUBLE QUOTATION MARK */,/* 1053 */
/* U+201E */	0x84	/*                   DOUBLE LOW-9 QUOTATION MARK */,/* 1054 */
/* U+201F */	CANT_MAP_CHARACTER,	/* 1055 */
/* U+2020 */	0x86	/*                                        DAGGER */,/* 1056 */
/* U+2021 */	0x87	/*                                 DOUBLE DAGGER */,/* 1057 */
/* U+2022 */	0x95	/*                                        BULLET */,/* 1058 */
/* U+2023 */	CANT_MAP_CHARACTER,	/* 1059 */
/* U+2024 */	CANT_MAP_CHARACTER,	/* 1060 */
/* U+2025 */	CANT_MAP_CHARACTER,	/* 1061 */
/* U+2026 */	0x85	/*                           HORIZONTAL ELLIPSIS */,/* 1062 */
/* U+2027 */	CANT_MAP_CHARACTER,	/* 1063 */
/* U+2028 */	CANT_MAP_CHARACTER,	/* 1064 */
/* U+2029 */	CANT_MAP_CHARACTER,	/* 1065 */
/* U+202A */	CANT_MAP_CHARACTER,	/* 1066 */
/* U+202B */	CANT_MAP_CHARACTER,	/* 1067 */
/* U+202C */	CANT_MAP_CHARACTER,	/* 1068 */
/* U+202D */	CANT_MAP_CHARACTER,	/* 1069 */
/* U+202E */	CANT_MAP_CHARACTER,	/* 1070 */
/* U+202F */	CANT_MAP_CHARACTER,	/* 1071 */
/* U+2030 */	0x89	/*                                PER MILLE SIGN */,/* 1072 */
/* U+2031 */	CANT_MAP_CHARACTER,	/* 1073 */
/* U+2032 */	CANT_MAP_CHARACTER,	/* 1074 */
/* U+2033 */	CANT_MAP_CHARACTER,	/* 1075 */
/* U+2034 */	CANT_MAP_CHARACTER,	/* 1076 */
/* U+2035 */	CANT_MAP_CHARACTER,	/* 1077 */
/* U+2036 */	CANT_MAP_CHARACTER,	/* 1078 */
/* U+2037 */	CANT_MAP_CHARACTER,	/* 1079 */
/* U+2038 */	CANT_MAP_CHARACTER,	/* 1080 */
/* U+2039 */	0x8B	/*     SINGLE LEFT-POINTING ANGLE QUOTATION MARK */,/* 1081 */
/* U+203A */	0x9B	/*    SINGLE RIGHT-POINTING ANGLE QUOTATION MARK */,/* 1082 */
/* U+203B */	CANT_MAP_CHARACTER,	/* 1083 */
/* U+203C */	CANT_MAP_CHARACTER,	/* 1084 */
/* U+203D */	CANT_MAP_CHARACTER,	/* 1085 */
/* U+203E */	CANT_MAP_CHARACTER,	/* 1086 */
/* U+203F */	CANT_MAP_CHARACTER,	/* 1087 */
/* U+2040 */	CANT_MAP_CHARACTER,	/* 1088 */
/* U+2041 */	CANT_MAP_CHARACTER,	/* 1089 */
/* U+2042 */	CANT_MAP_CHARACTER,	/* 1090 */
/* U+2043 */	CANT_MAP_CHARACTER,	/* 1091 */
/* U+2044 */	CANT_MAP_CHARACTER,	/* 1092 */
/* U+2045 */	CANT_MAP_CHARACTER,	/* 1093 */
/* U+2046 */	CANT_MAP_CHARACTER,	/* 1094 */
/* U+2047 */	CANT_MAP_CHARACTER,	/* 1095 */
/* U+2048 */	CANT_MAP_CHARACTER,	/* 1096 */
/* U+2049 */	CANT_MAP_CHARACTER,	/* 1097 */
/* U+204A */	CANT_MAP_CHARACTER,	/* 1098 */
/* U+204B */	CANT_MAP_CHARACTER,	/* 1099 */
/* U+204C */	CANT_MAP_CHARACTER,	/* 1100 */
/* U+204D */	CANT_MAP_CHARACTER,	/* 1101 */
/* U+204E */	CANT_MAP_CHARACTER,	/* 1102 */
/* U+204F */	CANT_MAP_CHARACTER,	/* 1103 */
/* U+2050 */	CANT_MAP_CHARACTER,	/* 1104 */
/* U+2051 */	CANT_MAP_CHARACTER,	/* 1105 */
/* U+2052 */	CANT_MAP_CHARACTER,	/* 1106 */
/* U+2053 */	CANT_MAP_CHARACTER,	/* 1107 */
/* U+2054 */	CANT_MAP_CHARACTER,	/* 1108 */
/* U+2055 */	CANT_MAP_CHARACTER,	/* 1109 */
/* U+2056 */	CANT_MAP_CHARACTER,	/* 1110 */
/* U+2057 */	CANT_MAP_CHARACTER,	/* 1111 */
/* U+2058 */	CANT_MAP_CHARACTER,	/* 1112 */
/* U+2059 */	CANT_MAP_CHARACTER,	/* 1113 */
/* U+205A */	CANT_MAP_CHARACTER,	/* 1114 */
/* U+205B */	CANT_MAP_CHARACTER,	/* 1115 */
/* U+205C */	CANT_MAP_CHARACTER,	/* 1116 */
/* U+205D */	CANT_MAP_CHARACTER,	/* 1117 */
/* U+205E */	CANT_MAP_CHARACTER,	/* 1118 */
/* U+205F */	CANT_MAP_CHARACTER,	/* 1119 */
/* U+2060 */	CANT_MAP_CHARACTER,	/* 1120 */
/* U+2061 */	CANT_MAP_CHARACTER,	/* 1121 */
/* U+2062 */	CANT_MAP_CHARACTER,	/* 1122 */
/* U+2063 */	CANT_MAP_CHARACTER,	/* 1123 */
/* U+2064 */	CANT_MAP_CHARACTER,	/* 1124 */
/* U+2065 */	CANT_MAP_CHARACTER,	/* 1125 */
/* U+2066 */	CANT_MAP_CHARACTER,	/* 1126 */
/* U+2067 */	CANT_MAP_CHARACTER,	/* 1127 */
/* U+2068 */	CANT_MAP_CHARACTER,	/* 1128 */
/* U+2069 */	CANT_MAP_CHARACTER,	/* 1129 */
/* U+206A */	CANT_MAP_CHARACTER,	/* 1130 */
/* U+206B */	CANT_MAP_CHARACTER,	/* 1131 */
/* U+206C */	CANT_MAP_CHARACTER,	/* 1132 */
/* U+206D */	CANT_MAP_CHARACTER,	/* 1133 */
/* U+206E */	CANT_MAP_CHARACTER,	/* 1134 */
/* U+206F */	CANT_MAP_CHARACTER,	/* 1135 */
/* U+2070 */	CANT_MAP_CHARACTER,	/* 1136 */
/* U+2071 */	CANT_MAP_CHARACTER,	/* 1137 */
/* U+2072 */	CANT_MAP_CHARACTER,	/* 1138 */
/* U+2073 */	CANT_MAP_CHARACTER,	/* 1139 */
/* U+2074 */	CANT_MAP_CHARACTER,	/* 1140 */
/* U+2075 */	CANT_MAP_CHARACTER,	/* 1141 */
/* U+2076 */	CANT_MAP_CHARACTER,	/* 1142 */
/* U+2077 */	CANT_MAP_CHARACTER,	/* 1143 */
/* U+2078 */	CANT_MAP_CHARACTER,	/* 1144 */
/* U+2079 */	CANT_MAP_CHARACTER,	/* 1145 */
/* U+207A */	CANT_MAP_CHARACTER,	/* 1146 */
/* U+207B */	CANT_MAP_CHARACTER,	/* 1147 */
/* U+207C */	CANT_MAP_CHARACTER,	/* 1148 */
/* U+207D */	CANT_MAP_CHARACTER,	/* 1149 */
/* U+207E */	CANT_MAP_CHARACTER,	/* 1150 */
/* U+207F */	CANT_MAP_CHARACTER,	/* 1151 */
/* U+2080 */	CANT_MAP_CHARACTER,	/* 1152 */
/* U+2081 */	CANT_MAP_CHARACTER,	/* 1153 */
/* U+2082 */	CANT_MAP_CHARACTER,	/* 1154 */
/* U+2083 */	CANT_MAP_CHARACTER,	/* 1155 */
/* U+2084 */	CANT_MAP_CHARACTER,	/* 1156 */
/* U+2085 */	CANT_MAP_CHARACTER,	/* 1157 */
/* U+2086 */	CANT_MAP_CHARACTER,	/* 1158 */
/* U+2087 */	CANT_MAP_CHARACTER,	/* 1159 */
/* U+2088 */	CANT_MAP_CHARACTER,	/* 1160 */
/* U+2089 */	CANT_MAP_CHARACTER,	/* 1161 */
/* U+208A */	CANT_MAP_CHARACTER,	/* 1162 */
/* U+208B */	CANT_MAP_CHARACTER,	/* 1163 */
/* U+208C */	CANT_MAP_CHARACTER,	/* 1164 */
/* U+208D */	CANT_MAP_CHARACTER,	/* 1165 */
/* U+208E */	CANT_MAP_CHARACTER,	/* 1166 */
/* U+208F */	CANT_MAP_CHARACTER,	/* 1167 */
/* U+2090 */	CANT_MAP_CHARACTER,	/* 1168 */
/* U+2091 */	CANT_MAP_CHARACTER,	/* 1169 */
/* U+2092 */	CANT_MAP_CHARACTER,	/* 1170 */
/* U+2093 */	CANT_MAP_CHARACTER,	/* 1171 */
/* U+2094 */	CANT_MAP_CHARACTER,	/* 1172 */
/* U+2095 */	CANT_MAP_CHARACTER,	/* 1173 */
/* U+2096 */	CANT_MAP_CHARACTER,	/* 1174 */
/* U+2097 */	CANT_MAP_CHARACTER,	/* 1175 */
/* U+2098 */	CANT_MAP_CHARACTER,	/* 1176 */
/* U+2099 */	CANT_MAP_CHARACTER,	/* 1177 */
/* U+209A */	CANT_MAP_CHARACTER,	/* 1178 */
/* U+209B */	CANT_MAP_CHARACTER,	/* 1179 */
/* U+209C */	CANT_MAP_CHARACTER,	/* 1180 */
/* U+209D */	CANT_MAP_CHARACTER,	/* 1181 */
/* U+209E */	CANT_MAP_CHARACTER,	/* 1182 */
/* U+209F */	CANT_MAP_CHARACTER,	/* 1183 */
/* U+20A0 */	CANT_MAP_CHARACTER,	/* 1184 */
/* U+20A1 */	CANT_MAP_CHARACTER,	/* 1185 */
/* U+20A2 */	CANT_MAP_CHARACTER,	/* 1186 */
/* U+20A3 */	CANT_MAP_CHARACTER,	/* 1187 */
/* U+20A4 */	CANT_MAP_CHARACTER,	/* 1188 */
/* U+20A5 */	CANT_MAP_CHARACTER,	/* 1189 */
/* U+20A6 */	CANT_MAP_CHARACTER,	/* 1190 */
/* U+20A7 */	CANT_MAP_CHARACTER,	/* 1191 */
/* U+20A8 */	CANT_MAP_CHARACTER,	/* 1192 */
/* U+20A9 */	CANT_MAP_CHARACTER,	/* 1193 */
/* U+20AA */	CANT_MAP_CHARACTER,	/* 1194 */
/* U+20AB */	CANT_MAP_CHARACTER,	/* 1195 */
/* U+20AC */	0x80	/*                                     EURO SIGN */,/* 1196 */
/* U+20AD */	CANT_MAP_CHARACTER,	/* 1197 */
/* U+20AE */	CANT_MAP_CHARACTER,	/* 1198 */
/* U+20AF */	CANT_MAP_CHARACTER,	/* 1199 */
/* U+20B0 */	CANT_MAP_CHARACTER,	/* 1200 */
/* U+20B1 */	CANT_MAP_CHARACTER,	/* 1201 */
/* U+20B2 */	CANT_MAP_CHARACTER,	/* 1202 */
/* U+20B3 */	CANT_MAP_CHARACTER,	/* 1203 */
/* U+20B4 */	CANT_MAP_CHARACTER,	/* 1204 */
/* U+20B5 */	CANT_MAP_CHARACTER,	/* 1205 */
/* U+20B6 */	CANT_MAP_CHARACTER,	/* 1206 */
/* U+20B7 */	CANT_MAP_CHARACTER,	/* 1207 */
/* U+20B8 */	CANT_MAP_CHARACTER,	/* 1208 */
/* U+20B9 */	CANT_MAP_CHARACTER,	/* 1209 */
/* U+20BA */	CANT_MAP_CHARACTER,	/* 1210 */
/* U+20BB */	CANT_MAP_CHARACTER,	/* 1211 */
/* U+20BC */	CANT_MAP_CHARACTER,	/* 1212 */
/* U+20BD */	CANT_MAP_CHARACTER,	/* 1213 */
/* U+20BE */	CANT_MAP_CHARACTER,	/* 1214 */
/* U+20BF */	CANT_MAP_CHARACTER,	/* 1215 */
/* U+20C0 */	CANT_MAP_CHARACTER,	/* 1216 */
/* U+20C1 */	CANT_MAP_CHARACTER,	/* 1217 */
/* U+20C2 */	CANT_MAP_CHARACTER,	/* 1218 */
/* U+20C3 */	CANT_MAP_CHARACTER,	/* 1219 */
/* U+20C4 */	CANT_MAP_CHARACTER,	/* 1220 */
/* U+20C5 */	CANT_MAP_CHARACTER,	/* 1221 */
/* U+20C6 */	CANT_MAP_CHARACTER,	/* 1222 */
/* U+20C7 */	CANT_MAP_CHARACTER,	/* 1223 */
/* U+20C8 */	CANT_MAP_CHARACTER,	/* 1224 */
/* U+20C9 */	CANT_MAP_CHARACTER,	/* 1225 */
/* U+20CA */	CANT_MAP_CHARACTER,	/* 1226 */
/* U+20CB */	CANT_MAP_CHARACTER,	/* 1227 */
/* U+20CC */	CANT_MAP_CHARACTER,	/* 1228 */
/* U+20CD */	CANT_MAP_CHARACTER,	/* 1229 */
/* U+20CE */	CANT_MAP_CHARACTER,	/* 1230 */
/* U+20CF */	CANT_MAP_CHARACTER,	/* 1231 */
/* U+20D0 */	CANT_MAP_CHARACTER,	/* 1232 */
/* U+20D1 */	CANT_MAP_CHARACTER,	/* 1233 */
/* U+20D2 */	CANT_MAP_CHARACTER,	/* 1234 */
/* U+20D3 */	CANT_MAP_CHARACTER,	/* 1235 */
/* U+20D4 */	CANT_MAP_CHARACTER,	/* 1236 */
/* U+20D5 */	CANT_MAP_CHARACTER,	/* 1237 */
/* U+20D6 */	CANT_MAP_CHARACTER,	/* 1238 */
/* U+20D7 */	CANT_MAP_CHARACTER,	/* 1239 */
/* U+20D8 */	CANT_MAP_CHARACTER,	/* 1240 */
/* U+20D9 */	CANT_MAP_CHARACTER,	/* 1241 */
/* U+20DA */	CANT_MAP_CHARACTER,	/* 1242 */
/* U+20DB */	CANT_MAP_CHARACTER,	/* 1243 */
/* U+20DC */	CANT_MAP_CHARACTER,	/* 1244 */
/* U+20DD */	CANT_MAP_CHARACTER,	/* 1245 */
/* U+20DE */	CANT_MAP_CHARACTER,	/* 1246 */
/* U+20DF */	CANT_MAP_CHARACTER,	/* 1247 */
/* U+20E0 */	CANT_MAP_CHARACTER,	/* 1248 */
/* U+20E1 */	CANT_MAP_CHARACTER,	/* 1249 */
/* U+20E2 */	CANT_MAP_CHARACTER,	/* 1250 */
/* U+20E3 */	CANT_MAP_CHARACTER,	/* 1251 */
/* U+20E4 */	CANT_MAP_CHARACTER,	/* 1252 */
/* U+20E5 */	CANT_MAP_CHARACTER,	/* 1253 */
/* U+20E6 */	CANT_MAP_CHARACTER,	/* 1254 */
/* U+20E7 */	CANT_MAP_CHARACTER,	/* 1255 */
/* U+20E8 */	CANT_MAP_CHARACTER,	/* 1256 */
/* U+20E9 */	CANT_MAP_CHARACTER,	/* 1257 */
/* U+20EA */	CANT_MAP_CHARACTER,	/* 1258 */
/* U+20EB */	CANT_MAP_CHARACTER,	/* 1259 */
/* U+20EC */	CANT_MAP_CHARACTER,	/* 1260 */
/* U+20ED */	CANT_MAP_CHARACTER,	/* 1261 */
/* U+20EE */	CANT_MAP_CHARACTER,	/* 1262 */
/* U+20EF */	CANT_MAP_CHARACTER,	/* 1263 */
/* U+20F0 */	CANT_MAP_CHARACTER,	/* 1264 */
/* U+20F1 */	CANT_MAP_CHARACTER,	/* 1265 */
/* U+20F2 */	CANT_MAP_CHARACTER,	/* 1266 */
/* U+20F3 */	CANT_MAP_CHARACTER,	/* 1267 */
/* U+20F4 */	CANT_MAP_CHARACTER,	/* 1268 */
/* U+20F5 */	CANT_MAP_CHARACTER,	/* 1269 */
/* U+20F6 */	CANT_MAP_CHARACTER,	/* 1270 */
/* U+20F7 */	CANT_MAP_CHARACTER,	/* 1271 */
/* U+20F8 */	CANT_MAP_CHARACTER,	/* 1272 */
/* U+20F9 */	CANT_MAP_CHARACTER,	/* 1273 */
/* U+20FA */	CANT_MAP_CHARACTER,	/* 1274 */
/* U+20FB */	CANT_MAP_CHARACTER,	/* 1275 */
/* U+20FC */	CANT_MAP_CHARACTER,	/* 1276 */
/* U+20FD */	CANT_MAP_CHARACTER,	/* 1277 */
/* U+20FE */	CANT_MAP_CHARACTER,	/* 1278 */
/* U+20FF */	CANT_MAP_CHARACTER,	/* 1279 */
/* U+2100 */	CANT_MAP_CHARACTER,	/* 1280 */
/* U+2101 */	CANT_MAP_CHARACTER,	/* 1281 */
/* U+2102 */	CANT_MAP_CHARACTER,	/* 1282 */
/* U+2103 */	CANT_MAP_CHARACTER,	/* 1283 */
/* U+2104 */	CANT_MAP_CHARACTER,	/* 1284 */
/* U+2105 */	CANT_MAP_CHARACTER,	/* 1285 */
/* U+2106 */	CANT_MAP_CHARACTER,	/* 1286 */
/* U+2107 */	CANT_MAP_CHARACTER,	/* 1287 */
/* U+2108 */	CANT_MAP_CHARACTER,	/* 1288 */
/* U+2109 */	CANT_MAP_CHARACTER,	/* 1289 */
/* U+210A */	CANT_MAP_CHARACTER,	/* 1290 */
/* U+210B */	CANT_MAP_CHARACTER,	/* 1291 */
/* U+210C */	CANT_MAP_CHARACTER,	/* 1292 */
/* U+210D */	CANT_MAP_CHARACTER,	/* 1293 */
/* U+210E */	CANT_MAP_CHARACTER,	/* 1294 */
/* U+210F */	CANT_MAP_CHARACTER,	/* 1295 */
/* U+2110 */	CANT_MAP_CHARACTER,	/* 1296 */
/* U+2111 */	CANT_MAP_CHARACTER,	/* 1297 */
/* U+2112 */	CANT_MAP_CHARACTER,	/* 1298 */
/* U+2113 */	CANT_MAP_CHARACTER,	/* 1299 */
/* U+2114 */	CANT_MAP_CHARACTER,	/* 1300 */
/* U+2115 */	CANT_MAP_CHARACTER,	/* 1301 */
/* U+2116 */	CANT_MAP_CHARACTER,	/* 1302 */
/* U+2117 */	CANT_MAP_CHARACTER,	/* 1303 */
/* U+2118 */	CANT_MAP_CHARACTER,	/* 1304 */
/* U+2119 */	CANT_MAP_CHARACTER,	/* 1305 */
/* U+211A */	CANT_MAP_CHARACTER,	/* 1306 */
/* U+211B */	CANT_MAP_CHARACTER,	/* 1307 */
/* U+211C */	CANT_MAP_CHARACTER,	/* 1308 */
/* U+211D */	CANT_MAP_CHARACTER,	/* 1309 */
/* U+211E */	CANT_MAP_CHARACTER,	/* 1310 */
/* U+211F */	CANT_MAP_CHARACTER,	/* 1311 */
/* U+2120 */	CANT_MAP_CHARACTER,	/* 1312 */
/* U+2121 */	CANT_MAP_CHARACTER,	/* 1313 */
/* U+2122 */	0x99	/*                               TRADE MARK SIGN */,/* 1314 */
/* U+2123 */	CANT_MAP_CHARACTER,	/* 1315 */
/* U+2124 */	CANT_MAP_CHARACTER,	/* 1316 */
/* U+2125 */	CANT_MAP_CHARACTER,	/* 1317 */
/* U+2126 */	CANT_MAP_CHARACTER,	/* 1318 */
/* U+2127 */	CANT_MAP_CHARACTER,	/* 1319 */
/* U+2128 */	CANT_MAP_CHARACTER,	/* 1320 */
/* U+2129 */	CANT_MAP_CHARACTER,	/* 1321 */
/* U+212A */	CANT_MAP_CHARACTER,	/* 1322 */
/* U+212B */	CANT_MAP_CHARACTER,	/* 1323 */
/* U+212C */	CANT_MAP_CHARACTER,	/* 1324 */
/* U+212D */	CANT_MAP_CHARACTER,	/* 1325 */
/* U+212E */	CANT_MAP_CHARACTER,	/* 1326 */
/* U+212F */	CANT_MAP_CHARACTER,	/* 1327 */
/* U+2130 */	CANT_MAP_CHARACTER,	/* 1328 */
/* U+2131 */	CANT_MAP_CHARACTER,	/* 1329 */
/* U+2132 */	CANT_MAP_CHARACTER,	/* 1330 */
/* U+2133 */	CANT_MAP_CHARACTER,	/* 1331 */
/* U+2134 */	CANT_MAP_CHARACTER,	/* 1332 */
/* U+2135 */	CANT_MAP_CHARACTER,	/* 1333 */
/* U+2136 */	CANT_MAP_CHARACTER,	/* 1334 */
/* U+2137 */	CANT_MAP_CHARACTER,	/* 1335 */
/* U+2138 */	CANT_MAP_CHARACTER,	/* 1336 */
/* U+2139 */	CANT_MAP_CHARACTER,	/* 1337 */
/* U+213A */	CANT_MAP_CHARACTER,	/* 1338 */
/* U+213B */	CANT_MAP_CHARACTER,	/* 1339 */
/* U+213C */	CANT_MAP_CHARACTER,	/* 1340 */
/* U+213D */	CANT_MAP_CHARACTER,	/* 1341 */
/* U+213E */	CANT_MAP_CHARACTER,	/* 1342 */
/* U+213F */	CANT_MAP_CHARACTER,	/* 1343 */
/* U+2140 */	CANT_MAP_CHARACTER,	/* 1344 */
/* U+2141 */	CANT_MAP_CHARACTER,	/* 1345 */
/* U+2142 */	CANT_MAP_CHARACTER,	/* 1346 */
/* U+2143 */	CANT_MAP_CHARACTER,	/* 1347 */
/* U+2144 */	CANT_MAP_CHARACTER,	/* 1348 */
/* U+2145 */	CANT_MAP_CHARACTER,	/* 1349 */
/* U+2146 */	CANT_MAP_CHARACTER,	/* 1350 */
/* U+2147 */	CANT_MAP_CHARACTER,	/* 1351 */
/* U+2148 */	CANT_MAP_CHARACTER,	/* 1352 */
/* U+2149 */	CANT_MAP_CHARACTER,	/* 1353 */
/* U+214A */	CANT_MAP_CHARACTER,	/* 1354 */
/* U+214B */	CANT_MAP_CHARACTER,	/* 1355 */
/* U+214C */	CANT_MAP_CHARACTER,	/* 1356 */
/* U+214D */	CANT_MAP_CHARACTER,	/* 1357 */
/* U+214E */	CANT_MAP_CHARACTER,	/* 1358 */
/* U+214F */	CANT_MAP_CHARACTER,	/* 1359 */
/* U+2150 */	CANT_MAP_CHARACTER,	/* 1360 */
/* U+2151 */	CANT_MAP_CHARACTER,	/* 1361 */
/* U+2152 */	CANT_MAP_CHARACTER,	/* 1362 */
/* U+2153 */	CANT_MAP_CHARACTER,	/* 1363 */
/* U+2154 */	CANT_MAP_CHARACTER,	/* 1364 */
/* U+2155 */	CANT_MAP_CHARACTER,	/* 1365 */
/* U+2156 */	CANT_MAP_CHARACTER,	/* 1366 */
/* U+2157 */	CANT_MAP_CHARACTER,	/* 1367 */
/* U+2158 */	CANT_MAP_CHARACTER,	/* 1368 */
/* U+2159 */	CANT_MAP_CHARACTER,	/* 1369 */
/* U+215A */	CANT_MAP_CHARACTER,	/* 1370 */
/* U+215B */	CANT_MAP_CHARACTER,	/* 1371 */
/* U+215C */	CANT_MAP_CHARACTER,	/* 1372 */
/* U+215D */	CANT_MAP_CHARACTER,	/* 1373 */
/* U+215E */	CANT_MAP_CHARACTER,	/* 1374 */
/* U+215F */	CANT_MAP_CHARACTER,	/* 1375 */
/* U+2160 */	CANT_MAP_CHARACTER,	/* 1376 */
/* U+2161 */	CANT_MAP_CHARACTER,	/* 1377 */
/* U+2162 */	CANT_MAP_CHARACTER,	/* 1378 */
/* U+2163 */	CANT_MAP_CHARACTER,	/* 1379 */
/* U+2164 */	CANT_MAP_CHARACTER,	/* 1380 */
/* U+2165 */	CANT_MAP_CHARACTER,	/* 1381 */
/* U+2166 */	CANT_MAP_CHARACTER,	/* 1382 */
/* U+2167 */	CANT_MAP_CHARACTER,	/* 1383 */
/* U+2168 */	CANT_MAP_CHARACTER,	/* 1384 */
/* U+2169 */	CANT_MAP_CHARACTER,	/* 1385 */
/* U+216A */	CANT_MAP_CHARACTER,	/* 1386 */
/* U+216B */	CANT_MAP_CHARACTER,	/* 1387 */
/* U+216C */	CANT_MAP_CHARACTER,	/* 1388 */
/* U+216D */	CANT_MAP_CHARACTER,	/* 1389 */
/* U+216E */	CANT_MAP_CHARACTER,	/* 1390 */
/* U+216F */	CANT_MAP_CHARACTER,	/* 1391 */
/* U+2170 */	CANT_MAP_CHARACTER,	/* 1392 */
/* U+2171 */	CANT_MAP_CHARACTER,	/* 1393 */
/* U+2172 */	CANT_MAP_CHARACTER,	/* 1394 */
/* U+2173 */	CANT_MAP_CHARACTER,	/* 1395 */
/* U+2174 */	CANT_MAP_CHARACTER,	/* 1396 */
/* U+2175 */	CANT_MAP_CHARACTER,	/* 1397 */
/* U+2176 */	CANT_MAP_CHARACTER,	/* 1398 */
/* U+2177 */	CANT_MAP_CHARACTER,	/* 1399 */
/* U+2178 */	CANT_MAP_CHARACTER,	/* 1400 */
/* U+2179 */	CANT_MAP_CHARACTER,	/* 1401 */
/* U+217A */	CANT_MAP_CHARACTER,	/* 1402 */
/* U+217B */	CANT_MAP_CHARACTER,	/* 1403 */
/* U+217C */	CANT_MAP_CHARACTER,	/* 1404 */
/* U+217D */	CANT_MAP_CHARACTER,	/* 1405 */
/* U+217E */	CANT_MAP_CHARACTER,	/* 1406 */
/* U+217F */	CANT_MAP_CHARACTER,	/* 1407 */
/* U+2180 */	CANT_MAP_CHARACTER,	/* 1408 */
/* U+2181 */	CANT_MAP_CHARACTER,	/* 1409 */
/* U+2182 */	CANT_MAP_CHARACTER,	/* 1410 */
/* U+2183 */	CANT_MAP_CHARACTER,	/* 1411 */
/* U+2184 */	CANT_MAP_CHARACTER,	/* 1412 */
/* U+2185 */	CANT_MAP_CHARACTER,	/* 1413 */
/* U+2186 */	CANT_MAP_CHARACTER,	/* 1414 */
/* U+2187 */	CANT_MAP_CHARACTER,	/* 1415 */
/* U+2188 */	CANT_MAP_CHARACTER,	/* 1416 */
/* U+2189 */	CANT_MAP_CHARACTER,	/* 1417 */
/* U+218A */	CANT_MAP_CHARACTER,	/* 1418 */
/* U+218B */	CANT_MAP_CHARACTER,	/* 1419 */
/* U+218C */	CANT_MAP_CHARACTER,	/* 1420 */
/* U+218D */	CANT_MAP_CHARACTER,	/* 1421 */
/* U+218E */	CANT_MAP_CHARACTER,	/* 1422 */
/* U+218F */	CANT_MAP_CHARACTER,	/* 1423 */
/* U+2190 */	CANT_MAP_CHARACTER,	/* 1424 */
/* U+2191 */	CANT_MAP_CHARACTER,	/* 1425 */
/* U+2192 */	CANT_MAP_CHARACTER,	/* 1426 */
/* U+2193 */	CANT_MAP_CHARACTER,	/* 1427 */
/* U+2194 */	CANT_MAP_CHARACTER,	/* 1428 */
/* U+2195 */	CANT_MAP_CHARACTER,	/* 1429 */
/* U+2196 */	CANT_MAP_CHARACTER,	/* 1430 */
/* U+2197 */	CANT_MAP_CHARACTER,	/* 1431 */
/* U+2198 */	CANT_MAP_CHARACTER,	/* 1432 */
/* U+2199 */	CANT_MAP_CHARACTER,	/* 1433 */
/* U+219A */	CANT_MAP_CHARACTER,	/* 1434 */
/* U+219B */	CANT_MAP_CHARACTER,	/* 1435 */
/* U+219C */	CANT_MAP_CHARACTER,	/* 1436 */
/* U+219D */	CANT_MAP_CHARACTER,	/* 1437 */
/* U+219E */	CANT_MAP_CHARACTER,	/* 1438 */
/* U+219F */	CANT_MAP_CHARACTER,	/* 1439 */
/* U+21A0 */	CANT_MAP_CHARACTER,	/* 1440 */
/* U+21A1 */	CANT_MAP_CHARACTER,	/* 1441 */
/* U+21A2 */	CANT_MAP_CHARACTER,	/* 1442 */
/* U+21A3 */	CANT_MAP_CHARACTER,	/* 1443 */
/* U+21A4 */	CANT_MAP_CHARACTER,	/* 1444 */
/* U+21A5 */	CANT_MAP_CHARACTER,	/* 1445 */
/* U+21A6 */	CANT_MAP_CHARACTER,	/* 1446 */
/* U+21A7 */	CANT_MAP_CHARACTER,	/* 1447 */
/* U+21A8 */	CANT_MAP_CHARACTER,	/* 1448 */
/* U+21A9 */	CANT_MAP_CHARACTER,	/* 1449 */
/* U+21AA */	CANT_MAP_CHARACTER,	/* 1450 */
/* U+21AB */	CANT_MAP_CHARACTER,	/* 1451 */
/* U+21AC */	CANT_MAP_CHARACTER,	/* 1452 */
/* U+21AD */	CANT_MAP_CHARACTER,	/* 1453 */
/* U+21AE */	CANT_MAP_CHARACTER,	/* 1454 */
/* U+21AF */	CANT_MAP_CHARACTER,	/* 1455 */
/* U+21B0 */	CANT_MAP_CHARACTER,	/* 1456 */
/* U+21B1 */	CANT_MAP_CHARACTER,	/* 1457 */
/* U+21B2 */	CANT_MAP_CHARACTER,	/* 1458 */
/* U+21B3 */	CANT_MAP_CHARACTER,	/* 1459 */
/* U+21B4 */	CANT_MAP_CHARACTER,	/* 1460 */
/* U+21B5 */	CANT_MAP_CHARACTER,	/* 1461 */
/* U+21B6 */	CANT_MAP_CHARACTER,	/* 1462 */
/* U+21B7 */	CANT_MAP_CHARACTER,	/* 1463 */
/* U+21B8 */	CANT_MAP_CHARACTER,	/* 1464 */
/* U+21B9 */	CANT_MAP_CHARACTER,	/* 1465 */
/* U+21BA */	CANT_MAP_CHARACTER,	/* 1466 */
/* U+21BB */	CANT_MAP_CHARACTER,	/* 1467 */
/* U+21BC */	CANT_MAP_CHARACTER,	/* 1468 */
/* U+21BD */	CANT_MAP_CHARACTER,	/* 1469 */
/* U+21BE */	CANT_MAP_CHARACTER,	/* 1470 */
/* U+21BF */	CANT_MAP_CHARACTER,	/* 1471 */
/* U+21C0 */	CANT_MAP_CHARACTER,	/* 1472 */
/* U+21C1 */	CANT_MAP_CHARACTER,	/* 1473 */
/* U+21C2 */	CANT_MAP_CHARACTER,	/* 1474 */
/* U+21C3 */	CANT_MAP_CHARACTER,	/* 1475 */
/* U+21C4 */	CANT_MAP_CHARACTER,	/* 1476 */
/* U+21C5 */	CANT_MAP_CHARACTER,	/* 1477 */
/* U+21C6 */	CANT_MAP_CHARACTER,	/* 1478 */
/* U+21C7 */	CANT_MAP_CHARACTER,	/* 1479 */
/* U+21C8 */	CANT_MAP_CHARACTER,	/* 1480 */
/* U+21C9 */	CANT_MAP_CHARACTER,	/* 1481 */
/* U+21CA */	CANT_MAP_CHARACTER,	/* 1482 */
/* U+21CB */	CANT_MAP_CHARACTER,	/* 1483 */
/* U+21CC */	CANT_MAP_CHARACTER,	/* 1484 */
/* U+21CD */	CANT_MAP_CHARACTER,	/* 1485 */
/* U+21CE */	CANT_MAP_CHARACTER,	/* 1486 */
/* U+21CF */	CANT_MAP_CHARACTER,	/* 1487 */
/* U+21D0 */	CANT_MAP_CHARACTER,	/* 1488 */
/* U+21D1 */	CANT_MAP_CHARACTER,	/* 1489 */
/* U+21D2 */	CANT_MAP_CHARACTER,	/* 1490 */
/* U+21D3 */	CANT_MAP_CHARACTER,	/* 1491 */
/* U+21D4 */	CANT_MAP_CHARACTER,	/* 1492 */
/* U+21D5 */	CANT_MAP_CHARACTER,	/* 1493 */
/* U+21D6 */	CANT_MAP_CHARACTER,	/* 1494 */
/* U+21D7 */	CANT_MAP_CHARACTER,	/* 1495 */
/* U+21D8 */	CANT_MAP_CHARACTER,	/* 1496 */
/* U+21D9 */	CANT_MAP_CHARACTER,	/* 1497 */
/* U+21DA */	CANT_MAP_CHARACTER,	/* 1498 */
/* U+21DB */	CANT_MAP_CHARACTER,	/* 1499 */
/* U+21DC */	CANT_MAP_CHARACTER,	/* 1500 */
/* U+21DD */	CANT_MAP_CHARACTER,	/* 1501 */
/* U+21DE */	CANT_MAP_CHARACTER,	/* 1502 */
/* U+21DF */	CANT_MAP_CHARACTER,	/* 1503 */
/* U+21E0 */	CANT_MAP_CHARACTER,	/* 1504 */
/* U+21E1 */	CANT_MAP_CHARACTER,	/* 1505 */
/* U+21E2 */	CANT_MAP_CHARACTER,	/* 1506 */
/* U+21E3 */	CANT_MAP_CHARACTER,	/* 1507 */
/* U+21E4 */	CANT_MAP_CHARACTER,	/* 1508 */
/* U+21E5 */	CANT_MAP_CHARACTER,	/* 1509 */
/* U+21E6 */	CANT_MAP_CHARACTER,	/* 1510 */
/* U+21E7 */	CANT_MAP_CHARACTER,	/* 1511 */
/* U+21E8 */	CANT_MAP_CHARACTER,	/* 1512 */
/* U+21E9 */	CANT_MAP_CHARACTER,	/* 1513 */
/* U+21EA */	CANT_MAP_CHARACTER,	/* 1514 */
/* U+21EB */	CANT_MAP_CHARACTER,	/* 1515 */
/* U+21EC */	CANT_MAP_CHARACTER,	/* 1516 */
/* U+21ED */	CANT_MAP_CHARACTER,	/* 1517 */
/* U+21EE */	CANT_MAP_CHARACTER,	/* 1518 */
/* U+21EF */	CANT_MAP_CHARACTER,	/* 1519 */
/* U+21F0 */	CANT_MAP_CHARACTER,	/* 1520 */
/* U+21F1 */	CANT_MAP_CHARACTER,	/* 1521 */
/* U+21F2 */	CANT_MAP_CHARACTER,	/* 1522 */
/* U+21F3 */	CANT_MAP_CHARACTER,	/* 1523 */
/* U+21F4 */	CANT_MAP_CHARACTER,	/* 1524 */
/* U+21F5 */	CANT_MAP_CHARACTER,	/* 1525 */
/* U+21F6 */	CANT_MAP_CHARACTER,	/* 1526 */
/* U+21F7 */	CANT_MAP_CHARACTER,	/* 1527 */
/* U+21F8 */	CANT_MAP_CHARACTER,	/* 1528 */
/* U+21F9 */	CANT_MAP_CHARACTER,	/* 1529 */
/* U+21FA */	CANT_MAP_CHARACTER,	/* 1530 */
/* U+21FB */	CANT_MAP_CHARACTER,	/* 1531 */
/* U+21FC */	CANT_MAP_CHARACTER,	/* 1532 */
/* U+21FD */	CANT_MAP_CHARACTER,	/* 1533 */
/* U+21FE */	CANT_MAP_CHARACTER,	/* 1534 */
/* U+21FF */	CANT_MAP_CHARACTER,	/* 1535 */
	0 /* END OF MAP TABLE */
};
static const USHORT from_unicode_map[256] = {
/* U+00-- */	256,
/* U+01-- */	512,
/* U+02-- */	768,
/* U+03-- */	0,
/* U+04-- */	0,
/* U+05-- */	0,
/* U+06-- */	0,
/* U+07-- */	0,
/* U+08-- */	0,
/* U+09-- */	0,
/* U+0A-- */	0,
/* U+0B-- */	0,
/* U+0C-- */	0,
/* U+0D-- */	0,
/* U+0E-- */	0,
/* U+0F-- */	0,
/* U+10-- */	0,
/* U+11-- */	0,
/* U+12-- */	0,
/* U+13-- */	0,
/* U+14-- */	0,
/* U+15-- */	0,
/* U+16-- */	0,
/* U+17-- */	0,
/* U+18-- */	0,
/* U+19-- */	0,
/* U+1A-- */	0,
/* U+1B-- */	0,
/* U+1C-- */	0,
/* U+1D-- */	0,
/* U+1E-- */	0,
/* U+1F-- */	0,
/* U+20-- */	1024,
/* U+21-- */	1280,
/* U+22-- */	0,
/* U+23-- */	0,
/* U+24-- */	0,
/* U+25-- */	0,
/* U+26-- */	0,
/* U+27-- */	0,
/* U+28-- */	0,
/* U+29-- */	0,
/* U+2A-- */	0,
/* U+2B-- */	0,
/* U+2C-- */	0,
/* U+2D-- */	0,
/* U+2E-- */	0,
/* U+2F-- */	0,
/* U+30-- */	0,
/* U+31-- */	0,
/* U+32-- */	0,
/* U+33-- */	0,
/* U+34-- */	0,
/* U+35-- */	0,
/* U+36-- */	0,
/* U+37-- */	0,
/* U+38-- */	0,
/* U+39-- */	0,
/* U+3A-- */	0,
/* U+3B-- */	0,
/* U+3C-- */	0,
/* U+3D-- */	0,
/* U+3E-- */	0,
/* U+3F-- */	0,
/* U+40-- */	0,
/* U+41-- */	0,
/* U+42-- */	0,
/* U+43-- */	0,
/* U+44-- */	0,
/* U+45-- */	0,
/* U+46-- */	0,
/* U+47-- */	0,
/* U+48-- */	0,
/* U+49-- */	0,
/* U+4A-- */	0,
/* U+4B-- */	0,
/* U+4C-- */	0,
/* U+4D-- */	0,
/* U+4E-- */	0,
/* U+4F-- */	0,
/* U+50-- */	0,
/* U+51-- */	0,
/* U+52-- */	0,
/* U+53-- */	0,
/* U+54-- */	0,
/* U+55-- */	0,
/* U+56-- */	0,
/* U+57-- */	0,
/* U+58-- */	0,
/* U+59-- */	0,
/* U+5A-- */	0,
/* U+5B-- */	0,
/* U+5C-- */	0,
/* U+5D-- */	0,
/* U+5E-- */	0,
/* U+5F-- */	0,
/* U+60-- */	0,
/* U+61-- */	0,
/* U+62-- */	0,
/* U+63-- */	0,
/* U+64-- */	0,
/* U+65-- */	0,
/* U+66-- */	0,
/* U+67-- */	0,
/* U+68-- */	0,
/* U+69-- */	0,
/* U+6A-- */	0,
/* U+6B-- */	0,
/* U+6C-- */	0,
/* U+6D-- */	0,
/* U+6E-- */	0,
/* U+6F-- */	0,
/* U+70-- */	0,
/* U+71-- */	0,
/* U+72-- */	0,
/* U+73-- */	0,
/* U+74-- */	0,
/* U+75-- */	0,
/* U+76-- */	0,
/* U+77-- */	0,
/* U+78-- */	0,
/* U+79-- */	0,
/* U+7A-- */	0,
/* U+7B-- */	0,
/* U+7C-- */	0,
/* U+7D-- */	0,
/* U+7E-- */	0,
/* U+7F-- */	0,
/* U+80-- */	0,
/* U+81-- */	0,
/* U+82-- */	0,
/* U+83-- */	0,
/* U+84-- */	0,
/* U+85-- */	0,
/* U+86-- */	0,
/* U+87-- */	0,
/* U+88-- */	0,
/* U+89-- */	0,
/* U+8A-- */	0,
/* U+8B-- */	0,
/* U+8C-- */	0,
/* U+8D-- */	0,
/* U+8E-- */	0,
/* U+8F-- */	0,
/* U+90-- */	0,
/* U+91-- */	0,
/* U+92-- */	0,
/* U+93-- */	0,
/* U+94-- */	0,
/* U+95-- */	0,
/* U+96-- */	0,
/* U+97-- */	0,
/* U+98-- */	0,
/* U+99-- */	0,
/* U+9A-- */	0,
/* U+9B-- */	0,
/* U+9C-- */	0,
/* U+9D-- */	0,
/* U+9E-- */	0,
/* U+9F-- */	0,
/* U+A0-- */	0,
/* U+A1-- */	0,
/* U+A2-- */	0,
/* U+A3-- */	0,
/* U+A4-- */	0,
/* U+A5-- */	0,
/* U+A6-- */	0,
/* U+A7-- */	0,
/* U+A8-- */	0,
/* U+A9-- */	0,
/* U+AA-- */	0,
/* U+AB-- */	0,
/* U+AC-- */	0,
/* U+AD-- */	0,
/* U+AE-- */	0,
/* U+AF-- */	0,
/* U+B0-- */	0,
/* U+B1-- */	0,
/* U+B2-- */	0,
/* U+B3-- */	0,
/* U+B4-- */	0,
/* U+B5-- */	0,
/* U+B6-- */	0,
/* U+B7-- */	0,
/* U+B8-- */	0,
/* U+B9-- */	0,
/* U+BA-- */	0,
/* U+BB-- */	0,
/* U+BC-- */	0,
/* U+BD-- */	0,
/* U+BE-- */	0,
/* U+BF-- */	0,
/* U+C0-- */	0,
/* U+C1-- */	0,
/* U+C2-- */	0,
/* U+C3-- */	0,
/* U+C4-- */	0,
/* U+C5-- */	0,
/* U+C6-- */	0,
/* U+C7-- */	0,
/* U+C8-- */	0,
/* U+C9-- */	0,
/* U+CA-- */	0,
/* U+CB-- */	0,
/* U+CC-- */	0,
/* U+CD-- */	0,
/* U+CE-- */	0,
/* U+CF-- */	0,
/* U+D0-- */	0,
/* U+D1-- */	0,
/* U+D2-- */	0,
/* U+D3-- */	0,
/* U+D4-- */	0,
/* U+D5-- */	0,
/* U+D6-- */	0,
/* U+D7-- */	0,
/* U+D8-- */	0,
/* U+D9-- */	0,
/* U+DA-- */	0,
/* U+DB-- */	0,
/* U+DC-- */	0,
/* U+DD-- */	0,
/* U+DE-- */	0,
/* U+DF-- */	0,
/* U+E0-- */	0,
/* U+E1-- */	0,
/* U+E2-- */	0,
/* U+E3-- */	0,
/* U+E4-- */	0,
/* U+E5-- */	0,
/* U+E6-- */	0,
/* U+E7-- */	0,
/* U+E8-- */	0,
/* U+E9-- */	0,
/* U+EA-- */	0,
/* U+EB-- */	0,
/* U+EC-- */	0,
/* U+ED-- */	0,
/* U+EE-- */	0,
/* U+EF-- */	0,
/* U+F0-- */	0,
/* U+F1-- */	0,
/* U+F2-- */	0,
/* U+F3-- */	0,
/* U+F4-- */	0,
/* U+F5-- */	0,
/* U+F6-- */	0,
/* U+F7-- */	0,
/* U+F8-- */	0,
/* U+F9-- */	0,
/* U+FA-- */	0,
/* U+FB-- */	0,
/* U+FC-- */	0,
/* U+FD-- */	0,
/* U+FE-- */	0,
/* U+FF-- */	0,
};
