/* GBINDADMIN, a GTK+ frontend for ISC BIND
 * Copyright C 2005, 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "commands.h"
#include "chars_are_digits.h"
#include "populate_log_tab.h"
#include "activate_button_clicked.h"

extern int activated;
extern char CHROOT_PATH_BUF[1024];


void activate_button_clicked(struct w *widgets)
{
    gchar *start, *test, *info;

    if( activated )
      return;

    start = g_strdup_printf("%s -u %s -t %s -c /etc/named.conf", NAMED_BINARY, NAMED_USER, CHROOT_PATH_BUF);
    if( ! run_command(start) )
    {
	/* Shows any errors QA:d */
        test = g_strdup_printf("%s -fg -u %s -t %s -c /etc/named.conf 2>&1", NAMED_BINARY, NAMED_USER, CHROOT_PATH_BUF);
	run_command_show_err(test);
	g_free(test);
	activated = 0;
	return;
    }
    g_free(start);

    activated = 1;

    if( ! chars_are_digits(CMD_SLEEP_LOG_SECS) )
    {
	info = g_strdup_printf(_("CMD_SLEEP_LOG_SECS should be in seconds, please reinstall the program.\n"));
	show_info(info);
	g_free(info);
	return;
    }
    if( strlen(CMD_SLEEP_LOG_SECS) > 2 ) /* 99 seconds max */
    {
	info = g_strdup_printf(_("CMD_SLEEP_LOG_SECS max length is 2, please reinstall the program.\n"));
	show_info(info);
	g_free(info);
	return;
    }

    sleep(atoi(CMD_SLEEP_LOG_SECS));

    populate_log_tab(widgets);
}
