#ifndef CHECK_ANONYMOUS_H
#define CHECK_ANONYMOUS_H

#include <qobject.h>
#include <qdict.h>

#include "gadu.h"

class UserGroup;

/*!
 * This class provides functionality to automaticly get informations
 * about anonymous interlocutor from the public directory.
 * \brief Automaticly anonymous checking class
 */
class AnonymousCheck : public QObject
{
	Q_OBJECT
	public:
		//! 
		/*!
	 	 * \brief Default constructor.
		 * \param parent points to patent's object.
		 * \param name is an object's name.
		 */
		AnonymousCheck(QObject *parent = 0, const char *name = 0);

		//! Default destructor.
		~AnonymousCheck();

	public slots:
		/*!
	 	 * \brief This slot is called wthen new chat is created.
		 * \param group is a pointer to group of people we're chatting with.
		 */
		void onNewChatSlot(const UserGroup *group);

	private slots:
		/*!
	 	 * \brief This slot is called when search in the public directory finishes finished.
		 * \param searchResults holds the search result.
		 * \param seq %Ignored here
		 * \param lastUin %Ignored here
		 */
		void onSearchFinishedSlot(SearchResults &searchResults, int seq, int lastUin);
	
	protected:
		/*!
		 * The keys are Uins of checked interlocutors and the values are pointers to
		 * UserGroup groups on chat windows we're displaying results on.
		 * \brief Holds pointers to groups of interlocutors we're chatting with.
		 */
		QDict<UserGroup> groups;
};

#endif
