#ifndef KADU_CHAT_MANAGER_SLOTS_H
#define KADU_CHAT_MANAGER_SLOTS_H

#include <qobject.h>
#include <qcolor.h>
#include <qfont.h>

class QComboBox;
class QLineEdit;

/**
	\class ChatSlots
	\brief Sloty do obsugi okna konfiguracji
**/
class ChatManagerSlots :public QObject
{
	Q_OBJECT

	private:
		/**
			\fn void updatePreview()
			Odwieenie wygldu
		**/
		void updatePreview();

	public:
		/**
			\fn ChatManagerSlots(QObject* parent=0, const char* name=0)
			Konstruktor obiektu
			\param parent rodzic obiektu
			\param name nazwa obiektu
		**/
		ChatManagerSlots(QObject* parent=0, const char* name=0);

	public slots:
		/**
			\fn void onCreateTabChat()
			Slot jest wywoywany gdy otwierana jest zakladka Chat
		**/
		void onCreateTabChat();

		/**
			\fn void onCreateTabLook()
			Slot jest wywoywany gdy otwierana jest zakladka Wyglad
		**/
		void onCreateTabLook();

		/**
			\fn void onApplyTabChat()
			Slot jest wywoywany gdy zamykane jest okno konfiguracji
		**/
		void onApplyTabChat();

		/**
			\fn void onApplyTabLook()
			Slot jest wywoywany gdy zamykane jest okno konfiguracji
		**/
		void onApplyTabLook();

		/**
			\fn void chooseEmoticonsStyle(int index)
			Slot jest wywoywany gdy wybierany jest styl ikonek
			\param index nr stylu emotikonek
		**/
		void chooseEmoticonsStyle(int index);

		/**
			\fn void onPruneChat(bool toggled)
			Slot jest wywoywany gdy wybierane jest czy otwierane okno
			ma by pusty czy nie
			\param toggled
		**/
		void onPruneChat(bool toggled);

		/**
			\fn void onFoldLink(bool toggled)
			Slot jest wywoywany gdy wczono/wyczono zawijanie linkw,
			aby uaktualni podgld
			\param toggled
		**/
		void onFoldLink(bool toggled);

		/**
			\fn void onBlockClose(bool toggled)
			Slot jest wywoywany gdy wybierany jest maksymalny czas
			blokowania zamknicia okna po otrzymaniu wiadomoci
			\param toggled
		**/
		void onBlockClose(bool toggled);

		/**
			\fn void onRemoveHeaders(bool toggled)
			Slot jest wywoywany gdy wczono/wyczono wywietlanie nagwkw,
			aby uaktualni podgld
			\param toggled
		**/
		void onRemoveHeaders(bool toggled);

		/**
			\fn void onChatThemeChanged(const QString& name)
			Slot jest wywoywany po zmianie stylu okna Chat,
			aby uaktualni podgld
			\param name nazwa stylu
		**/
		void onChatThemeChanged(const QString& name);

		/**
			\fn void chooseColor(const char* name, const QColor& color)
			Slot jest wywoywany gdy zmieniono kolor,
			aby uaktualni podgld
			\param name nazwa koloru
			\param color kolor
		**/
		void chooseColor(const char* name, const QColor& color);

		/**
			\fn void chooseFont(const char* name, const QFont& font)
			Slot jest wywoywany gdy zmieniono czcionke,
			aby uaktualni podgld
			\param name nazwa czcionki
			\param font czcionka
		**/
		void chooseFont(const char* name, const QFont& font);

		/**
			\fn void chooseBackgroundFile()
			Slot jest wywoywany aby wybra obraz ta dla okna Chat
		**/
		void chooseBackgroundFile();

		/**
			\fn void findAndSetWebBrowser(int selectedBrowser)
			Slot jest wywoywany gdy wybrano z listy przegldark
			\param selectedBrowser nr przegldarki
		**/
		void findAndSetWebBrowser(int selectedBrowser);

		/**
			\fn void findAndSetBrowserOption(int selectedOption)
			Slot jest wywoywany gdy aktywowano pole do wpisania opcji
			\param selectedOption wybrana opcja
		**/
		void findAndSetBrowserOption(int selectedOption);

		/**
			\fn static void initBrowserOptions(QComboBox *browserCombo, QComboBox *browserOptionsCombo, QLineEdit *browserPath)
			Slot ustawia przegldarki wraz z opcjami
			\param browserCombo
			\param browserOptionsCombo
			\param browserPath
		**/
		static void initBrowserOptions(QComboBox *browserCombo, QComboBox *browserOptionsCombo, QLineEdit *browserPath);

		/**
			\fn static void findBrowser(int selectedBrowser, QComboBox *browserCombo, QComboBox *browserOptionsCombo, QLineEdit *browserPath)
			Slot jest wywoywany gdy wybrano z listy przegldark
			\param selectedBrowser
			\param browserCombo
			\param browserOptionsCombo
			\param browserPath
		**/
		static void findBrowser(int selectedBrowser, QComboBox *browserCombo, QComboBox *browserOptionsCombo, QLineEdit *browserPath);

		/**
			\fn static void setBrowserOption(int selectedOption, QLineEdit *browserPathEdit, int chosenBrowser)
			Slot ustawia przegldarki wraz z opcjami
			\param selectedOption
			\param browsePathEdit
			\param chosenBrowser
		**/
		static void setBrowserOption(int selectedOption, QLineEdit *browserPathEdit, int chosenBrowser);
};
#endif
