#ifndef KADU_CHAT_MESSAGE_H
#define KADU_CHAT_MESSAGE_H

#include <qcolor.h>
#include <qdatetime.h>
#include <qmap.h>
#include <qstring.h>

#include "chat_colors.h"
#include "emoticons.h"

class ChatStyle;

/**

	Klasa przechowujca informacje o wiadomoci, ktra ma si pojawi
	w oknie Chat.
	\class ChatMessage
	\brief Klasa przechowujca informacje o wiadomoci.
**/
class ChatMessage
{
	private:
		/**
			\fn QString convertCharacters(QString text, const QColor &bgcolor, EmoticonsStyle style)
			Funkcja zamienia specjalne tagi na emotikonki,
			html na czysty tekst itp.
			\param text tekst do konwersji
			\param bgcolor kolor ta
			\param style styl emotikonek
		**/
		QString convertCharacters(QString text, const QColor &bgcolor, EmoticonsStyle style);


	public:
	QString nick; /*!< nazwa uytkownika */
	QDateTime date; /*!< data otrzymania wiadomoci */
	QDateTime sdate; /*!< data wysania wiadomoci */
	QString unformattedMessage; /*!< niesformatowana wiadomo */
	bool isMyMessage; /*!< zmienna mowica czy wiadomoc zostaa
				napisana przez nas */
	ChatColors Colors; /*!< przechowuje kolory uywane w wiadomoci
				(ta, czcionki i nicku) */

	QMap<QString, bool> attributes; /*!<
		Moe suy do przechowywania informacji o tym
		czy wiadomo bya potwierdzona, szyfrowana, ...
		W zamyle ma suy do okrelania czy jaki obrazek
		ma by dodawany do wiadomoci czy nie - jaki obrazek -
		ta informacja bdzie gdzie indziej
		*/

	//inne atrybuty?
	//QMap<QString, QString> stringAttributes;

	bool needsToBeFormatted; /*!< zmienna mowica czy wiadomoc powinna
				  by sformatowana */

	QString message; /*!< Sformatowana wiadomo (razem z \<p\> lub \<table\>) **/

	/**
		\fn ChatMessage(const QString &nick, const QString &unformattedMessage, bool myMessage, QDateTime date, QDateTime sdate=QDateTime())
		Konstruktor ustawiajcy nick, niesformatowan wiadomo,
		czy wiadomo pochodzi od nas, dat wiadomoci,
		dat nadania wiadomoci przez serwer
		\param nick nazwa uytkownika
		\param unformattedMessage niesformatowana wiadomo
		\param myMessage zmienna mowica czy wiadomo pochodzi od nas
		\param date data otrzymania wiadomoci
		\param sdate data wysania wiadomoci
	**/
	ChatMessage(const QString &nick, const QString &unformattedMessage, bool myMessage, QDateTime date, QDateTime sdate=QDateTime());

	/**
		\fn ChatMessage(const QString &formattedMessage, const ChatColors& colors = ChatColors(Qt::white, Qt::black, Qt::black))
		Konstruktor ustawiajcy sformatowan wiadomo,
		kolor ta i liter wiadomoci
		\param nick nazwa uytkownika
		\param unformattedMessage niesformatowana wiadomo
		\param myMessage zmienna mowica czy wiadomo pochodzi od nas
		\param date data otrzymania wiadomoci
		\param sdate data wysania wiadomoci
	**/
	ChatMessage(const QString &formattedMessage,
		const ChatColors& colors = ChatColors(Qt::white, Qt::black, Qt::black));

	/**
		\fn void formatMessage(const ChatStyle* chat_style, const EmoticonsStyle emoticons_style,
			bool include_header, int separator_size);
		Funkcja formatujca niesformatowan wiadomo
		zgodnie z zadanymi parametrami
		\param chat_style styl dla okna, ktry powinien zosta uyty
		\param emoticons_style uywany styl emotikon
		\param include_header czy powinien by doczony nagwek
		\param separator_size wysoko separatora
	**/
	void formatMessage(const ChatStyle* chat_style, const EmoticonsStyle emoticons_style,
		bool include_header, int separator_size);
};

#endif
