/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kadu.h"
#include "config_file.h"
#include "config_dialog.h"
#include "debug.h"
#include "misc.h"

#include "filedesc.h"

#include <qtimer.h>

#define MODULE_FILEDESC_VERSION 1.12

FileDescription *file_desc;

extern "C" int filedesc_init()
{
	file_desc = new FileDescription();

	return 0;
}

extern "C" void filedesc_close()
{
	delete file_desc;
}

// Implementation of FileDescription class

FileDescription::FileDescription()
{
	kdebugf();

	ConfigDialog::addTab("FileDesc", dataPath("kadu/modules/data/filedesc/config.png"));
	ConfigDialog::addLineEdit("FileDesc", "FileDesc", QT_TRANSLATE_NOOP("@default", "File with description to synchronize"), "file", ".gg/description",
		QT_TRANSLATE_NOOP("@default", "Enter here a file, which will contain descriptions to refresh by module."));
	ConfigDialog::addCheckBox("FileDesc", "FileDesc", QT_TRANSLATE_NOOP("@default", "Force status to be 'with description'"), "forceDescr", TRUE,
		QT_TRANSLATE_NOOP("@default", "If you choose status without description, module will set it automaticaly to similar but with description"));
	ConfigDialog::addCheckBox("FileDesc", "FileDesc", QT_TRANSLATE_NOOP("@default", "Allow other descriptions"), "allowOther", TRUE,
		QT_TRANSLATE_NOOP("@default", "Allows you to set some custom description manualy, until file contents doesn't change"));

	timer = new QTimer();
	connect(timer, SIGNAL(timeout()), this, SLOT(checkTitle()));
	timer->start(500);
}

FileDescription::~FileDescription()
{
	kdebugf();
	disconnect(timer, SIGNAL(timeout()), this, SLOT(checkTitle()));
	delete timer;

	ConfigDialog::removeControl("FileDesc", "File with description to synchronize");
	ConfigDialog::removeControl("FileDesc", "Force status to be 'with description'");
	ConfigDialog::removeControl("FileDesc", "Allow other descriptions");
	ConfigDialog::removeTab("FileDesc");
}

void FileDescription::checkTitle()
{
	if (QFile::exists(config_file.readEntry("FileDesc", "file")))
	{
		QFile file(config_file.readEntry("FileDesc", "file"));
		if (!gadu->status().isOffline())
		{
			if (file.open(IO_ReadOnly))
			{
				QString desc = "";
				QTextStream stream(&file);
				if (!stream.atEnd())
					desc = stream.readLine();

				if ((desc != currDesc || gadu->status().description() != desc && !config_file.readBoolEntry("FileDesc", "allowOther")
					|| !gadu->status().hasDescription() && config_file.readBoolEntry("FileDesc", "forceDescr")) && !gadu->status().isOffline())
				{
					currDesc = desc;
					gadu->status().setDescription(desc);
				}
				file.close();
			}
		}
	}
}
