/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2006 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FORECAST_H
#define FORECAST_H

#include <qmap.h>
#include <qdatetime.h>
#include <qvaluelist.h>

/**
	Zawiera list wartoci opisujacych pogod. Dozwolone wartoci:
	"Name", "Icon", "Temperature", "Pressure", "Rain", "Snow", "Wind Speed", "Description"
	"Humidity", "Dew point", "Visibility"
**/
typedef QMap<QString, QString> ForecastDay;

/**
	\struct Forecast
	Zawiera informacj o jednym dniu z prognozy pogody.
	LocationName - nazwa miejscowoci
	LocationID - kod miejscowoci
	config - nazwa pliku konfiguracyjnego
	loadTime - data pobrania prognozy
	Days - poszczeglne dni prognozy
**/
struct Forecast
{
	QString LocationName;
	QString LocationID;
	QValueList<ForecastDay> Days;
	QString config;
	QString serverName;
	QTime loadTime;
};

#endif // FORECAST_H
