/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2006 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef FORECAST_CONTAINER_H
#define FORECAST_CONTAINER_H

#include "forecast.h"

#include <qvaluelist.h>

/**
	\class ForecastContener
	Ma za zadanie przechowywa cignite prognozy.
	Prognozy identyfikowane s poprzez kod miejscowoci oraz
	serwer (nazwa pliku konfiguracyjnego). Oznacza to, e w kontenerze
	nie ma dwch prognoz dla tej samej miejscowoci z tym samym serwerem.
	
	Funkcja deleteObsolete() usuwa z pojemnika przestarzae prognozy
**/
class ForecastContainer
{
	QValueList<Forecast> list_;

public:
	const Forecast* getForecast( const QString& configFile, const QString& location );
	void deleteObsolete();
	void add( const Forecast& forecast );
};

#endif // FORECAST_CONTAINER_H
