/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2004 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef GETCITYDIALOG_H
#define GETCITYDIALOG_H

#include <qdialog.h>

#include "userlistelement.h"
#include "gadu.h"

#include "weather_global.h"
#include "search_location_id.h"

class QVBoxLayout;
class TextProgress;
class QComboBox;
class QListBox;
class QPushButton;
class QHBox;

/**
	\class GetCityDialog
	Znajduje miasto uytkownika w serwisach pogodowych.
	Klasa najpierw wyszukuje nazw miasta w katalogu publicznym
	a nastpnie szuka go w serwisach pogodowych, zgodnie z ustalon
	kolejnoci serwisw.
**/
class GetCityDialog : public QDialog
{
	Q_OBJECT

public:
	GetCityDialog();
	virtual ~GetCityDialog();
	void show();

protected:
	virtual void getUserData( QString* ggUserId ) {}
	virtual void showForecast( const CitySearchResult& result );

private:

	enum Mode
	{
		NONE,
		SEARCH,
		ENTER,
		SELECT
	};
	SearchLocationID searchId_;
	
	QVBoxLayout* mainLayout_;
	Mode currentMode_;
	
	TextProgress* progress_;
	QPushButton* cancelButton_;
	
	QHBox* ecHLayout_;
	QComboBox* cityEdit_;
	QPushButton* findButton_;
	
	QLabel* cityLabel_;
	QListBox* cityList_;
	QPushButton* okButton_;
	QHBox* okNewSearchHLayout_;
	
	void findCity( const QString& name );
	void switchLayout( Mode mode );
	void showCityAtPos( int pos );
	
private slots:
	void newSearchResults(SearchResults& searchResults, int seq, int fromUin);
	void cancelClicked();
	void findClicked();
	void okClicked();
	void newSearchClicked();
	void listDoubleClicked( QListBoxItem* item );
	void nextServerSearch( const QString& city, const QString& serverName_ );
	void searchFinished();
	
};

/**
	\class GetUserCityDialog
	Implementacja klasy @see GetCityDialog dla kontaktw na licie
**/
class GetUserCityDialog : public GetCityDialog
{
public:
	GetUserCityDialog( UserListElement user );
	
private:
	UserListElement user_;

	virtual void getUserData( QString* ggUserId );
	virtual void showForecast( const CitySearchResult& result );
};

/**
	\class GetMyCityDialog
	Implementacja klasy @see GetCityDialog dla gwnego uytkownika
**/
class GetMyCityDialog : public GetCityDialog
{
public:
	GetMyCityDialog() {}
	
private:
	virtual void getUserData( QString* ggUserId );
	virtual void showForecast( const CitySearchResult& result );
};

#endif // GETCITYDIALOG_H
