/***************************************************************************
 *   Weather module for Kadu communicator                                  *
 *   2006 Micha Maek (bysk)                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WEATHER_H
#define WEATHER_H

#include <qobject.h>

#include "config_file.h"
#include "userbox.h"

#include "autodownloader.h"

class QListViewItem;

/**
	Gwna klasa moduu, obsuga menu oraz konfiguracji.
**/
class Weather : public QObject
{
	Q_OBJECT
	
	public:
		Weather();
		~Weather();
		
	private:
		AutoDownloader autoDownloader_;
		
		int menuMyWeather_;
		int menuWeatherFor_;
		bool menuShowContactWeather_;
		
	private slots:
		void CreateConfigDialog();
		void ApplyConfigDialog();
		
		void serverListItemChanged( QListViewItem* item );
		void upClicked();
		void downClicked();
		void checkedAutoLoad(bool check);
		void checkedShowHints(bool check);
		void checkedDescription(bool check);
		
		void ShowWeather();
		void ShowMyWeather();
		void ShowWeatherFor();
};

#endif // WEATHER_H
