#ifndef __MAIL_SSOCKET_H
#define __MAIL_SSOCKET_H
#include <qsocket.h>
#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>

enum SecureType {
	WithoutEncryption,
	StartTLS,
	Immediately
};

class SSocket: public QObject
{
	Q_OBJECT

	public:
		SSocket(QObject*);
		QString readLine();
		void flush();
		void close();
		Q_LONG writeBlock(const char* data, Q_ULONG len);
		void connectToHost(const QString& host, Q_UINT16 port);
		void setType(SecureType type);
		SecureType getType();

	public slots:
		void onError(int);
		void onConnected();
		void onReadyRead();

	signals:
		void error(int);
		void connected();
		void readyRead();


	private:
		QSocket socl;
		SecureType stype;
		SSL_CTX *ctx;
		SSL *ssl;
};
#endif
