/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 */

#ifndef PROFILES_H
#define PROFILES_H
 
#include <qstring.h> 
#include <qobject.h> 
#include <qwidget.h>
#include <qthread.h>
#include <qdom.h>
#include <qdialog.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qvaluelist.h>
 
class ConfigurationWindow : public QDialog
{
	Q_OBJECT
	public:
		ConfigurationWindow(QWidget * parent = 0, const char * name = 0, bool modal = FALSE, WFlags f = 0);
		~ConfigurationWindow();	
		void initConfiguration();
		void clear();
		void saveProfile(QString name, QString directory, QString uin, QString password, bool config, bool userlist, bool autostart);
		void removeProfile(QString name);
		QDomElement getProfile(QString name);
		QListBox *profilesList;
	private:
		QLineEdit *profileName;
		QLineEdit *profileUIN;
		QLineEdit *profileDir;
		QLineEdit *profilePassword;
		QCheckBox *advancedCheck;
		QCheckBox *configCheck;
		QCheckBox *userlistCheck;
		QCheckBox *autostartCheck;
		QPushButton *saveButton;
		QPushButton *deleteButton;
		QPushButton *openButton;
		QPushButton *closeButton;

	private slots:
		void closeBtnPressed();
		void openBtnPressed();
		void saveBtnPressed();
		void deleteBtnPressed();
		void profileSelected(QListBoxItem *item);
		void advancedChecked(bool state);
		void configChecked(bool state);
		void fillDir(const QString &s);
};	
 
class MyThread : public QThread {
	public:
		MyThread() {};
		QString path;
		QString command;
		virtual void run();
};

//typedef QValueList<MyThread *> ThreadList;

class ProfileManager : public QObject
{
	Q_OBJECT
	public:
		ProfileManager(QObject *parent=0, const char *name=0);
		~ProfileManager();
		void firstRun();
		void runAutostarted();
		void runKadu(QString profilePath);
		static QString dirString();
	
	private:
		int menuPos;
		ConfigurationWindow *dialogWindow;
		//ThreadList thread_list;
	
	private slots:
		void showConfig();	
};


extern ProfileManager *profileManager;

#endif
