/***************************************************************************
                          transferwindow.cpp -  description
                             -------------------
    begin                : Wed Nov 3 2004
    copyright            : (C) 2004 by Diederik van der Boor
    email                : vdboor --at-- codingdomain.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "transferwindow.h"
#include "transferentry.h"

#include <klocale.h>
#include <kdebug.h>

#include <qscrollview.h>
#include <qlayout.h>
#include <qsplitter.h>
#include <qptrlist.h>
#include <qwidget.h>

// Initialize the instance to zero
TransferWindow* TransferWindow::onlyInstance_(0);


// Constructor
TransferWindow::TransferWindow(QWidget *parent, const char *name)
  : KDialogBase(parent, name, false, i18n("File Transfers"), Close | User1, Close, false, i18n("&Clean up"))
{
  // Central list for entries
  scrollView_ = new QScrollView( this );
  scrollView_->viewport()->setPaletteBackgroundColor( paletteBackgroundColor() );
  scrollView_->setHScrollBarMode( QScrollView::AlwaysOff );  // Disable horizontal scrolllbar
  scrollView_->setMinimumSize(380, 100);                     // Force a mimimum size
  scrollView_->setResizePolicy(QScrollView::AutoOneFit);     // Stretch contents
  setMainWidget( scrollView_ );

  // Container for all download entries:
  mainWidgets_ = new QWidget( scrollView_->viewport() );
  mainWidgets_->setSizePolicy(QSizePolicy::Maximum, QSizePolicy::Preferred, false);  // Stretch widget
  scrollView_->addChild(mainWidgets_);

  // Layout class
  mainLayout_ = new QVBoxLayout( mainWidgets_, 0 );
  mainLayout_->setSpacing(0);
  mainLayout_->setMargin(2);

  // Occupy all bottom space
  mainLayout_->addItem( new QSpacerItem(20, 0, QSizePolicy::Ignored, QSizePolicy::Ignored) );
}


//
// Destructor
TransferWindow::~TransferWindow()
{
}


// Add an entry to the transfer manager
TransferEntry *TransferWindow::addEntry(QString filename, uint filesize, bool incoming)
{
  TransferEntry *entry = new TransferEntry(mainWidgets_, "TransferEntry", filename, filesize, incoming);

  mainLayout_->insertWidget(0, entry, 0, AlignTop);
  entryList_.append(entry);

  entry->show();
  mainWidgets_->update();

  return entry;
}


// Return an instance of the singleton.
TransferWindow *TransferWindow::instance()
{
  if(onlyInstance_ == 0)
  {
    onlyInstance_ = new TransferWindow();
  }
  return onlyInstance_;
}


// Destroy the singleton.
void TransferWindow::destroy()
{
  delete onlyInstance_;
  onlyInstance_ = 0;
}


// The "cleap up" button was pressed
void TransferWindow::slotUser1()
{
#ifdef KMESSDEBUG_TRANSFERFILE
  kdDebug() << "TransferWindow: Cleaning up" << endl;
#endif

  QPtrList<TransferEntry> toRemove;
  TransferEntry *entry;

  // Remove the entries from the dialog
  for(entry = entryList_.first(); entry != 0; entry = entryList_.next())
  {
    if(entry->isDone())
    {
      mainWidgets_->removeChild(entry);
      mainLayout_->remove(entry);
      toRemove.append(entry);
    }
  }

  // Remove the items from the list afterwards (would disturb the previous iterator otherwise)
  for(entry = toRemove.first(); entry != 0; entry = toRemove.next())
  {
    entryList_.remove(entry);
#ifdef KMESSDEBUG_TRANSFERFILE
    kdDebug() << "TransferWindow: Removed " << entry.getFileName() << endl;
#endif
    delete entry;
  }

  mainWidgets_->update();
}


#include "transferwindow.moc"
