/*
 * Copyright (c) 2003, Intel Corporation. All rights reserved.
 * Created by:  julie.n.fleischer REMOVE-THIS AT intel DOT com
 * This file is licensed under the GPL license.  For the full content
 * of this license, see the COPYING file at the top level of this
 * source tree.
 */

/*
 * Basic test that mq_timedsend() actually places a message into mqdes.  Verify
 * by ensuring the message can be received.
 *
 * 3/13/03 - Added fix from Gregoire Pichon for specifying an attr
 *           with a mq_maxmsg >= BUFFER.
 */

#include <stdio.h>
#include <mqueue.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <time.h>
#include "posixtest.h"

#define NAMESIZE 50
#define MSGSTR "0123456789"
#define BUFFER 40
#define MAXMSG 10

int main()
{
        char qname[NAMESIZE], msgrcd[BUFFER];
        const char *msgptr = MSGSTR;
	struct timespec ts;
        mqd_t queue;
	struct mq_attr attr;
	int unresolved=0, failure=0, pri;

        sprintf(qname, "/mq_timedsend_1-1_%d", getpid());

	attr.mq_msgsize = BUFFER;
	attr.mq_maxmsg = MAXMSG;
        queue = mq_open(qname, O_CREAT |O_RDWR, S_IRUSR | S_IWUSR, &attr);
        if (queue == (mqd_t)-1) {
                perror("mq_open() did not return success");
                return PTS_UNRESOLVED;
        }

	ts.tv_sec=time(NULL)+1;
	ts.tv_nsec=0;
        if (mq_timedsend(queue, msgptr, strlen(msgptr), 1, &ts) != 0) {
                perror("mq_timedsend() did not return success");
		failure=1;
        }

        if (mq_receive(queue, msgrcd, BUFFER, &pri) == -1) {
		perror("mq_receive() returned failure");
		failure=1;
	}

	if (strncmp(msgptr, msgrcd, strlen(msgptr)) != 0) {
		printf("FAIL:  sent %s received %s\n", msgptr, msgrcd);
		failure = 1;
	}

        if (mq_close(queue) != 0) {
		perror("mq_close() did not return success");
		unresolved=1;
        }

        if (mq_unlink(qname) != 0) {
		perror("mq_unlink() did not return success");
		unresolved=1;
        }

	if (failure==1) {
		printf("Test FAILED\n");
		return PTS_FAIL;
	}

	if (unresolved==1) {
		printf("Test UNRESOLVED\n");
		return PTS_UNRESOLVED;
	}

        printf("Test PASSED\n");
        return PTS_PASS;
}

