/* gsd-secure-delete-operation.c generated by valac 0.12.0, the Vala compiler
 * generated from gsd-secure-delete-operation.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GSD_TYPE_ASYNC_OPERATION (gsd_async_operation_get_type ())
#define GSD_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperation))
#define GSD_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))
#define GSD_IS_ASYNC_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_ASYNC_OPERATION))
#define GSD_IS_ASYNC_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_ASYNC_OPERATION))
#define GSD_ASYNC_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_ASYNC_OPERATION, GsdAsyncOperationClass))

typedef struct _GsdAsyncOperation GsdAsyncOperation;
typedef struct _GsdAsyncOperationClass GsdAsyncOperationClass;
typedef struct _GsdAsyncOperationPrivate GsdAsyncOperationPrivate;

#define GSD_TYPE_SECURE_DELETE_OPERATION (gsd_secure_delete_operation_get_type ())
#define GSD_SECURE_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperation))
#define GSD_SECURE_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperationClass))
#define GSD_IS_SECURE_DELETE_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GSD_TYPE_SECURE_DELETE_OPERATION))
#define GSD_IS_SECURE_DELETE_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GSD_TYPE_SECURE_DELETE_OPERATION))
#define GSD_SECURE_DELETE_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperationClass))

typedef struct _GsdSecureDeleteOperation GsdSecureDeleteOperation;
typedef struct _GsdSecureDeleteOperationClass GsdSecureDeleteOperationClass;
typedef struct _GsdSecureDeleteOperationPrivate GsdSecureDeleteOperationPrivate;

#define GSD_SECURE_DELETE_OPERATION_TYPE_MODE (gsd_secure_delete_operation_mode_get_type ())
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	GSD_ASYNC_OPERATION_ERROR_CHILD_FAILED,
	GSD_ASYNC_OPERATION_ERROR_SUBCLASS_ERROR
} GsdAsyncOperationError;
#define GSD_ASYNC_OPERATION_ERROR gsd_async_operation_error_quark ()
struct _GsdAsyncOperation {
	GObject parent_instance;
	GsdAsyncOperationPrivate * priv;
	guint n_passes;
	guint passes;
	GPid pid;
	gint fd_in;
	gint fd_out;
	gint fd_err;
};

struct _GsdAsyncOperationClass {
	GObjectClass parent_class;
	GList* (*build_args) (GsdAsyncOperation* self, GError** error);
	gchar** (*build_env) (GsdAsyncOperation* self, int* result_length1);
	void (*cleanup) (GsdAsyncOperation* self);
	guint (*get_max_progress) (GsdAsyncOperation* self);
	guint (*get_progress) (GsdAsyncOperation* self);
	gchar* (*get_subprocess_error_msg) (GsdAsyncOperation* self);
};

struct _GsdSecureDeleteOperation {
	GsdAsyncOperation parent_instance;
	GsdSecureDeleteOperationPrivate * priv;
};

struct _GsdSecureDeleteOperationClass {
	GsdAsyncOperationClass parent_class;
};

typedef enum  {
	GSD_SECURE_DELETE_OPERATION_MODE_NORMAL,
	GSD_SECURE_DELETE_OPERATION_MODE_INSECURE,
	GSD_SECURE_DELETE_OPERATION_MODE_VERY_INSECURE
} GsdSecureDeleteOperationMode;

struct _GsdSecureDeleteOperationPrivate {
	gboolean _fast;
	GsdSecureDeleteOperationMode _mode;
};

typedef enum  {
	GSD_FD_ERROR_KILL_ERROR,
	GSD_FD_ERROR_READ_ERROR,
	GSD_FD_ERROR_SELECT_ERROR,
	GSD_FD_ERROR_WAITPID_ERROR
} GsdFDError;
#define GSD_FD_ERROR gsd_fd_error_quark ()

static gpointer gsd_secure_delete_operation_parent_class = NULL;

GType gsd_async_operation_get_type (void) G_GNUC_CONST;
GQuark gsd_async_operation_error_quark (void);
GType gsd_secure_delete_operation_get_type (void) G_GNUC_CONST;
GType gsd_secure_delete_operation_mode_get_type (void) G_GNUC_CONST;
#define GSD_SECURE_DELETE_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GSD_TYPE_SECURE_DELETE_OPERATION, GsdSecureDeleteOperationPrivate))
enum  {
	GSD_SECURE_DELETE_OPERATION_DUMMY_PROPERTY,
	GSD_SECURE_DELETE_OPERATION_FAST,
	GSD_SECURE_DELETE_OPERATION_MODE
};
static const gchar* gsd_secure_delete_operation_get_argument_for_fast (GsdSecureDeleteOperation* self, gboolean fast);
static void gsd_secure_delete_operation_add_fast_argument (GsdSecureDeleteOperation* self, GList** args);
gboolean gsd_secure_delete_operation_get_fast (GsdSecureDeleteOperation* self);
static const gchar* gsd_secure_delete_operation_get_argument_for_mode (GsdSecureDeleteOperation* self, GsdSecureDeleteOperationMode mode);
static void gsd_secure_delete_operation_add_mode_argument (GsdSecureDeleteOperation* self, GList** args);
GsdSecureDeleteOperationMode gsd_secure_delete_operation_get_mode (GsdSecureDeleteOperation* self);
static GList* gsd_secure_delete_operation_real_build_args (GsdAsyncOperation* base, GError** error);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static guint gsd_secure_delete_operation_real_get_max_progress (GsdAsyncOperation* base);
static guint gsd_secure_delete_operation_real_get_progress (GsdAsyncOperation* base);
GQuark gsd_fd_error_quark (void);
guint gsd_fd_count_ready_bytes (gint fd, gint byte, gsize bufsize, GError** error);
gboolean gsd_secure_delete_operation_run (GsdSecureDeleteOperation* self, GError** error);
gboolean gsd_async_operation_run (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, GError** error);
gboolean gsd_secure_delete_operation_run_sync (GsdSecureDeleteOperation* self, GError** error);
gboolean gsd_async_operation_run_sync (GsdAsyncOperation* self, const gchar* working_directory, GSpawnFlags spawn_flags, gchar** standard_output, GError** error);
GsdSecureDeleteOperation* gsd_secure_delete_operation_construct (GType object_type);
GsdAsyncOperation* gsd_async_operation_construct (GType object_type);
void gsd_secure_delete_operation_set_fast (GsdSecureDeleteOperation* self, gboolean value);
void gsd_secure_delete_operation_set_mode (GsdSecureDeleteOperation* self, GsdSecureDeleteOperationMode value);
static void gsd_secure_delete_operation_finalize (GObject* obj);
static void _vala_gsd_secure_delete_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gsd_secure_delete_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/**
     * Security mode
     */
GType gsd_secure_delete_operation_mode_get_type (void) {
	static volatile gsize gsd_secure_delete_operation_mode_type_id__volatile = 0;
	if (g_once_init_enter (&gsd_secure_delete_operation_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{GSD_SECURE_DELETE_OPERATION_MODE_NORMAL, "GSD_SECURE_DELETE_OPERATION_MODE_NORMAL", "normal"}, {GSD_SECURE_DELETE_OPERATION_MODE_INSECURE, "GSD_SECURE_DELETE_OPERATION_MODE_INSECURE", "insecure"}, {GSD_SECURE_DELETE_OPERATION_MODE_VERY_INSECURE, "GSD_SECURE_DELETE_OPERATION_MODE_VERY_INSECURE", "very-insecure"}, {0, NULL, NULL}};
		GType gsd_secure_delete_operation_mode_type_id;
		gsd_secure_delete_operation_mode_type_id = g_enum_register_static ("GsdSecureDeleteOperationMode", values);
		g_once_init_leave (&gsd_secure_delete_operation_mode_type_id__volatile, gsd_secure_delete_operation_mode_type_id);
	}
	return gsd_secure_delete_operation_mode_type_id__volatile;
}


static const gchar* gsd_secure_delete_operation_get_argument_for_fast (GsdSecureDeleteOperation* self, gboolean fast) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (fast) {
		result = "-f";
		return result;
	}
	result = NULL;
	return result;
}


static void gsd_secure_delete_operation_add_fast_argument (GsdSecureDeleteOperation* self, GList** args) {
	const gchar* _tmp0_ = NULL;
	const gchar* arg_fast;
	g_return_if_fail (self != NULL);
	_tmp0_ = gsd_secure_delete_operation_get_argument_for_fast (self, self->priv->_fast);
	arg_fast = _tmp0_;
	if (arg_fast != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (arg_fast);
		*args = g_list_append (*args, _tmp1_);
	}
}


static const gchar* gsd_secure_delete_operation_get_argument_for_mode (GsdSecureDeleteOperation* self, GsdSecureDeleteOperationMode mode) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (mode) {
		case GSD_SECURE_DELETE_OPERATION_MODE_INSECURE:
		{
			result = "-l";
			return result;
		}
		case GSD_SECURE_DELETE_OPERATION_MODE_VERY_INSECURE:
		{
			result = "-ll";
			return result;
		}
		default:
		break;
	}
	result = NULL;
	return result;
}


static void gsd_secure_delete_operation_add_mode_argument (GsdSecureDeleteOperation* self, GList** args) {
	const gchar* _tmp0_ = NULL;
	const gchar* arg_mode;
	g_return_if_fail (self != NULL);
	_tmp0_ = gsd_secure_delete_operation_get_argument_for_mode (self, self->priv->_mode);
	arg_mode = _tmp0_;
	if (arg_mode != NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (arg_mode);
		*args = g_list_append (*args, _tmp1_);
	}
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static GList* gsd_secure_delete_operation_real_build_args (GsdAsyncOperation* base, GError** error) {
	GsdSecureDeleteOperation * self;
	GList* result = NULL;
	GList* args;
	gchar* _tmp0_;
	self = (GsdSecureDeleteOperation*) base;
	args = NULL;
	_tmp0_ = g_strdup ("-v");
	args = g_list_append (args, _tmp0_);
	gsd_secure_delete_operation_add_fast_argument (self, &args);
	gsd_secure_delete_operation_add_mode_argument (self, &args);
	result = args;
	return result;
}


static guint gsd_secure_delete_operation_real_get_max_progress (GsdAsyncOperation* base) {
	GsdSecureDeleteOperation * self;
	guint result = 0U;
	self = (GsdSecureDeleteOperation*) base;
	switch (self->priv->_mode) {
		case GSD_SECURE_DELETE_OPERATION_MODE_INSECURE:
		{
			result = (guint) 2;
			return result;
		}
		case GSD_SECURE_DELETE_OPERATION_MODE_VERY_INSECURE:
		{
			result = (guint) 1;
			return result;
		}
		default:
		{
			result = (guint) 38;
			return result;
		}
	}
}


static guint gsd_secure_delete_operation_real_get_progress (GsdAsyncOperation* base) {
	GsdSecureDeleteOperation * self;
	guint result = 0U;
	guint progress;
	guint _tmp0_;
	guint _tmp1_;
	GError * _inner_error_ = NULL;
	self = (GsdSecureDeleteOperation*) base;
	progress = (guint) 0;
	_tmp0_ = gsd_fd_count_ready_bytes (((GsdAsyncOperation*) self)->fd_out, (gint) '*', (gsize) 16, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == GSD_FD_ERROR) {
			goto __catch10_gsd_fd_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0U;
	}
	progress = _tmp1_;
	goto __finally10;
	__catch10_gsd_fd_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("gsd-secure-delete-operation.vala:145: Progression check failed: %s", e->message);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0U;
	}
	result = progress;
	return result;
}


/**
     * Runs a SecureDelete operator asynchronously.
     * 
     * @return whether operation started successfully.
     */
gboolean gsd_secure_delete_operation_run (GsdSecureDeleteOperation* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gsd_async_operation_run (GSD_ASYNC_OPERATION (self), NULL, 0, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


/**
     * Runs a SecureDelete operator synchronously.
     * 
     * @return whether operation was successful.
     */
gboolean gsd_secure_delete_operation_run_sync (GsdSecureDeleteOperation* self, GError** error) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gsd_async_operation_run_sync (GSD_ASYNC_OPERATION (self), NULL, G_SPAWN_STDOUT_TO_DEV_NULL, NULL, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == G_SPAWN_ERROR) || (_inner_error_->domain == GSD_ASYNC_OPERATION_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _tmp1_;
	return result;
}


GsdSecureDeleteOperation* gsd_secure_delete_operation_construct (GType object_type) {
	GsdSecureDeleteOperation * self = NULL;
	self = (GsdSecureDeleteOperation*) gsd_async_operation_construct (object_type);
	return self;
}


gboolean gsd_secure_delete_operation_get_fast (GsdSecureDeleteOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_fast;
	return result;
}


void gsd_secure_delete_operation_set_fast (GsdSecureDeleteOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_fast = value;
	g_object_notify ((GObject *) self, "fast");
}


GsdSecureDeleteOperationMode gsd_secure_delete_operation_get_mode (GsdSecureDeleteOperation* self) {
	GsdSecureDeleteOperationMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}


void gsd_secure_delete_operation_set_mode (GsdSecureDeleteOperation* self, GsdSecureDeleteOperationMode value) {
	g_return_if_fail (self != NULL);
	self->priv->_mode = value;
	g_object_notify ((GObject *) self, "mode");
}


static void gsd_secure_delete_operation_class_init (GsdSecureDeleteOperationClass * klass) {
	gsd_secure_delete_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GsdSecureDeleteOperationPrivate));
	GSD_ASYNC_OPERATION_CLASS (klass)->build_args = gsd_secure_delete_operation_real_build_args;
	GSD_ASYNC_OPERATION_CLASS (klass)->get_max_progress = gsd_secure_delete_operation_real_get_max_progress;
	GSD_ASYNC_OPERATION_CLASS (klass)->get_progress = gsd_secure_delete_operation_real_get_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_gsd_secure_delete_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gsd_secure_delete_operation_set_property;
	G_OBJECT_CLASS (klass)->finalize = gsd_secure_delete_operation_finalize;
	/**
	     * Whether to use fast (and insecure) work mode (-f option).
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_SECURE_DELETE_OPERATION_FAST, g_param_spec_boolean ("fast", "fast", "fast", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	     * The security mode
	     */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GSD_SECURE_DELETE_OPERATION_MODE, g_param_spec_enum ("mode", "mode", "mode", GSD_SECURE_DELETE_OPERATION_TYPE_MODE, GSD_SECURE_DELETE_OPERATION_MODE_NORMAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gsd_secure_delete_operation_instance_init (GsdSecureDeleteOperation * self) {
	self->priv = GSD_SECURE_DELETE_OPERATION_GET_PRIVATE (self);
	self->priv->_fast = FALSE;
	self->priv->_mode = GSD_SECURE_DELETE_OPERATION_MODE_NORMAL;
}


static void gsd_secure_delete_operation_finalize (GObject* obj) {
	GsdSecureDeleteOperation * self;
	self = GSD_SECURE_DELETE_OPERATION (obj);
	G_OBJECT_CLASS (gsd_secure_delete_operation_parent_class)->finalize (obj);
}


/**
   * An AsyncOperation subclass to implement SecureDelete operations.
   * 
   * This class implements everything that is shared by all SecureDelete
   * operators.
   */
GType gsd_secure_delete_operation_get_type (void) {
	static volatile gsize gsd_secure_delete_operation_type_id__volatile = 0;
	if (g_once_init_enter (&gsd_secure_delete_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GsdSecureDeleteOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gsd_secure_delete_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GsdSecureDeleteOperation), 0, (GInstanceInitFunc) gsd_secure_delete_operation_instance_init, NULL };
		GType gsd_secure_delete_operation_type_id;
		gsd_secure_delete_operation_type_id = g_type_register_static (GSD_TYPE_ASYNC_OPERATION, "GsdSecureDeleteOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&gsd_secure_delete_operation_type_id__volatile, gsd_secure_delete_operation_type_id);
	}
	return gsd_secure_delete_operation_type_id__volatile;
}


static void _vala_gsd_secure_delete_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GsdSecureDeleteOperation * self;
	self = GSD_SECURE_DELETE_OPERATION (object);
	switch (property_id) {
		case GSD_SECURE_DELETE_OPERATION_FAST:
		g_value_set_boolean (value, gsd_secure_delete_operation_get_fast (self));
		break;
		case GSD_SECURE_DELETE_OPERATION_MODE:
		g_value_set_enum (value, gsd_secure_delete_operation_get_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gsd_secure_delete_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GsdSecureDeleteOperation * self;
	self = GSD_SECURE_DELETE_OPERATION (object);
	switch (property_id) {
		case GSD_SECURE_DELETE_OPERATION_FAST:
		gsd_secure_delete_operation_set_fast (self, g_value_get_boolean (value));
		break;
		case GSD_SECURE_DELETE_OPERATION_MODE:
		gsd_secure_delete_operation_set_mode (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



