/* main.c generated by valac 0.12.0, the Vala compiler
 * generated from main.vala, do not modify */

/* 
 * 
 * Copyright (C) 2009-2011 Colomban Wendling <ban@herbesfolles.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#include <glib.h>
#include <glib-object.h>
#include <gsecuredelete.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TEST (test_get_type ())
#define TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST, Test))
#define TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST, TestClass))
#define IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST))
#define IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST))
#define TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST, TestClass))

typedef struct _Test Test;
typedef struct _TestClass TestClass;
typedef struct _TestPrivate TestPrivate;

#define TEST_TYPE_OPERATION (test_operation_get_type ())
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecTest ParamSpecTest;
#define _test_unref0(var) ((var == NULL) ? NULL : (var = (test_unref (var), NULL)))

struct _Test {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TestPrivate * priv;
};

struct _TestClass {
	GTypeClass parent_class;
	void (*finalize) (Test *self);
};

typedef GsdSecureDeleteOperation* (*TestOperationProvider) (gchar** args, int args_length1);
struct _TestPrivate {
	GMainLoop* main_loop;
	TestOperationProvider* operations;
	gint operations_length1;
	gint _operations_size_;
};

typedef enum  {
	TEST_OPERATION_DELETE,
	TEST_OPERATION_FILL,
	TEST_OPERATION_MEM,
	TEST_OPERATION_SWAP
} TestOperation;

struct _ParamSpecTest {
	GParamSpec parent_instance;
};


static gpointer test_parent_class = NULL;

gpointer test_ref (gpointer instance);
void test_unref (gpointer instance);
GParamSpec* param_spec_test (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_test (GValue* value, gpointer v_object);
void value_take_test (GValue* value, gpointer v_object);
gpointer value_get_test (const GValue* value);
GType test_get_type (void) G_GNUC_CONST;
#define TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TEST, TestPrivate))
enum  {
	TEST_DUMMY_PROPERTY
};
GType test_operation_get_type (void) G_GNUC_CONST;
static GsdSecureDeleteOperation* test_prepare_delop (gchar** args, int args_length1);
static GsdSecureDeleteOperation* _test_prepare_delop_test_operation_provider (gchar** args, int args_length1);
static GsdSecureDeleteOperation* test_prepare_fillop (gchar** args, int args_length1);
static GsdSecureDeleteOperation* _test_prepare_fillop_test_operation_provider (gchar** args, int args_length1);
static GsdSecureDeleteOperation* test_prepare_memop (gchar** args, int args_length1);
static GsdSecureDeleteOperation* _test_prepare_memop_test_operation_provider (gchar** args, int args_length1);
static GsdSecureDeleteOperation* test_prepare_swapop (gchar** args, int args_length1);
static GsdSecureDeleteOperation* _test_prepare_swapop_test_operation_provider (gchar** args, int args_length1);
Test* test_new (void);
Test* test_construct (GType object_type);
static void test_finished_handler (Test* self, gboolean success, const gchar* message);
static void test_progress_handler (gdouble progress);
gboolean test_run (Test* self, gchar** args, int args_length1, TestOperation operation);
static void _test_finished_handler_gsd_async_operation_finished (GsdAsyncOperation* _sender, gboolean success, const gchar* message, gpointer self);
static void _test_progress_handler_gsd_async_operation_progress (GsdAsyncOperation* _sender, gdouble fraction, gpointer self);
static void test_finalize (Test* obj);
gint _vala_main (gchar** args, int args_length1);


GType test_operation_get_type (void) {
	static volatile gsize test_operation_type_id__volatile = 0;
	if (g_once_init_enter (&test_operation_type_id__volatile)) {
		static const GEnumValue values[] = {{TEST_OPERATION_DELETE, "TEST_OPERATION_DELETE", "delete"}, {TEST_OPERATION_FILL, "TEST_OPERATION_FILL", "fill"}, {TEST_OPERATION_MEM, "TEST_OPERATION_MEM", "mem"}, {TEST_OPERATION_SWAP, "TEST_OPERATION_SWAP", "swap"}, {0, NULL, NULL}};
		GType test_operation_type_id;
		test_operation_type_id = g_enum_register_static ("TestOperation", values);
		g_once_init_leave (&test_operation_type_id__volatile, test_operation_type_id);
	}
	return test_operation_type_id__volatile;
}


static GsdSecureDeleteOperation* _test_prepare_delop_test_operation_provider (gchar** args, int args_length1) {
	GsdSecureDeleteOperation* result;
	result = test_prepare_delop (args, args_length1);
	return result;
}


static GsdSecureDeleteOperation* _test_prepare_fillop_test_operation_provider (gchar** args, int args_length1) {
	GsdSecureDeleteOperation* result;
	result = test_prepare_fillop (args, args_length1);
	return result;
}


static GsdSecureDeleteOperation* _test_prepare_memop_test_operation_provider (gchar** args, int args_length1) {
	GsdSecureDeleteOperation* result;
	result = test_prepare_memop (args, args_length1);
	return result;
}


static GsdSecureDeleteOperation* _test_prepare_swapop_test_operation_provider (gchar** args, int args_length1) {
	GsdSecureDeleteOperation* result;
	result = test_prepare_swapop (args, args_length1);
	return result;
}


Test* test_construct (GType object_type) {
	Test* self = NULL;
	GMainLoop* _tmp0_ = NULL;
	self = (Test*) g_type_create_instance (object_type);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp0_;
	return self;
}


Test* test_new (void) {
	return test_construct (TYPE_TEST);
}


static void test_finished_handler (Test* self, gboolean success, const gchar* message) {
	g_return_if_fail (self != NULL);
	if (success) {
		fprintf (stdout, "Success!\n");
	} else {
		fprintf (stderr, "Failure: %s\n", message);
	}
	g_main_loop_quit (self->priv->main_loop);
}


static void test_progress_handler (gdouble progress) {
	fprintf (stdout, "%.0f%%\n", progress * 100);
}


static GsdSecureDeleteOperation* test_prepare_delop (gchar** args, int args_length1) {
	GsdSecureDeleteOperation* result = NULL;
	GsdDeleteOperation* _tmp0_ = NULL;
	GsdDeleteOperation* op;
	GList* _tmp2_ = NULL;
	_tmp0_ = gsd_delete_operation_new ();
	op = _tmp0_;
	{
		gchar** arg_collection;
		int arg_collection_length1;
		int arg_it;
		arg_collection = args;
		arg_collection_length1 = args_length1;
		for (arg_it = 0; arg_it < args_length1; arg_it = arg_it + 1) {
			gchar* _tmp1_;
			gchar* arg;
			_tmp1_ = g_strdup (arg_collection[arg_it]);
			arg = _tmp1_;
			{
				if (g_strcmp0 (arg, args[0]) != 0) {
					gsd_delete_operation_add_path (op, arg);
				}
				_g_free0 (arg);
			}
		}
	}
	_tmp2_ = gsd_delete_operation_get_paths (op);
	{
		GList* i_collection;
		GList* i_it;
		i_collection = _tmp2_;
		for (i_it = i_collection; i_it != NULL; i_it = i_it->next) {
			gchar* _tmp3_;
			gchar* i;
			_tmp3_ = g_strdup ((const gchar*) i_it->data);
			i = _tmp3_;
			{
				fprintf (stdout, "Will delete: %s\n", i);
				_g_free0 (i);
			}
		}
	}
	result = (GsdSecureDeleteOperation*) op;
	return result;
}


static GsdSecureDeleteOperation* test_prepare_fillop (gchar** args, int args_length1) {
	GsdSecureDeleteOperation* result = NULL;
	GsdFillOperation* _tmp0_ = NULL;
	GsdFillOperation* op;
	_tmp0_ = gsd_fill_operation_new ();
	op = _tmp0_;
	if (args_length1 != 2) {
		result = NULL;
		_g_object_unref0 (op);
		return result;
	}
	gsd_fill_operation_set_directory (op, args[1]);
	result = (GsdSecureDeleteOperation*) op;
	return result;
}


static GsdSecureDeleteOperation* test_prepare_memop (gchar** args, int args_length1) {
	GsdSecureDeleteOperation* result = NULL;
	GsdMemOperation* _tmp0_ = NULL;
	GsdMemOperation* op;
	_tmp0_ = gsd_mem_operation_new ();
	op = _tmp0_;
	gsd_secure_delete_operation_set_mode ((GsdSecureDeleteOperation*) op, GSD_SECURE_DELETE_OPERATION_MODE_VERY_INSECURE);
	result = (GsdSecureDeleteOperation*) op;
	return result;
}


static GsdSecureDeleteOperation* test_prepare_swapop (gchar** args, int args_length1) {
	GsdSecureDeleteOperation* result = NULL;
	GsdSwapOperation* _tmp0_ = NULL;
	GsdSwapOperation* op;
	_tmp0_ = gsd_swap_operation_new ();
	op = _tmp0_;
	gsd_swap_operation_set_device (op, "/dev/sda1");
	gsd_secure_delete_operation_set_mode ((GsdSecureDeleteOperation*) op, GSD_SECURE_DELETE_OPERATION_MODE_INSECURE);
	result = (GsdSecureDeleteOperation*) op;
	return result;
}


static void _test_finished_handler_gsd_async_operation_finished (GsdAsyncOperation* _sender, gboolean success, const gchar* message, gpointer self) {
	test_finished_handler (self, success, message);
}


static void _test_progress_handler_gsd_async_operation_progress (GsdAsyncOperation* _sender, gdouble fraction, gpointer self) {
	test_progress_handler (fraction);
}


gboolean test_run (Test* self, gchar** args, int args_length1, TestOperation operation) {
	gboolean result = FALSE;
	GsdSecureDeleteOperation* _tmp0_ = NULL;
	GsdSecureDeleteOperation* op;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->operations[operation] (args, args_length1);
	op = _tmp0_;
	if (op == NULL) {
		result = FALSE;
		_g_object_unref0 (op);
		return result;
	}
	g_signal_connect ((GsdAsyncOperation*) op, "finished", (GCallback) _test_finished_handler_gsd_async_operation_finished, self);
	g_signal_connect ((GsdAsyncOperation*) op, "progress", (GCallback) _test_progress_handler_gsd_async_operation_progress, NULL);
	gsd_secure_delete_operation_run (op, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	g_main_loop_run (self->priv->main_loop);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "failed to start deletion: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (op);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_object_unref0 (op);
	return result;
}


static void value_test_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_test_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		test_unref (value->data[0].v_pointer);
	}
}


static void value_test_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = test_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_test_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_test_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Test* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = test_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_test_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Test** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = test_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_test (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTest* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TEST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_test (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST), NULL);
	return value->data[0].v_pointer;
}


void value_set_test (GValue* value, gpointer v_object) {
	Test* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		test_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_unref (old);
	}
}


void value_take_test (GValue* value, gpointer v_object) {
	Test* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		test_unref (old);
	}
}


static void test_class_init (TestClass * klass) {
	test_parent_class = g_type_class_peek_parent (klass);
	TEST_CLASS (klass)->finalize = test_finalize;
	g_type_class_add_private (klass, sizeof (TestPrivate));
}


static void test_instance_init (Test * self) {
	TestOperationProvider* _tmp0_ = NULL;
	self->priv = TEST_GET_PRIVATE (self);
	_tmp0_ = g_new0 (TestOperationProvider, 4);
	_tmp0_[0] = _test_prepare_delop_test_operation_provider;
	_tmp0_[1] = _test_prepare_fillop_test_operation_provider;
	_tmp0_[2] = _test_prepare_memop_test_operation_provider;
	_tmp0_[3] = _test_prepare_swapop_test_operation_provider;
	self->priv->operations = _tmp0_;
	self->priv->operations_length1 = 4;
	self->priv->_operations_size_ = self->priv->operations_length1;
	self->ref_count = 1;
}


static void test_finalize (Test* obj) {
	Test * self;
	gboolean _tmp0_;
	self = TEST (obj);
	_tmp0_ = g_main_loop_is_running (self->priv->main_loop);
	if (_tmp0_) {
		g_main_loop_quit (self->priv->main_loop);
	}
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->operations = (g_free (self->priv->operations), NULL);
}


GType test_get_type (void) {
	static volatile gsize test_type_id__volatile = 0;
	if (g_once_init_enter (&test_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_test_init, value_test_free_value, value_test_copy_value, value_test_peek_pointer, "p", value_test_collect_value, "p", value_test_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Test), 0, (GInstanceInitFunc) test_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType test_type_id;
		test_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Test", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&test_type_id__volatile, test_type_id);
	}
	return test_type_id__volatile;
}


gpointer test_ref (gpointer instance) {
	Test* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void test_unref (gpointer instance) {
	Test* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TEST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	Test* _tmp0_ = NULL;
	Test* test;
	gint _tmp1_ = 0;
	gboolean _tmp2_;
	_tmp0_ = test_new ();
	test = _tmp0_;
	_tmp2_ = test_run (test, args, args_length1, TEST_OPERATION_DELETE);
	if (_tmp2_) {
		_tmp1_ = 0;
	} else {
		_tmp1_ = 1;
	}
	result = _tmp1_;
	_test_unref0 (test);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



