/****************************************************************************
 **
 ** Copyright (C) Qxt Foundation. Some rights reserved.
 **
 ** This file is part of the QxtCore module of the Qxt library.
 **
 ** This library is free software; you can redistribute it and/or modify it
 ** under the terms of the Common Public License, version 1.0, as published
 ** by IBM, and/or under the terms of the GNU Lesser General Public License,
 ** version 2.1, as published by the Free Software Foundation.
 **
 ** This file is provided "AS IS", without WARRANTIES OR CONDITIONS OF ANY
 ** KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT LIMITATION, ANY
 ** WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT, MERCHANTABILITY OR
 ** FITNESS FOR A PARTICULAR PURPOSE.
 **
 ** You should have received a copy of the CPL and the LGPL along with this
 ** file. See the LICENSE file and the cpl1.0.txt/lgpl-2.1.txt files
 ** included with the source distribution for more information.
 ** If you did not receive a copy of the licenses, contact the Qxt Foundation.
 **
 ** <http://libqxt.org>  <foundation@libqxt.org>
 **
 ****************************************************************************/

//
// Generated on Fri Aug 14 00:10:57 2009
//  for Qt 4.5.2
//

#ifndef QXTLOCALE_DATA_P_H
#define QXTLOCALE_DATA_P_H
#include <QObject>
#include <QChar>
static const unsigned char two_letter_country_code_list[] =
"  " // Default
"AF" // Afghanistan
"AL" // Albania
"DZ" // Algeria
"AS" // AmericanSamoa
"AD" // Andorra
"AO" // Angola
"AI" // Anguilla
"AQ" // Antarctica
"AG" // AntiguaAndBarbuda
"AR" // Argentina
"AM" // Armenia
"AW" // Aruba
"AU" // Australia
"AT" // Austria
"AZ" // Azerbaijan
"BS" // Bahamas
"BH" // Bahrain
"BD" // Bangladesh
"BB" // Barbados
"BY" // Belarus
"BE" // Belgium
"BZ" // Belize
"BJ" // Benin
"BM" // Bermuda
"BT" // Bhutan
"BO" // Bolivia
"BA" // BosniaAndHerzegowina
"BW" // Botswana
"BV" // BouvetIsland
"BR" // Brazil
"IO" // BritishIndianOceanTerritory
"BN" // BruneiDarussalam
"BG" // Bulgaria
"BF" // BurkinaFaso
"BI" // Burundi
"KH" // Cambodia
"CM" // Cameroon
"CA" // Canada
"CV" // CapeVerde
"KY" // CaymanIslands
"CF" // CentralAfricanRepublic
"TD" // Chad
"CL" // Chile
"CN" // China
"CX" // ChristmasIsland
"CC" // CocosIslands
"CO" // Colombia
"KM" // Comoros
"CD" // DemocraticRepublicOfCongo
"CG" // PeoplesRepublicOfCongo
"CK" // CookIslands
"CR" // CostaRica
"CI" // IvoryCoast
"HR" // Croatia
"CU" // Cuba
"CY" // Cyprus
"CZ" // CzechRepublic
"DK" // Denmark
"DJ" // Djibouti
"DM" // Dominica
"DO" // DominicanRepublic
"TL" // EastTimor
"EC" // Ecuador
"EG" // Egypt
"SV" // ElSalvador
"GQ" // EquatorialGuinea
"ER" // Eritrea
"EE" // Estonia
"ET" // Ethiopia
"FK" // FalklandIslands
"FO" // FaroeIslands
"FJ" // Fiji
"FI" // Finland
"FR" // France
"FX" // MetropolitanFrance
"GF" // FrenchGuiana
"PF" // FrenchPolynesia
"TF" // FrenchSouthernTerritories
"GA" // Gabon
"GM" // Gambia
"GE" // Georgia
"DE" // Germany
"GH" // Ghana
"GI" // Gibraltar
"GR" // Greece
"GL" // Greenland
"GD" // Grenada
"GP" // Guadeloupe
"GU" // Guam
"GT" // Guatemala
"GN" // Guinea
"GW" // GuineaBissau
"GY" // Guyana
"HT" // Haiti
"HM" // HeardAndMcDonaldIslands
"HN" // Honduras
"HK" // HongKong
"HU" // Hungary
"IS" // Iceland
"IN" // India
"ID" // Indonesia
"IR" // Iran
"IQ" // Iraq
"IE" // Ireland
"IL" // Israel
"IT" // Italy
"JM" // Jamaica
"JP" // Japan
"JO" // Jordan
"KZ" // Kazakhstan
"KE" // Kenya
"KI" // Kiribati
"KP" // DemocraticRepublicOfKorea
"KR" // RepublicOfKorea
"KW" // Kuwait
"KG" // Kyrgyzstan
"LA" // Lao
"LV" // Latvia
"LB" // Lebanon
"LS" // Lesotho
"LR" // Liberia
"LY" // LibyanArabJamahiriya
"LI" // Liechtenstein
"LT" // Lithuania
"LU" // Luxembourg
"MO" // Macau
"MK" // Macedonia
"MG" // Madagascar
"MW" // Malawi
"MY" // Malaysia
"MV" // Maldives
"ML" // Mali
"MT" // Malta
"MH" // MarshallIslands
"MQ" // Martinique
"MR" // Mauritania
"MU" // Mauritius
"YT" // Mayotte
"MX" // Mexico
"FM" // Micronesia
"MD" // Moldova
"MC" // Monaco
"MN" // Mongolia
"MS" // Montserrat
"MA" // Morocco
"MZ" // Mozambique
"MM" // Myanmar
"NA" // Namibia
"NR" // Nauru
"NP" // Nepal
"NL" // Netherlands
"AN" // NetherlandsAntilles
"NC" // NewCaledonia
"NZ" // NewZealand
"NI" // Nicaragua
"NE" // Niger
"NG" // Nigeria
"NU" // Niue
"NF" // NorfolkIsland
"MP" // NorthernMarianaIslands
"NO" // Norway
"OM" // Oman
"PK" // Pakistan
"PW" // Palau
"PS" // PalestinianTerritory
"PA" // Panama
"PG" // PapuaNewGuinea
"PY" // Paraguay
"PE" // Peru
"PH" // Philippines
"PN" // Pitcairn
"PL" // Poland
"PT" // Portugal
"PR" // PuertoRico
"QA" // Qatar
"RE" // Reunion
"RO" // Romania
"RU" // RussianFederation
"RW" // Rwanda
"KN" // SaintKittsAndNevis
"LC" // StLucia
"VC" // StVincentAndTheGrenadines
"WS" // Samoa
"SM" // SanMarino
"ST" // SaoTomeAndPrincipe
"SA" // SaudiArabia
"SN" // Senegal
"SC" // Seychelles
"SL" // SierraLeone
"SG" // Singapore
"SK" // Slovakia
"SI" // Slovenia
"SB" // SolomonIslands
"SO" // Somalia
"ZA" // SouthAfrica
"GS" // SouthGeorgiaAndTheSouthSandwichIslands
"ES" // Spain
"LK" // SriLanka
"SH" // StHelena
"PM" // StPierreAndMiquelon
"SD" // Sudan
"SR" // Suriname
"SJ" // SvalbardAndJanMayenIslands
"SZ" // Swaziland
"SE" // Sweden
"CH" // Switzerland
"SY" // SyrianArabRepublic
"TW" // Taiwan
"TJ" // Tajikistan
"TZ" // Tanzania
"TH" // Thailand
"TG" // Togo
"TK" // Tokelau
"TO" // Tonga
"TT" // TrinidadAndTobago
"TN" // Tunisia
"TR" // Turkey
"TM" // Turkmenistan
"TC" // TurksAndCaicosIslands
"TV" // Tuvalu
"UG" // Uganda
"UA" // Ukraine
"AE" // UnitedArabEmirates
"GB" // UnitedKingdom
"US" // UnitedStates
"UM" // UnitedStatesMinorOutlyingIslands
"UY" // Uruguay
"UZ" // Uzbekistan
"VU" // Vanuatu
"VA" // VaticanCityState
"VE" // Venezuela
"VN" // VietNam
"VG" // BritishVirginIslands
"VI" // USVirginIslands
"WF" // WallisAndFutunaIslands
"EH" // WesternSahara
"YE" // Yemen
"YU" // Yugoslavia
"ZM" // Zambia
"ZW" // Zimbabwe
"CS" // SerbiaAndMontenegro
;
static const unsigned char three_letter_country_code_list[] =
"   " // Default
"AFG" // Afghanistan
"ALB" // Albania
"DZA" // Algeria
"ASM" // AmericanSamoa
"AND" // Andorra
"AGO" // Angola
"AIA" // Anguilla
"ATA" // Antarctica
"ATG" // AntiguaAndBarbuda
"ARG" // Argentina
"ARM" // Armenia
"ABW" // Aruba
"AUS" // Australia
"AUT" // Austria
"AZE" // Azerbaijan
"BHS" // Bahamas
"BHR" // Bahrain
"BGD" // Bangladesh
"BRB" // Barbados
"BLR" // Belarus
"BEL" // Belgium
"BLZ" // Belize
"BEN" // Benin
"BMU" // Bermuda
"BTN" // Bhutan
"BOL" // Bolivia
"BIH" // BosniaAndHerzegowina
"BWA" // Botswana
"BVT" // BouvetIsland
"BRA" // Brazil
"IOT" // BritishIndianOceanTerritory
"BRN" // BruneiDarussalam
"BGR" // Bulgaria
"BFA" // BurkinaFaso
"BDI" // Burundi
"KHM" // Cambodia
"CMR" // Cameroon
"CAN" // Canada
"CPV" // CapeVerde
"CYM" // CaymanIslands
"CAF" // CentralAfricanRepublic
"TCD" // Chad
"CHL" // Chile
"CHN" // China
"CXR" // ChristmasIsland
"CCK" // CocosIslands
"COL" // Colombia
"COM" // Comoros
"COD" // DemocraticRepublicOfCongo
"COG" // PeoplesRepublicOfCongo
"COK" // CookIslands
"CRI" // CostaRica
"CIV" // IvoryCoast
"HRV" // Croatia
"CUB" // Cuba
"CYP" // Cyprus
"CZE" // CzechRepublic
"DNK" // Denmark
"DJI" // Djibouti
"DMA" // Dominica
"DOM" // DominicanRepublic
"TLS" // EastTimor
"ECU" // Ecuador
"EGY" // Egypt
"SLV" // ElSalvador
"GNQ" // EquatorialGuinea
"ERI" // Eritrea
"EST" // Estonia
"ETH" // Ethiopia
"FLK" // FalklandIslands
"FRO" // FaroeIslands
"FJI" // Fiji
"FIN" // Finland
"FRA" // France
"FX." // MetropolitanFrance
"GUF" // FrenchGuiana
"PYF" // FrenchPolynesia
"ATF" // FrenchSouthernTerritories
"GAB" // Gabon
"GMB" // Gambia
"GEO" // Georgia
"DEU" // Germany
"GHA" // Ghana
"GIB" // Gibraltar
"GRC" // Greece
"GRL" // Greenland
"GRD" // Grenada
"GLP" // Guadeloupe
"GUM" // Guam
"GTM" // Guatemala
"GIN" // Guinea
"GNB" // GuineaBissau
"GUY" // Guyana
"HTI" // Haiti
"HMD" // HeardAndMcDonaldIslands
"HND" // Honduras
"HKG" // HongKong
"HUN" // Hungary
"ISL" // Iceland
"IND" // India
"IDN" // Indonesia
"IRN" // Iran
"IRQ" // Iraq
"IRL" // Ireland
"ISR" // Israel
"ITA" // Italy
"JAM" // Jamaica
"JPN" // Japan
"JOR" // Jordan
"KAZ" // Kazakhstan
"KEN" // Kenya
"KIR" // Kiribati
"PRK" // DemocraticRepublicOfKorea
"KOR" // RepublicOfKorea
"KWT" // Kuwait
"KGZ" // Kyrgyzstan
"LAO" // Lao
"LVA" // Latvia
"LBN" // Lebanon
"LSO" // Lesotho
"LBR" // Liberia
"LBY" // LibyanArabJamahiriya
"LIE" // Liechtenstein
"LTU" // Lithuania
"LUX" // Luxembourg
"MAC" // Macau
"MKD" // Macedonia
"MDG" // Madagascar
"MWI" // Malawi
"MYS" // Malaysia
"MDV" // Maldives
"MLI" // Mali
"MLT" // Malta
"MHL" // MarshallIslands
"MTQ" // Martinique
"MRT" // Mauritania
"MUS" // Mauritius
"MYT" // Mayotte
"MEX" // Mexico
"FSM" // Micronesia
"MDA" // Moldova
"MCO" // Monaco
"MNG" // Mongolia
"MSR" // Montserrat
"MAR" // Morocco
"MOZ" // Mozambique
"MMR" // Myanmar
"NAM" // Namibia
"NRU" // Nauru
"NPL" // Nepal
"NLD" // Netherlands
"ANT" // NetherlandsAntilles
"NCL" // NewCaledonia
"NZL" // NewZealand
"NIC" // Nicaragua
"NER" // Niger
"NGA" // Nigeria
"NIU" // Niue
"NFK" // NorfolkIsland
"MNP" // NorthernMarianaIslands
"NOR" // Norway
"OMN" // Oman
"PAK" // Pakistan
"PLW" // Palau
"PSE" // PalestinianTerritory
"PAN" // Panama
"PNG" // PapuaNewGuinea
"PRY" // Paraguay
"PER" // Peru
"PHL" // Philippines
"PCN" // Pitcairn
"POL" // Poland
"PRT" // Portugal
"PRI" // PuertoRico
"QAT" // Qatar
"REU" // Reunion
"ROU" // Romania
"RUS" // RussianFederation
"RWA" // Rwanda
"KNA" // SaintKittsAndNevis
"LCA" // StLucia
"VCT" // StVincentAndTheGrenadines
"WSM" // Samoa
"SMR" // SanMarino
"STP" // SaoTomeAndPrincipe
"SAU" // SaudiArabia
"SEN" // Senegal
"SYC" // Seychelles
"SLE" // SierraLeone
"SGP" // Singapore
"SVK" // Slovakia
"SVN" // Slovenia
"SLB" // SolomonIslands
"SOM" // Somalia
"ZAF" // SouthAfrica
"SGS" // SouthGeorgiaAndTheSouthSandwichIslands
"ESP" // Spain
"LKA" // SriLanka
"SHN" // StHelena
"SPM" // StPierreAndMiquelon
"SDN" // Sudan
"SUR" // Suriname
"SJM" // SvalbardAndJanMayenIslands
"SWZ" // Swaziland
"SWE" // Sweden
"CHE" // Switzerland
"SYR" // SyrianArabRepublic
"TWN" // Taiwan
"TJK" // Tajikistan
"TZA" // Tanzania
"THA" // Thailand
"TGO" // Togo
"TKL" // Tokelau
"TON" // Tonga
"TTO" // TrinidadAndTobago
"TUN" // Tunisia
"TUR" // Turkey
"TKM" // Turkmenistan
"TCA" // TurksAndCaicosIslands
"TUV" // Tuvalu
"UGA" // Uganda
"UKR" // Ukraine
"ARE" // UnitedArabEmirates
"GBR" // UnitedKingdom
"USA" // UnitedStates
"UMI" // UnitedStatesMinorOutlyingIslands
"URY" // Uruguay
"UZB" // Uzbekistan
"VUT" // Vanuatu
"VAT" // VaticanCityState
"VEN" // Venezuela
"VNM" // VietNam
"VGB" // BritishVirginIslands
"VIR" // USVirginIslands
"WLF" // WallisAndFutunaIslands
"ESH" // WesternSahara
"YEM" // Yemen
"YUG" // Yugoslavia
"ZMB" // Zambia
"ZWE" // Zimbabwe
"SRB" // SerbiaAndMontenegro
;
static QxtLocale::Currency currency_for_country_list[] = {
 QxtLocale::NoCurrency, // Default
 QxtLocale::Afghani, // Afghanistan
 QxtLocale::Lek, // Albania
 QxtLocale::AlgerianDinar, // Algeria
 QxtLocale::USDollar, // AmericanSamoa
 QxtLocale::Euro, // Andorra
 QxtLocale::Kwanza, // Angola
 QxtLocale::EastCaribbeanDollar, // Anguilla
 QxtLocale::NoCurrency, // Antarctica
 QxtLocale::EastCaribbeanDollar, // AntiguaAndBarbuda
 QxtLocale::ArgentinePeso, // Argentina
 QxtLocale::ArmenianDram, // Armenia
 QxtLocale::ArubanGuilder, // Aruba
 QxtLocale::AustralianDollar, // Australia
 QxtLocale::Euro, // Austria
 QxtLocale::AzerbaijanianManat, // Azerbaijan
 QxtLocale::BahamianDollar, // Bahamas
 QxtLocale::BahrainiDinar, // Bahrain
 QxtLocale::Taka, // Bangladesh
 QxtLocale::BarbadosDollar, // Barbados
 QxtLocale::BelarussianRuble, // Belarus
 QxtLocale::Euro, // Belgium
 QxtLocale::BelizeDollar, // Belize
 QxtLocale::CFAFrancBCEAO, // Benin
 QxtLocale::BermudianDollar, // Bermuda
 QxtLocale::IndianRupee, // Bhutan
 QxtLocale::Boliviano, // Bolivia
 QxtLocale::ConvertibleMarks, // BosniaAndHerzegowina
 QxtLocale::Pula, // Botswana
 QxtLocale::NorwegianKrone, // BouvetIsland
 QxtLocale::BrazilianReal, // Brazil
 QxtLocale::USDollar, // BritishIndianOceanTerritory
 QxtLocale::BruneiDollar, // BruneiDarussalam
 QxtLocale::BulgarianLev, // Bulgaria
 QxtLocale::CFAFrancBCEAO, // BurkinaFaso
 QxtLocale::BurundiFranc, // Burundi
 QxtLocale::Riel, // Cambodia
 QxtLocale::CFAFrancBEAC, // Cameroon
 QxtLocale::CanadianDollar, // Canada
 QxtLocale::CapeVerdeEscudo, // CapeVerde
 QxtLocale::CaymanIslandsDollar, // CaymanIslands
 QxtLocale::CFAFrancBEAC, // CentralAfricanRepublic
 QxtLocale::CFAFrancBEAC, // Chad
 QxtLocale::ChileanPeso, // Chile
 QxtLocale::YuanRenminbi, // China
 QxtLocale::AustralianDollar, // ChristmasIsland
 QxtLocale::AustralianDollar, // CocosIslands
 QxtLocale::ColombianPeso, // Colombia
 QxtLocale::ComoroFranc, // Comoros
 QxtLocale::CFAFrancBEAC, // DemocraticRepublicOfCongo
 QxtLocale::CFAFrancBEAC, // PeoplesRepublicOfCongo
 QxtLocale::NewZealandDollar, // CookIslands
 QxtLocale::CostaRicanColon, // CostaRica
 QxtLocale::CFAFrancBCEAO, // IvoryCoast
 QxtLocale::CroatianKuna, // Croatia
 QxtLocale::CubanPeso, // Cuba
 QxtLocale::CyprusPound, // Cyprus
 QxtLocale::CzechKoruna, // CzechRepublic
 QxtLocale::DanishKrone, // Denmark
 QxtLocale::DjiboutiFranc, // Djibouti
 QxtLocale::EastCaribbeanDollar, // Dominica
 QxtLocale::EastCaribbeanDollar, // DominicanRepublic
 QxtLocale::USDollar, // EastTimor
 QxtLocale::USDollar, // Ecuador
 QxtLocale::EgyptianPound, // Egypt
 QxtLocale::ElSalvadorColon, // ElSalvador
 QxtLocale::CFAFrancBEAC, // EquatorialGuinea
 QxtLocale::Nakfa, // Eritrea
 QxtLocale::Kroon, // Estonia
 QxtLocale::EthiopianBirr, // Ethiopia
 QxtLocale::FalklandIslandsPound, // FalklandIslands
 QxtLocale::DanishKrone, // FaroeIslands
 QxtLocale::FijiDollar, // Fiji
 QxtLocale::Euro, // Finland
 QxtLocale::Euro, // France
 QxtLocale::Euro, // MetropolitanFrance
 QxtLocale::Euro, // FrenchGuiana
 QxtLocale::CFPFranc, // FrenchPolynesia
 QxtLocale::Euro, // FrenchSouthernTerritories
 QxtLocale::CFAFrancBEAC, // Gabon
 QxtLocale::Dalasi, // Gambia
 QxtLocale::Lari, // Georgia
 QxtLocale::Euro, // Germany
 QxtLocale::GhanaCedi, // Ghana
 QxtLocale::GibraltarPound, // Gibraltar
 QxtLocale::Euro, // Greece
 QxtLocale::DanishKrone, // Greenland
 QxtLocale::EastCaribbeanDollar, // Grenada
 QxtLocale::Euro, // Guadeloupe
 QxtLocale::USDollar, // Guam
 QxtLocale::Quetzal, // Guatemala
 QxtLocale::CFAFrancBEAC, // Guinea
 QxtLocale::GuineaFranc, // GuineaBissau
 QxtLocale::GuyanaDollar, // Guyana
 QxtLocale::Gourde, // Haiti
 QxtLocale::AustralianDollar, // HeardAndMcDonaldIslands
 QxtLocale::Lempira, // Honduras
 QxtLocale::HongKongDollar, // HongKong
 QxtLocale::Forint, // Hungary
 QxtLocale::IcelandKrona, // Iceland
 QxtLocale::IndianRupee, // India
 QxtLocale::Rupiah, // Indonesia
 QxtLocale::IranianRial, // Iran
 QxtLocale::IraqiDinar, // Iraq
 QxtLocale::Euro, // Ireland
 QxtLocale::NewIsraeliSheqel, // Israel
 QxtLocale::Euro, // Italy
 QxtLocale::JamaicanDollar, // Jamaica
 QxtLocale::Yen, // Japan
 QxtLocale::JordanianDinar, // Jordan
 QxtLocale::Tenge, // Kazakhstan
 QxtLocale::KenyanShilling, // Kenya
 QxtLocale::AustralianDollar, // Kiribati
 QxtLocale::Won, // DemocraticRepublicOfKorea
 QxtLocale::NorthKoreanWon, // RepublicOfKorea
 QxtLocale::KuwaitiDinar, // Kuwait
 QxtLocale::Som, // Kyrgyzstan
 QxtLocale::Kip, // Lao
 QxtLocale::LatvianLats, // Latvia
 QxtLocale::LebanesePound, // Lebanon
 QxtLocale::Rand, // Lesotho
 QxtLocale::LiberianDollar, // Liberia
 QxtLocale::LibyanDinar, // LibyanArabJamahiriya
 QxtLocale::SwissFranc, // Liechtenstein
 QxtLocale::LithuanianLitas, // Lithuania
 QxtLocale::Euro, // Luxembourg
 QxtLocale::Pataca, // Macau
 QxtLocale::Denar, // Macedonia
 QxtLocale::MalagasyAriary, // Madagascar
 QxtLocale::MalawiKwacha, // Malawi
 QxtLocale::MalaysianRinggit, // Malaysia
 QxtLocale::Rufiyaa, // Maldives
 QxtLocale::CFAFrancBCEAO, // Mali
 QxtLocale::MalteseLira, // Malta
 QxtLocale::USDollar, // MarshallIslands
 QxtLocale::Euro, // Martinique
 QxtLocale::Ouguiya, // Mauritania
 QxtLocale::MauritiusRupee, // Mauritius
 QxtLocale::Euro, // Mayotte
 QxtLocale::MexicanPeso, // Mexico
 QxtLocale::USDollar, // Micronesia
 QxtLocale::MoldovanLeu, // Moldova
 QxtLocale::Euro, // Monaco
 QxtLocale::Tugrik, // Mongolia
 QxtLocale::EastCaribbeanDollar, // Montserrat
 QxtLocale::MoroccanDirham, // Morocco
 QxtLocale::Metical, // Mozambique
 QxtLocale::Kyat, // Myanmar
 QxtLocale::Rand, // Namibia
 QxtLocale::AustralianDollar, // Nauru
 QxtLocale::NepaleseRupee, // Nepal
 QxtLocale::Euro, // Netherlands
 QxtLocale::Euro, // NetherlandsAntilles
 QxtLocale::CFPFranc, // NewCaledonia
 QxtLocale::NewZealandDollar, // NewZealand
 QxtLocale::CordobaOro, // Nicaragua
 QxtLocale::CFAFrancBCEAO, // Niger
 QxtLocale::CFAFrancBCEAO, // Nigeria
 QxtLocale::NewZealandDollar, // Niue
 QxtLocale::AustralianDollar, // NorfolkIsland
 QxtLocale::USDollar, // NorthernMarianaIslands
 QxtLocale::NorwegianKrone, // Norway
 QxtLocale::RialOmani, // Oman
 QxtLocale::PakistanRupee, // Pakistan
 QxtLocale::USDollar, // Palau
 QxtLocale::NewIsraeliSheqel, // PalestinianTerritory
 QxtLocale::Balboa, // Panama
 QxtLocale::GuineaFranc, // PapuaNewGuinea
 QxtLocale::Guarani, // Paraguay
 QxtLocale::NuevoSol, // Peru
 QxtLocale::PhilippinePeso, // Philippines
 QxtLocale::NewZealandDollar, // Pitcairn
 QxtLocale::Zloty, // Poland
 QxtLocale::Euro, // Portugal
 QxtLocale::USDollar, // PuertoRico
 QxtLocale::QatariRial, // Qatar
 QxtLocale::Euro, // Reunion
 QxtLocale::NewLeu, // Romania
 QxtLocale::RussianRuble, // RussianFederation
 QxtLocale::RwandaFranc, // Rwanda
 QxtLocale::EastCaribbeanDollar, // SaintKittsAndNevis
 QxtLocale::EastCaribbeanDollar, // StLucia
 QxtLocale::EastCaribbeanDollar, // StVincentAndTheGrenadines
 QxtLocale::USDollar, // Samoa
 QxtLocale::Euro, // SanMarino
 QxtLocale::Dobra, // SaoTomeAndPrincipe
 QxtLocale::SaudiRiyal, // SaudiArabia
 QxtLocale::CFAFrancBCEAO, // Senegal
 QxtLocale::SeychellesRupee, // Seychelles
 QxtLocale::Leone, // SierraLeone
 QxtLocale::SingaporeDollar, // Singapore
 QxtLocale::SlovakKoruna, // Slovakia
 QxtLocale::Euro, // Slovenia
 QxtLocale::SolomonIslandsDollar, // SolomonIslands
 QxtLocale::SomaliShilling, // Somalia
 QxtLocale::Rand, // SouthAfrica
 QxtLocale::PoundSterling, // SouthGeorgiaAndTheSouthSandwichIslands
 QxtLocale::Euro, // Spain
 QxtLocale::SriLankaRupee, // SriLanka
 QxtLocale::SaintHelenaPound, // StHelena
 QxtLocale::Euro, // StPierreAndMiquelon
 QxtLocale::SudanesePound, // Sudan
 QxtLocale::SurinamDollar, // Suriname
 QxtLocale::NorwegianKrone, // SvalbardAndJanMayenIslands
 QxtLocale::Lilangeni, // Swaziland
 QxtLocale::SwedishKrona, // Sweden
 QxtLocale::SwissFranc, // Switzerland
 QxtLocale::SyrianPound, // SyrianArabRepublic
 QxtLocale::NewTaiwanDollar, // Taiwan
 QxtLocale::Somoni, // Tajikistan
 QxtLocale::TanzanianShilling, // Tanzania
 QxtLocale::Baht, // Thailand
 QxtLocale::CFAFrancBCEAO, // Togo
 QxtLocale::NewZealandDollar, // Tokelau
 QxtLocale::Paanga, // Tonga
 QxtLocale::TrinidadAndTobagoDollar, // TrinidadAndTobago
 QxtLocale::TunisianDinar, // Tunisia
 QxtLocale::NewTurkishLira, // Turkey
 QxtLocale::Manat, // Turkmenistan
 QxtLocale::USDollar, // TurksAndCaicosIslands
 QxtLocale::AustralianDollar, // Tuvalu
 QxtLocale::UgandaShilling, // Uganda
 QxtLocale::Hryvnia, // Ukraine
 QxtLocale::UAEDirham, // UnitedArabEmirates
 QxtLocale::PoundSterling, // UnitedKingdom
 QxtLocale::USDollar, // UnitedStates
 QxtLocale::USDollar, // UnitedStatesMinorOutlyingIslands
 QxtLocale::PesoUruguayo, // Uruguay
 QxtLocale::UzbekistanSum, // Uzbekistan
 QxtLocale::Vatu, // Vanuatu
 QxtLocale::Euro, // VaticanCityState
 QxtLocale::BolivarFuerte, // Venezuela
 QxtLocale::Dong, // VietNam
 QxtLocale::USDollar, // BritishVirginIslands
 QxtLocale::USDollar, // USVirginIslands
 QxtLocale::CFPFranc, // WallisAndFutunaIslands
 QxtLocale::MoroccanDirham, // WesternSahara
 QxtLocale::YemeniRial, // Yemen
 QxtLocale::NoCurrency, // Yugoslavia
 QxtLocale::ZambiaKwacha, // Zambia
 QxtLocale::ZimbabweDollar, // Zimbabwe
};
static const char* currency_names[] = {
  QT_TRANSLATE_NOOP("QxtLocale", "*No Currency*"), // NoCurrency
  QT_TRANSLATE_NOOP("QxtLocale", "Afghani"), // Afghani
  QT_TRANSLATE_NOOP("QxtLocale", "Algerian Dinar"), // AlgerianDinar
  QT_TRANSLATE_NOOP("QxtLocale", "Argentine Peso"), // ArgentinePeso
  QT_TRANSLATE_NOOP("QxtLocale", "Armenian Dram"), // ArmenianDram
  QT_TRANSLATE_NOOP("QxtLocale", "Aruban Guilder"), // ArubanGuilder
  QT_TRANSLATE_NOOP("QxtLocale", "Australian Dollar"), // AustralianDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Azerbaijanian Manat"), // AzerbaijanianManat
  QT_TRANSLATE_NOOP("QxtLocale", "Bahamian Dollar"), // BahamianDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Bahraini Dinar"), // BahrainiDinar
  QT_TRANSLATE_NOOP("QxtLocale", "Baht"), // Baht
  QT_TRANSLATE_NOOP("QxtLocale", "Balboa"), // Balboa
  QT_TRANSLATE_NOOP("QxtLocale", "Barbados Dollar"), // BarbadosDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Belarussian Ruble"), // BelarussianRuble
  QT_TRANSLATE_NOOP("QxtLocale", "Belize Dollar"), // BelizeDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Bermudian Dollar"), // BermudianDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Bolivar Fuerte"), // BolivarFuerte
  QT_TRANSLATE_NOOP("QxtLocale", "Boliviano"), // Boliviano
  QT_TRANSLATE_NOOP("QxtLocale", "Brazilian Real"), // BrazilianReal
  QT_TRANSLATE_NOOP("QxtLocale", "Brunei Dollar"), // BruneiDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Bulgarian Lev"), // BulgarianLev
  QT_TRANSLATE_NOOP("QxtLocale", "Burundi Franc"), // BurundiFranc
  QT_TRANSLATE_NOOP("QxtLocale", "CFA Franc BCEAO"), // CFAFrancBCEAO
  QT_TRANSLATE_NOOP("QxtLocale", "CFA Franc BEAC"), // CFAFrancBEAC
  QT_TRANSLATE_NOOP("QxtLocale", "CFP Franc"), // CFPFranc
  QT_TRANSLATE_NOOP("QxtLocale", "Canadian Dollar"), // CanadianDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Cape Verde Escudo"), // CapeVerdeEscudo
  QT_TRANSLATE_NOOP("QxtLocale", "Cayman Islands Dollar"), // CaymanIslandsDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Chilean Peso"), // ChileanPeso
  QT_TRANSLATE_NOOP("QxtLocale", "Colombian Peso"), // ColombianPeso
  QT_TRANSLATE_NOOP("QxtLocale", "Comoro Franc"), // ComoroFranc
  QT_TRANSLATE_NOOP("QxtLocale", "Convertible Marks"), // ConvertibleMarks
  QT_TRANSLATE_NOOP("QxtLocale", "Cordoba Oro"), // CordobaOro
  QT_TRANSLATE_NOOP("QxtLocale", "Costa Rican Colon"), // CostaRicanColon
  QT_TRANSLATE_NOOP("QxtLocale", "Croatian Kuna"), // CroatianKuna
  QT_TRANSLATE_NOOP("QxtLocale", "Cuban Peso"), // CubanPeso
  QT_TRANSLATE_NOOP("QxtLocale", "Cyprus Pound"), // CyprusPound
  QT_TRANSLATE_NOOP("QxtLocale", "Czech Koruna"), // CzechKoruna
  QT_TRANSLATE_NOOP("QxtLocale", "Dalasi"), // Dalasi
  QT_TRANSLATE_NOOP("QxtLocale", "Danish Krone"), // DanishKrone
  QT_TRANSLATE_NOOP("QxtLocale", "Denar"), // Denar
  QT_TRANSLATE_NOOP("QxtLocale", "Djibouti Franc"), // DjiboutiFranc
  QT_TRANSLATE_NOOP("QxtLocale", "Dobra"), // Dobra
  QT_TRANSLATE_NOOP("QxtLocale", "Dominican Peso"), // DominicanPeso
  QT_TRANSLATE_NOOP("QxtLocale", "Dong"), // Dong
  QT_TRANSLATE_NOOP("QxtLocale", "East Caribbean Dollar"), // EastCaribbeanDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Egyptian Pound"), // EgyptianPound
  QT_TRANSLATE_NOOP("QxtLocale", "El Salvador Colon"), // ElSalvadorColon
  QT_TRANSLATE_NOOP("QxtLocale", "Ethiopian Birr"), // EthiopianBirr
  QT_TRANSLATE_NOOP("QxtLocale", "Euro"), // Euro
  QT_TRANSLATE_NOOP("QxtLocale", "Falkland Islands Pound"), // FalklandIslandsPound
  QT_TRANSLATE_NOOP("QxtLocale", "Fiji Dollar"), // FijiDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Forint"), // Forint
  QT_TRANSLATE_NOOP("QxtLocale", "Franc Congolais"), // FrancCongolais
  QT_TRANSLATE_NOOP("QxtLocale", "Ghana Cedi"), // GhanaCedi
  QT_TRANSLATE_NOOP("QxtLocale", "Gibraltar Pound"), // GibraltarPound
  QT_TRANSLATE_NOOP("QxtLocale", "Gourde"), // Gourde
  QT_TRANSLATE_NOOP("QxtLocale", "Guarani"), // Guarani
  QT_TRANSLATE_NOOP("QxtLocale", "Guinea-Bissau Peso"), // GuineaBissauPeso
  QT_TRANSLATE_NOOP("QxtLocale", "Guinea Franc"), // GuineaFranc
  QT_TRANSLATE_NOOP("QxtLocale", "Guyana Dollar"), // GuyanaDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Hong Kong Dollar"), // HongKongDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Hryvnia"), // Hryvnia
  QT_TRANSLATE_NOOP("QxtLocale", "Iceland Krona"), // IcelandKrona
  QT_TRANSLATE_NOOP("QxtLocale", "Indian Rupee"), // IndianRupee
  QT_TRANSLATE_NOOP("QxtLocale", "Iranian Rial"), // IranianRial
  QT_TRANSLATE_NOOP("QxtLocale", "Iraqi Dinar"), // IraqiDinar
  QT_TRANSLATE_NOOP("QxtLocale", "Jamaican Dollar"), // JamaicanDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Jordanian Dinar"), // JordanianDinar
  QT_TRANSLATE_NOOP("QxtLocale", "Kenyan Shilling"), // KenyanShilling
  QT_TRANSLATE_NOOP("QxtLocale", "Kina"), // Kina
  QT_TRANSLATE_NOOP("QxtLocale", "Kip"), // Kip
  QT_TRANSLATE_NOOP("QxtLocale", "Kroon"), // Kroon
  QT_TRANSLATE_NOOP("QxtLocale", "Kuwaiti Dinar"), // KuwaitiDinar
  QT_TRANSLATE_NOOP("QxtLocale", "Kwanza"), // Kwanza
  QT_TRANSLATE_NOOP("QxtLocale", "Kyat"), // Kyat
  QT_TRANSLATE_NOOP("QxtLocale", "Lari"), // Lari
  QT_TRANSLATE_NOOP("QxtLocale", "Latvian Lats"), // LatvianLats
  QT_TRANSLATE_NOOP("QxtLocale", "Lebanese Pound"), // LebanesePound
  QT_TRANSLATE_NOOP("QxtLocale", "Lek"), // Lek
  QT_TRANSLATE_NOOP("QxtLocale", "Lempira"), // Lempira
  QT_TRANSLATE_NOOP("QxtLocale", "Leone"), // Leone
  QT_TRANSLATE_NOOP("QxtLocale", "Liberian Dollar"), // LiberianDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Libyan Dinar"), // LibyanDinar
  QT_TRANSLATE_NOOP("QxtLocale", "Lilangeni"), // Lilangeni
  QT_TRANSLATE_NOOP("QxtLocale", "Lithuanian Litas"), // LithuanianLitas
  QT_TRANSLATE_NOOP("QxtLocale", "Loti"), // Loti
  QT_TRANSLATE_NOOP("QxtLocale", "Malagasy Ariary"), // MalagasyAriary
  QT_TRANSLATE_NOOP("QxtLocale", "MalawiKwacha"), // MalawiKwacha
  QT_TRANSLATE_NOOP("QxtLocale", "Malaysian Ringgit"), // MalaysianRinggit
  QT_TRANSLATE_NOOP("QxtLocale", "Maltese Lira"), // MalteseLira
  QT_TRANSLATE_NOOP("QxtLocale", "Manat"), // Manat
  QT_TRANSLATE_NOOP("QxtLocale", "Mauritius Rupee"), // MauritiusRupee
  QT_TRANSLATE_NOOP("QxtLocale", "Metical"), // Metical
  QT_TRANSLATE_NOOP("QxtLocale", "Mexican Peso"), // MexicanPeso
  QT_TRANSLATE_NOOP("QxtLocale", "Mexican Unidad de Inversion"), // MexicanUnidadDeInversion
  QT_TRANSLATE_NOOP("QxtLocale", "Moldovan Leu"), // MoldovanLeu
  QT_TRANSLATE_NOOP("QxtLocale", "Moroccan Dirham"), // MoroccanDirham
  QT_TRANSLATE_NOOP("QxtLocale", "Mvdol"), // Mvdol
  QT_TRANSLATE_NOOP("QxtLocale", "Naira"), // Naira
  QT_TRANSLATE_NOOP("QxtLocale", "Nakfa"), // Nakfa
  QT_TRANSLATE_NOOP("QxtLocale", "Namibia Dollar"), // NamibiaDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Nepalese Rupee"), // NepaleseRupee
  QT_TRANSLATE_NOOP("QxtLocale", "Netherlands Antillian Guilder"), // NetherlandsAntillianGuilder
  QT_TRANSLATE_NOOP("QxtLocale", "New Israeli Sheqel"), // NewIsraeliSheqel
  QT_TRANSLATE_NOOP("QxtLocale", "New Leu"), // NewLeu
  QT_TRANSLATE_NOOP("QxtLocale", "New Taiwan Dollar"), // NewTaiwanDollar
  QT_TRANSLATE_NOOP("QxtLocale", "New Turkish Lira"), // NewTurkishLira
  QT_TRANSLATE_NOOP("QxtLocale", "New Zealand Dollar"), // NewZealandDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Ngultrum"), // Ngultrum
  QT_TRANSLATE_NOOP("QxtLocale", "North Korean Won"), // NorthKoreanWon
  QT_TRANSLATE_NOOP("QxtLocale", "Norwegian Krone"), // NorwegianKrone
  QT_TRANSLATE_NOOP("QxtLocale", "Nuevo Sol"), // NuevoSol
  QT_TRANSLATE_NOOP("QxtLocale", "Ouguiya"), // Ouguiya
  QT_TRANSLATE_NOOP("QxtLocale", "Pa'anga"), // Paanga
  QT_TRANSLATE_NOOP("QxtLocale", "Pakistan Rupee"), // PakistanRupee
  QT_TRANSLATE_NOOP("QxtLocale", "Pataca"), // Pataca
  QT_TRANSLATE_NOOP("QxtLocale", "Peso Uruguayo"), // PesoUruguayo
  QT_TRANSLATE_NOOP("QxtLocale", "Philippine Peso"), // PhilippinePeso
  QT_TRANSLATE_NOOP("QxtLocale", "Pound Sterling"), // PoundSterling
  QT_TRANSLATE_NOOP("QxtLocale", "Pula"), // Pula
  QT_TRANSLATE_NOOP("QxtLocale", "Qatari Rial"), // QatariRial
  QT_TRANSLATE_NOOP("QxtLocale", "Quetzal"), // Quetzal
  QT_TRANSLATE_NOOP("QxtLocale", "Rand"), // Rand
  QT_TRANSLATE_NOOP("QxtLocale", "Rial Omani"), // RialOmani
  QT_TRANSLATE_NOOP("QxtLocale", "Riel"), // Riel
  QT_TRANSLATE_NOOP("QxtLocale", "Rufiyaa"), // Rufiyaa
  QT_TRANSLATE_NOOP("QxtLocale", "Rupiah"), // Rupiah
  QT_TRANSLATE_NOOP("QxtLocale", "Russian Ruble"), // RussianRuble
  QT_TRANSLATE_NOOP("QxtLocale", "Rwanda Franc"), // RwandaFranc
  QT_TRANSLATE_NOOP("QxtLocale", "Saint Helena Pound"), // SaintHelenaPound
  QT_TRANSLATE_NOOP("QxtLocale", "Saudi Riyal"), // SaudiRiyal
  QT_TRANSLATE_NOOP("QxtLocale", "Serbian Dinar"), // SerbianDinar
  QT_TRANSLATE_NOOP("QxtLocale", "Seychelles Rupee"), // SeychellesRupee
  QT_TRANSLATE_NOOP("QxtLocale", "Singapore Dollar"), // SingaporeDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Slovak Koruna"), // SlovakKoruna
  QT_TRANSLATE_NOOP("QxtLocale", "Solomon Islands Dollar"), // SolomonIslandsDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Som"), // Som
  QT_TRANSLATE_NOOP("QxtLocale", "Somali Shilling"), // SomaliShilling
  QT_TRANSLATE_NOOP("QxtLocale", "Somoni"), // Somoni
  QT_TRANSLATE_NOOP("QxtLocale", "Sri Lanka Rupee"), // SriLankaRupee
  QT_TRANSLATE_NOOP("QxtLocale", "Sudanese Pound"), // SudanesePound
  QT_TRANSLATE_NOOP("QxtLocale", "Surinam Dollar"), // SurinamDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Swedish Krona"), // SwedishKrona
  QT_TRANSLATE_NOOP("QxtLocale", "Swiss Franc"), // SwissFranc
  QT_TRANSLATE_NOOP("QxtLocale", "Syrian Pound"), // SyrianPound
  QT_TRANSLATE_NOOP("QxtLocale", "Taka"), // Taka
  QT_TRANSLATE_NOOP("QxtLocale", "Tala"), // Tala
  QT_TRANSLATE_NOOP("QxtLocale", "Tanzanian Shilling"), // TanzanianShilling
  QT_TRANSLATE_NOOP("QxtLocale", "Tenge"), // Tenge
  QT_TRANSLATE_NOOP("QxtLocale", "Trinidad and Tobago Dollar"), // TrinidadAndTobagoDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Tugrik"), // Tugrik
  QT_TRANSLATE_NOOP("QxtLocale", "Tunisian Dinar"), // TunisianDinar
  QT_TRANSLATE_NOOP("QxtLocale", "UAE Dirham"), // UAEDirham
  QT_TRANSLATE_NOOP("QxtLocale", "US Dollar"), // USDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Uganda Shilling"), // UgandaShilling
  QT_TRANSLATE_NOOP("QxtLocale", "Unidad de Valor Real"), // UnidadDeValorReal
  QT_TRANSLATE_NOOP("QxtLocale", "Unidades de fomento"), // UnidadesDeFomento
  QT_TRANSLATE_NOOP("QxtLocale", "Uruguay Peso en Unidades Indexadas"), // UruguayPesoEnUnidadesIndexadas
  QT_TRANSLATE_NOOP("QxtLocale", "Uzbekistan Sum"), // UzbekistanSum
  QT_TRANSLATE_NOOP("QxtLocale", "Vatu"), // Vatu
  QT_TRANSLATE_NOOP("QxtLocale", "Won"), // Won
  QT_TRANSLATE_NOOP("QxtLocale", "Yemeni Rial"), // YemeniRial
  QT_TRANSLATE_NOOP("QxtLocale", "Yen"), // Yen
  QT_TRANSLATE_NOOP("QxtLocale", "Yuan Renminbi"), // YuanRenminbi
  QT_TRANSLATE_NOOP("QxtLocale", "ZambiaKwacha"), // ZambiaKwacha
  QT_TRANSLATE_NOOP("QxtLocale", "Zimbabwe Dollar"), // ZimbabweDollar
  QT_TRANSLATE_NOOP("QxtLocale", "Zloty"), // Zloty
};
static QChar symbol_for_country_list[][5] =
{
{  }, // NoCurrency
{ 1,0x60b }, // Afghani
{  }, // AlgerianDinar
{ 1,0x24 }, // ArgentinePeso
{  }, // ArmenianDram
{ 1,0x192 }, // ArubanGuilder
{ 1,0x24 }, // AustralianDollar
{ 3,0x43c,0x430,0x43d }, // AzerbaijanianManat
{ 1,0x24 }, // BahamianDollar
{  }, // BahrainiDinar
{ 1,0xe3f }, // Baht
{ 3,0x42,0x2f,0x2e }, // Balboa
{ 1,0x24 }, // BarbadosDollar
{ 2,0x70,0x2e }, // BelarussianRuble
{ 3,0x42,0x5a,0x24 }, // BelizeDollar
{ 1,0x24 }, // BermudianDollar
{ 2,0x42,0x73 }, // BolivarFuerte
{ 2,0x24,0x62 }, // Boliviano
{ 2,0x52,0x24 }, // BrazilianReal
{ 1,0x24 }, // BruneiDollar
{ 2,0x43b,0x432 }, // BulgarianLev
{  }, // BurundiFranc
{  }, // CFAFrancBCEAO
{  }, // CFAFrancBEAC
{  }, // CFPFranc
{ 1,0x24 }, // CanadianDollar
{  }, // CapeVerdeEscudo
{ 1,0x24 }, // CaymanIslandsDollar
{ 1,0x24 }, // ChileanPeso
{ 1,0x24 }, // ColombianPeso
{  }, // ComoroFranc
{ 2,0x4b,0x4d }, // ConvertibleMarks
{ 2,0x43,0x24 }, // CordobaOro
{ 1,0x20a1 }, // CostaRicanColon
{ 2,0x6b,0x6e }, // CroatianKuna
{ 1,0x20b1 }, // CubanPeso
{  }, // CyprusPound
{ 2,0x4b,0x10d }, // CzechKoruna
{  }, // Dalasi
{ 2,0x6b,0x72 }, // DanishKrone
{ 3,0x434,0x435,0x43d }, // Denar
{  }, // DjiboutiFranc
{  }, // Dobra
{ 3,0x52,0x44,0x24 }, // DominicanPeso
{ 1,0x20ab }, // Dong
{ 1,0x24 }, // EastCaribbeanDollar
{ 1,0xa3 }, // EgyptianPound
{ 1,0x24 }, // ElSalvadorColon
{  }, // EthiopianBirr
{ 1,0x20ac }, // Euro
{ 1,0xa3 }, // FalklandIslandsPound
{ 1,0x24 }, // FijiDollar
{ 2,0x46,0x74 }, // Forint
{  }, // FrancCongolais
{  }, // GhanaCedi
{ 1,0xa3 }, // GibraltarPound
{  }, // Gourde
{ 2,0x47,0x73 }, // Guarani
{  }, // GuineaBissauPeso
{  }, // GuineaFranc
{ 1,0x24 }, // GuyanaDollar
{ 1,0x5143 }, // HongKongDollar
{ 1,0x20b4 }, // Hryvnia
{ 2,0x6b,0x72 }, // IcelandKrona
{ 1,0x20a8 }, // IndianRupee
{ 1,0xfdfc }, // IranianRial
{  }, // IraqiDinar
{ 2,0x4a,0x24 }, // JamaicanDollar
{  }, // JordanianDinar
{  }, // KenyanShilling
{  }, // Kina
{ 1,0x20ad }, // Kip
{ 2,0x6b,0x72 }, // Kroon
{  }, // KuwaitiDinar
{  }, // Kwanza
{  }, // Kyat
{  }, // Lari
{ 2,0x4c,0x73 }, // LatvianLats
{ 1,0xa3 }, // LebanesePound
{ 3,0x4c,0x65,0x6b }, // Lek
{ 1,0x4c }, // Lempira
{  }, // Leone
{ 1,0x24 }, // LiberianDollar
{  }, // LibyanDinar
{  }, // Lilangeni
{ 2,0x4c,0x74 }, // LithuanianLitas
{  }, // Loti
{  }, // MalagasyAriary
{  }, // MalawiKwacha
{ 2,0x52,0x4d }, // MalaysianRinggit
{  }, // MalteseLira
{  }, // Manat
{ 1,0x20a8 }, // MauritiusRupee
{ 2,0x4d,0x54 }, // Metical
{ 1,0x24 }, // MexicanPeso
{  }, // MexicanUnidadDeInversion
{  }, // MoldovanLeu
{  }, // MoroccanDirham
{  }, // Mvdol
{ 1,0x20a6 }, // Naira
{  }, // Nakfa
{ 1,0x24 }, // NamibiaDollar
{ 1,0x20a8 }, // NepaleseRupee
{ 1,0x192 }, // NetherlandsAntillianGuilder
{ 1,0x20aa }, // NewIsraeliSheqel
{ 3,0x6c,0x65,0x69 }, // NewLeu
{ 3,0x4e,0x54,0x24 }, // NewTaiwanDollar
{ 3,0x59,0x54,0x4c }, // NewTurkishLira
{ 1,0x24 }, // NewZealandDollar
{  }, // Ngultrum
{ 1,0x20a9 }, // NorthKoreanWon
{ 2,0x6b,0x72 }, // NorwegianKrone
{ 3,0x53,0x2f,0x2e }, // NuevoSol
{  }, // Ouguiya
{  }, // Paanga
{ 1,0x20a8 }, // PakistanRupee
{  }, // Pataca
{ 2,0x24,0x55 }, // PesoUruguayo
{ 3,0x50,0x68,0x70 }, // PhilippinePeso
{ 1,0xa3 }, // PoundSterling
{ 1,0x50 }, // Pula
{ 1,0xfdfc }, // QatariRial
{ 1,0x51 }, // Quetzal
{ 1,0x52 }, // Rand
{ 1,0xfdfc }, // RialOmani
{ 1,0x17db }, // Riel
{  }, // Rufiyaa
{ 2,0x52,0x7 }, // Rupiah
{ 3,0x440,0x443,0x431 }, // RussianRuble
{  }, // RwandaFranc
{ 1,0xa3 }, // SaintHelenaPound
{ 1,0xfdfc }, // SaudiRiyal
{ 4,0x414,0x438,0x43d,0x2e }, // SerbianDinar
{ 1,0x20a8 }, // SeychellesRupee
{ 1,0x24 }, // SingaporeDollar
{  }, // SlovakKoruna
{ 1,0x24 }, // SolomonIslandsDollar
{ 2,0x43b,0x432 }, // Som
{ 1,0x53 }, // SomaliShilling
{  }, // Somoni
{ 1,0x20a8 }, // SriLankaRupee
{  }, // SudanesePound
{ 1,0x24 }, // SurinamDollar
{ 2,0x6b,0x72 }, // SwedishKrona
{ 3,0x43,0x48,0x46 }, // SwissFranc
{ 1,0xa3 }, // SyrianPound
{  }, // Taka
{  }, // Tala
{  }, // TanzanianShilling
{ 2,0x43b,0x432 }, // Tenge
{ 3,0x54,0x54,0x24 }, // TrinidadAndTobagoDollar
{ 1,0x20ae }, // Tugrik
{  }, // TunisianDinar
{ 1,0x62c }, // UAEDirham
{ 1,0x24 }, // USDollar
{  }, // UgandaShilling
{  }, // UnidadDeValorReal
{  }, // UnidadesDeFomento
{  }, // UruguayPesoEnUnidadesIndexadas
{ 2,0x43b,0x432 }, // UzbekistanSum
{  }, // Vatu
{ 1,0x20a9 }, // Won
{ 1,0xfdfc }, // YemeniRial
{ 1,0xa5 }, // Yen
{ 1,0x5143 }, // YuanRenminbi
{  }, // ZambiaKwacha
{ 2,0x5a,0x24 }, // ZimbabweDollar
{ 2,0x7a,0x142 }, // Zloty
}
;
static const unsigned char currency_code_list[] = 
"   " // NoCurrency
"AFN" // Afghani
"DZD" // AlgerianDinar
"ARS" // ArgentinePeso
"AMD" // ArmenianDram
"AWG" // ArubanGuilder
"AUD" // AustralianDollar
"AZN" // AzerbaijanianManat
"BSD" // BahamianDollar
"BHD" // BahrainiDinar
"THB" // Baht
"PAB" // Balboa
"BBD" // BarbadosDollar
"BYR" // BelarussianRuble
"BZD" // BelizeDollar
"BMD" // BermudianDollar
"VEF" // BolivarFuerte
"BOB" // Boliviano
"BRL" // BrazilianReal
"BND" // BruneiDollar
"BGN" // BulgarianLev
"BIF" // BurundiFranc
"XOF" // CFAFrancBCEAO
"XAF" // CFAFrancBEAC
"XPF" // CFPFranc
"CAD" // CanadianDollar
"CVE" // CapeVerdeEscudo
"KYD" // CaymanIslandsDollar
"CLP" // ChileanPeso
"COP" // ColombianPeso
"KMF" // ComoroFranc
"BAM" // ConvertibleMarks
"NIO" // CordobaOro
"CRC" // CostaRicanColon
"HRK" // CroatianKuna
"CUP" // CubanPeso
"CYP" // CyprusPound
"CZK" // CzechKoruna
"GMD" // Dalasi
"DKK" // DanishKrone
"MKD" // Denar
"DJF" // DjiboutiFranc
"STD" // Dobra
"DOP" // DominicanPeso
"VND" // Dong
"XCD" // EastCaribbeanDollar
"EGP" // EgyptianPound
"SVC" // ElSalvadorColon
"ETB" // EthiopianBirr
"EUR" // Euro
"FKP" // FalklandIslandsPound
"FJD" // FijiDollar
"HUF" // Forint
"CDF" // FrancCongolais
"GHS" // GhanaCedi
"GIP" // GibraltarPound
"HTG" // Gourde
"PYG" // Guarani
"GWP" // GuineaBissauPeso
"GNF" // GuineaFranc
"GYD" // GuyanaDollar
"HKD" // HongKongDollar
"UAH" // Hryvnia
"ISK" // IcelandKrona
"INR" // IndianRupee
"IRR" // IranianRial
"IQD" // IraqiDinar
"JMD" // JamaicanDollar
"JOD" // JordanianDinar
"KES" // KenyanShilling
"PGK" // Kina
"LAK" // Kip
"EEK" // Kroon
"KWD" // KuwaitiDinar
"AOA" // Kwanza
"MMK" // Kyat
"GEL" // Lari
"LVL" // LatvianLats
"LBP" // LebanesePound
"ALL" // Lek
"HNL" // Lempira
"SLL" // Leone
"LRD" // LiberianDollar
"LYD" // LibyanDinar
"SZL" // Lilangeni
"LTL" // LithuanianLitas
"LSL" // Loti
"MGA" // MalagasyAriary
"MWK" // MalawiKwacha
"MYR" // MalaysianRinggit
"MTL" // MalteseLira
"TMM" // Manat
"MUR" // MauritiusRupee
"MZN" // Metical
"MXN" // MexicanPeso
"MXV" // MexicanUnidadDeInversion
"MDL" // MoldovanLeu
"MAD" // MoroccanDirham
"BOV" // Mvdol
"NGN" // Naira
"ERN" // Nakfa
"NAD" // NamibiaDollar
"NPR" // NepaleseRupee
"ANG" // NetherlandsAntillianGuilder
"ILS" // NewIsraeliSheqel
"RON" // NewLeu
"TWD" // NewTaiwanDollar
"TRY" // NewTurkishLira
"NZD" // NewZealandDollar
"BTN" // Ngultrum
"KPW" // NorthKoreanWon
"NOK" // NorwegianKrone
"PEN" // NuevoSol
"MRO" // Ouguiya
"TOP" // Paanga
"PKR" // PakistanRupee
"MOP" // Pataca
"UYU" // PesoUruguayo
"PHP" // PhilippinePeso
"GBP" // PoundSterling
"BWP" // Pula
"QAR" // QatariRial
"GTQ" // Quetzal
"ZAR" // Rand
"OMR" // RialOmani
"KHR" // Riel
"MVR" // Rufiyaa
"IDR" // Rupiah
"RUB" // RussianRuble
"RWF" // RwandaFranc
"SHP" // SaintHelenaPound
"SAR" // SaudiRiyal
"RSD" // SerbianDinar
"SCR" // SeychellesRupee
"SGD" // SingaporeDollar
"SKK" // SlovakKoruna
"SBD" // SolomonIslandsDollar
"KGS" // Som
"SOS" // SomaliShilling
"TJS" // Somoni
"LKR" // SriLankaRupee
"SDG" // SudanesePound
"SRD" // SurinamDollar
"SEK" // SwedishKrona
"CHF" // SwissFranc
"SYP" // SyrianPound
"BDT" // Taka
"WST" // Tala
"TZS" // TanzanianShilling
"KZT" // Tenge
"TTD" // TrinidadAndTobagoDollar
"MNT" // Tugrik
"TND" // TunisianDinar
"AED" // UAEDirham
"USD" // USDollar
"UGX" // UgandaShilling
"COU" // UnidadDeValorReal
"CLF" // UnidadesDeFomento
"UYI" // UruguayPesoEnUnidadesIndexadas
"UZS" // UzbekistanSum
"VUV" // Vatu
"KRW" // Won
"YER" // YemeniRial
"JPY" // Yen
"CNY" // YuanRenminbi
"ZMK" // ZambiaKwacha
"ZWD" // ZimbabweDollar
"PLN" // Zloty
;
static const char* continent_names[] = {
  QT_TRANSLATE_NOOP("QxtLocale", "None"), // None
  QT_TRANSLATE_NOOP("QxtLocale", "NorthAmerica"), // NorthAmerica
  QT_TRANSLATE_NOOP("QxtLocale", "SouthAmerica"), // SouthAmerica
  QT_TRANSLATE_NOOP("QxtLocale", "Europe"), // Europe
  QT_TRANSLATE_NOOP("QxtLocale", "Africa"), // Africa
  QT_TRANSLATE_NOOP("QxtLocale", "Asia"), // Asia
  QT_TRANSLATE_NOOP("QxtLocale", "Australia"), // Australia
  QT_TRANSLATE_NOOP("QxtLocale", "Antarctica"), // Antarctica
};
static const QxtLocale::Continent continent_for_country_list[] = {
QxtLocale::None, // Default
QxtLocale::Asia, // Afghanistan
QxtLocale::Europe, // Albania
QxtLocale::Africa, // Algeria
QxtLocale::Australia, // AmericanSamoa
QxtLocale::Europe, // Andorra
QxtLocale::Africa, // Angola
QxtLocale::NorthAmerica, // Anguilla
QxtLocale::Antarctica, // Antarctica
QxtLocale::NorthAmerica, // AntiguaAndBarbuda
QxtLocale::SouthAmerica, // Argentina
QxtLocale::Europe, // Armenia
QxtLocale::NorthAmerica, // Aruba
QxtLocale::Australia, // Australia
QxtLocale::Europe, // Austria
QxtLocale::Europe, // Azerbaijan
QxtLocale::NorthAmerica, // Bahamas
QxtLocale::Asia, // Bahrain
QxtLocale::Asia, // Bangladesh
QxtLocale::NorthAmerica, // Barbados
QxtLocale::Europe, // Belarus
QxtLocale::Europe, // Belgium
QxtLocale::SouthAmerica, // Belize
QxtLocale::Africa, // Benin
QxtLocale::NorthAmerica, // Bermuda
QxtLocale::Asia, // Bhutan
QxtLocale::SouthAmerica, // Bolivia
QxtLocale::Europe, // BosniaAndHerzegowina
QxtLocale::Africa, // Botswana
QxtLocale::None, // BouvetIsland
QxtLocale::SouthAmerica, // Brazil
QxtLocale::Asia, // BritishIndianOceanTerritory
QxtLocale::Asia, // BruneiDarussalam
QxtLocale::Europe, // Bulgaria
QxtLocale::Africa, // BurkinaFaso
QxtLocale::Africa, // Burundi
QxtLocale::Asia, // Cambodia
QxtLocale::Africa, // Cameroon
QxtLocale::NorthAmerica, // Canada
QxtLocale::Africa, // CapeVerde
QxtLocale::NorthAmerica, // CaymanIslands
QxtLocale::Africa, // CentralAfricanRepublic
QxtLocale::Africa, // Chad
QxtLocale::SouthAmerica, // Chile
QxtLocale::Asia, // China
QxtLocale::Australia, // ChristmasIsland
QxtLocale::Australia, // CocosIslands
QxtLocale::SouthAmerica, // Colombia
QxtLocale::Africa, // Comoros
QxtLocale::Africa, // DemocraticRepublicOfCongo
QxtLocale::Africa, // PeoplesRepublicOfCongo
QxtLocale::Australia, // CookIslands
QxtLocale::NorthAmerica, // CostaRica
QxtLocale::Africa, // IvoryCoast
QxtLocale::Europe, // Croatia
QxtLocale::NorthAmerica, // Cuba
QxtLocale::Europe, // Cyprus
QxtLocale::Europe, // CzechRepublic
QxtLocale::Europe, // Denmark
QxtLocale::Africa, // Djibouti
QxtLocale::NorthAmerica, // Dominica
QxtLocale::NorthAmerica, // DominicanRepublic
QxtLocale::Asia, // EastTimor
QxtLocale::SouthAmerica, // Ecuador
QxtLocale::Africa, // Egypt
QxtLocale::NorthAmerica, // ElSalvador
QxtLocale::Africa, // EquatorialGuinea
QxtLocale::Africa, // Eritrea
QxtLocale::Europe, // Estonia
QxtLocale::Africa, // Ethiopia
QxtLocale::SouthAmerica, // FalklandIslands
QxtLocale::Europe, // FaroeIslands
QxtLocale::Australia, // Fiji
QxtLocale::Europe, // Finland
QxtLocale::Europe, // France
QxtLocale::Europe, // MetropolitanFrance
QxtLocale::SouthAmerica, // FrenchGuiana
QxtLocale::Australia, // FrenchPolynesia
QxtLocale::None, // FrenchSouthernTerritories
QxtLocale::Africa, // Gabon
QxtLocale::Africa, // Gambia
QxtLocale::Europe, // Georgia
QxtLocale::Europe, // Germany
QxtLocale::Africa, // Ghana
QxtLocale::Europe, // Gibraltar
QxtLocale::Europe, // Greece
QxtLocale::NorthAmerica, // Greenland
QxtLocale::NorthAmerica, // Grenada
QxtLocale::NorthAmerica, // Guadeloupe
QxtLocale::Australia, // Guam
QxtLocale::NorthAmerica, // Guatemala
QxtLocale::Africa, // Guinea
QxtLocale::Africa, // GuineaBissau
QxtLocale::SouthAmerica, // Guyana
QxtLocale::NorthAmerica, // Haiti
QxtLocale::None, // HeardAndMcDonaldIslands
QxtLocale::SouthAmerica, // Honduras
QxtLocale::Asia, // HongKong
QxtLocale::Europe, // Hungary
QxtLocale::Europe, // Iceland
QxtLocale::Asia, // India
QxtLocale::Australia, // Indonesia
QxtLocale::Asia, // Iran
QxtLocale::Asia, // Iraq
QxtLocale::Europe, // Ireland
QxtLocale::Asia, // Israel
QxtLocale::Europe, // Italy
QxtLocale::NorthAmerica, // Jamaica
QxtLocale::Asia, // Japan
QxtLocale::Asia, // Jordan
QxtLocale::Europe, // Kazakhstan
QxtLocale::Africa, // Kenya
QxtLocale::Australia, // Kiribati
QxtLocale::Asia, // DemocraticRepublicOfKorea
QxtLocale::Asia, // RepublicOfKorea
QxtLocale::Asia, // Kuwait
QxtLocale::Asia, // Kyrgyzstan
QxtLocale::Asia, // Lao
QxtLocale::Europe, // Latvia
QxtLocale::Asia, // Lebanon
QxtLocale::Africa, // Lesotho
QxtLocale::Africa, // Liberia
QxtLocale::Africa, // LibyanArabJamahiriya
QxtLocale::Europe, // Liechtenstein
QxtLocale::Europe, // Lithuania
QxtLocale::Europe, // Luxembourg
QxtLocale::Asia, // Macau
QxtLocale::Europe, // Macedonia
QxtLocale::Africa, // Madagascar
QxtLocale::Africa, // Malawi
QxtLocale::Asia, // Malaysia
QxtLocale::Asia, // Maldives
QxtLocale::Africa, // Mali
QxtLocale::Europe, // Malta
QxtLocale::Australia, // MarshallIslands
QxtLocale::NorthAmerica, // Martinique
QxtLocale::Africa, // Mauritania
QxtLocale::Africa, // Mauritius
QxtLocale::Africa, // Mayotte
QxtLocale::NorthAmerica, // Mexico
QxtLocale::Australia, // Micronesia
QxtLocale::Asia, // Moldova
QxtLocale::Europe, // Monaco
QxtLocale::Asia, // Mongolia
QxtLocale::NorthAmerica, // Montserrat
QxtLocale::Africa, // Morocco
QxtLocale::Africa, // Mozambique
QxtLocale::Asia, // Myanmar
QxtLocale::Africa, // Namibia
QxtLocale::Australia, // Nauru
QxtLocale::Asia, // Nepal
QxtLocale::Europe, // Netherlands
QxtLocale::NorthAmerica, // NetherlandsAntilles
QxtLocale::Australia, // NewCaledonia
QxtLocale::Australia, // NewZealand
QxtLocale::NorthAmerica, // Nicaragua
QxtLocale::Africa, // Niger
QxtLocale::Africa, // Nigeria
QxtLocale::Australia, // Niue
QxtLocale::Australia, // NorfolkIsland
QxtLocale::Australia, // NorthernMarianaIslands
QxtLocale::Europe, // Norway
QxtLocale::Asia, // Oman
QxtLocale::Asia, // Pakistan
QxtLocale::Australia, // Palau
QxtLocale::Asia, // PalestinianTerritory
QxtLocale::NorthAmerica, // Panama
QxtLocale::Australia, // PapuaNewGuinea
QxtLocale::SouthAmerica, // Paraguay
QxtLocale::SouthAmerica, // Peru
QxtLocale::Asia, // Philippines
QxtLocale::Australia, // Pitcairn
QxtLocale::Europe, // Poland
QxtLocale::Europe, // Portugal
QxtLocale::NorthAmerica, // PuertoRico
QxtLocale::Asia, // Qatar
QxtLocale::Africa, // Reunion
QxtLocale::Europe, // Romania
QxtLocale::Europe, // RussianFederation
QxtLocale::Africa, // Rwanda
QxtLocale::NorthAmerica, // SaintKittsAndNevis
QxtLocale::NorthAmerica, // StLucia
QxtLocale::NorthAmerica, // StVincentAndTheGrenadines
QxtLocale::Australia, // Samoa
QxtLocale::Europe, // SanMarino
QxtLocale::Africa, // SaoTomeAndPrincipe
QxtLocale::Asia, // SaudiArabia
QxtLocale::Africa, // Senegal
QxtLocale::Africa, // Seychelles
QxtLocale::Africa, // SierraLeone
QxtLocale::Asia, // Singapore
QxtLocale::Europe, // Slovakia
QxtLocale::Europe, // Slovenia
QxtLocale::Australia, // SolomonIslands
QxtLocale::Africa, // Somalia
QxtLocale::Africa, // SouthAfrica
QxtLocale::SouthAmerica, // SouthGeorgiaAndTheSouthSandwichIslands
QxtLocale::Europe, // Spain
QxtLocale::Asia, // SriLanka
QxtLocale::Africa, // StHelena
QxtLocale::NorthAmerica, // StPierreAndMiquelon
QxtLocale::Africa, // Sudan
QxtLocale::SouthAmerica, // Suriname
QxtLocale::Europe, // SvalbardAndJanMayenIslands
QxtLocale::Africa, // Swaziland
QxtLocale::Europe, // Sweden
QxtLocale::Europe, // Switzerland
QxtLocale::Asia, // SyrianArabRepublic
QxtLocale::Asia, // Taiwan
QxtLocale::Asia, // Tajikistan
QxtLocale::Africa, // Tanzania
QxtLocale::Asia, // Thailand
QxtLocale::Africa, // Togo
QxtLocale::Australia, // Tokelau
QxtLocale::Australia, // Tonga
QxtLocale::NorthAmerica, // TrinidadAndTobago
QxtLocale::Africa, // Tunisia
QxtLocale::Europe, // Turkey
QxtLocale::Asia, // Turkmenistan
QxtLocale::NorthAmerica, // TurksAndCaicosIslands
QxtLocale::Australia, // Tuvalu
QxtLocale::Africa, // Uganda
QxtLocale::Europe, // Ukraine
QxtLocale::Asia, // UnitedArabEmirates
QxtLocale::Europe, // UnitedKingdom
QxtLocale::NorthAmerica, // UnitedStates
QxtLocale::Australia, // UnitedStatesMinorOutlyingIslands
QxtLocale::SouthAmerica, // Uruguay
QxtLocale::Asia, // Uzbekistan
QxtLocale::Australia, // Vanuatu
QxtLocale::Europe, // VaticanCityState
QxtLocale::SouthAmerica, // Venezuela
QxtLocale::Asia, // VietNam
QxtLocale::NorthAmerica, // BritishVirginIslands
QxtLocale::NorthAmerica, // USVirginIslands
QxtLocale::Australia, // WallisAndFutunaIslands
QxtLocale::Africa, // WesternSahara
QxtLocale::Asia, // Yemen
QxtLocale::Europe, // Yugoslavia
QxtLocale::Africa, // Zambia
QxtLocale::Africa, // Zimbabwe
QxtLocale::Europe, // SerbiaAndMontenegro
};
#endif
