package org.pentaho.reporting.libraries.formula;

import junit.framework.TestCase;
import org.pentaho.reporting.libraries.formula.common.TestFormulaContext;

/**
 * Todo: Document Me
 *
 * @author Thomas Morgner
 */
public abstract class FormulaTestBase extends TestCase
{
  private FormulaContext context;

  protected FormulaTestBase()
  {
  }

  protected FormulaTestBase(final String s)
  {
    super(s);
  }

  protected void setUp() throws Exception
  {
    context = new TestFormulaContext(TestFormulaContext.testCaseDataset);
    LibFormulaBoot.getInstance().start();
  }

  protected abstract Object[][] createDataTest();

  public FormulaContext getContext()
  {
    return context;
  }

  protected void runDefaultTest() throws Exception
  {
    final Object[][] dataTest = createDataTest();
    runTest(dataTest);
  }

  protected void runTest(final Object[][] dataTest) throws Exception
  {
    for (int i = 0; i < dataTest.length; i++)
    {
      final Object[] objects = dataTest[i];
      performTest((String) objects[0], objects[1]);
    }
  }


  protected void performTest(final String formul, final Object result) throws Exception
  {
    performTest(formul, result, this.context);
  }

  protected void performTest(final String formul, final Object result, final FormulaContext context) throws Exception
  {
    final Formula formula = new Formula(formul);
    formula.initialize(context);
    final Object eval = formula.evaluate();
    if (result instanceof Comparable && eval instanceof Comparable)
    {
      final Comparable n = (Comparable) result;
      try
      {
        assertTrue("Failure numeric comparison on " + formul + ": " + result + " vs. " + eval, n.compareTo(eval) == 0);
      }
      catch (final ClassCastException cce)
      {
        fail("Failure numeric comparison on " + formul + ": " + result + " vs. " + eval);
      }
    }
    else
    {
      assertEquals("Failure on " + formul, result, eval);
    }
  }

}
