/**
 * ===========================================
 * LibFonts : a free Java font reading library
 * ===========================================
 *
 * Project Info:  http://reporting.pentaho.org/libfonts/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 * ------------
 * FirstLevelFontCache.java
 * ------------
 */

package org.pentaho.reporting.libraries.fonts.cache;

import java.util.HashMap;

import org.pentaho.reporting.libraries.fonts.registry.FontKey;
import org.pentaho.reporting.libraries.fonts.registry.FontMetrics;

/**
 * The first level font cache is always a perfect cache. It holds all fonts used by the current storage in
 * memory. Once finished, the cache-contents are pushed downwards into the second level cache.
 *
 * @author : Thomas Morgner
 */
public class FirstLevelFontCache implements FontCache
{
  private HashMap backend;
  private FontCache secondLevelCache;

  public FirstLevelFontCache(final FontCache secondLevelCache)
  {
    this.secondLevelCache = secondLevelCache;
    backend = new HashMap();
  }

  public FontMetrics getFontMetrics(final FontKey fontKey)
  {
    final FontMetrics metrics = (FontMetrics) backend.get(fontKey);
    if (metrics != null)
    {
      return metrics;
    }
    if (secondLevelCache == null)
    {
      return null;
    }
    final FontMetrics fromSecondLevel = secondLevelCache.getFontMetrics(fontKey);
    if (fromSecondLevel != null)
    {
      backend.put(fontKey.clone(), fromSecondLevel);
      return fromSecondLevel;
    }
    return null;
  }

  public void putFontMetrics(final FontKey key, final FontMetrics fontMetrics)
  {
    backend.put(key, fontMetrics);
    if (secondLevelCache != null)
    {
      secondLevelCache.putFontMetrics(key, fontMetrics);
    }
  }

  public void commit()
  {
    backend.clear();
    secondLevelCache = null;
  }
}
