/**
 * ================================================
 * LibLoader : a free Java resource loading library
 * ================================================
 *
 * Project Info:  http://reporting.pentaho.org/libloader/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * CacheUtility.java
 * ------------
 */

package org.pentaho.reporting.libraries.resourceloader.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

/**
 * Creation-Date: Feb 22, 2007, 7:36:19 PM
 *
 * @author Thomas Morgner
 */
public class CacheUtility
{
  public static String externalizeKey(final ResourceKey key)
  {
    try
    {
      final ByteArrayOutputStream bout = new ByteArrayOutputStream();
      final ObjectOutputStream oout = new ObjectOutputStream(bout);
      oout.writeObject(key);
      oout.close();
      final byte[] serializedKeyData = bout.toByteArray();
      return convertToString(serializedKeyData);
    }
    catch (IOException ioe)
    {
      return null;
    }
  }

  private static String convertToString(final byte[] serializedKeyData)
  {
    final int capacity = (serializedKeyData.length / 2) + 2;
    final StringBuffer buffer = new StringBuffer(capacity);
    char data = 0;
    if ((serializedKeyData.length & 1) == 1)
    {
      buffer.append('*');
    }
    else
    {
      buffer.append('#');
    }

    for (int i = 0; i < serializedKeyData.length; i += 1)
    {
      data <<= 8;
      data |= serializedKeyData[i];
      if ((i & 1) == 1)
      {
        buffer.append(data);
      }
    }
    if ((serializedKeyData.length & 1) == 1)
    {
      data <<= 8;
      buffer.append(data);
    }
    return buffer.toString();
  }

  private CacheUtility()
  {
  }
}
