/**
 * ================================================
 * LibLoader : a free Java resource loading library
 * ================================================
 *
 * Project Info:  http://reporting.pentaho.org/libloader/
 *
 * (C) Copyright 2006-2008, by Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * WrapperWMFDrawableFactoryModule.java
 * ------------
 */

package org.pentaho.reporting.libraries.resourceloader.modules.factory.wmf;

import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.FactoryModule;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

/**
 * Todo: Document Me
 *
 * @author Thomas Morgner
 */
public class WrapperWMFDrawableFactoryModule implements FactoryModule
{
  private FactoryModule parent;

  public WrapperWMFDrawableFactoryModule()
  {
    parent = (FactoryModule) ObjectUtilities.loadAndInstantiate
        ("org.pentaho.reporting.libraries.resourceloader.modules.factory.wmf.WMFImageFactoryModule",
            WrapperWMFImageFactoryModule.class, FactoryModule.class);
  }

  public int canHandleResource(final ResourceManager caller, final ResourceData data) throws ResourceCreationException, ResourceLoadingException
  {
    if (parent == null)
    {
      return FactoryModule.REJECTED;
    }
    return parent.canHandleResource(caller, data);
  }

  public int getHeaderFingerprintSize()
  {
    if (parent == null)
    {
      return 0;
    }
    return parent.getHeaderFingerprintSize();
  }

  public Resource create(final ResourceManager caller, final ResourceData data, final ResourceKey context) throws ResourceCreationException, ResourceLoadingException
  {
    if (parent == null)
    {
      throw new ResourceCreationException("Cannot create resource: Pixie library is not available.");
    }
    return parent.create(caller, data, context);
  }
}