#*************************************************************************
#
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
# 
# Copyright 2000, 2010 Oracle and/or its affiliates.
#
# OpenOffice.org - a multi-platform office productivity suite
#
# This file is part of OpenOffice.org.
#
# OpenOffice.org is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# only, as published by the Free Software Foundation.
#
# OpenOffice.org is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License version 3 for more details
# (a copy is included in the LICENSE file that accompanied this code).
#
# You should have received a copy of the GNU Lesser General Public License
# version 3 along with OpenOffice.org.  If not, see
# <http://www.openoffice.org/license.html>
# for a copy of the LGPLv3 License.
#
#*************************************************************************

PRJ=.

PRJNAME=jpeg
TARGET=jpeg

# --- Settings -----------------------------------------------------

.INCLUDE :	settings.mk

.IF "$(SYSTEM_JPEG)" == "YES"
all:
	@echo "An already available installation of libjpeg should exist on your system."
	@echo "Therefore the version provided here does not need to be built in addition."
.ENDIF

# --- Files --------------------------------------------------------

#TARFILE_NAME=jpeg-6b
TARFILE_NAME=jpeg-8c

#TARFILE_MD5=dbd5f3b47ed13132f04c685d608a7547
TARFILE_MD5=a2c10c04f396a9ce72894beb18b4e1f9

#PATCH_FILES=jpeg-6b.patch
PATCH_FILES=jpeg-8c.patch
.IF "$(OS)$(CPU)"=="MACOSXP"
PATCH_FILES+=struct_alignment.patch
.ENDIF

ADDITIONAL_FILES=makefile.mk jconfig.h	

#relative to CONFIGURE_DIR

BUILD_DIR=$(CONFIGURE_DIR)
BUILD_ACTION=dmake $(MFLAGS) $(CALLMACROS)

OUT2INC=    jconfig.h	\
            jerror.h	\
            jmorecfg.h	\
            jpegint.h	\
            jpeglib.h	

# --- Targets ------------------------------------------------------

.INCLUDE : set_ext.mk
.INCLUDE : target.mk
.INCLUDE : tg_ext.mk
