%{
/* mswatch configuration parser */

/* TODO:
 * - add error reporting
 * - don't make base_delay, inter_delay, max_delay, sync, store, and watch keywords?
 */
%}

%{
#include <stdio.h>
#include <time.h>

#include "lib/util.h"
#include "parser_types.h"
#include "semantic_actions.h"

/* lex provides; declare here to rid compiler warning */
extern int yylex(void);

//#define YYDEBUG 1

int yyerror(const char* msg)
{
	fprintf(stderr, "Error parsing configuration: %s.\n", msg);
	return 0;
}

/* When the parser reaches EOF it calls yywrap() to see if there is another
 * file it can parse (it enjoys this kind of thing), we say no and return 1.
 * (We only parse one input source at a time.)
 */
int yywrap(void)
{
	return 1;
}
%}

%union
{
	int num;
	char* str;
	struct rc_setting* setting;
	struct rc_store_setting* store_setting;
	struct str_list* str_list;
}

%token <str> TEXT
%token <num> NUM
%token BASEDELAY INTERDELAY MAXDELAY SYNC MAILBOXPREFIX STORE WATCH CBOPEN CBCLOSE EOL

%type <setting> config;
%type <setting> settings;
%type <setting> setting;
%type <store_setting> store_settings;
%type <store_setting> store_setting;
%type <str_list> strings;
%type <str_list> string;
%type <str> text;

%%

config:     settings
            { $$ = NULL; emit($1); }
          ;

settings:   eols
            { $$ = NULL; }
          | setting eols
            { $$ = $1; }
          | settings setting eols
            { $$ = append_rc($1, $2); }
          ;

setting:    BASEDELAY NUM
            { $$ = create_base_delay($2); }
          | INTERDELAY NUM
            { $$ = create_inter_delay($2); }
          | INTERDELAY NUM strings
            { $$ = create_inter_delay_list($2, $3); }
          | MAXDELAY NUM
            { $$ = create_max_delay($2); }
          | SYNC strings
            { $$ = create_sync($2); }
          | MAILBOXPREFIX text text
            { $$ = create_mailbox_prefix($2, $3); }
          | STORE TEXT opt_eols CBOPEN opt_eols store_settings opt_eols CBCLOSE
            { $$ = create_store(append_rc_store(create_store_name($2), $6)); }
          ;

store_settings:   store_setting
                  { $$ = $1; }
                | store_settings eols store_setting
                  { $$ = append_rc_store($1, $3); }
                ;

store_setting:    WATCH strings
                  { $$ = create_store_watch($2); }
                ;

strings:    string
            { $$ = $1; }
          | strings string
            { $$ = append_str($1, $2); }
          ;

string:     text
            { $$ = create_str($1); }
          ;

text:       TEXT
            { $$ = $1; }
          | NUM
            { $$ = itoa($1); }
          ;

opt_eols:   { }
          | eols { }
          ;

eols:       EOL { }
          | eols EOL { }
          ;

%%

//#define DEBUG_PARSER
#ifdef DEBUG_PARSER
int main(void)
{
	//yydebug = 1;
	return yyparse();
}
#endif
