
function run_test(name_test_file,format,name_result)
{
  fso.GetFile(name_test_file).Copy("in.xml")
  shell.Run("Debug\\test_xml.exe " + format,0,true)
  fso.GetFile("in.xml").Delete()
  if (fso.FileExists(name_result))
    fso.GetFile(name_result).Delete()
  fso.GetFile("out.xml").Move(name_result)
}

function check(format,test_name,test_prompt)
{
  var name_found=     format + "_" + test_name
  var name_test_file= ".\\t\\" + name_found + ".test.xml"
  var name_prefix=    ".\\r\\" + name_found
  var name_result=    name_prefix + ".result.xml"
  var name_etalon=    name_prefix + ".result.etalon.xml"
  var name_diff=      name_prefix + ".result.diff"

  run_test(name_test_file,format,name_result)

  var fc_result= compare_results(name_etalon,name_result,name_diff)
  print_test_res(test_prompt,fc_result)
}

function check_idempotency(format,test_name,test_prompt)
{
  var name_found=     format + "_" + test_name
  var name_prefix=    ".\\r\\" + name_found
  var name_test_file= name_prefix + ".result.etalon.xml"
  var name_result=    name_prefix + ".id.result.xml"
  var name_etalon=    name_prefix + ".result.etalon.xml"
  var name_diff=      name_prefix + ".id.result.diff"

  run_test(name_test_file,format,name_result)

  var fc_result= compare_results(name_etalon,name_result,name_diff)
  print_test_res(test_prompt,fc_result)
}

print_title("test xml storing")
copy_dlls()

check             ( "backup_profile", "simple",  "backup_profile simple read write")
check_idempotency ( "backup_profile", "simple",  "backup_profile simple read write idempotency")

check             ( "backup_profile", "example", "Ulli's test backup_profile simple read write")
check_idempotency ( "backup_profile", "example", "Ulli's test backup_profile simple read write idempotency")

clear_dlls()
print_footer()
