
run_test()
{
  name_test_file=$1
  name_result=$2

  cp $name_test_file in.xml
  ./test_mysql_api > $name_result
  rm in.xml
}

check()
{
  server=$1
  file_name=$2
  test_prompt=$3

  load_members $server

  if [ "x$this_enabled" = "x0" ]; then
    print_test_skipped "$test_prompt"
  else
    name_test_file="t/${file_name}.test.xml"
    name_prepared_test_file="t/${file_name}.test.prepared.xml"
    name_result_file="r/${file_name}.result"
    name_etalon_file="r/${file_name}.result.etalon"
    name_diff_file="r/${file_name}.diff"

    server_prepare_connection_file $server $name_test_file $name_prepared_test_file
    run_test $name_prepared_test_file $name_result_file
    rm $name_prepared_test_file

    compare_results $name_etalon_file $name_result_file $name_diff_file
    fc_result=$?
    print_test_res "$test_prompt" $fc_result
  fi
}

print_title "test mysql api"

server_safe_start server_40
export my_cnf_path=""
check server_40 mysql_40_simple "simple connection to mysql-4.0"
export my_cnf_path="t/test.cnf"
check server_40 mysql_40_with_test_cnf "simple connection to mysql-4.0 with configure file"
server_safe_stop server_40

server_safe_start server_41
export my_cnf_path=""
check server_41 mysql_41_simple "simple connection to mysql-4.1"
export my_cnf_path="t/test.cnf"
check server_41 mysql_41_with_test_cnf "simple connection to mysql-4.1 with configure file"
server_safe_stop server_41

print_footer
exit $one_of_tests_failed
