
run_test()
{
  name_test_file=$1
  format=$2
  name_result=$3

  cp $name_test_file ./in.xml
  ./test_xml $format
  rm ./in.xml
  rm -f $name_result
  mv out.xml $name_result
}

check()
{
  format=$1
  test_name=$2
  test_prompt=$3

  name_found="${format}_${test_name}"
  name_test_file="./t/${name_found}.test.xml"
  name_prefix="./r/${name_found}"
  name_result="${name_prefix}.result.xml"
  name_etalon="${name_prefix}.result.etalon.xml"
  name_diff="${name_prefix}.result.diff"

  run_test $name_test_file $format $name_result

  compare_results $name_etalon $name_result $name_diff
  fc_result=$?
  print_test_res "$test_prompt" $fc_result
}

check_idempotency()
{
  format=$1
  test_name=$2
  test_prompt=$3

  name_found="${format}_${test_name}"
  name_prefix="./r/${name_found}"
  name_test_file="${name_prefix}.result.etalon.xml"
  name_result="${name_prefix}.id.result.xml"
  name_etalon="${name_prefix}.result.etalon.xml"
  name_diff="${name_prefix}.id.result.diff"

  run_test $name_test_file $format $name_result

  compare_results $name_etalon $name_result $name_diff
  fc_result=$?
  print_test_res "$test_prompt" $fc_result
}

check_os_specific()
{
  format=$1
  test_name=$2
  test_prompt=$3

  #name_found="${format}_${test_name}"
  #name_test_file="./t/${name_found}.test.xml"
  #name_prefix="./r/${name_found}"
  #name_interim_result="${name_prefix}.interim.result.xml"
  #name_result="${name_prefix}.result.xml"
  #name_etalon="${name_prefix}.result.etalon.xml"
  #name_diff="${name_prefix}.id.result.diff"

  #export MYX_PASSWORD_STORAGE_TYPE="4"
  #run_test $name_test_file $format $name_interim_result

  #export MYX_PASSWORD_STORAGE_TYPE="2"
  #run_test $name_interim_result $format $name_result

  #compare_results $name_etalon $name_result $name_diff
  #fc_result=$?
  #print_test_res "$test_prompt" $fc_result
  #rm $name_interim_result

  print_test_skipped $test_prompt
}

print_title "test reading from international files"

check             charsets   simple "charsets  simple read write"
check_idempotency charsets   simple "charsets  simple read write idempotency"

check             datatypes  simple "datatypes simple read write"
check_idempotency datatypes  simple "datatypes simple read write idempotency"

check             options    simple "options   simple read write"
check_idempotency options    simple "options   simple read write idempotency"

export my_cnf_path=""
export MYX_PASSWORD_STORAGE_TYPE="1"
check             connections simple "connections read write             MYX_PASSWORD_NOT_STORED (simple)"
check_idempotency connections simple "connections read write idempotency MYX_PASSWORD_NOT_STORED (simple)"

export MYX_PASSWORD_STORAGE_TYPE="2"
check             connections plain  "connections read write             MYX_PASSWORD_PLAINTEXT"
check_idempotency connections plain  "connections read write idempotency MYX_PASSWORD_PLAINTEXT"

export MYX_PASSWORD_STORAGE_TYPE="3"
check             connections obscured "connections read write             MYX_PASSWORD_OBSCURED"
check_idempotency connections obscured "connections read write idempotency MYX_PASSWORD_OBSCURED"

check_os_specific connections os_specific "connections read write             MYX_PASSWORD_OS_SPECIFIC"

export MYX_PASSWORD_STORAGE_TYPE="2"
check connections obscured_to_plane "connections read from obscured write to plane"

print_footer
exit $one_of_tests_failed
